/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.recovery.process;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryResourceService;
import com.huawei.ism.drm.host.recovery.process.MappingReplicaSubProcessor;
import com.huawei.ism.drm.host.sdk.model.DrHost;
import com.huawei.ism.drm.host.util.DrHostUtil;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.recovery.process.RecoveryProcessResult;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.recovery.sdk.model.HostGroupVO;
import com.huawei.ism.drm.recovery.sdk.model.HostVO;
import com.huawei.ism.drm.recovery.sdk.model.ResourceVO;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.storage.manager.proxy.StorageLunManagerProxy;
import com.huawei.ism.drm.storage.manager.proxy.StorageSnapshotManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageLunBaseManager;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageSnapshotManager;
import com.huawei.ism.drm.storage.sdk.model.ArraySnapshot;
import com.huawei.ism.drm.storage.sdk.model.Snapshot;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class MappingCloneVolumeReplicaSubProcessor
extends MappingReplicaSubProcessor {
    private static final Log logger = LogFactory.getInstance(MappingCloneVolumeReplicaSubProcessor.class);
    private String cloneVolumeWWN;

    @Override
    protected boolean execute(RecoveryProcessorContext context) {
        OperationResult result = this.mappingSnapshotCloneVolume();
        if (null == result) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
        } else if (!result.isSuccess()) {
            this.updateProcessDetail("lego.err." + result.getErrorCode(), result.getArgs());
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
        } else {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        }
        return true;
    }

    private OperationResult mappingSnapshotCloneVolume() {
        IRecoveryResourceService recoveryService = (IRecoveryResourceService)ServiceLocator.getInstance().getService(IRecoveryResourceService.class);
        DrResource drResource = recoveryService.getDrResourceByID(this.getMountHostOrHostGroupId());
        if (null == drResource) {
            this.updateProcessName("ism.drm.recovery.snapshot.cloneVolume.mapping.failed");
            OperationResult operationResult = this.checkOperationObject();
            return operationResult;
        }
        this.updateProcessNameParams(new String[]{this.getReplicaName(), drResource.getName()});
        StorageSnapshotManagerProxy storageManagerProxy = StorageSnapshotManagerProxy.getInstance();
        String deviceType = recoveryService.getStorageType(this.getDeviceId());
        IStorageSnapshotManager proxy = storageManagerProxy.getStorageSnapshotMgrByDevType(deviceType);
        ArraySnapshot arraySnapshot = new ArraySnapshot();
        arraySnapshot.setId(this.getReplicaId());
        arraySnapshot.setSnapshotName(this.getReplicaName());
        IStorageLunBaseManager lunManager = StorageLunManagerProxy.getInstance().getStorageLunMgrByDevType(deviceType);
        ArrayList<String> lunNames = new ArrayList<String>();
        lunNames.add(this.getReplicaName());
        List luns = lunManager.queryLunsByNames(this.getDeviceId(), lunNames);
        if (VerifyUtil.isEmpty((Collection)luns)) {
            logger.error((Object)"can't find luns, lun names: %s", new Object[]{lunNames});
            return new OperationResult("ism.drm.recovery.snapshot.cloneVolume.mapping.failed", true, false, new String[0]);
        }
        this.cloneVolumeWWN = ((Lun)CommonUtil.getFirstElement((Collection)luns)).getWwn();
        OperationResult operationResult = this.mappingSnapshotCloneVolume("", (Snapshot)arraySnapshot, drResource, proxy);
        if (!operationResult.isSuccess()) {
            operationResult.setOperationName("ism.drm.recovery.snapshot.cloneVolume.mapping.failed");
            return operationResult;
        }
        return new OperationResult("ism.drm.add.snapshot.cloneVolume.mapping.operation", true, true, new String[]{arraySnapshot.getId()});
    }

    private OperationResult mappingSnapshotCloneVolume(String srcLunId, Snapshot arraySnapshot, DrResource drResource, IStorageSnapshotManager proxy) {
        HashSet<String> hostOrGropId = new HashSet<String>();
        hostOrGropId.add(this.getMountHostOrHostGroupId());
        Map<String, ResourceVO> resourceVOMap = DrHostUtil.getHostInitiators(hostOrGropId);
        ResourceVO resourceVO = resourceVOMap.get(this.getMountHostOrHostGroupId());
        if (drResource instanceof DrHost) {
            return proxy.mappingSnapshot(this.getDeviceId(), srcLunId, arraySnapshot, (HostVO)resourceVO);
        }
        return proxy.mappingSnapshot(this.getDeviceId(), srcLunId, arraySnapshot, (HostGroupVO)resourceVO);
    }

    @Override
    protected String generateResultKey() {
        return RecoveryProcessResult.getMappingLunProcResultKey((String)this.getReplicaSourceId(), (String)this.getReplicaId(), (String)this.cloneVolumeWWN, (String)this.getMountHostOrHostGroupId(), (String)this.getDeviceId());
    }

    private OperationResult checkOperationObject() {
        String[] errorParams = new String[]{this.getMountHostOrHostGroupId()};
        String errorCode = String.valueOf(1073948686L);
        return new OperationResult("Mapping", true, false, errorCode, errorParams);
    }
}

