/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.recovery.process;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.process.MappingReplicaSubProcessorBuilderManager;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.process.IMappingReplicaSubProcessorBuilder;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.util.NasCloneUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUnsupportedOperationException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class MappingNasSnapshotProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 5618734635729961187L;
    private static final Log LOGGER = LogFactory.getInstance(MappingNasSnapshotProcessor.class);

    protected boolean execute(RecoveryProcessorContext context) {
        ProtectGroupReplica replica = context.getProtectGroupReplica();
        if (replica == null) {
            LOGGER.error((Object)"replica is null!");
            throw new LegoCheckedException(1073947393L);
        }
        String hostOrGroupId = (String)context.getRecoveryPlan().getGlobalSettings().get("PG_DISASTER_HOST");
        replica.setMountedHost(hostOrGroupId);
        MappingReplicaSubProcessorBuilderManager manager = MappingReplicaSubProcessorBuilderManager.getInstance();
        IMappingReplicaSubProcessorBuilder builder = manager.getBuider(this.getTargetReplicaType(replica));
        Set subProcessors = builder.buildMappingProcessor((RecoveryProcessor)this, replica);
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            this.setChildProc(subProcessors);
        } else {
            this.updateSubProcessors(subProcessors);
        }
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
        return this.executeSubProcessor(context);
    }

    protected boolean executeSubProcessor(RecoveryProcessorContext context) {
        List processors = RecoveryServiceUtil.sortAndUpdateProcessorRation((Set)this.getChildProc());
        RecoveryProcessConcurrentExecutor concurrentExecutor = RecoveryProcessConcurrentExecutor.createExecutor((List)processors);
        concurrentExecutor.process(context);
        boolean executeResult = this.calcProcessResultBySubProc();
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS.getValue() == this.getProcStatus()) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            executeResult = false;
            NasCloneUtil.rollbackCreateShare((RecoveryProcessorContext)context);
        }
        return executeResult;
    }

    protected String generateResultKey() {
        throw new LegoUnsupportedOperationException("The operation is not supported.");
    }

    private int getTargetReplicaType(ProtectGroupReplica replica) {
        int targetReplicaType = replica.getType();
        if (targetReplicaType != 14) {
            targetReplicaType = 14;
        }
        return targetReplicaType;
    }
}

