/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.recovery.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.sdk.model.NasSnapshotClone;
import com.huawei.ism.drm.storage.util.NasCloneUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUnsupportedOperationException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;

public class MappingNasSnapshotSubProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -987941449317299834L;
    private static final Log LOGGER = LogFactory.getInstance(MappingNasSnapshotSubProcessor.class);
    private String deviceId;
    private String replicaSourceId;
    private String replicaId;
    private String replicaName;
    private String mountHostOrHostGroupId;
    private NasSnapshotClone nasSnapshotClone;

    protected boolean execute(RecoveryProcessorContext context) {
        String id = this.nasSnapshotClone.getId();
        String shareType = this.nasSnapshotClone.getShareType();
        try {
            this.updateProcessNameParams(new String[]{id, shareType});
            boolean result = NasCloneUtil.createShare((RecoveryProcessorContext)context, (NasSnapshotClone)this.nasSnapshotClone);
            if (!result) {
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
                this.updateProcessDetail("lego.err.1677929219", new String[0]);
                return false;
            }
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Create share failed, fsId:%s, shareType:%s, error:%s.", new Object[]{id, shareType, ExceptionUtil.getErrorMessage((Throwable)e)});
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail(e);
            return false;
        }
        catch (Exception e) {
            LOGGER.error((Object)"Create share failed, fsId:%s, shareType:%s, error:%s.", new Object[]{id, shareType, ExceptionUtil.getErrorMessage((Throwable)e)});
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail("lego.err.-1", new String[0]);
            return false;
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        return true;
    }

    protected String generateResultKey() {
        throw new LegoUnsupportedOperationException("The operation is not supported.");
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getReplicaSourceId() {
        return this.replicaSourceId;
    }

    public String getReplicaId() {
        return this.replicaId;
    }

    public String getReplicaName() {
        return this.replicaName;
    }

    public String getMountHostOrHostGroupId() {
        return this.mountHostOrHostGroupId;
    }

    public NasSnapshotClone getNasSnapshotClone() {
        return this.nasSnapshotClone;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public void setReplicaSourceId(String replicaSourceId) {
        this.replicaSourceId = replicaSourceId;
    }

    public void setReplicaId(String replicaId) {
        this.replicaId = replicaId;
    }

    public void setReplicaName(String replicaName) {
        this.replicaName = replicaName;
    }

    public void setMountHostOrHostGroupId(String mountHostOrHostGroupId) {
        this.mountHostOrHostGroupId = mountHostOrHostGroupId;
    }

    public void setNasSnapshotClone(NasSnapshotClone nasSnapshotClone) {
        this.nasSnapshotClone = nasSnapshotClone;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MappingNasSnapshotSubProcessor)) {
            return false;
        }
        MappingNasSnapshotSubProcessor other = (MappingNasSnapshotSubProcessor)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$deviceId = this.getDeviceId();
        String other$deviceId = other.getDeviceId();
        if (this$deviceId == null ? other$deviceId != null : !this$deviceId.equals(other$deviceId)) {
            return false;
        }
        String this$replicaSourceId = this.getReplicaSourceId();
        String other$replicaSourceId = other.getReplicaSourceId();
        if (this$replicaSourceId == null ? other$replicaSourceId != null : !this$replicaSourceId.equals(other$replicaSourceId)) {
            return false;
        }
        String this$replicaId = this.getReplicaId();
        String other$replicaId = other.getReplicaId();
        if (this$replicaId == null ? other$replicaId != null : !this$replicaId.equals(other$replicaId)) {
            return false;
        }
        String this$replicaName = this.getReplicaName();
        String other$replicaName = other.getReplicaName();
        if (this$replicaName == null ? other$replicaName != null : !this$replicaName.equals(other$replicaName)) {
            return false;
        }
        String this$mountHostOrHostGroupId = this.getMountHostOrHostGroupId();
        String other$mountHostOrHostGroupId = other.getMountHostOrHostGroupId();
        if (this$mountHostOrHostGroupId == null ? other$mountHostOrHostGroupId != null : !this$mountHostOrHostGroupId.equals(other$mountHostOrHostGroupId)) {
            return false;
        }
        NasSnapshotClone this$nasSnapshotClone = this.getNasSnapshotClone();
        NasSnapshotClone other$nasSnapshotClone = other.getNasSnapshotClone();
        return !(this$nasSnapshotClone == null ? other$nasSnapshotClone != null : !this$nasSnapshotClone.equals(other$nasSnapshotClone));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MappingNasSnapshotSubProcessor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $deviceId = this.getDeviceId();
        result = result * 59 + ($deviceId == null ? 43 : $deviceId.hashCode());
        String $replicaSourceId = this.getReplicaSourceId();
        result = result * 59 + ($replicaSourceId == null ? 43 : $replicaSourceId.hashCode());
        String $replicaId = this.getReplicaId();
        result = result * 59 + ($replicaId == null ? 43 : $replicaId.hashCode());
        String $replicaName = this.getReplicaName();
        result = result * 59 + ($replicaName == null ? 43 : $replicaName.hashCode());
        String $mountHostOrHostGroupId = this.getMountHostOrHostGroupId();
        result = result * 59 + ($mountHostOrHostGroupId == null ? 43 : $mountHostOrHostGroupId.hashCode());
        NasSnapshotClone $nasSnapshotClone = this.getNasSnapshotClone();
        result = result * 59 + ($nasSnapshotClone == null ? 43 : $nasSnapshotClone.hashCode());
        return result;
    }

    public String toString() {
        return "MappingNasSnapshotSubProcessor(deviceId=" + this.getDeviceId() + ", replicaSourceId=" + this.getReplicaSourceId() + ", replicaId=" + this.getReplicaId() + ", replicaName=" + this.getReplicaName() + ", mountHostOrHostGroupId=" + this.getMountHostOrHostGroupId() + ", nasSnapshotClone=" + this.getNasSnapshotClone() + ")";
    }
}

