/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.recovery.process;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryResourceService;
import com.huawei.ism.drm.host.recovery.process.MappingLunSubProcessor;
import com.huawei.ism.drm.host.recovery.process.MappingReplicaProcessor;
import com.huawei.ism.drm.host.util.DrHostUtil;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.recovery.sdk.model.HostGroupVO;
import com.huawei.ism.drm.recovery.sdk.model.HostVO;
import com.huawei.ism.drm.recovery.sdk.model.ResourceVO;
import com.huawei.ism.drm.storage.manager.proxy.StorageLunManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageLunBaseManager;
import com.huawei.ism.drm.storage.recovery.process.CreateNativeLunSubProcessor;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class MappingNativeReplicaProcessor
extends MappingReplicaProcessor {
    private static final long serialVersionUID = -4813589949455070196L;
    private static final Log logger = LogFactory.getInstance(MappingNativeReplicaProcessor.class);

    @Override
    protected boolean execute(RecoveryProcessorContext context) {
        logger.info((Object)"begin to MappingNativeReplicaProcessor.");
        if (VerifyUtil.isEmpty((Object)context)) {
            logger.error((Object)"CreateNativeLunProcessor: context is null.", 90160758784001L);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        ProtectGroupReplica replica = context.getProtectGroupReplica();
        if (null == replica) {
            logger.error((Object)"protectGroup replica is null!", 90160758784001L);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        String hostKey = "PG_DISASTER_HOST";
        String hostOrGroupId = (String)context.getRecoveryPlan().getGlobalSettings().get(hostKey);
        HashSet<String> hostOrGroupIds = new HashSet<String>();
        hostOrGroupIds.add(hostOrGroupId);
        Map<String, ResourceVO> resourceVOs = DrHostUtil.getHostInitiators(hostOrGroupIds);
        if (null == resourceVOs || null == resourceVOs.get(hostOrGroupId)) {
            logger.error((Object)"hostSn or scriptName is empty", 90160758786989L);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        ResourceVO vo = resourceVOs.get(hostOrGroupId);
        replica.setMountedHost(hostOrGroupId);
        String storageDeviceId = replica.getStorageDeviceId();
        String lunGroupId = this.createLunGroup(storageDeviceId, vo);
        replica.addProperty("lunGroupId", lunGroupId);
        if (!this.generateSubProcessor(context, lunGroupId, vo, hostOrGroupId, storageDeviceId)) {
            logger.error((Object)"generate sub procssor failed", 90160758784001L);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        return this.executeSubProcessor(context);
    }

    private String createLunGroup(String storageDeviceId, ResourceVO resourceVO) {
        StorageLunManagerProxy storageManagerProxy = StorageLunManagerProxy.getInstance();
        IRecoveryResourceService recoveryService = (IRecoveryResourceService)ServiceLocator.getInstance().getService(IRecoveryResourceService.class);
        String deviceType = recoveryService.getStorageType(storageDeviceId);
        IStorageLunBaseManager proxy = storageManagerProxy.getStorageLunMgrByDevType(deviceType);
        String lunGroupId = null;
        if (resourceVO instanceof HostVO) {
            lunGroupId = proxy.prepareMapping(storageDeviceId, (HostVO)resourceVO);
        } else if (resourceVO instanceof HostGroupVO) {
            lunGroupId = proxy.prepareMapping(storageDeviceId, (HostGroupVO)resourceVO);
        }
        return lunGroupId;
    }

    private boolean generateSubProcessor(RecoveryProcessorContext context, String lunGroupId, ResourceVO resourceVO, String hostOrGroupId, String devSn) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Object)recoveryPlan)) {
            logger.error((Object)"RestoreNativeReplicaSubProcessor: recoverplan is null.");
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        List recoveryProcesses = this.getRecoveryProcessors(recoveryPlan, DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)this.getProcType()), CreateNativeLunSubProcessor.class);
        HashSet<MappingLunSubProcessor> mappingLunProcessors = new HashSet<MappingLunSubProcessor>();
        for (RecoveryProcessor processor : recoveryProcesses) {
            CreateNativeLunSubProcessor createProcessor = (CreateNativeLunSubProcessor)processor;
            MappingLunSubProcessor subProcessor = new MappingLunSubProcessor();
            subProcessor.setProcName(subProcessor.getName());
            subProcessor.setProcType(this.getProcType());
            subProcessor.setPlanId(this.getPlanId());
            subProcessor.setProcessId(this.getProcessId());
            subProcessor.setParentProc((RecoveryProcessor)this);
            subProcessor.setSrcDeviceId(devSn);
            subProcessor.setDeviceId(devSn);
            subProcessor.setLunId(createProcessor.getDstLunId());
            subProcessor.setLunWWN(createProcessor.getDstLunWwn());
            subProcessor.setLunName(createProcessor.getDstLunName());
            subProcessor.setLunGroupId(lunGroupId);
            subProcessor.setResourceVO(resourceVO);
            subProcessor.setHostOrGroupId(hostOrGroupId);
            subProcessor.setIsCheckReplication(false);
            subProcessor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
            mappingLunProcessors.add(subProcessor);
        }
        if (!VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            this.updateSubProcessors(mappingLunProcessors);
        } else {
            this.setChildProc(mappingLunProcessors);
        }
        if (!((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this)) {
            logger.error((Object)"save recover processor failed.");
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        return true;
    }
}

