/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.recovery.process;

import com.huawei.ism.array.sdk.model.HvsUnit;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryResourceService;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.host.recovery.process.MappingSnapshotSubProcessor;
import com.huawei.ism.drm.host.util.DrHostUtil;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.framework.util.RecoveryProcessUtil;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.recovery.sdk.model.HostGroupVO;
import com.huawei.ism.drm.recovery.sdk.model.HostVO;
import com.huawei.ism.drm.recovery.sdk.model.ResourceVO;
import com.huawei.ism.drm.storage.manager.proxy.StorageLunManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageLunBaseManager;
import com.huawei.ism.drm.storage.recovery.process.CreateSnapshotCopySubProcessor;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoUnsupportedOperationException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MappingSnapshotProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -5862047499194345022L;
    private static Log logger = LogFactory.getInstance(MappingSnapshotProcessor.class);

    public final boolean execute(RecoveryProcessorContext context) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        this.updateProcessName(this.calcProcessName(recoveryPlan.getPlanType()));
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue() == this.getProcType() && DrmEnumDefine.RecoveryPlanTypeE.LOCAL.getValue() == recoveryPlan.getPlanType()) {
            List recoveryProcesses = this.getRecoveryProcessors(recoveryPlan, DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING, CreateSnapshotCopySubProcessor.class);
            this.updateSubProcessors4Local(recoveryProcesses);
        } else {
            Map lunAndSnapshotInfos = (Map)context.getAttribute("CreateSnapshotSubProcessors");
            Map backCopySnapshotInfos = (Map)context.getAttribute("TYPE_OF_CREATE_SNAPSHOT_BACKUP_COPY_PRO");
            Map waitUpdatedMap = this.isEmptyMap(lunAndSnapshotInfos) ? backCopySnapshotInfos : lunAndSnapshotInfos;
            this.updateChildSubProcessors(waitUpdatedMap);
        }
        if (this.getChildProc() == null || this.getChildProc().isEmpty()) {
            return this.endRecoveryProcess(context);
        }
        this.initResourceVOs();
        Map<String, String> lunGroupIds = this.prepareMapping();
        this.setLunGroupId(lunGroupIds);
        List processors = RecoveryServiceUtil.sortAndUpdateProcessorRation((Set)this.getChildProc());
        RecoveryProcessConcurrentExecutor recoveryTemplate = RecoveryProcessConcurrentExecutor.createExecutor((List)processors);
        recoveryTemplate.process(context);
        boolean executeResult = this.calcProcessResultBySubProc();
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS.getValue() == this.getProcStatus()) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            executeResult = false;
        }
        return executeResult;
    }

    private boolean isEmptyMap(Map<String, String> waitCheckMap) {
        return waitCheckMap == null || waitCheckMap.isEmpty();
    }

    private void setLunGroupId(Map<String, String> lunGroupIds) {
        Set subProcessors = this.getChildProc();
        for (RecoveryProcessor subProcessor : subProcessors) {
            MappingSnapshotSubProcessor mappingSnapshotSubProcessor = (MappingSnapshotSubProcessor)subProcessor;
            String lunGroupId = lunGroupIds.get(mappingSnapshotSubProcessor.getDeviceId() + "_" + mappingSnapshotSubProcessor.getHostOrGroupId());
            if (VerifyUtil.isEmpty((String)lunGroupId)) continue;
            mappingSnapshotSubProcessor.setLunGroupId(lunGroupId);
        }
    }

    public String generateResultKey() {
        throw new LegoUnsupportedOperationException("The operation is not supported.");
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected boolean isSameProcessor(RecoveryProcessor oldProcess, RecoveryProcessor newProcess) {
        if (null == oldProcess || null == newProcess) {
            logger.error((Object)"oldProcess or newProcess is emtpy.");
            return false;
        }
        MappingSnapshotSubProcessor preProcessor = (MappingSnapshotSubProcessor)oldProcess;
        MappingSnapshotSubProcessor newProcessor = (MappingSnapshotSubProcessor)newProcess;
        return preProcessor.getLunId().equals(newProcessor.getLunId()) && preProcessor.getDeviceId().equals(newProcessor.getDeviceId()) && preProcessor.getHostOrGroupId().equals(newProcessor.getHostOrGroupId());
    }

    protected void updateProcessorData(RecoveryProcessor oldProcess, RecoveryProcessor newProcess) {
        if (null == oldProcess || null == newProcess) {
            logger.error((Object)"oldProcess or newProcess is emtpy.");
            return;
        }
        MappingSnapshotSubProcessor preProcessor = (MappingSnapshotSubProcessor)oldProcess;
        MappingSnapshotSubProcessor newProcessor = (MappingSnapshotSubProcessor)newProcess;
        this.updateProcessorStatus(preProcessor, newProcessor);
        preProcessor.setSnapshotId(newProcessor.getSnapshotId());
        preProcessor.setSnapshotName(newProcessor.getSnapshotName());
    }

    protected final boolean updateChildSubProcessors(Map<String, String> lunAndSnapshotInfos) {
        if (lunAndSnapshotInfos == null || lunAndSnapshotInfos.isEmpty()) {
            logger.error((Object)"The map of lunAndSnapshotInfos is empty.");
            return true;
        }
        Set<RecoveryProcessor> subProcessors = this.createMappingSnapshotSubProcessors(lunAndSnapshotInfos);
        if (this.getChildProc() == null || this.getChildProc().isEmpty()) {
            this.setChildProc(subProcessors);
        } else {
            this.updateSubProcessors(subProcessors);
        }
        return ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private void initResourceVOs() {
        HashSet<String> hostOrGroupIds = new HashSet<String>();
        Set subProcessors = this.getChildProc();
        for (RecoveryProcessor subProcessor : subProcessors) {
            MappingSnapshotSubProcessor mappingSnapshotSubProcessor = (MappingSnapshotSubProcessor)subProcessor;
            String hostOrGroupId = mappingSnapshotSubProcessor.getHostOrGroupId();
            if (VerifyUtil.isEmpty((String)hostOrGroupId)) continue;
            hostOrGroupIds.add(hostOrGroupId);
        }
        Map<String, ResourceVO> resourceVOs = DrHostUtil.getHostInitiators(hostOrGroupIds);
        if (!VerifyUtil.isEmpty(resourceVOs)) {
            for (RecoveryProcessor subProcessor : subProcessors) {
                MappingSnapshotSubProcessor mappingSnapshotSubProcessor = (MappingSnapshotSubProcessor)subProcessor;
                ResourceVO resourceVO = resourceVOs.get(mappingSnapshotSubProcessor.getHostOrGroupId());
                mappingSnapshotSubProcessor.setResourceVO(resourceVO);
            }
        }
    }

    private boolean updateSubProcessors4Local(Collection<RecoveryProcessor> recoveryProcesses) {
        if (VerifyUtil.isEmpty(recoveryProcesses)) {
            return true;
        }
        Set<RecoveryProcessor> subProcessors = this.createMappingSnapshotSubProcessors4Local(recoveryProcesses);
        if (this.getChildProc() == null || this.getChildProc().isEmpty()) {
            this.setChildProc(subProcessors);
        } else {
            this.updateSubProcessors(subProcessors);
        }
        return ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    protected Set<RecoveryProcessor> createMappingSnapshotSubProcessors(Map<String, String> lunAndSnapshotInfos) {
        HashSet<RecoveryProcessor> subProcessors = new HashSet<RecoveryProcessor>();
        Set<Map.Entry<String, String>> entrySet = lunAndSnapshotInfos.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            String[] hostOrGroupIds;
            String key = entry.getKey();
            String str = key.split(":")[1];
            String[] strArray = str.split(";");
            String deviceId = strArray[0].split("=")[1];
            String lunId = strArray[1].split("=")[1];
            String value = entry.getValue();
            strArray = value.split(";");
            String snapshotId = strArray[0];
            String snapshotName = strArray[1];
            String snapshotWWN = strArray[2];
            for (String hostOrGroupId : hostOrGroupIds = strArray[3].split(":")) {
                MappingSnapshotSubProcessor processor = new MappingSnapshotSubProcessor();
                processor.setProcName(processor.getName());
                processor.setProcType(this.getProcType());
                processor.setPlanId(this.getPlanId());
                processor.setProcessId(this.getProcessId());
                processor.setParentProc((RecoveryProcessor)this);
                processor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
                processor.setDeviceId(deviceId);
                processor.setLunId(lunId);
                processor.setSnapshotId(snapshotId);
                processor.setSnapshotName(snapshotName);
                processor.setSnapshotWWN(snapshotWWN);
                processor.setHostOrGroupId(hostOrGroupId);
                subProcessors.add((RecoveryProcessor)processor);
            }
        }
        return subProcessors;
    }

    protected Set<RecoveryProcessor> createMappingSnapshotSubProcessors4Local(Collection<RecoveryProcessor> recoveryProcesses) {
        HashSet<RecoveryProcessor> subProcessors = new HashSet<RecoveryProcessor>();
        for (RecoveryProcessor process : recoveryProcesses) {
            CreateSnapshotCopySubProcessor copySubProcessor = (CreateSnapshotCopySubProcessor)process;
            String hostOrGroupIds = copySubProcessor.getHostOrGroupIds();
            List hosts = RecoveryProcessUtil.getHostOrGroupIds((String)hostOrGroupIds);
            if (VerifyUtil.isEmpty((Collection)hosts)) continue;
            for (String tmpHostOrGroupId : hosts) {
                MappingSnapshotSubProcessor processor = new MappingSnapshotSubProcessor();
                processor.setProcName("com.huawei.ism.drm.host.recovery.process.MappingSnapshotCopySubProcessor");
                processor.setProcType(this.getProcType());
                processor.setPlanId(this.getPlanId());
                processor.setProcessId(this.getProcessId());
                processor.setParentProc((RecoveryProcessor)this);
                processor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
                processor.setDeviceId(copySubProcessor.getDeviceId());
                processor.setLunId(copySubProcessor.getLunId());
                processor.setSnapshotId(copySubProcessor.getSnapshotId());
                processor.setSnapshotName(copySubProcessor.getSnapshotName());
                processor.setHostOrGroupId(tmpHostOrGroupId);
                subProcessors.add((RecoveryProcessor)processor);
            }
        }
        return subProcessors;
    }

    private void updateProcessorStatus(MappingSnapshotSubProcessor preProcessor, MappingSnapshotSubProcessor newProcessor) {
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == preProcessor.getProcStatus() && null != preProcessor.getSnapshotId() && null != newProcessor.getSnapshotId() && !preProcessor.getSnapshotId().equals(newProcessor.getSnapshotId())) {
            preProcessor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
            logger.info((Object)("The snapshot id has been changed. DevSN:" + preProcessor.getDeviceId() + ",LunId:" + preProcessor.getLunId() + ",OldSnapshotId:" + preProcessor.getSnapshotId() + ",NewSnapshotId:" + preProcessor.getSnapshotId()), 90160758784000L);
        }
    }

    private boolean endRecoveryProcess(RecoveryProcessorContext context) {
        if (RecoveryServiceUtil.getAppType((RecoveryPlan)context.getRecoveryPlan()) == DrmEnumDefine.AppType.LUN) {
            this.updateProcessDetail("ism.drm.recovery.no.configured.host", new String[0]);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        this.updateProcessDetail("ism.drm.recovery.no.configured.host", new String[0]);
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
        return false;
    }

    public void updateProcessName() {
        IRecoveryPlanService recoveryPlanService = (IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class);
        RecoveryPlan recoverPlan = recoveryPlanService.queryRecoveryPlanWithoutAssociatedData(this.getPlanId());
        this.setProcName(this.calcProcessName(recoverPlan.getPlanType()));
    }

    protected String calcProcessName(int planType) {
        String processName = this.getName();
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue() == this.getProcType() && DrmEnumDefine.RecoveryPlanTypeE.LOCAL.getValue() == planType) {
            processName = "com.huawei.ism.drm.host.recovery.process.MappingSnapshotCopyProcessor";
        }
        return processName;
    }

    private Map<String, String> prepareMapping() {
        Set subProcessors = this.getChildProc();
        HashMap<String, HashSet<ResourceVO>> resourceVOMap = new HashMap<String, HashSet<ResourceVO>>();
        for (RecoveryProcessor subProcessor : subProcessors) {
            MappingSnapshotSubProcessor mappingSnapshotSubProcessor = (MappingSnapshotSubProcessor)subProcessor;
            HashSet<ResourceVO> resources = (HashSet<ResourceVO>)resourceVOMap.get(mappingSnapshotSubProcessor.getDeviceId());
            if (null == resources) {
                resources = new HashSet<ResourceVO>();
                resourceVOMap.put(mappingSnapshotSubProcessor.getDeviceId(), resources);
            }
            resources.add(mappingSnapshotSubProcessor.getResourceVO());
        }
        HashMap<String, String> lunGroupIds = new HashMap<String, String>();
        StorageLunManagerProxy storageManagerProxy = StorageLunManagerProxy.getInstance();
        IRecoveryResourceService recoveryService = (IRecoveryResourceService)ServiceLocator.getInstance().getService(IRecoveryResourceService.class);
        for (Map.Entry entry : resourceVOMap.entrySet()) {
            String deviceType = recoveryService.getStorageType((String)entry.getKey());
            IStorageLunBaseManager proxy = storageManagerProxy.getStorageLunMgrByDevType(deviceType);
            Set resources = (Set)entry.getValue();
            for (ResourceVO resouce : resources) {
                String key = (String)entry.getKey() + "_" + resouce.getId();
                String lunGroupId = resouce instanceof HostVO ? proxy.prepareMapping((String)entry.getKey(), (HostVO)resouce) : proxy.prepareMapping((String)entry.getKey(), (HostGroupVO)resouce);
                if (!VerifyUtil.isEmpty((String)lunGroupId)) {
                    lunGroupIds.put(key, lunGroupId);
                    logger.debug((Object)("prepareMapping, lunGroupId:" + lunGroupId + ",key:" + key));
                    continue;
                }
                if (!HvsUnit.class.getName().equals(deviceType)) continue;
                logger.error((Object)"prepareMapping return lunGroupId is null for HvsUnit.");
            }
        }
        return lunGroupIds;
    }

    public void updateDescription() {
        IRecoveryPlanService recoveryPlanService = (IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class);
        RecoveryPlan recoveryPlan = recoveryPlanService.queryRecoveryPlanWithoutAssociatedData(this.getPlanId());
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue() == this.getProcType() && DrmEnumDefine.RecoveryPlanTypeE.LOCAL.getValue() == recoveryPlan.getPlanType()) {
            this.setDescription("com.huawei.ism.drm.storage.recovery.process.MappingSnapshotCopyProcessor.des");
        } else {
            this.setDescription("com.huawei.ism.drm.storage.recovery.process.MappingSnapshotProcessor.des");
        }
    }

    public String getStepPosition() {
        return "MappingSnapshot";
    }
}

