/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.recovery.process;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.host.recovery.process.RefreshHostSubProcessor;
import com.huawei.ism.drm.host.sdk.model.DrHost;
import com.huawei.ism.drm.host.sdk.model.DrHostGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessResult;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoUnsupportedOperationException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RefreshHostProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 1591468831038036494L;
    private static final Log LOGGER = LogFactory.getInstance(RefreshHostProcessor.class);
    private Map<String, Boolean> lastProcResult;

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected boolean execute(RecoveryProcessorContext context) {
        RecoveryProcessResult processResult = context.getProcessResult();
        this.lastProcResult = processResult.getMappingProcessResults();
        LOGGER.info((Object)("RefreshHostProcessor: " + this.lastProcResult), 90160758786944L);
        Set subProcessors = this.getChildProc();
        if (null == subProcessors || subProcessors.isEmpty()) {
            this.createSubProcessors(context);
        } else {
            this.updateMountSubProcessors(subProcessors);
        }
        List processors = RecoveryServiceUtil.sortAndUpdateProcessorRation((Set)this.getChildProc());
        RecoveryProcessConcurrentExecutor recoveryTemplate = RecoveryProcessConcurrentExecutor.createExecutor((List)processors);
        if (null == recoveryTemplate) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        recoveryTemplate.process(context);
        return this.calcProcessResultBySubProc();
    }

    protected boolean calcProcessResultBySubProc() {
        boolean executeResult = super.calcProcessResultBySubProc();
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS.getValue() == this.getProcStatus()) {
            if (this.getContextRef().getProtectGroup().getPoType() == 19) {
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
                executeResult = true;
            } else {
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
                executeResult = false;
            }
        }
        return executeResult;
    }

    public String generateResultKey() {
        throw new LegoUnsupportedOperationException("The operation is not supported.");
    }

    protected boolean createSubProcessors(RecoveryProcessorContext context) {
        Set<ProtectObject> pos = context.getRecoveryProtectObjects();
        if (pos == null) {
            LOGGER.error((Object)"can't find ProtectObject from context");
            pos = Collections.emptySet();
        }
        HashSet<RecoveryProcessor> subProcessors = new HashSet<RecoveryProcessor>();
        HashSet<String> mountProcKeySet = new HashSet<String>();
        for (ProtectObject po : pos) {
            DrResource hostOrGroup = this.getRecoveryHostOrGroupId(context.getRecoveryPlan(), po);
            if (null == hostOrGroup) {
                LOGGER.error((Object)("hostOrGroup is null.poid is " + po.getUuid() + ",poName is " + po.getName()), 90160758786989L);
                continue;
            }
            Set<DrResource> hosts = new HashSet();
            if (hostOrGroup instanceof DrHostGroup) {
                hosts = hostOrGroup.getChildResources();
            } else if (hostOrGroup instanceof DrHost) {
                hosts.add(hostOrGroup);
            }
            for (DrResource host : hosts) {
                RefreshHostSubProcessor subProcessor = this.generateSubProcessor(host);
                this.addProcessorToSubProcessors(subProcessors, mountProcKeySet, subProcessor);
            }
        }
        this.setChildProc(subProcessors);
        boolean result = ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
        return result;
    }

    private void addProcessorToSubProcessors(Set<RecoveryProcessor> subProcessors, Set<String> mountProcKeySet, RefreshHostSubProcessor subProcessor) {
        String resultKey = subProcessor.generateResultKey();
        if (!mountProcKeySet.contains(resultKey)) {
            subProcessors.add((RecoveryProcessor)subProcessor);
            mountProcKeySet.add(subProcessor.generateResultKey());
        }
    }

    private DrResource getRecoveryHostOrGroupId(RecoveryPlan recoveryPlan, ProtectObject po) {
        String deviceSn = (String)recoveryPlan.getGlobalSettings().get("PG_DISASTER_HOST");
        for (RecoverySetting setting : recoveryPlan.getRecoverySettings()) {
            if (!setting.getRecoveryPlan().getPlanId().equals(recoveryPlan.getPlanId()) || !setting.getName().equals("PG_DISASTER_HOST")) continue;
            deviceSn = setting.getValue();
            break;
        }
        if (VerifyUtil.isEmpty((String)deviceSn)) {
            LOGGER.error((Object)("the protectobject(" + po.getName() + ") has not matched hostInfo"), 90160758786989L);
            return null;
        }
        List list = CommonDAOLocator.getBaseDao().find("from DrResource where deviceSn = ?", new Object[]{deviceSn});
        if (list.isEmpty()) {
            LOGGER.error((Object)("the drresource(deviceSn:" + deviceSn + ") dose not exist."), 90160758786989L);
            return null;
        }
        return (DrResource)list.get(0);
    }

    private boolean updateMountSubProcessors(Set<RecoveryProcessor> subProcessors) {
        this.setChildProc(subProcessors);
        boolean result = ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
        return result;
    }

    private RefreshHostSubProcessor generateSubProcessor(DrResource host) {
        RefreshHostSubProcessor subProcessor = new RefreshHostSubProcessor();
        subProcessor.setProcType(this.getProcType());
        subProcessor.setPlanId(this.getPlanId());
        subProcessor.setProcessId(this.getProcessId());
        subProcessor.setParentProc((RecoveryProcessor)this);
        subProcessor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
        subProcessor.setHostDeviceName(host.getName());
        subProcessor.setHostSN(host.getDeviceSn());
        subProcessor.setProcName(subProcessor.getName());
        return subProcessor;
    }

    public void updateDescription() {
        this.setDescription("com.huawei.ism.drm.host.recovery.process.RefreshHostProcessor.des");
    }
}

