/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.recovery.process;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.host.recovery.process.RemoveLunMappingProcessor;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessBaseProvider;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessProvider;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import org.springframework.stereotype.Component;

@Component
public class RemoveLunMappingBeforeCheckProcessor
extends RemoveLunMappingProcessor {
    private static final long serialVersionUID = -8341477350631587891L;
    private static final Log LOGGER = LogFactory.getInstance(RemoveLunMappingBeforeCheckProcessor.class);

    @Override
    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    @Override
    protected boolean execute(RecoveryProcessorContext context) {
        LOGGER.info((Object)"Begin to RemoveLunMappingBeforeCheckProcessor.");
        if (VerifyUtil.isEmpty((Object)context)) {
            LOGGER.error((Object)"RemoveLunMappingBeforeCheckProcessor: context is empty!");
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() == this.getProcType() || DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK.getValue() == this.getProcType()) {
            boolean isStopped;
            IRecoveryProcessBaseProvider recoveryProcessProvider = RecoveryServiceUtil.getRecoveryProcessProvider((RecoveryPlan)recoveryPlan);
            if (!(recoveryProcessProvider instanceof IRecoveryProcessProvider)) {
                LOGGER.error((Object)"RemoveLunMappingBeforeCheckProcessor: recoveryProcessProvider is invalid!");
                return false;
            }
            IRecoveryProcessProvider provider = (IRecoveryProcessProvider)recoveryProcessProvider;
            if (VerifyUtil.isEmpty((Object)provider)) {
                LOGGER.error((Object)"RemoveLunMappingBeforeCheckProcessor: provider is empty!");
                return false;
            }
            try {
                isStopped = provider.checkProductionBusinessStopped(context);
            }
            catch (LegoCheckedException e) {
                LOGGER.error((Object)"Check lun mapping failed.");
                throw e;
            }
            if (isStopped) {
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
                return true;
            }
        }
        return super.execute(context);
    }

    public void updateDescription() {
        this.setDescription("com.huawei.ism.drm.host.recovery.process.RemoveLunMappingBeforeCheckProcessor.des");
    }

    public String getStepPosition() {
        return "RemoveMapping";
    }
}

