/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.recovery.process;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.host.recovery.process.UmountHostDeviceSubProcessor;
import com.huawei.ism.drm.host.recovery.process.UmountProHostDeviceSubProcessor;
import com.huawei.ism.drm.host.util.DBRecoveryTools;
import com.huawei.ism.drm.host.util.DrHostUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUnsupportedOperationException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class UmountProHostDeviceProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 252756386811799335L;
    private static final Log LOGGER = LogFactory.getInstance(UmountProHostDeviceProcessor.class);

    public UmountProHostDeviceProcessor() {
        this.setIsNeedSave(false);
    }

    public UmountProHostDeviceProcessor(RecoveryProcessor parentProcess) {
        this();
        if (null == parentProcess) {
            return;
        }
        this.setProcName(this.getName());
        this.setProcType(parentProcess.getProcType());
        this.setPlanId(parentProcess.getPlanId());
        this.setParentProc(parentProcess);
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected String generateResultKey() {
        throw new LegoUnsupportedOperationException("The operation is not supported.");
    }

    protected boolean execute(RecoveryProcessorContext context) {
        List<ProtectObject> pos = DBRecoveryTools.appCurrentPosFilter(context);
        Iterator pgIter = context.getRecoveryPlan().getProtectGroups().iterator();
        if (!pgIter.hasNext()) {
            throw new LegoCheckedException(1073947393L);
        }
        String hostOrGroupId = ((ProtectGroup)pgIter.next()).getPoProviderSN();
        Set<DrResource> hosts = DrHostUtil.getDrHostsByHostOrGroupId(hostOrGroupId);
        Set subProcessors = this.getChildProc();
        if (VerifyUtil.isEmpty((Collection)subProcessors)) {
            this.createSubProcessors(pos, hosts);
        }
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            LOGGER.error((Object)"getChildProc is empty.", 90160758786989L);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return false;
        }
        subProcessors = this.getChildProc();
        for (RecoveryProcessor recoveryProcessor : subProcessors) {
            UmountHostDeviceSubProcessor subProcessor = (UmountHostDeviceSubProcessor)recoveryProcessor;
            subProcessor.setProtectObjects(pos);
        }
        List processors = RecoveryServiceUtil.sortAndUpdateProcessorRation((Set)subProcessors);
        RecoveryProcessConcurrentExecutor recoveryTemplate = RecoveryProcessConcurrentExecutor.createExecutor((List)processors);
        if (null == recoveryTemplate) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return false;
        }
        recoveryTemplate.process(context);
        return this.calcProcessResultBySubProc();
    }

    protected boolean createSubProcessors(List<ProtectObject> pos, Set<DrResource> hosts) {
        HashSet<UmountProHostDeviceSubProcessor> subProcessors = new HashSet<UmountProHostDeviceSubProcessor>();
        for (DrResource host : hosts) {
            UmountProHostDeviceSubProcessor umountProc = new UmountProHostDeviceSubProcessor();
            umountProc.setProcName(umountProc.getName());
            umountProc.setProcType(this.getProcType());
            umountProc.setPlanId(this.getPlanId());
            umountProc.setParentProc((RecoveryProcessor)this);
            umountProc.setProtectObjects(pos);
            umountProc.setHostSN(host.getDeviceSn());
            umountProc.setHostName(host.getName());
            umountProc.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
            umountProc.setResult(Boolean.TRUE);
            subProcessors.add(umountProc);
        }
        this.setChildProc(subProcessors);
        boolean result = ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
        return result;
    }

    protected boolean calcProcessResultBySubProc() {
        boolean executeResult = super.calcProcessResultBySubProc();
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS.getValue() == this.getProcStatus()) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            executeResult = false;
        }
        return executeResult;
    }
}

