/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.recovery.process.builder;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.host.recovery.process.DeleteNasSnapshotMappingProcessor;
import com.huawei.ism.drm.host.recovery.process.DeleteNasSnapshotMappingSubProcessor;
import com.huawei.ism.drm.host.recovery.process.MappingNasSnapshotSubProcessor;
import com.huawei.ism.drm.protection.replica.sdk.model.LocalStorageReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.recovery.process.IMappingReplicaSubProcessorBuilder;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.sdk.model.NasSnapshotClone;
import com.huawei.ism.drm.storage.util.NasCloneUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MappingNasSnapshotCloneReplicaProcessorBuilder
implements IMappingReplicaSubProcessorBuilder {
    private static final Log LOGGER = LogFactory.getInstance(MappingNasSnapshotCloneReplicaProcessorBuilder.class);

    public Set<RecoveryProcessor> buildMappingProcessor(RecoveryProcessor parent, ProtectGroupReplica replica) {
        HashSet<RecoveryProcessor> results = new HashSet<RecoveryProcessor>();
        String hostOrHostgroupId = replica.getMountedHost();
        List cloneList = NasCloneUtil.getNasSnapshotClones((ProtectGroupReplica)replica);
        Set protectObjectReplicaList = replica.getReplicas();
        for (ProtectObjectReplica protectObjectReplica : protectObjectReplicaList) {
            Set storageReplicaList = protectObjectReplica.getStorageInfos();
            for (RelicaStorageInfo storageInfo : storageReplicaList) {
                MappingNasSnapshotSubProcessor processor = new MappingNasSnapshotSubProcessor();
                processor.setProcName("com.huawei.ism.drm.host.recovery.process.MappingNasSnapshotSubProcessor");
                processor.setProcType(parent.getProcType());
                processor.setPlanId(parent.getPlanId());
                processor.setProcessId(parent.getProcessId());
                processor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
                processor.setParentProc(parent);
                processor.setReplicaSourceId(storageInfo.getSrcStorageId());
                processor.setDeviceId(storageInfo.getSrcStorageProviderSN());
                processor.setReplicaId(storageInfo.getStorageId());
                if (storageInfo instanceof LocalStorageReplica) {
                    processor.setReplicaName(((LocalStorageReplica)storageInfo).getSnapshotName());
                }
                processor.setMountHostOrHostGroupId(hostOrHostgroupId);
                processor.setNasSnapshotClone(this.filterClone(cloneList, storageInfo.getStorageId()));
                results.add((RecoveryProcessor)processor);
            }
        }
        return results;
    }

    private NasSnapshotClone filterClone(List<NasSnapshotClone> cloneList, String id) {
        return cloneList.stream().filter(e -> e.getId().equals(id)).findFirst().orElseGet(NasSnapshotClone::new);
    }

    public Set<RecoveryProcessor> buildDeleteMappingProcessor(RecoveryProcessor parent, List<RecoveryProcessor> processors) {
        ProtectGroupReplica replica = null;
        if (parent instanceof DeleteNasSnapshotMappingProcessor) {
            DeleteNasSnapshotMappingProcessor processor = (DeleteNasSnapshotMappingProcessor)parent;
            RecoveryProcessorContext context = processor.getContextRef();
            if (context == null) {
                LOGGER.error((Object)"context is null!");
                throw new LegoCheckedException(1073947393L);
            }
            replica = context.getProtectGroupReplica();
        }
        if (replica == null) {
            LOGGER.error((Object)"replica is null!");
            throw new LegoCheckedException(1073947393L);
        }
        List cloneList = NasCloneUtil.getNasSnapshotClones(replica);
        HashSet<RecoveryProcessor> results = new HashSet<RecoveryProcessor>();
        for (RecoveryProcessor processor : processors) {
            if (!(processor instanceof MappingNasSnapshotSubProcessor)) continue;
            MappingNasSnapshotSubProcessor tmpProcessor = (MappingNasSnapshotSubProcessor)processor;
            for (NasSnapshotClone nasSnapshotClone : cloneList) {
                if (!tmpProcessor.getReplicaSourceId().equals(nasSnapshotClone.getParentFilesystemId())) continue;
                DeleteNasSnapshotMappingSubProcessor subProcessor = new DeleteNasSnapshotMappingSubProcessor();
                subProcessor.setProcName("com.huawei.ism.drm.host.recovery.process.DeleteNasSnapshotMappingSubProcessor");
                subProcessor.setProcType(parent.getProcType());
                subProcessor.setPlanId(parent.getPlanId());
                subProcessor.setProcessId(parent.getProcessId());
                subProcessor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
                subProcessor.setParentProc(parent);
                subProcessor.setDeviceId(tmpProcessor.getDeviceId());
                subProcessor.setSnapshotId(tmpProcessor.getReplicaId());
                subProcessor.setSnapshotName(tmpProcessor.getReplicaName());
                subProcessor.setHostOrGroupId(tmpProcessor.getMountHostOrHostGroupId());
                subProcessor.setNasSnapshotClone(nasSnapshotClone);
                results.add((RecoveryProcessor)subProcessor);
            }
        }
        return results;
    }

    public int getReplicaType() {
        return 14;
    }
}

