/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.reprotect.manager;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.base.util.MOUtil;
import com.huawei.ism.cbb.discover.sdk.service.INeMgrProtocolExtendService;
import com.huawei.ism.database.sdk.model.DatabaseInstance;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryResourceService;
import com.huawei.ism.drm.host.discovery.proxy.HostApplicationDiscoverProxy;
import com.huawei.ism.drm.host.sdk.model.DrHost;
import com.huawei.ism.drm.host.util.DrHostUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.reprotect.manager.sdk.service.IReprotectEnvironmentChecker;
import com.huawei.ism.drm.util.RecoveryUtil;
import com.huawei.ism.host.sdk.model.Host;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HostReprotectEnvironmentChecker
implements IReprotectEnvironmentChecker {
    public List<String> getTypes() {
        ArrayList<String> types = new ArrayList<String>();
        types.add(Host.class.getName());
        return types;
    }

    public Map<String, Object> checkEnviroment(RecoveryPlan recoveryPlan) {
        this.refreshHosts(recoveryPlan);
        return new HashMap<String, Object>();
    }

    private void refreshHosts(RecoveryPlan recoveryPlan) {
        String planId = recoveryPlan.getPlanId();
        Set settings = recoveryPlan.getRecoverySettings();
        Iterator pgIter = recoveryPlan.getProtectGroups().iterator();
        if (!pgIter.hasNext()) {
            throw new LegoCheckedException(1073947394L);
        }
        String pgId = ((ProtectGroup)pgIter.next()).getUuid();
        RecoverySetting hostSetting = RecoveryUtil.getRecoverySetting((String)planId, (String)pgId, (String)"PG_DISASTER_HOST", (Set)settings);
        IRecoveryResourceService recoveryService = (IRecoveryResourceService)ServiceLocator.getInstance().getService(IRecoveryResourceService.class);
        if (null == hostSetting) {
            throw new LegoCheckedException(1073947394L);
        }
        List drHosts = recoveryService.getDrHostsByDrHostOrGroupId(hostSetting.getValue());
        IMoDao moDao = CommonDAOLocator.getMoDao();
        HostApplicationDiscoverProxy hostAppDiscoverProxy = HostApplicationDiscoverProxy.getInstance();
        for (DrHost drHost : drHosts) {
            Host host = (Host)moDao.getMo(Host.class, "hostSN", (Object)drHost.getDeviceSn());
            if (null == host) {
                throw new LegoCheckedException(1073947394L);
            }
            INeMgrProtocolExtendService service = (INeMgrProtocolExtendService)ServiceLocator.getInstance().getService(INeMgrProtocolExtendService.class);
            NeMgrProtocolExtend extend = service.findByMoId(host.getMoId());
            Map<Integer, List<ManagedObject>> results = hostAppDiscoverProxy.discoverApplication(extend);
            ArrayList<ManagedObject> oldMOs = new ArrayList<ManagedObject>();
            for (ManagedObject mo : host.getChildMos()) {
                if (!(mo instanceof DatabaseInstance)) continue;
                oldMOs.add(mo);
            }
            DrHostUtil.updateAppInfo(host, results);
            ArrayList appMos = new ArrayList();
            appMos.addAll(host.getChildMos());
            MOUtil.saveOrUpdateMoAndDeleteOldMo((IMoDao)moDao, appMos, oldMOs);
        }
    }
}

