/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.service.impl;

import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskHandler;
import com.huawei.ism.cbb.base.task.BackTaskUtil;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.host.sdk.service.IHostDataCollectService;
import com.huawei.ism.drm.host.sdk.service.IHostService;
import com.huawei.ism.drm.host.service.impl.HostDataCollectBackTask;
import com.huawei.ism.drm.host.util.HostDataCollectUtil;
import com.huawei.ism.host.sdk.model.Host;
import com.huawei.lego.cbb.backtask.sdk.model.BackTask;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.io.File;

@Service(name="com.huawei.ism.drm.host.sdk.service.IHostDataCollectService", desc="", interfaceClass=IHostDataCollectService.class)
public class HostDataCollectServiceImpl
extends BaseService
implements IHostDataCollectService {
    private static Log logger = LogFactory.getInstance(HostDataCollectServiceImpl.class);

    public void dataCollect(String sn, String userName) {
        Host host = ((IHostService)ServiceLocator.getInstance().getService(IHostService.class)).getHost(sn);
        if (VerifyUtil.isEmpty((Object)host)) {
            logger.error((Object)("data collect failed,sn=" + sn), 90160758786989L);
            throw new LegoCheckedException(1073947394L);
        }
        BackTask bt = BackTaskUtil.buildBackTask((String)host.getName(), (String)"ism.drm.app.host.datacollect.operationName", (String)userName, (String)"", null);
        HostDataCollectBackTask task = new HostDataCollectBackTask(host.getUuid() + "dataCollect", bt, true, host);
        BackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
    }

    public File getAgentLogFile(String sn) {
        Host host = ((IHostService)ServiceLocator.getInstance().getService(IHostService.class)).getHost(sn);
        if (VerifyUtil.isEmpty((Object)host)) {
            logger.error((Object)("get agent log file failed,sn=" + sn), 90160758786989L);
            throw new LegoCheckedException(1073947394L);
        }
        int osType = NumberUtil.parseInteger((Object)host.getOs());
        String suffix = 1 == osType ? ".zip" : ".tar.gz";
        File logFile = new File(HostDataCollectUtil.getHostDataCollectLogFilePath() + sn + suffix);
        return logFile;
    }
}

