/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.topology;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.base.sdk.model.Initiator;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.host.sdk.model.DrHost;
import com.huawei.ism.drm.host.sdk.model.DrHostGroup;
import com.huawei.ism.drm.host.sdk.service.IHostService;
import com.huawei.ism.drm.host.topology.element.HostElement;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectionJobUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.sdk.model.DrStorage;
import com.huawei.ism.drm.topo.builder.AbstractGlobalTopoBuilder;
import com.huawei.ism.drm.topo.sdk.context.TopoBaseContext;
import com.huawei.ism.drm.topo.sdk.manager.ITopoResourceManager;
import com.huawei.ism.drm.topo.utils.TopoServiceUtil;
import com.huawei.lego.core.sdk.base.annotation.ServiceBoundInfo;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.topology.Element;
import com.huawei.topology.ElementBox;
import com.huawei.topology.Group;
import com.huawei.topology.IData;
import com.huawei.topology.Link;
import com.huawei.topology.Node;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

@ServiceBoundInfo(methodName="onBind", targetBeanName="topoBuilderManager", properties="type:Global-Topology-Host")
public class HostGlobalTopoBuilder
extends AbstractGlobalTopoBuilder {
    private static final int LOCAL_GROUP_OUTLINE_WIDTH = 1;
    private static final Log LOGGER = LogFactory.getInstance(HostGlobalTopoBuilder.class);
    private static final Map<Integer, String> APP_TYPE_ICON_MAP = new HashMap<Integer, String>();
    private static final List<Integer> SAN_ACTIVE_TEMPLATE_TYPE_LIST = new ArrayList<Integer>(Arrays.asList(15, 18, 19, 23));
    private static final Set<Integer> SNAPSHOT_TYPE_SET = new HashSet<Integer>();
    private IHostService hostService = null;

    public IHostService getHostService() {
        return this.hostService;
    }

    public void setHostService(IHostService hostService) {
        this.hostService = hostService;
    }

    public void buildTopo(TopoBaseContext context) {
        ProtectGroup protectGroup = context.getProtectGroup();
        ElementBox layout = (ElementBox)context.find((Object)"layout");
        ElementBox box = context.getElementBox();
        int poType = protectGroup.getPoType();
        if (!this.checkPoType(poType)) {
            return;
        }
        if (SAN_ACTIVE_TEMPLATE_TYPE_LIST.contains(protectGroup.getTemplate().getType()) || PolicyTemplateType.REP_4DC_POLICYTEMPLATE.contains(protectGroup.getTemplate().getType()) && ProtectionJobUtil.isHyperMetroInFirstSite((ProtectGroup)context.getProtectGroup())) {
            String hostSN = protectGroup.getPoProviderSN();
            DrResource drResource = this.getDrResourceInContext(context, hostSN);
            if (VerifyUtil.isEmpty((Object)drResource)) {
                return;
            }
            if (drResource instanceof DrHostGroup) {
                Set drHosts = drResource.getChildResources();
                for (DrResource eachHost : drHosts) {
                    String id = eachHost.getSiteId();
                    Site site = this.getSiteInContext(context, id);
                    Group group = this.getOrCreateGroup(box, site, layout);
                    Node hostNode = this.createHostTopo(context, eachHost, site, group, layout);
                    context.getVmEsxNode().add(hostNode);
                }
            } else if (drResource instanceof DrHost) {
                String id = drResource.getSiteId();
                Site site = this.getSiteInContext(context, id);
                Group group = this.getOrCreateGroup(box, site, layout);
                Node hostNode = this.createHostTopo(context, drResource, site, group, layout);
                context.getVmEsxNode().add(hostNode);
            }
        } else {
            String id = protectGroup.getProductSiteId();
            Site site = this.getSiteInContext(context, id);
            Group group = this.getOrCreateGroup(box, site, layout, context.isDoubleActive());
            String hostSN = protectGroup.getPoProviderSN();
            DrResource drResource = this.getDrResourceInContext(context, hostSN);
            if (VerifyUtil.isEmpty((Object)drResource)) {
                return;
            }
            if (drResource instanceof DrHostGroup) {
                Set drHosts = drResource.getChildResources();
                for (DrResource eachHost : drHosts) {
                    Node hostNode = this.createHostTopo(context, eachHost, site, group, layout);
                    context.getVmEsxNode().add(hostNode);
                    this.createHostStorages(context, layout, hostNode);
                }
            } else {
                Node hostNode = this.createHostTopo(context, drResource, site, group, layout);
                context.getVmEsxNode().add(hostNode);
                this.createHostStorages(context, layout, hostNode);
            }
        }
        this.createRecoveryHost(context, layout);
    }

    private void buildAsyncHyperMetroArrayAndHost(ProtectGroup protectGroup, TopoBaseContext context, ElementBox layout) {
        DrStorage targetResouce;
        Site site;
        String targetArraySn;
        ProtectGroup protectGroupAllInfo = context.getProtectGroupService().getProtectGroupByID(protectGroup.getUuid());
        Set replicas = protectGroupAllInfo.getReplicaList();
        if (VerifyUtil.isEmpty((Collection)replicas)) {
            LOGGER.error((Object)("the replicas is null, pgUUID is: " + protectGroupAllInfo.getUuid()));
            return;
        }
        ProtectGroupReplica pgReplica = (ProtectGroupReplica)replicas.iterator().next();
        Lun targetLun = this.getTargetLunInfo(pgReplica, targetArraySn = pgReplica.getRecoveryArray(), site = this.getSiteInContext(context, (targetResouce = (DrStorage)this.getDrResourceInContext(context, targetArraySn)).getSiteId()));
        if (null == targetLun) {
            LOGGER.error((Object)("The resouce is not Lun: targstoragearrayetArraySn=" + targetArraySn));
            return;
        }
        List lunList = 0 == site.getSiteType() ? context.getStorageService().getStorageResourceByWwn(new String[]{targetLun.getWwn()}) : context.getStorageService().getResourceByWwnFromRemote(site, new ArrayList<String>(Arrays.asList(targetLun.getWwn())));
        ArrayList<Node> storageNodeList = new ArrayList<Node>();
        for (StorageResource lun : lunList) {
            if (!(lun instanceof Lun)) continue;
            String devSn = lun.getDevSn();
            DrStorage drStorage = (DrStorage)this.getDrResourceInContext(context, devSn);
            Node storageNode = this.createStorage(context, context.getProtectGroup(), drStorage, layout);
            storageNodeList.add(storageNode);
            this.createHostAndArrayLink(context, drStorage.getSiteId(), drStorage.getDeviceSn(), storageNode, layout);
        }
        context.bind((Object)"hyperValutArrayList", storageNodeList);
    }

    private Lun getTargetLunInfo(ProtectGroupReplica pgReplica, String targetArraySn, Site site) {
        Iterator poRepIter = pgReplica.getReplicas().iterator();
        if (!poRepIter.hasNext()) {
            LOGGER.error((Object)("the replicas is null, pgReplicaID is: " + pgReplica.getId()));
            return null;
        }
        ProtectObjectReplica poReplica = (ProtectObjectReplica)poRepIter.next();
        Iterator repStorIter = poReplica.getStorageInfos().iterator();
        if (!repStorIter.hasNext()) {
            LOGGER.error((Object)("the repStorIter is null, poReplicaId is: " + poReplica.getId()));
            return null;
        }
        RelicaStorageInfo storageInfo = (RelicaStorageInfo)repStorIter.next();
        String targetLunId = storageInfo.getStorageId();
        ArrayList<String> lunSnList = new ArrayList<String>();
        lunSnList.add(targetLunId);
        List targetLunList = this.getResourceListFromDB(site, targetArraySn, lunSnList);
        if (VerifyUtil.isEmpty((Collection)targetLunList)) {
            LOGGER.error((Object)("The targetLun is null: targetArraySn=" + targetArraySn + ", targetLunId=" + targetLunId));
            return null;
        }
        Lun targetLun = null;
        for (StorageResource resource : targetLunList) {
            if (!(resource instanceof Lun)) continue;
            targetLun = (Lun)resource;
            break;
        }
        return targetLun;
    }

    private void createHostAndArrayLink(TopoBaseContext context, String siteId, String devSn, Node storageNode, ElementBox layout) {
        List drRes = this.hostService.getHostAndGroupListBySite(Arrays.asList(siteId), Long.valueOf(1L));
        if (VerifyUtil.isEmpty((Collection)drRes)) {
            return;
        }
        Site site = this.getSiteInContext(context, siteId);
        List arrayInitiators = this.getInitiatorsInContext(context, devSn, site);
        if (VerifyUtil.isEmpty((Collection)arrayInitiators)) {
            return;
        }
        ArrayList<DrHost> recoverHosts = new ArrayList<DrHost>();
        for (DrHost host : drRes) {
            this.getRecoveryHostList(recoverHosts, host, arrayInitiators);
        }
        if (VerifyUtil.isEmpty(recoverHosts)) {
            return;
        }
        ElementBox box = context.getElementBox();
        for (DrHost host : recoverHosts) {
            Site hostSite = this.getSiteInContext(context, host.getSiteId());
            Group group = this.getOrCreateGroup(box, hostSite, layout);
            this.createRecoveryHostOrGroupTopo(context, layout, storageNode, hostSite, group, host);
        }
    }

    private void createRecoveryHost(TopoBaseContext context, ElementBox layout) {
        if (this.checkSnapshot(context)) {
            return;
        }
        ProtectGroup protectGroup = context.getProtectGroup();
        if (20 == protectGroup.getTemplate().getType() || 24 == protectGroup.getTemplate().getType()) {
            this.buildAsyncHyperMetroArrayAndHost(protectGroup, context, layout);
            return;
        }
        List replicas = context.getReplicaService().queryProtectGroupReplicaByGroup(protectGroup.getUuid(), "ID", true);
        for (ProtectGroupReplica replica : replicas) {
            int repType = replica.getType();
            if (this.checkRepType(repType)) continue;
            Node storageNode = this.getOrCreateRecoverSiteNode(context, replica, layout);
            this.createHostAndArrayLink(context, replica.getRecoverySite(), replica.getRecoveryArray(), storageNode, layout);
        }
    }

    private void getRecoveryHostList(List<DrHost> recoverHosts, DrHost host, List<Initiator> arrayInitiators) {
        if (VerifyUtil.isEmpty((Object)host)) {
            return;
        }
        Set childs = host.getChildResources();
        if (VerifyUtil.isEmpty((Collection)childs)) {
            List initiators = this.getConnectInitiators((DrResource)host, arrayInitiators);
            if (!VerifyUtil.isEmpty((Collection)initiators)) {
                recoverHosts.add(host);
            }
        } else {
            for (DrResource child : childs) {
                if (!(child instanceof DrHost)) continue;
                this.getRecoveryHostList(recoverHosts, (DrHost)child, arrayInitiators);
            }
        }
    }

    private boolean checkRepType(int repType) {
        return SNAPSHOT_TYPE_SET.contains(repType);
    }

    private void createRecoveryHostOrGroupTopo(TopoBaseContext context, ElementBox layout, Node storageNode, Site site, Group group, DrHost host) {
        Node hostNode = this.createHostTopo(context, (DrResource)host, site, group, layout);
        this.createStorageAndHostLink(context, storageNode, hostNode);
    }

    private boolean checkPoType(int poType) {
        return 0 < poType && poType <= 9 || poType == 13 || poType == 15 || poType == 16;
    }

    private void createHostStorages(TopoBaseContext context, ElementBox layout, Node hostNode) {
        ProtectGroup protectGroup = context.getProtectGroup();
        ProtectObjectStorageInfo poStorageInfo = context.getTopoBaseService().getProtectObjectStorageInfoByPgId(protectGroup.getUuid());
        Node storageNode = this.createStorage(context, protectGroup, poStorageInfo, layout);
        this.createHostAndStorageLink(context, hostNode, storageNode);
    }

    private Node createHostTopo(TopoBaseContext context, DrResource drHost, Site site, Group group, ElementBox layout) {
        Node hostNode = null;
        if (drHost instanceof DrHost) {
            hostNode = this.createHostNode(context, (DrHost)drHost, site, group, layout);
            this.addProtectGroupIDToElement((Element)hostNode, context.getProtectGroup().getUuid());
        } else if (drHost instanceof DrHostGroup) {
            hostNode = this.createGroupTopoForGlobalTopo(context, (DrHostGroup)drHost, site, group, layout);
            Set drHosts = drHost.getChildResources();
            for (DrResource eachHost : drHosts) {
                this.createHostTopo(context, eachHost, site, (Group)hostNode, layout);
            }
        }
        return hostNode;
    }

    private Group createGroupTopoForGlobalTopo(TopoBaseContext context, DrHostGroup hostGroupInfo, Site site, Group group, ElementBox layout) {
        String groupId = hostGroupInfo.getDeviceSn() + "---" + site.getSiteId();
        Group hostGroup = (Group)context.getElementBox().getElementByID((Object)groupId);
        if (hostGroup != null) {
            return hostGroup;
        }
        ITopoResourceManager resourceManager = TopoBaseContext.getTopoResourceManager();
        hostGroup = new Group((Object)groupId);
        hostGroup.setStyle("label.bold", false);
        hostGroup.setStyle("label.font", (Object)resourceManager.getText("ism.drm.topo.label.font"));
        hostGroup.setClient("imageWidth", 48.0);
        hostGroup.setClient("imageHeight", 60.0);
        hostGroup.setName(TopoServiceUtil.getNodeShowName((String)hostGroupInfo.getName()));
        hostGroup.setToolTip(this.createHostGroupToolTip(hostGroupInfo));
        hostGroup.setImage("/theme/recoverydirector/images/topo/hostgroup.png");
        hostGroup.setStyle("group.outline.color", (Object)"0xDCDCDC");
        hostGroup.setStyle("group.outline.width", 1);
        hostGroup.setStyle("group.fill.color", (Object)"0xFCFCFC");
        hostGroup.setStyle("group.shape", (Object)"roundrect");
        hostGroup.setStyle("vector.roundrect.radius", 7);
        hostGroup.setExpanded(true);
        hostGroup.setStyle("select.alpha", 1.0);
        hostGroup.setStyle("select.style", (Object)"none");
        hostGroup.setStyle("label.color", (Object)"0x222222");
        if (group != null) {
            this.initGroupLocation(hostGroup, (Node)group, layout);
            group.addChild((IData)hostGroup);
        }
        TopoServiceUtil.addElementToBox((ElementBox)context.getElementBox(), (IData)hostGroup);
        return hostGroup;
    }

    private String createHostGroupToolTip(DrHostGroup hostGroupInfo) {
        return HostElement.createHostTooltip(hostGroupInfo.getIpAddress(), hostGroupInfo.getName(), hostGroupInfo.getOsType(), "0");
    }

    private Node createHostNode(TopoBaseContext context, DrHost hostInfo, Site site, Group group, ElementBox layout) {
        String nodeId = hostInfo.getDeviceSn() + "---" + site.getSiteId();
        Node hostNode = (Node)context.getElementBox().getElementByID((Object)nodeId);
        if (hostNode != null) {
            return hostNode;
        }
        hostNode = this.drawNode(hostInfo, site, nodeId);
        this.setHostNodeAppInfo(hostInfo, site, hostNode);
        if (group != null) {
            this.initNodeLocation(hostNode, (Node)group, layout);
            group.addChild((IData)hostNode);
        }
        this.addIdtoList(context.getHostNodeIds(), nodeId);
        TopoServiceUtil.addElementToBox((ElementBox)context.getElementBox(), (IData)hostNode);
        return hostNode;
    }

    private Node drawNode(DrHost hostInfo, Site site, String nodeId) {
        ITopoResourceManager resourceManager = TopoBaseContext.getTopoResourceManager();
        Node hostNode = new Node((Object)nodeId);
        hostNode.setStyle("label.bold", false);
        hostNode.setStyle("label.font", (Object)resourceManager.getText("ism.drm.topo.label.font"));
        hostNode.setStyle("label.color", 35020);
        HostElement.setImageByStatus(hostNode, hostInfo.getStatus());
        if (site.getSiteType() == 0) {
            hostNode.setClient("isHostOrStorage", (Object)"ishost");
            hostNode.setClient("topoHostName", (Object)("<![CDATA[" + hostInfo.getName() + "]]>"));
        }
        hostNode.setClient("imageWidth", 48.0);
        hostNode.setClient("imageHeight", 60.0);
        hostNode.setName(TopoServiceUtil.getNodeShowName((String)hostInfo.getName()));
        hostNode.setToolTip(HostElement.createHostToolTip(hostInfo));
        DrResource parent = hostInfo.getParentDrResource();
        if (parent instanceof DrHostGroup) {
            hostNode.setClient("clusterSn", (Object)parent.getDeviceSn());
            this.setNodeExtName(hostNode, hostInfo.getName(), parent.getName(), "ism.drm.topo.hypermetro.hostgroup");
        }
        hostNode.setStyle("select.alpha", 1.0);
        hostNode.setStyle("select.style", (Object)"none");
        return hostNode;
    }

    private void setHostNodeAppInfo(DrHost hostInfo, Site site, Node hostNode) {
        List<Integer> appTypes = this.getHostAppTypes(hostInfo.getDeviceSn(), site);
        int len = appTypes.size();
        if (len > 0) {
            ArrayList<String> nameList = new ArrayList<String>();
            for (int i = 0; i < len; ++i) {
                String appPic = APP_TYPE_ICON_MAP.get(appTypes.get(i));
                if (VerifyUtil.isEmpty((String)appPic) || nameList.contains(appPic)) continue;
                nameList.add(appPic);
            }
            if (!VerifyUtil.isEmpty(nameList)) {
                int nameLen = nameList.size();
                String[] nameArray = new String[nameList.size()];
                for (int j = 0; j < nameLen; ++j) {
                    nameArray[j] = (String)nameList.get(j);
                }
                hostNode.setStyle("icons.names", (Object)nameArray);
                hostNode.setStyle("icons.position", (Object)"top.top");
                hostNode.setStyle("icons.xgap", 5.0);
                hostNode.setStyle("icons.ygap", -20.0);
            }
        }
    }

    protected void removeLinkFromBox(TopoBaseContext context, Link link) {
        context.getElementBox().remove((IData)link);
    }

    private List<Integer> getHostAppTypes(String hostSn, Site site) {
        return this.hostService.getHostAppTypes(hostSn);
    }

    static {
        APP_TYPE_ICON_MAP.put(1, "/theme/recoverydirector/images/topo/host_oracle_icon.png");
        APP_TYPE_ICON_MAP.put(2, "/theme/recoverydirector/images/topo/host_sqlserver_icon.png");
        APP_TYPE_ICON_MAP.put(3, "/theme/recoverydirector/images/topo/host_db2_icon.png");
        APP_TYPE_ICON_MAP.put(8, "/theme/recoverydirector/images/topo/host_exchange_icon.png");
        APP_TYPE_ICON_MAP.put(13, "/theme/recoverydirector/images/topo/host_exchange2007_icon.png");
        APP_TYPE_ICON_MAP.put(15, "/theme/recoverydirector/images/topo/host_cache_icon.png");
        APP_TYPE_ICON_MAP.put(16, "/theme/recoverydirector/images/topo/host_hana_icon.png");
        SNAPSHOT_TYPE_SET.add(8);
        SNAPSHOT_TYPE_SET.add(3);
        SNAPSHOT_TYPE_SET.add(6);
        SNAPSHOT_TYPE_SET.add(5);
        SNAPSHOT_TYPE_SET.add(4);
        SNAPSHOT_TYPE_SET.add(102);
    }
}

