/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.topology.element;

import com.huawei.ism.cbb.util.StringEscapeUtil;
import com.huawei.ism.drm.host.sdk.model.DrHost;
import com.huawei.ism.drm.topo.sdk.context.TopoBaseContext;
import com.huawei.ism.drm.topo.sdk.manager.ITopoResourceManager;
import com.huawei.ism.drm.topo.sdk.topology.Skin;
import com.huawei.ism.drm.topo.skin.HostNodeSkin;
import com.huawei.ism.drm.topo.topology.TopoElement;
import com.huawei.ism.drm.topo.utils.TooltipUtil;
import com.huawei.topology.Node;

public class ClusterNodeElement
extends TopoElement {
    private static final String NORMAL = "Normal";
    private static final int XOFFSET = 13;
    private static final int YOFFSET = -2;

    public ClusterNodeElement() {
    }

    public ClusterNodeElement(DrHost host, String state) {
        super((Object)host.getDeviceSn(), host.getName());
        this.setToolTip(ClusterNodeElement.createHostTooltip(host.getIpAddress(), host.getName(), host.getOsType(), state));
        this.setImage("/theme/recoverydirector/images/topo/opgsnode.png");
        this.use(new Skin[]{new HostNodeSkin()});
        this.setIconByStatus((Node)this, state);
        this.setStyle("label.yoffset", -6);
        this.setStyle("icons.xoffset", 13);
        this.setStyle("icons.yoffset", -2);
    }

    private void setIconByStatus(Node cluster, String status) {
        if (NORMAL.equals(status)) {
            cluster.setIcon("/theme/recoverydirector/images/topo/opgsnode.png");
            cluster.setStyle("icons.names", (Object)"/theme/recoverydirector/images/topo/opgsnode.png");
        } else {
            cluster.setIcon("/theme/recoverydirector/images/topo/opgsnode_faulty.png");
            cluster.setStyle("icons.names", (Object)"/theme/recoverydirector/images/topo/opgsnode_faulty.png");
        }
    }

    public static String createHostTooltip(String ip, String name, String os, String status) {
        String newOs;
        ITopoResourceManager resourceManager = TopoBaseContext.getTopoResourceManager();
        newOs = resourceManager.containText(newOs = "ism.drm.topo.host.os." + os) ? resourceManager.getText(newOs) : null;
        StringBuilder tooltipBuilder = new StringBuilder();
        TooltipUtil.appendTooltip((StringBuilder)tooltipBuilder, (String)"ism.drm.topo.host.ip", (String)ip);
        TooltipUtil.appendTooltip((StringBuilder)tooltipBuilder, (String)"ism.drm.topo.host.name", (String)StringEscapeUtil.escape((String)name));
        TooltipUtil.appendTooltip((StringBuilder)tooltipBuilder, (String)"ism.drm.topo.host.os", (String)newOs);
        if (NORMAL.equals(status)) {
            tooltipBuilder.append(resourceManager.getText("ism.drm.topo.storage.status")).append(" ").append(resourceManager.getText("ism.drm.host.online")).append("\n");
        } else {
            tooltipBuilder.append(resourceManager.getText("ism.drm.topo.storage.status")).append(" ").append(resourceManager.getText("ism.drm.host.faulty")).append("\n");
        }
        return tooltipBuilder.toString();
    }
}

