/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.util;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.NumberUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public final class DBRecoveryTools {
    private static Log logger = LogFactory.getInstance(DBRecoveryTools.class);

    private DBRecoveryTools() {
    }

    public static ProtectObject getProtectObjectByPoId(Set<ProtectObject> pos, String poId) {
        if (VerifyUtil.isEmpty((String)poId)) {
            logger.info((Object)"po id is null.", 90160758786989L);
            return null;
        }
        if (VerifyUtil.isEmpty(pos)) {
            logger.info((Object)"pos id is null.", 90160758786989L);
            return null;
        }
        for (ProtectObject protectObject : pos) {
            if (!poId.equals(protectObject.getUuid())) continue;
            return protectObject;
        }
        return null;
    }

    public static String getDisasterHostSn(RecoveryPlan recoveryPlan, String pgId, int procType) {
        String deviceSn;
        block4: {
            block3: {
                if (null == recoveryPlan) {
                    return null;
                }
                deviceSn = null;
                if (DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK.getValue() != procType) break block3;
                Iterator pgIter = recoveryPlan.getProtectGroups().iterator();
                if (!pgIter.hasNext()) {
                    return null;
                }
                ProtectGroup pg = (ProtectGroup)pgIter.next();
                if (null == pg) break block4;
                deviceSn = pg.getPoProviderSN();
                break block4;
            }
            deviceSn = (String)recoveryPlan.getGlobalSettings().get("PG_DISASTER_HOST");
            for (RecoverySetting setting : recoveryPlan.getRecoverySettings()) {
                if (!setting.getOwnerId().equals(pgId) || !setting.getName().equals("PG_DISASTER_HOST")) continue;
                deviceSn = setting.getValue();
                break;
            }
        }
        return deviceSn;
    }

    public static String getMountHostProcResultKey(String hostSN) {
        return "mount_" + hostSN;
    }

    public static String getUmountHostProcResultKey(String hostSN) {
        return "umount_" + hostSN;
    }

    public static int getRecoverType(String proProviderType, String disasterProviderType) {
        if (null == proProviderType || null == disasterProviderType) {
            return 0;
        }
        int hostType = DrmEnumDefine.ProviderTypeE.HOST.getValue();
        int iProProviderType = NumberUtil.parseInteger((Object)proProviderType);
        int iDisasterProviderType = NumberUtil.parseInteger((Object)disasterProviderType);
        int recoverType = hostType == iProProviderType ? (hostType == iDisasterProviderType ? 0 : 1) : (hostType == iDisasterProviderType ? 2 : 3);
        return recoverType;
    }

    public static List<ProtectObject> appProtectObjectsFilter(RecoveryProcessorContext context) {
        ProtectGroup protectGroup = context.getProtectGroup();
        return DBRecoveryTools.appProtectObjectsFilter(context.getRecoveryProtectObjects(), protectGroup.getPoType());
    }

    public static List<ProtectObject> appCurrentPosFilter(RecoveryProcessorContext context) {
        ProtectGroup protectGroup = context.getProtectGroup();
        return DBRecoveryTools.appProtectObjectsFilter(protectGroup.getPolist(), protectGroup.getPoType());
    }

    private static List<ProtectObject> appProtectObjectsFilter(Set<ProtectObject> pos, int poType) {
        pos = pos == null ? Collections.emptySet() : pos;
        ArrayList<ProtectObject> filterPos = new ArrayList<ProtectObject>();
        for (ProtectObject protectObject : pos) {
            if (protectObject.getPoType() == poType) {
                filterPos.add(protectObject);
                continue;
            }
            logger.info((Object)("protectObject.getPoType()=" + protectObject.getPoType() + ",protectGroup.getPoType()=" + poType));
        }
        return filterPos;
    }
}

