/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.util;

import com.huawei.ism.cbb.util.DiscParamValidator;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.nem.discover.sdk.model.DiscParamVilidateResult;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public final class DrHostValidUtil {
    private static final Log LOGGER = LogFactory.getInstance(DrHostValidUtil.class);
    private static final int USER_NAME_PWD_MIM = 1;
    private static final int USER_NAME_PWD_MAX = 32;
    private static final int HANA_USER_NAME_PWD_MAX = 128;
    private static final int PORT_MAX = 65535;
    private static final int SIXTY_FOUR = 64;
    private static final String CHINESE_STR = "[^\\x00-\\xff]";
    private static final String CHAR_STR_LOWER = "[a-z]+";
    private static final String CHAR_STR_UPPER = "[A-Z]+";
    private static final String NUM_STR = "[0-9]+";
    private static final String SPECIAL_STR = "[\\`|\\~|!|@|#|$|%|\\^|&|\\*|\\(|\\)|\\-|_|=|+|\\\\|\\||\\{|\\}|\\[|\\]|;|:|\\'|\\\"|\\,|\\.|\\<|\\>|\\/|\\s|?]+";

    private DrHostValidUtil() {
    }

    public static boolean checkUserName(String param) {
        if (VerifyUtil.isEmpty((String)param)) {
            return false;
        }
        int len = param.length();
        return len <= 32 && len >= 1;
    }

    public static boolean checkPwd(String param) {
        if (null == param) {
            return false;
        }
        int len = param.length();
        return len <= 32 && len >= 1;
    }

    public static boolean checkPort(String port) {
        if (VerifyUtil.isEmpty((String)port)) {
            return false;
        }
        int pTmp = NumberUtil.parseInteger((Object)port);
        return pTmp >= 1 && pTmp <= 65535;
    }

    public static DiscParamVilidateResult checkSNMP(Map<String, String> paramMap) {
        String snmpport;
        String timeout;
        DiscParamVilidateResult dpvrError = new DiscParamVilidateResult();
        dpvrError.setResult(false);
        dpvrError.setErrorCode(1073947393L);
        if (null == paramMap) {
            return dpvrError;
        }
        String retries = paramMap.get("snmpRetries");
        if (!DrHostValidUtil.checkSNMPParam0(retries, timeout = paramMap.get("snmpTimeout"), snmpport = paramMap.get("snmpPort"))) {
            return dpvrError;
        }
        if (!DrHostValidUtil.checkSNMPParam1(retries, timeout, snmpport)) {
            return dpvrError;
        }
        if ("SNMPv3".equals(paramMap.get("snmpVersion"))) {
            return DrHostValidUtil.checkSNMPV3(paramMap, retries, timeout, snmpport);
        }
        return dpvrError;
    }

    private static boolean checkSNMPParam0(String retries, String timeout, String snmpport) {
        if (DiscParamValidator.stringisNull((String)String.valueOf(retries)) || DiscParamValidator.stringisNull((String)String.valueOf(timeout)) || DiscParamValidator.stringisNull((String)String.valueOf(snmpport))) {
            return false;
        }
        return DiscParamValidator.isNum((String)retries) && DiscParamValidator.isNum((String)timeout) && DiscParamValidator.isNum((String)snmpport);
    }

    private static boolean checkSNMPParam1(String retries, String timeout, String snmpport) {
        int retri = NumberUtil.convertToInteger((Object)retries);
        int time = NumberUtil.convertToInteger((Object)timeout);
        int port = NumberUtil.convertToInteger((Object)snmpport);
        if (retri < 0 || retri > 5) {
            return false;
        }
        if (time < 1 || time > 5) {
            return false;
        }
        return port >= 1 && port <= 65535;
    }

    private static DiscParamVilidateResult checkSNMPV3(Map<String, String> paramMap, String retries, String timeout, String snmpport) {
        DiscParamVilidateResult dpvrSuccess = new DiscParamVilidateResult();
        dpvrSuccess.setResult(true);
        DiscParamVilidateResult dpvrError = new DiscParamVilidateResult();
        dpvrError.setResult(false);
        dpvrError.setErrorCode(1073947393L);
        ArrayList<String> authProtocolList = new ArrayList<String>();
        authProtocolList.add("HMACMD5");
        authProtocolList.add("HMAC_SHA1");
        authProtocolList.add("HMAC_SHA2");
        ArrayList<String> encryptProtocolList = new ArrayList<String>();
        encryptProtocolList.add("DES");
        encryptProtocolList.add("AES");
        String snmpSecurityName = paramMap.get("snmpSecurityName");
        String snmpContextName = paramMap.get("snmpContextName");
        String snmpContextEngineId = paramMap.get("snmpContextEngineId");
        String snmpAuthProtocol = paramMap.get("snmpAuthProtocol");
        String snmpEncryptProtocol = paramMap.get("snmpEncryptProtocol");
        String snmpAuthPwd = paramMap.get("snmpAuthPwd");
        String snmpEncryptPwd = paramMap.get("snmpEncryptPwd");
        if (!DrHostValidUtil.checkSNMPV3Param0(snmpSecurityName, snmpContextName, snmpContextEngineId, snmpAuthProtocol, snmpEncryptProtocol)) {
            return dpvrError;
        }
        if (!DrHostValidUtil.checkSNMPV3Param1(snmpAuthProtocol, snmpEncryptProtocol, snmpAuthPwd, snmpEncryptPwd, authProtocolList, encryptProtocolList)) {
            return dpvrError;
        }
        if (!DrHostValidUtil.checkSNMPV3Param2(retries, timeout, snmpport)) {
            return dpvrError;
        }
        return dpvrSuccess;
    }

    private static boolean checkSNMPV3Param0(String v3securityName, String v3contextName, String v3contextEngineId, String v3authProtocol, String v3encryptProtocol) {
        if (DiscParamValidator.stringisNull((String)v3securityName) || !DiscParamValidator.checkStringLength((String)v3securityName, (int)64)) {
            return false;
        }
        if (!DiscParamValidator.stringisNull((String)v3contextName) && !DiscParamValidator.checkStringLength((String)v3contextName, (int)64)) {
            return false;
        }
        if (!DiscParamValidator.stringisNull((String)v3contextEngineId) && !DiscParamValidator.checkStringLength((String)v3contextEngineId, (int)64)) {
            return false;
        }
        return !DiscParamValidator.stringisNull((String)v3authProtocol) || DiscParamValidator.stringisNull((String)v3encryptProtocol);
    }

    private static boolean checkSNMPV3Param1(String v3authProtocol, String v3encryptProtocol, String v3authPwd, String v3encryptPwd, List<String> authProtocolList, List<String> encryptProtocolList) {
        if (!DiscParamValidator.stringisNull((String)v3authProtocol)) {
            if (!authProtocolList.contains(v3authProtocol)) {
                return false;
            }
            if (DiscParamValidator.stringisNull((String)v3authPwd)) {
                return false;
            }
            if (!DiscParamValidator.checkStringLength((String)v3authPwd, (int)64)) {
                return false;
            }
        }
        if (!DiscParamValidator.stringisNull((String)v3encryptProtocol)) {
            if (!encryptProtocolList.contains(v3encryptProtocol)) {
                return false;
            }
            if (DiscParamValidator.stringisNull((String)v3encryptPwd)) {
                return false;
            }
            return DiscParamValidator.checkStringLength((String)v3encryptPwd, (int)64);
        }
        return true;
    }

    private static boolean checkSNMPV3Param2(String retries, String timeout, String snmpPort) {
        try {
            int retriesInt = NumberUtil.convertToInteger((Object)retries);
            if (retriesInt < 0 || retriesInt > 5) {
                return false;
            }
            int timeoutInt = NumberUtil.convertToInteger((Object)timeout);
            if (timeoutInt < 0 || timeoutInt > 5) {
                return false;
            }
            int snmpPortInt = NumberUtil.convertToInteger((Object)snmpPort);
            if (snmpPortInt < 1 || snmpPortInt > 65535) {
                return false;
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("check snmp param fail." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
            return false;
        }
        return true;
    }

    public static void checkUsernameAndPwd(String param, boolean isAllowEmpty) {
        if (!isAllowEmpty && VerifyUtil.isEmpty((String)param)) {
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)param)) {
            return;
        }
        int len = param.length();
        if (len > 32 || len < 1) {
            throw new LegoCheckedException(1073947393L);
        }
    }

    public static void checkHANAUsernameAndPwd(String param, boolean isAllowEmpty) {
        if (!isAllowEmpty && VerifyUtil.isEmpty((String)param)) {
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)param)) {
            return;
        }
        int len = param.length();
        if (len > 128 || len < 1) {
            throw new LegoCheckedException(1073947393L);
        }
    }

    public static boolean isPwdMatchComplex(String password, String userName) {
        if (VerifyUtil.isEmpty((String)password)) {
            return false;
        }
        String tmpPwd = Normalizer.normalize(password, Normalizer.Form.NFKC);
        int len = tmpPwd.length();
        StringBuilder sbPwd = new StringBuilder(tmpPwd);
        String reversePwd = sbPwd.reverse().toString();
        if (tmpPwd.equals(userName) || reversePwd.equals(userName)) {
            return false;
        }
        if (password.indexOf(" ") >= 0) {
            return false;
        }
        if (len < 8 || len > 16) {
            return false;
        }
        if (Pattern.compile(CHINESE_STR).matcher(tmpPwd).find()) {
            return false;
        }
        return DrHostValidUtil.isPwdMatchComplexSecond(tmpPwd);
    }

    private static boolean isPwdMatchComplexSecond(String password) {
        boolean flag1 = !Pattern.compile(CHAR_STR_LOWER).matcher(password).find() || !Pattern.compile(NUM_STR).matcher(password).find() || !Pattern.compile(SPECIAL_STR).matcher(password).find();
        boolean flag2 = !Pattern.compile(CHAR_STR_UPPER).matcher(password).find() || !Pattern.compile(NUM_STR).matcher(password).find() || !Pattern.compile(SPECIAL_STR).matcher(password).find();
        boolean flag3 = !Pattern.compile(CHAR_STR_UPPER).matcher(password).find() || !Pattern.compile(CHAR_STR_LOWER).matcher(password).find() || !Pattern.compile(SPECIAL_STR).matcher(password).find();
        return !flag1 || !flag2 || !flag3;
    }
}

