/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.util;

import com.huawei.ism.drm.host.util.KvJsonTree;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class KvJson {
    private final String source;

    public KvJson(String source) {
        this.source = source;
    }

    public String resolveString() {
        Map<List<String>, String> items = this.split();
        KvJsonTree tree = this.reorganize(items.keySet());
        return tree.resolveString(items);
    }

    public Object resolveObject() {
        Map<List<String>, String> items = this.split();
        KvJsonTree tree = this.reorganize(items.keySet());
        return tree.resolveObject(items);
    }

    private Map<List<String>, String> split() {
        String[] lines = this.source.split("\n");
        HashMap<List<String>, String> items = new HashMap<List<String>, String>();
        for (String line : lines) {
            int index = line.indexOf(61);
            if (index == -1) continue;
            String field = line.substring(0, index).trim();
            String value = line.substring(index + 1).trim();
            items.put(Arrays.asList(field.split("\\.")), value);
        }
        return items;
    }

    private KvJsonTree reorganize(Set<List<String>> fields) {
        KvJsonTree root = new KvJsonTree();
        fields.forEach(field -> this.attachNameTree(root, (List<String>)field));
        return root;
    }

    private void attachNameTree(KvJsonTree root, List<String> field) {
        KvJsonTree tree = root;
        for (String name : field) {
            tree = tree.getChildByName(name);
        }
        tree.getFields().add(field);
    }
}

