/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.framework.system.service;

import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.rest.service.base.AbstractRestService;
import com.huawei.ism.drm.rest.service.framework.system.model.SystemThresholdVo;
import com.huawei.ism.drm.rest.service.framework.system.service.ISystemRestService;
import com.huawei.ism.drm.rest.service.framework.system.util.SystemFileUtil;
import com.huawei.ism.drm.rest.service.framework.user.service.model.UserConstant;
import com.huawei.ism.drm.system.cfgdata.sdk.model.FtpServerInfo;
import com.huawei.ism.drm.system.cfgdata.sdk.service.IConfigDataBackupBaseService;
import com.huawei.ism.drm.system.cfgdata.sdk.service.IConfigDataBackupService;
import com.huawei.ism.drm.system.info.sdk.model.SoftwareInfo;
import com.huawei.ism.drm.system.info.sdk.service.ISoftwareInfoService;
import com.huawei.ism.drm.system.personaldata.sdk.service.IPersonalDataService;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.ism.drm.web.annotation.Logging;
import com.huawei.ism.drm.web.annotation.Permission;
import com.huawei.ism.drm.web.util.HtmlStringConverter;
import com.huawei.lego.cbb.nms.north.sdk.service.INorthNmsService;
import com.huawei.lego.core.sdk.base.ServiceContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.FELogFactory;
import com.huawei.lego.core.sdk.log.ILogConfigService;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.util.AddressUtil;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.Ipv6AddressUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.WccEncryptor;
import com.huawei.lego.core.system.sysmonitor.sdk.model.DataBaseInfo;
import com.huawei.lego.core.system.sysmonitor.sdk.model.DiskResouceUse;
import com.huawei.lego.core.system.sysmonitor.sdk.model.HostServerMonitorInfo;
import com.huawei.lego.core.system.sysmonitor.sdk.model.SysmTreshold;
import com.huawei.lego.core.system.sysmonitor.sdk.model.SysmTresholdType;
import com.huawei.lego.core.system.sysmonitor.sdk.service.ISysMonitor;
import java.io.Closeable;
import java.io.File;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.DecimalFormat;
import java.text.Normalizer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.logging.log4j.Level;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SystemRestServiceImpl
extends AbstractRestService
implements ISystemRestService {
    private static final Log LOGGER = FELogFactory.getInstance((String)"ui");
    private static final String LOCAL_HOST_IP_FIRST = "127";
    private static final String AUTO_BACKUP_FLAG_TRUE = "true";
    private static final String AUTO_BACKUP_FLAG_FALSE = "false";
    private static final int PORT_MIN_VAL = 1;
    private static final int PORT_MAX_VAL = 65535;
    private static final long DEFALTPERCENT = 90L;
    private static final String LOGGER_LEGO_NAME = "com.huawei.lego";
    private static final String LOGGER_ISM_NAME = "com.huawei.ism";
    private static final String EXPORT_CHECKED_TOKEN = "EXPORT_CHECKED_TOKEN";
    private static final String LOWER_CHAR = "[a-z]+";
    private static final String NUMBER = "[0-9]+";
    private static final String SPECIAL_CHAR = "[\\`|\\~|!|@|#|$|%|\\^|&|\\*|\\(|\\)|\\-|_|=|+|\\\\|\\||\\{|\\}|\\[|\\]|;|:|\\'|\\\"|\\,|\\.|\\<|\\>|\\/|\\s|?]+";
    private static final String UPPER_CHAR = "[A-Z]+";
    private static final int PWDMAXLEN = 15;
    private static final int PWDMINLEN = 8;
    private static final Map<String, Level> LEVELS = new HashMap<String, Level>(6);
    private static final Object LOG_EXPORT_LOCKER = new Object();

    public static ILogConfigService getService() {
        ServiceContext localServiceContext = ServiceContext.getInstance();
        return (ILogConfigService)localServiceContext.lookup("KernelApplication/logConfigService");
    }

    @Override
    @Permission(name={"lego.sys.systemMonitor.scan"})
    public SystemThresholdVo querySystemThreshold() {
        LOGGER.debug((Object)"Enter querySystemThreshold");
        SystemThresholdVo vo = new SystemThresholdVo();
        long cpuPercent = 90L;
        long diskPercent = 90L;
        long memPercent = 90L;
        ISysMonitor mgr = (ISysMonitor)ServiceLocator.getBundleService((String)"system", (String)"sysMonitor");
        List list = mgr.getSysmTreshold();
        if (null != list && !list.isEmpty()) {
            for (SysmTreshold sysmTreshold : list) {
                if (sysmTreshold.getId().longValue() == SysmTresholdType.CPU.getValue()) {
                    cpuPercent = sysmTreshold.getPercent();
                    continue;
                }
                if (sysmTreshold.getId().longValue() == SysmTresholdType.DISK.getValue()) {
                    diskPercent = sysmTreshold.getPercent();
                    continue;
                }
                if (sysmTreshold.getId().longValue() != SysmTresholdType.MEM.getValue()) continue;
                memPercent = sysmTreshold.getPercent();
            }
        }
        vo.setCpuPercent(Long.valueOf(cpuPercent));
        vo.setDiskPercent(Long.valueOf(diskPercent));
        vo.setMemPercent(Long.valueOf(memPercent));
        return vo;
    }

    @Override
    @Permission(name={"lego.sys.systemMonitor.Threshold.modify"})
    @Logging(name="performance_setThreshold_operateName", rank=3, object="=performanceThreshold_objectName")
    public Response modifySysmTreshold(SystemThresholdVo vo) {
        LOGGER.debug((Object)"Enter modifySysmTreshold");
        this.checkParam(vo);
        ISysMonitor mgr = (ISysMonitor)ServiceLocator.getBundleService((String)"system", (String)"sysMonitor");
        List list = mgr.getSysmTreshold();
        if (!VerifyUtil.isEmpty((Collection)list)) {
            for (SysmTreshold sysmTreshold : list) {
                if (sysmTreshold.getId().longValue() == SysmTresholdType.CPU.getValue()) {
                    sysmTreshold.setPercent(vo.getCpuPercent().longValue());
                    continue;
                }
                if (sysmTreshold.getId().longValue() == SysmTresholdType.DB.getValue()) {
                    sysmTreshold.setPercent(0L);
                    continue;
                }
                if (sysmTreshold.getId().longValue() == SysmTresholdType.DISK.getValue()) {
                    sysmTreshold.setPercent(vo.getDiskPercent().longValue());
                    continue;
                }
                if (sysmTreshold.getId().longValue() != SysmTresholdType.MEM.getValue()) continue;
                sysmTreshold.setPercent(vo.getMemPercent().longValue());
            }
        }
        mgr.updateSysmTreshold(list);
        return Response.ok().build();
    }

    private void checkParam(SystemThresholdVo vo) {
        LOGGER.debug((Object)"Enter checkParam");
        if (VerifyUtil.isEmpty((Object)vo)) {
            LOGGER.error((Object)"The vo is invalid!");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((Object)vo.getCpuPercent()) || VerifyUtil.isEmpty((Object)vo.getDiskPercent()) || VerifyUtil.isEmpty((Object)vo.getMemPercent())) {
            LOGGER.error((Object)"The cpuPercent or diskPercent or memPercent are invalid!");
            throw new LegoCheckedException(1073947393L);
        }
        this.checkNumArea(vo.getCpuPercent(), 1, 99);
        this.checkNumArea(vo.getDiskPercent(), 1, 99);
        this.checkNumArea(vo.getMemPercent(), 1, 99);
    }

    private void checkNumArea(Long num, int min, int max) {
        if (num < (long)min || num > (long)max) {
            LOGGER.error((Object)"Num %s is not between min(%s) and max(%s)", new Object[]{String.valueOf(num), String.valueOf(min), String.valueOf(max)});
            throw new LegoCheckedException(250L);
        }
    }

    @Override
    @Permission(name={"lego.sys.systemMonitor.scan"})
    public String queryCpuStatus() {
        JSONObject resultObject;
        block3: {
            Iterator iterator;
            Object object;
            resultObject = new JSONObject();
            try {
                object = ServiceLocator.getBundleService((String)"system", (String)"sysMonitor");
            }
            catch (Exception e) {
                LOGGER.error((Object)"QueryCpuStatus getBundleService error : %s", new Object[]{ServiceLocator.getBundleService((String)"system", (String)"sysMonitor")});
                throw new LegoCheckedException("queryCpuStatus getBundleService error", (Throwable)e);
            }
            ISysMonitor mgr = (ISysMonitor)object;
            List list = mgr.getHistoryhostInfo();
            List treshold = mgr.getSysmTreshold();
            if (VerifyUtil.isEmpty((Collection)treshold)) {
                LOGGER.error((Object)"Treshold is empty.");
                throw new LegoCheckedException(1073947393L);
            }
            String maxCpu = String.valueOf(((SysmTreshold)treshold.get(0)).getPercent());
            resultObject.put((Object)"cpuMax", (Object)maxCpu);
            if (VerifyUtil.isEmpty((Collection)list) || !(iterator = list.iterator()).hasNext()) break block3;
            Map map = (Map)iterator.next();
            Set<Map.Entry<Long, HostServerMonitorInfo>> set = map.entrySet();
            this.getTimeAndPercent(resultObject, set);
        }
        return resultObject.toString();
    }

    private void getTimeAndPercent(JSONObject resultObject, Set<Map.Entry<Long, HostServerMonitorInfo>> set) {
        block2: {
            long time;
            LOGGER.debug((Object)"Enter getTimeAndPercent");
            Iterator<Map.Entry<Long, HostServerMonitorInfo>> iterator = set.iterator();
            if (!iterator.hasNext()) break block2;
            Map.Entry<Long, HostServerMonitorInfo> entry = iterator.next();
            Long key = entry.getKey();
            if (key == null) {
                time = 0L;
            } else {
                Date date = new Date(key);
                time = date.getTime();
            }
            resultObject.put((Object)"time", (Object)time);
            HostServerMonitorInfo temp = entry.getValue();
            String cpuPer = temp.getCpuInfo().getPercent().trim().replace("%", "");
            resultObject.put((Object)"cpuPer", (Object)cpuPer);
        }
    }

    @Override
    @Permission(name={"lego.sys.systemMonitor.scan"})
    public String queryMemStatus() {
        ISysMonitor mgr;
        JSONObject resultObject = new JSONObject();
        try {
            mgr = (ISysMonitor)ServiceLocator.getBundleService((String)"system", (String)"sysMonitor");
        }
        catch (Exception e) {
            LOGGER.error((Object)"QueryMemStatus getBundleService error : %s", new Object[]{ServiceLocator.getBundleService((String)"system", (String)"sysMonitor")});
            throw new LegoCheckedException("queryMemStatus getBundleService error", (Throwable)e);
        }
        List list = mgr.getHistoryhostInfo();
        List treshold = mgr.getSysmTreshold();
        if (VerifyUtil.isEmpty((Collection)treshold) || treshold.size() < 2) {
            LOGGER.error((Object)"Threshold is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        String maxMemo = String.valueOf(((SysmTreshold)treshold.get(1)).getPercent());
        resultObject.put((Object)"memoMax", (Object)maxMemo);
        if (null != list && !list.isEmpty()) {
            this.getMemo(resultObject, list);
        }
        return resultObject.toString();
    }

    private void getMemo(JSONObject resultObject, List<Map<Long, HostServerMonitorInfo>> list) {
        block2: {
            long time;
            Map<Long, HostServerMonitorInfo> map;
            Set<Map.Entry<Long, HostServerMonitorInfo>> set;
            Iterator<Map.Entry<Long, HostServerMonitorInfo>> iterator;
            LOGGER.debug((Object)"Enter getMemo");
            Iterator<Map<Long, HostServerMonitorInfo>> iterator2 = list.iterator();
            if (!iterator2.hasNext() || !(iterator = (set = (map = iterator2.next()).entrySet()).iterator()).hasNext()) break block2;
            Map.Entry<Long, HostServerMonitorInfo> entry = iterator.next();
            Long key = entry.getKey();
            if (key == null) {
                time = 0L;
            } else {
                Date date = new Date(key);
                time = date.getTime();
            }
            resultObject.put((Object)"time", (Object)time);
            HostServerMonitorInfo temp = entry.getValue();
            String memoPer = temp.getMemoryInfo().getPercent().trim().replace("%", "");
            resultObject.put((Object)"memoPer", (Object)memoPer);
        }
    }

    @Override
    @Permission(name={"lego.sys.systemMonitor.scan"})
    public String queryDiskStatus() {
        LOGGER.debug((Object)"Enter queryDiskStatus");
        JSONArray resultArray = new JSONArray();
        Object object = ServiceLocator.getBundleService((String)"system", (String)"sysMonitor");
        ISysMonitor mgr = (ISysMonitor)object;
        Map tempMap = mgr.getCurrentHostServerInfo();
        if (tempMap != null) {
            double ten = 10.0;
            double diskMax = 10.0;
            StringBuffer diskString = new StringBuffer();
            diskString.append("<item>");
            Collection setKey = tempMap.values();
            diskMax = this.addEachObject(resultArray, diskMax, diskString, setKey);
            double diskStepMax = diskMax / 10.0;
            Iterator iterator = resultArray.iterator();
            while (iterator.hasNext()) {
                JSONObject obj = JSONObject.fromObject(iterator.next());
                obj.put((Object)"stepMax", (Object)diskStepMax);
            }
        }
        return resultArray.toString();
    }

    private double addEachObject(JSONArray resultArray, double diskMax, StringBuffer diskString, Collection<?> setKey) {
        LOGGER.debug((Object)"Enter addEachObject");
        for (Object obj : setKey) {
            HostServerMonitorInfo tempHsInf = (HostServerMonitorInfo)obj;
            for (DiskResouceUse temp : tempHsInf.getDiskInfo()) {
                JSONObject resultObject = new JSONObject();
                String usedStr = temp.getUsed().trim().replace("G", "");
                String leftStr = temp.getAvail().trim().replace("G", "");
                if (usedStr.trim().isEmpty()) {
                    usedStr = "0";
                }
                if (leftStr.trim().isEmpty()) {
                    leftStr = "0";
                }
                diskString.append("<items label='").append(temp.getDiskName().trim().replace(":", "")).append("' data1='").append(usedStr).append("' data2='").append(leftStr).append("'/>");
                resultObject.put((Object)"partitionName", (Object)temp.getDiskName().trim().replace(":", ""));
                resultObject.put((Object)"used", (Object)usedStr.trim());
                resultObject.put((Object)"unused", (Object)leftStr.trim());
                double tempDiskStepMax = NumberUtil.parseDouble((Object)usedStr.trim()) + NumberUtil.parseDouble((Object)leftStr.trim());
                if (tempDiskStepMax > diskMax) {
                    diskMax = tempDiskStepMax;
                }
                resultArray.add((Object)resultObject);
            }
        }
        return diskMax;
    }

    @Override
    @Permission(name={"lego.sys.systemMonitor.scan"})
    public String queryDBStatus() {
        LOGGER.debug((Object)"Enter queryDBStatus");
        DecimalFormat df = new DecimalFormat("##0.0 ");
        JSONArray resultArray = new JSONArray();
        Object object = ServiceLocator.getBundleService((String)"system", (String)"sysMonitor");
        ISysMonitor mgr = (ISysMonitor)object;
        Map tempMap1 = mgr.getDataBaseInfo();
        if (tempMap1 != null) {
            double ten = 10.0;
            double dbMax = 10.0;
            Collection setKey1 = tempMap1.values();
            List listDataBase = new ArrayList();
            for (Object obj : setKey1) {
                listDataBase = (List)obj;
            }
            for (DataBaseInfo temp : listDataBase) {
                JSONObject resultObject = new JSONObject();
                String usedStr = temp.getUsed().trim().replace("MB", "");
                String totalStr = temp.getTotal().trim().replace("MB", "");
                String leftStr = df.format(NumberUtil.parseDouble((Object)totalStr) - NumberUtil.parseDouble((Object)usedStr));
                if (VerifyUtil.isEmpty((String)usedStr)) {
                    usedStr = "0";
                }
                if (VerifyUtil.isEmpty((String)leftStr)) {
                    leftStr = "0";
                }
                resultObject.put((Object)"dbName", (Object)temp.getDataBaseName());
                resultObject.put((Object)"used", (Object)usedStr.trim());
                resultObject.put((Object)"unused", (Object)leftStr.trim());
                double tempdbStepMax = NumberUtil.parseDouble((Object)usedStr.trim()) + NumberUtil.parseDouble((Object)leftStr.trim());
                if (tempdbStepMax > dbMax) {
                    dbMax = tempdbStepMax;
                }
                resultArray.add((Object)resultObject);
            }
            double dbStepMax = dbMax / 10.0;
            for (Object item : resultArray) {
                JSONObject obj = JSONObject.fromObject(item);
                obj.put((Object)"stepMax", (Object)dbStepMax);
            }
        }
        return resultArray.toString();
    }

    @Override
    @Permission(name={"ism.drm.dump.configdata.scan"})
    @Logging(name="dataMaintainence_exportConfigData_operateName", object="=configuredData_objectName")
    public Response exportSysConfigData(String dataPassword, String isDataAnonymous) {
        this.checkDataPassword(dataPassword);
        if (!this.isExportChecked().booleanValue()) {
            return Response.ok().build();
        }
        IConfigDataBackupService confDataBackupService = (IConfigDataBackupService)this.getBundleService(IConfigDataBackupService.class);
        File fileToDownload = confDataBackupService.backupConfig(dataPassword, !VerifyUtil.isEmpty((String)isDataAnonymous) && Boolean.parseBoolean(isDataAnonymous));
        if (VerifyUtil.isEmpty((Object)fileToDownload)) {
            throw new LegoCheckedException(0x300001L);
        }
        SystemFileUtil.downloadFile((HttpServletResponse)this.getResponse(), (File)fileToDownload, (IConfigDataBackupBaseService)confDataBackupService, (String)"ConfigData.zip");
        return Response.ok().build();
    }

    private void checkDataPassword(String dataPassword) {
        if (!this.checkPasswordComplex(dataPassword)) {
            LOGGER.error((Object)"The encrypt password is error, export config data failed.");
            throw new LegoCheckedException(1073947393L);
        }
    }

    private boolean checkPasswordComplex(String password) {
        boolean case3;
        LOGGER.debug((Object)"Enter checkPasswordComplex");
        if (VerifyUtil.isEmpty((String)password) || password.length() < 8 || password.length() > 15) {
            return false;
        }
        if (password.contains(" ")) {
            return false;
        }
        boolean isMatch = true;
        password = Normalizer.normalize(password, Normalizer.Form.NFKC);
        boolean case1 = !Pattern.compile(LOWER_CHAR).matcher(password).find() || !Pattern.compile(NUMBER).matcher(password).find() || !Pattern.compile(SPECIAL_CHAR).matcher(password).find();
        boolean case2 = !Pattern.compile(UPPER_CHAR).matcher(password).find() || !Pattern.compile(LOWER_CHAR).matcher(password).find() || !Pattern.compile(SPECIAL_CHAR).matcher(password).find();
        boolean bl = case3 = !Pattern.compile(UPPER_CHAR).matcher(password).find() || !Pattern.compile(NUMBER).matcher(password).find() || !Pattern.compile(SPECIAL_CHAR).matcher(password).find();
        if (case1 && case2 && case3) {
            isMatch = false;
        }
        return isMatch;
    }

    @Override
    @Permission(name={"ism.drm.dump.software.doc.scan"})
    @Logging(name="dataMaintainence_exportSoftwareArchive_operateName", object="=softwareInfo_objectName")
    public Response exportSoftwareArchive() {
        ISoftwareInfoService softwareService = (ISoftwareInfoService)this.getBundleService(ISoftwareInfoService.class.getName(), ISoftwareInfoService.class);
        String templateFileName = "BCManager_template.xml";
        String downloadFileName = "SoftwareArchive.xml";
        String type = this.getText("ultraapm.rd.base.about.title");
        String version = this.getText("ultraapm.rd.base.about.version.value");
        String typePrefix = type + "_";
        try {
            SoftwareInfo info = softwareService.getSoftwareInfo();
            ClassLoader clsLoader = this.getClass().getClassLoader();
            if (null == clsLoader) {
                LOGGER.error((Object)"Can not get the clas loader.");
                return Response.ok().build();
            }
            URL url = clsLoader.getResource("");
            if (VerifyUtil.isEmpty((Object)url)) {
                LOGGER.error((Object)"Can not get the clas loader.");
                return Response.ok().build();
            }
            String fileName = url.toURI().getPath() + templateFileName;
            DocumentBuilder db = this.getDocumentBuilder();
            Document doc = db.parse(new File(fileName));
            Element docEle = doc.getDocumentElement();
            this.setNodeAttributeInfo(type, version, typePrefix, info, docEle);
            String downloadPath = this.getSession().getServletContext().getRealPath("") + File.separator + UserConstant.FILEPATH_EXPORT_DIR;
            if (this.isPathNotExists(downloadPath)) {
                return Response.ok().build();
            }
            File ff = new File(downloadPath + File.separator + downloadFileName);
            this.outputXml(doc, ff);
            if (!this.isExportChecked().booleanValue()) {
                return Response.ok().build();
            }
            SystemFileUtil.downloadFile((HttpServletResponse)this.getResponse(), (File)ff, null, null);
        }
        catch (Exception e) {
            throw new LegoCheckedException(0x300001L, (Throwable)e);
        }
        return Response.ok().build();
    }

    private boolean isPathNotExists(String downloadPath) {
        boolean ret;
        File file = new File(downloadPath);
        if (!file.exists() && !(ret = file.mkdir())) {
            LOGGER.error((Object)"create export file directory failed");
            return true;
        }
        return false;
    }

    private void setNodeAttributeInfo(String type, String version, String typePrefix, SoftwareInfo info, Element docEle) {
        HashMap<String, String> neInfoAttr = new HashMap<String, String>();
        neInfoAttr.put("Type", type);
        neInfoAttr.put("NE_ID", typePrefix + info.getSn());
        neInfoAttr.put("Name", typePrefix + info.getIpAddress());
        neInfoAttr.put("Version", version);
        this.setNodeAttribute(docEle, "NEInformation", neInfoAttr);
        HashMap<String, String> softwareVerAttr = new HashMap<String, String>();
        softwareVerAttr.put("Type", "HOSTVER");
        softwareVerAttr.put("SN", typePrefix + info.getSn());
        softwareVerAttr.put("Version", version);
        this.setNodeAttribute(docEle, "SoftwareVersion", softwareVerAttr);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        HashMap<String, String> dateEndAttr = new HashMap<String, String>();
        dateEndAttr.put("datetime", format.format(new Date()));
        this.setNodeAttribute(docEle, "DataEnd", dateEndAttr);
    }

    private DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        return CommonUtil.createDocumentBuilder((boolean)false);
    }

    private void outputXml(Document doc, File file) {
        LOGGER.debug((Object)"Enter outputXml: %s", new Object[]{file.getName()});
        OutputStreamWriter outputWriter = null;
        try {
            TransformerFactory tf = CommonUtil.newSecureTransformer();
            Transformer transformer = tf.newTransformer();
            DOMSource source = new DOMSource(doc);
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            outputWriter = new OutputStreamWriter(Files.newOutputStream(file.toPath(), new OpenOption[0]), Charset.defaultCharset());
            StreamResult result = new StreamResult(outputWriter);
            transformer.transform(source, result);
        }
        catch (Exception e) {
            try {
                throw new LegoCheckedException(-1L, (Throwable)e);
            }
            catch (Throwable throwable) {
                CommonUtil.close(outputWriter);
                throw throwable;
            }
        }
        CommonUtil.close((Closeable)outputWriter);
    }

    private void setNodeAttribute(Element el, String nodeName, Map<String, String> attributes) {
        LOGGER.debug((Object)"Enter setNodeAttribute");
        NodeList neInfo = el.getElementsByTagName(nodeName);
        if (neInfo != null && neInfo.getLength() > 0) {
            Node node = neInfo.item(0);
            NamedNodeMap nnm = node.getAttributes();
            Iterator<Map.Entry<String, String>> it = attributes.entrySet().iterator();
            if (VerifyUtil.isEmpty((Object)nnm)) {
                return;
            }
            while (it.hasNext()) {
                Map.Entry<String, String> entry = it.next();
                nnm.getNamedItem(entry.getKey()).setNodeValue(entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Permission(name={"ism.drm.sys.exportrlog.scan"})
    @Logging(name="dataMaintainence_exportDebugLog_operateName")
    public Response exportDebugLog() {
        Object object = LOG_EXPORT_LOCKER;
        synchronized (object) {
            ISoftwareInfoService softwareService = (ISoftwareInfoService)this.getBundleService(ISoftwareInfoService.class.getName(), ISoftwareInfoService.class);
            if (!this.isExportChecked().booleanValue()) {
                return Response.ok().build();
            }
            String file = softwareService.exportLogs();
            File fileToDownload = new File(file);
            IConfigDataBackupBaseService confDataBackupService = (IConfigDataBackupBaseService)this.getBundleService(IConfigDataBackupService.class);
            SystemFileUtil.downloadFile((HttpServletResponse)this.getResponse(), (File)fileToDownload, (IConfigDataBackupBaseService)confDataBackupService, null);
        }
        return Response.ok().build();
    }

    @Override
    @Permission(name={"ism.drm.dump.configdata.setting.operateID"})
    @Logging(name="dataMaintainence_modifyBackupInfo_operateName", rank=3, object="=systemDataBackupParams_objectName", ward=true)
    public Response setFTPInfo(FtpServerInfo info) {
        FtpServerInfo oldFtpServerInfo;
        if (VerifyUtil.isEmpty((Object)info)) {
            throw new LegoCheckedException(1073947393L);
        }
        String ftpServerId = info.getFtpServerId();
        String ftpIp = info.getIp();
        String ftpPort = info.getPort() + "";
        String ftpUserName = info.getFtpUserName();
        String ftpPwd = info.getFtpPassword();
        String autoBackupFlag = info.isAutoBackupFlag() + "";
        String dataPwd = info.getDataPassword();
        String hostKey = info.getHostKey();
        ftpUserName = HtmlStringConverter.decodeByLength((String)ftpUserName);
        boolean isAuthChanged = false;
        boolean exportPwdChanged = false;
        FtpServerInfo ftpServerInfo = new FtpServerInfo();
        INorthNmsService nmsService = (INorthNmsService)ServiceLocator.getBundleService((String)"slave", (String)"northNmsService");
        if (!VerifyUtil.isEmpty((String)dataPwd)) {
            exportPwdChanged = true;
            if (!this.checkPasswordComplex(dataPwd)) {
                LOGGER.error((Object)"Change ftp server failed, check password error.");
                throw new LegoCheckedException(1073947393L);
            }
            ftpServerInfo.setDataPassword(nmsService.encrypt(dataPwd));
        }
        if (!VerifyUtil.isEmpty((String)ftpPwd)) {
            isAuthChanged = true;
            ftpServerInfo.setFtpPassword(nmsService.encrypt(ftpPwd));
        }
        this.checkFtpParams(isAuthChanged, info);
        IConfigDataBackupService confDataBackupService = (IConfigDataBackupService)this.getBundleService(IConfigDataBackupService.class);
        if (!Boolean.parseBoolean(autoBackupFlag) && (oldFtpServerInfo = confDataBackupService.queryFtpServerInfoVo(null)) != null) {
            ftpServerId = oldFtpServerInfo.getFtpServerId();
            ftpIp = oldFtpServerInfo.getIp();
            ftpUserName = oldFtpServerInfo.getFtpUserName();
            ftpPort = "" + oldFtpServerInfo.getPort();
        }
        ftpServerInfo.setFtpServerId(ftpServerId);
        ftpServerInfo.setIp(ftpIp);
        ftpServerInfo.setFtpUserName(ftpUserName);
        ftpServerInfo.setPort(NumberUtil.convertToInteger((Object)ftpPort).intValue());
        if (!VerifyUtil.isEmpty((String)hostKey)) {
            ftpServerInfo.setHostKey(nmsService.encrypt(hostKey));
        }
        this.setAutoBackup(autoBackupFlag, ftpServerInfo);
        this.saveFtpInfo(isAuthChanged, exportPwdChanged, ftpServerInfo, confDataBackupService);
        return Response.ok().build();
    }

    private void saveFtpInfo(boolean isAuthChanged, boolean exportPwdChanged, FtpServerInfo ftpServerInfo, IConfigDataBackupService confDataBackupService) {
        try {
            confDataBackupService.save(ftpServerInfo, isAuthChanged, exportPwdChanged);
            this.writeSucOperationLog("dataMaintainence_modifyBackupInfo_operateName", 3, "systemDataBackupParams_objectName", null, null);
        }
        catch (Exception e) {
            this.writeFailedOperationLog("dataMaintainence_modifyBackupInfo_operateName", 3, "systemDataBackupParams_objectName", e);
        }
    }

    private void setAutoBackup(String autoBackupFlag, FtpServerInfo ftpServerInfo) {
        LOGGER.debug((Object)"Enter setAutoBackup");
        try {
            ftpServerInfo.setAutoBackupFlag(Boolean.parseBoolean(autoBackupFlag));
            if (Boolean.parseBoolean(autoBackupFlag)) {
                this.writeSucOperationLog("dataMaintainence_enableAutoBackup_operateName", 3, "systemDataBackupSetting_objectName", null, null);
            } else {
                this.writeSucOperationLog("dataMaintainence_disableAutoBackup_operateName", 2, "systemDataBackupSetting_objectName", null, null);
            }
        }
        catch (Exception e) {
            if (Boolean.parseBoolean(autoBackupFlag)) {
                this.writeFailedOperationLog("dataMaintainence_enableAutoBackup_operateName", 3, "systemDataBackupSetting_objectName", e);
            }
            this.writeFailedOperationLog("dataMaintainence_disableAutoBackup_operateName", 2, "systemDataBackupSetting_objectName", e);
        }
    }

    private void checkFtpParams(boolean isAuthChanged, FtpServerInfo info) {
        String ftpServerId = info.getFtpServerId();
        String ftpIp = info.getIp();
        String ftpPort = info.getPort() + "";
        String ftpUserName = info.getFtpUserName();
        String ftpPwd = info.getFtpPassword();
        String autoBackupFlag = info.isAutoBackupFlag() + "";
        ftpUserName = HtmlStringConverter.decodeByLength((String)ftpUserName);
        boolean paraValidFlag = this.isAutoBackFlagValid(autoBackupFlag);
        if (paraValidFlag && !Boolean.parseBoolean(autoBackupFlag)) {
            return;
        }
        boolean ipIsValid = this.checkFtpIp(ftpIp);
        boolean bl = paraValidFlag = paraValidFlag && ipIsValid && this.isPortValid(ftpPort);
        if (this.checkParamsEmpty(ftpUserName, ftpPwd)) {
            paraValidFlag = false;
        }
        if (isAuthChanged && !this.between(ftpPwd.length(), 1, 255)) {
            paraValidFlag = false;
        }
        if (!this.between(ftpUserName.length(), 1, 255)) {
            paraValidFlag = false;
        }
        if (VerifyUtil.isEmpty((String)info.getHostKey()) || !CommUtil.checkParam((String)info.getHostKey(), (int)4096)) {
            paraValidFlag = false;
        }
        if (!paraValidFlag) {
            LOGGER.error((Object)"At least one of ftp server parameters is invalid.");
            throw new LegoCheckedException(1073947393L);
        }
    }

    private boolean checkFtpIp(String ftpIp) {
        String ipType = AddressUtil.ipType((String)ftpIp);
        return "IPV4".equals(ipType) && this.isIpValid(ftpIp) || "IPV6".equals(ipType) && Ipv6AddressUtil.isValidIPv6((String)ftpIp);
    }

    private boolean checkParamsEmpty(String ftpUserName, String ftpPwd) {
        return VerifyUtil.isEmpty((String)ftpUserName) || VerifyUtil.isEmpty((String)ftpPwd);
    }

    private boolean isAutoBackFlagValid(String autoBackupFlag) {
        if (VerifyUtil.isEmpty((String)autoBackupFlag)) {
            LOGGER.error((Object)"The parameter (autoBackupFlag) is empty.");
            return false;
        }
        if (!AUTO_BACKUP_FLAG_FALSE.equalsIgnoreCase(autoBackupFlag) && !AUTO_BACKUP_FLAG_TRUE.equalsIgnoreCase(autoBackupFlag)) {
            LOGGER.error((Object)"The parameter (autoBackupFlag) is not valid.");
            return false;
        }
        return true;
    }

    private boolean isIpValid(String ftpIp) {
        if (VerifyUtil.isEmpty((String)ftpIp) || ftpIp.startsWith(LOCAL_HOST_IP_FIRST)) {
            LOGGER.error((Object)"The parameter (ftpPort) is empty or localhost.");
            return false;
        }
        String reg = "(([1-9])|([1-9]\\d)|([1]\\d{2})|(22[0-3])|(2[0-1]\\d))(\\.((\\d)|([1-9]\\d)|([1]\\d{2})|([2][0-4]\\d)|([2][5][0-5]))){2}(\\.(([1-9])|([1-9]\\d)|([1]\\d{2})|([2][0-4]\\d)|([2][5][0-5])))";
        Matcher matcher = Pattern.compile(reg).matcher(Normalizer.normalize(ftpIp, Normalizer.Form.NFKC));
        if (!matcher.matches()) {
            LOGGER.error((Object)"The parameter (ftpPort) is invalid.");
            return false;
        }
        return true;
    }

    private boolean between(int length, int min, int max) {
        return min <= length && length <= max;
    }

    private boolean isPortValid(String ftpPort) {
        int port;
        if (VerifyUtil.isEmpty((String)ftpPort)) {
            LOGGER.error((Object)"The parameter (ftpPort) is empty.");
            return false;
        }
        try {
            port = Integer.parseInt(ftpPort);
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)"The parameter (ftpPort) is invalid.", (Throwable)e);
            return false;
        }
        return port >= 1 && port <= 65535;
    }

    @Override
    @Permission(name={"ism.drm.dump.configdata.setting.operateID"})
    public FtpServerInfo getFTPInfo() {
        LOGGER.debug((Object)"Enter getFTPInfo");
        IConfigDataBackupService confDataBackupService = (IConfigDataBackupService)this.getBundleService(IConfigDataBackupService.class);
        FtpServerInfo serverInfo = confDataBackupService.queryFtpServerInfo(null);
        if (serverInfo != null) {
            serverInfo.setFtpPassword("");
            serverInfo.setDataPassword("");
            serverInfo.setBaseDir("");
            serverInfo.setHostKey(WccEncryptor.decrypt((String)serverInfo.getHostKey()));
        }
        return serverInfo;
    }

    @Override
    @Permission(name={"ism.drm.dump.configdata.setting.operateID"})
    public String getFtpHostKey(String ip, Integer port) {
        String ipType = AddressUtil.ipType((String)ip);
        if ("IPV4".equals(ipType)) {
            if (!this.isIpValid(ip)) {
                LOGGER.error((Object)"SFTP server ip address is invalid ipv4 address! please check!");
                throw new LegoCheckedException(1073947393L);
            }
        } else if ("IPV6".equals(ipType)) {
            if (!Ipv6AddressUtil.isValidIPv6((String)ip)) {
                LOGGER.error((Object)"SFTP server ip address is invalid ipv6 address! please check!");
                throw new LegoCheckedException(1073947393L);
            }
        } else {
            LOGGER.error((Object)"SFTP server ip address is invalid ip address! please check!");
            throw new LegoCheckedException(1073947393L);
        }
        if (!this.isPortValid(port.toString().trim())) {
            LOGGER.error((Object)"SFTP server port number is invalid.");
            throw new LegoCheckedException(1073947393L);
        }
        IConfigDataBackupService confDataBackupService = (IConfigDataBackupService)this.getBundleService(IConfigDataBackupService.class);
        String hostKey = confDataBackupService.getFtpHostKey(ip, port);
        JSONObject jsonObject = new JSONObject();
        if (VerifyUtil.isEmpty((String)hostKey)) {
            LOGGER.error((Object)"Get SFTP hostKey failed. IP: %s", new Object[]{ip});
            throw new LegoCheckedException(1073947450L);
        }
        jsonObject.put((Object)"hostKey", (Object)hostKey);
        return jsonObject.toString();
    }

    @Override
    @Permission(name={"ism.drm.dump.configdata.setting.operateID"})
    @Logging(name="dataMaintainence_Test_AutoBackupInfo_operateName", rank=3, object="=systemDataBackupParams_objectName")
    public Response testAutoBackupConfig() {
        IConfigDataBackupService confDataBackupService = (IConfigDataBackupService)this.getBundleService(IConfigDataBackupService.class);
        confDataBackupService.testAutoBackupConfig();
        return Response.ok().build();
    }

    @Override
    @Permission(name={"ism.drm.personal.data.clear"})
    @Logging(name="dataMaintainence_clearPersonalData_operateName", rank=4, object="=personalData_objectName")
    public Response clearPersonalData() {
        LOGGER.debug((Object)"Personal data clearing...");
        IPersonalDataService personalDataService = (IPersonalDataService)this.getBundleService(IPersonalDataService.class);
        personalDataService.clearPersonalData();
        return Response.ok().build();
    }

    static {
        LEVELS.put("DEBUG", Level.DEBUG);
        LEVELS.put("INFO", Level.INFO);
        LEVELS.put("WARN", Level.WARN);
        LEVELS.put("ERROR", Level.ERROR);
    }
}

