/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.platform.bakupstorage;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.backup.model.BackupProxy;
import com.huawei.ism.drm.backup.service.IBackupProxyService;
import com.huawei.ism.drm.common.sdk.model.DRMObject;
import com.huawei.ism.drm.rest.service.base.AbstractRestService;
import com.huawei.ism.drm.rest.service.platform.bakupstorage.IBackupProxyRestService;
import com.huawei.ism.drm.web.annotation.Logging;
import com.huawei.ism.drm.web.annotation.Permission;
import com.huawei.ism.drm.web.util.CommUtils;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.moment.bedstone.shield.annotation.Context;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.core.Response;

public class BackupProxyRestServiceImpl
extends AbstractRestService
implements IBackupProxyRestService {
    @Override
    @Permission(name={"ism.drm.proxyserver.config"})
    @Logging(name="proxy_createProxy_operateName", rank=3, object="$1?.name")
    public Response createBackupProxy(BackupProxy proxy) {
        if (VerifyUtil.isEmpty((Object)proxy)) {
            throw new LegoCheckedException(1073947393L);
        }
        this.checkProxyParam(proxy);
        this.getBackupProxyService().createBackupProxy(proxy);
        return Response.ok().build();
    }

    @Override
    @Context(name="proxy")
    @Permission(name={"ism.drm.proxyserver.config"})
    @Logging(name="proxy_modifyProxy_operateName", rank=3, object="$proxy?.name ?: $1", detail="proxy_modifyProxy_operateDetail")
    public Response updateBackupProxy(String proxyId, BackupProxy proxy) {
        if (VerifyUtil.isEmpty((String)proxyId)) {
            throw new LegoCheckedException(1073947393L);
        }
        BackupProxy backupProxy = this.getBackupProxyService().getBackupProxy(proxyId);
        if (null == backupProxy) {
            throw new LegoCheckedException(2117645L);
        }
        Context.Variable.set((String)"proxy", (Object)backupProxy);
        backupProxy.setName(proxy.getName());
        backupProxy.setUserName(proxy.getUserName());
        backupProxy.setPassword(proxy.getPassword());
        backupProxy.setAddress(proxy.getAddress());
        backupProxy.setPort(proxy.getPort());
        backupProxy.setAnonymous(proxy.getAnonymous());
        if (proxy.getAnonymous().booleanValue()) {
            backupProxy.setPassword("");
            backupProxy.setUserName("");
        }
        this.checkProxyParam(backupProxy);
        this.getBackupProxyService().updateBackupProxy(backupProxy);
        return Response.ok().build();
    }

    @Override
    @Context(name="proxy")
    @Permission(name={"ism.drm.proxyserver.config"})
    @Logging(name="proxy_deleteProxy_operateName", rank=3, object="$proxy?.name", detail="proxy_deleteProxy_operateDetail", parameters={"$proxy?.name"})
    public Response deleteBackupProxy(String proxyId) {
        if (VerifyUtil.isEmpty((String)proxyId)) {
            throw new LegoCheckedException(1073947393L);
        }
        BackupProxy backupProxy = this.getBackupProxyService().getBackupProxy(proxyId);
        if (null == backupProxy) {
            throw new LegoCheckedException(2117645L);
        }
        Context.Variable.set((String)"proxy", (Object)backupProxy);
        this.getBackupProxyService().deleteBackupProxy(proxyId);
        return Response.ok().build();
    }

    @Override
    @Permission(name={"ism.drm.proxyserver.scan"})
    public BackupProxy getBackupProxy(String proxyId) {
        if (VerifyUtil.isEmpty((String)proxyId)) {
            throw new LegoCheckedException(1073947393L);
        }
        BackupProxy proxy = this.getBackupProxyService().getBackupProxy(proxyId);
        if (!VerifyUtil.isEmpty((Object)proxy)) {
            proxy.setPassword("");
        }
        return proxy;
    }

    @Override
    @Permission(name={"ism.drm.proxyserver.scan"})
    public String listBackupProxy() {
        List proxyList = this.getBackupProxyService().listBackupProxy();
        if (!VerifyUtil.isEmpty((Collection)proxyList)) {
            for (DRMObject proxy : proxyList) {
                if (!(proxy instanceof BackupProxy)) continue;
                ((BackupProxy)proxy).setPassword("********");
            }
        }
        JSONObject json = new JSONObject();
        json.put((Object)"totalCount", (Object)proxyList.size());
        JSONArray listArray = JSONArray.fromObject((Object)proxyList);
        json.put((Object)"records", (Object)listArray.toString());
        return json.toString();
    }

    private void checkProxyParam(BackupProxy proxy) {
        boolean paramFlag1 = CommUtils.checkParam((String)proxy.getName(), (int)32) && CommUtils.checkDrmPortParam((String)proxy.getPort()) && (CommUtils.checkStr((String)proxy.getAddress(), (String)"^(?=^.{3,255}$)[a-zA-Z0-9][-a-zA-Z0-9]{0,62}(\\.[a-zA-Z0-9][-a-zA-Z0-9]{0,62})+$") || CommUtils.checkStr((String)proxy.getAddress(), (String)"^\\s*((([0-9A-Fa-f]{1,4}:){7}(([0-9A-Fa-f]{1,4})|:))|(([0-9A-Fa-f]{1,4}:){6}(:|((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})|(:[0-9A-Fa-f]{1,4})))|(([0-9A-Fa-f]{1,4}:){5}((:((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(([0-9A-Fa-f]{1,4}:){4}(:[0-9A-Fa-f]{1,4}){0,1}((:((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(([0-9A-Fa-f]{1,4}:){3}(:[0-9A-Fa-f]{1,4}){0,2}((:((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(([0-9A-Fa-f]{1,4}:){2}(:[0-9A-Fa-f]{1,4}){0,3}((:((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(([0-9A-Fa-f]{1,4}:)(:[0-9A-Fa-f]{1,4}){0,4}((:((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(:(:[0-9A-Fa-f]{1,4}){0,5}((:((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})))(%.+)?\\s*$"));
        boolean paramFlag2 = true;
        if (!proxy.getAnonymous().booleanValue()) {
            boolean bl = paramFlag2 = CommUtils.checkParam((String)proxy.getUserName(), (int)512) && (VerifyUtil.isEmpty((String)proxy.getPassword()) || CommUtils.checkParam((String)proxy.getPassword(), (int)512));
        }
        if (!paramFlag1 || !paramFlag2) {
            throw new LegoCheckedException(1073947393L);
        }
    }

    private IBackupProxyService getBackupProxyService() {
        return (IBackupProxyService)this.getBundleService(IBackupProxyService.class.getName(), IBackupProxyService.class);
    }
}

