/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.platform.recovery;

import com.huawei.ism.array.sdk.model.HvsUnit;
import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.base.sdk.bo.Page;
import com.huawei.ism.cbb.base.sdk.bo.QueryCondition;
import com.huawei.ism.cbb.util.CommonComparator;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.drp.sdk.mo.ProtectObjectBo;
import com.huawei.ism.drm.drp.sdk.model.RecoveryLog;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessorDetail;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanBaseService;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.service.IReplicaService;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.schedule.sdk.model.ScheduleProtectedType;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.protection.template.sdk.model.SiteInfo;
import com.huawei.ism.drm.protection.template.sdk.service.IPolicyTemplateManager;
import com.huawei.ism.drm.recovery.sdk.model.MountConfiguration;
import com.huawei.ism.drm.rest.service.platform.recovery.AbstractRecoveryPlanRestService;
import com.huawei.ism.drm.rest.service.platform.recovery.RecoveryPlanEntity;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteBaseService;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.storage.sdk.service.IStorageResourceService;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.ism.drm.util.RecoveryUtil;
import com.huawei.ism.drm.util.ReplicaUtil;
import com.huawei.ism.drm.web.annotation.Permission;
import com.huawei.ism.drm.web.util.CommUtils;
import com.huawei.ism.drm.web.validator.Validator;
import com.huawei.ism.unistor.sdk.model.VstoreHyperMetroPair;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.TimeUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public abstract class RecoveryPlanQueryRestServiceImpl
extends AbstractRecoveryPlanRestService {
    private static final Log LOGGER = LogFactory.getInstance(RecoveryPlanQueryRestServiceImpl.class);
    private static final List<Integer> TYPES = Arrays.asList(20, 24, 27, 32);
    private static final List<Integer> REQUIRE_HANDLE_GLOBAL_SETTINGS_PO_TYPES = new ArrayList<Integer>();

    private static boolean isProtectGroupUseNasFileSystem(ProtectGroup pg) {
        boolean isNas = false;
        ProtectObjectStorageInfo storageInfo = (ProtectObjectStorageInfo)((ProtectObject)pg.getPolist().iterator().next()).getUsedStorageResourceSet().iterator().next();
        if (DrmEnumDefine.ResourceTypeE.NAS.getValue() == storageInfo.getResourceType().intValue()) {
            isNas = true;
        }
        return isNas;
    }

    @Override
    @Permission(name={"ism.drm.drp.auth.scan"})
    public String recoveryplans(String orderBy, String orderType, int pageSize, int startPage, int planType) {
        if (!Validator.checkPageQueryParams((String)orderType, (int)pageSize, (int)startPage)) {
            throw new LegoCheckedException(1073947393L);
        }
        boolean orderByAscend = "asc".equalsIgnoreCase(orderType);
        JSONObject result = new JSONObject();
        Map extFilterMap = this.getExtParamInQueryParam();
        Page page = this.getRecoveryPlanService().pageQueryRecoveryPlan(startPage, pageSize, orderBy, orderByAscend, planType, extFilterMap, this.getCurrentUserId());
        if (this.checkPage(page)) {
            result.put((Object)"totalCount", (Object)0);
            result.put((Object)"records", (Object)"[]");
            return result.toString();
        }
        List recoveryPlans = page.getResult();
        ArrayList<Integer> susccessStatuList = new ArrayList<Integer>();
        susccessStatuList.add(DrmEnumDefine.RecoveryPlanStatusE.CLEAN_COMPLETED.getValue());
        susccessStatuList.add(DrmEnumDefine.RecoveryPlanStatusE.DISASTER_RECOVERY_COMPLETED.getValue());
        susccessStatuList.add(DrmEnumDefine.RecoveryPlanStatusE.PLANED_MOTION_COMPLETED.getValue());
        susccessStatuList.add(DrmEnumDefine.RecoveryPlanStatusE.REPROTECT_COMPLETED.getValue());
        susccessStatuList.add(DrmEnumDefine.RecoveryPlanStatusE.ROLLBACK_COMPLETED.getValue());
        susccessStatuList.add(DrmEnumDefine.RecoveryPlanStatusE.TEST_COMPLETED.getValue());
        HashMap<String, String> planIdToLogId = new HashMap<String, String>();
        for (RecoveryPlan plan : recoveryPlans) {
            if (susccessStatuList.contains(plan.getPlanStatus()) && plan.getProcessStatus() == DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue()) {
                String logId = this.getRecoveryPlanService().getLatestRecoveryLogIdBy(plan.getPlanId());
                planIdToLogId.put(plan.getPlanId(), logId);
            }
            this.refactorGlobalSettings(plan);
        }
        result.put((Object)"totalCount", (Object)page.getTotalCount());
        result.put((Object)"records", (Object)this.toRecoveryPlanJson(recoveryPlans, planIdToLogId));
        return result.toString();
    }

    protected void refactorGlobalSettings(RecoveryPlan rp) {
        Set protectGroups;
        Iterator iterator;
        ProtectGroup firstGroup;
        int poType;
        String replicaId;
        Map globalSettings = rp.getGlobalSettings();
        HashMap<String, String> newGlobalSettings = new HashMap<String, String>();
        if (RecoveryPlan.MOUNT_PLAN.equals(rp.getUse()) && !VerifyUtil.isEmpty((String)(replicaId = (String)globalSettings.get("REPLICA_ID")))) {
            IReplicaService replicaService = (IReplicaService)this.getBundleService("DRM_Base", IReplicaService.class.getName());
            ProtectGroupReplica replica = replicaService.queryProtectGroupReplicaById(replicaId);
            newGlobalSettings.put("ReplicaId", replicaId);
            if (!VerifyUtil.isEmpty((Object)replica)) {
                newGlobalSettings.put("ReplicaName", replica.getName());
                if (!VerifyUtil.isEmpty((String)replica.getTimeStamp())) {
                    Date date = new Date(NumberUtil.convertToLong((Object)replica.getTimeStamp()));
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    String timeContent = dateFormat.format(date);
                    String timeZoneStr = " " + TimeUtil.getDefaultTimeZone((Date)date);
                    timeContent = timeContent + timeZoneStr;
                    newGlobalSettings.put("timeStamp", timeContent);
                } else {
                    newGlobalSettings.put("timeStamp", "--");
                }
                newGlobalSettings.put("ReplicaType", String.valueOf(replica.getType()));
                String mountConfigs = (String)replica.getProps().get("mountConfigs");
                MountConfiguration configuration = (MountConfiguration)JSONObject.toBean((String)mountConfigs, MountConfiguration.class);
                newGlobalSettings.put("StartTime", configuration.getStartTime());
                newGlobalSettings.put("UmountPreReplica", String.valueOf(configuration.isUnmountPreviousCopy()));
                newGlobalSettings.put("StartDB", String.valueOf(configuration.isStartDB()));
                newGlobalSettings.put("DeleteReplica", String.valueOf(configuration.isDeleteReplica()));
                newGlobalSettings.put("Description", String.valueOf(configuration.getDescription()));
                ISiteBaseService siteService = this.getSiteService();
                String siteId = configuration.getSiteId();
                Site site = siteService.getSiteById(siteId);
                newGlobalSettings.put("SiteId", siteId);
                newGlobalSettings.put("SiteName", site.getName());
                newGlobalSettings.put("isCloudSite", String.valueOf(site.getIsCloudSite()));
                String hostSnInGol = (String)globalSettings.get("PG_DISASTER_HOST");
                String hostSn = hostSnInGol == null ? configuration.getHostOrGroupSn() : hostSnInGol;
                String hostName = this.getRecoveryPlanService().getHostName(hostSn, site, rp.getProtectGroup());
                newGlobalSettings.put("MountHostName", hostName);
            }
        }
        if (globalSettings.containsKey("keepMac")) {
            String isKeepMac = (String)globalSettings.get("keepMac");
            newGlobalSettings.put("keepMac", Boolean.valueOf(isKeepMac).toString());
        }
        if (REQUIRE_HANDLE_GLOBAL_SETTINGS_PO_TYPES.contains(poType = (firstGroup = (ProtectGroup)(iterator = (protectGroups = rp.getProtectGroups()).iterator()).next()).getPoType())) {
            Iterator settingIterator = newGlobalSettings.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = settingIterator.next();
                globalSettings.put(entry.getKey(), entry.getValue());
            }
            rp.setGlobalSettings(globalSettings);
        } else {
            rp.setGlobalSettings(newGlobalSettings);
        }
    }

    @Override
    @Permission(name={"ism.drm.drp.auth.scan"}, uuid={"$1"})
    public String recoveryplans(String planId) {
        if (VerifyUtil.isEmpty((String)planId)) {
            throw new LegoCheckedException(1073947393L);
        }
        RecoveryPlan recoveryPlan = this.getRecoveryPlanService().getRecoveryPlan(planId);
        if (VerifyUtil.isEmpty((Object)recoveryPlan)) {
            throw new LegoCheckedException(1073947394L);
        }
        return this.toRecoveryPlanJson(recoveryPlan, "");
    }

    @Override
    @Permission(name={"ism.drm.drp.auth.scan"})
    public String queryAvailabelProtectGroup(Integer drpType) {
        if (null == drpType || null == DrmEnumDefine.RecoveryPlanTypeE.getType((int)drpType) && -1 != drpType) {
            throw new LegoCheckedException(1073947393L);
        }
        if (drpType == -1) {
            ArrayList<ProtectGroup> allProtectGroups = new ArrayList<ProtectGroup>();
            List pgsLocal = this.getRecoveryPlanService().getAvailableProtectGroups(this.getCurrentUserId().longValue(), DrmEnumDefine.RecoveryPlanTypeE.LOCAL);
            List pgsRemote = this.getRecoveryPlanService().getAvailableProtectGroups(this.getCurrentUserId().longValue(), DrmEnumDefine.RecoveryPlanTypeE.REMOTE);
            allProtectGroups.addAll(pgsLocal);
            allProtectGroups.addAll(pgsRemote);
            return this.toProtectGroupJson(allProtectGroups);
        }
        DrmEnumDefine.RecoveryPlanTypeE drpTypeEnum = DrmEnumDefine.RecoveryPlanTypeE.getType((int)drpType);
        CommUtil.checkEnumByType(DrmEnumDefine.RecoveryPlanTypeE.class, (int)drpType);
        List protectGrous = this.getRecoveryPlanService().getAvailableProtectGroups(this.getCurrentUserId().longValue(), drpTypeEnum);
        return this.toProtectGroupJson(protectGrous);
    }

    @Override
    @Permission(name={"ism.drm.drp.auth.scan"}, uuid={"$1"})
    public String logs(String planId, String orderby, String orderType, int pageSize, int startPage) {
        if (VerifyUtil.isEmpty((String)planId) || !Validator.checkPageQueryParams((String)orderType, (int)pageSize, (int)startPage)) {
            throw new LegoCheckedException(1073947393L);
        }
        JSONObject resultObject = new JSONObject();
        boolean orderByAscend = "asc".equalsIgnoreCase(orderType);
        Page page = this.getRecoveryPlanService().pageQueryRecoveryLog(planId, startPage, pageSize, orderby, orderByAscend);
        if (VerifyUtil.isEmpty((Object)page) || VerifyUtil.isEmpty((Collection)page.getResult())) {
            return "";
        }
        List recoveryLogs = page.getResult();
        JSONArray result = this.constructResult(recoveryLogs);
        resultObject.put((Object)"totalCount", (Object)page.getTotalCount());
        resultObject.put((Object)"records", (Object)result);
        return resultObject.toString();
    }

    private JSONArray constructResult(List<RecoveryLog> recoveryLogs) {
        JSONArray result = new JSONArray();
        for (RecoveryLog rplog : recoveryLogs) {
            JSONObject logJsonObj = new JSONObject();
            logJsonObj.put((Object)"logId", (Object)rplog.getLogId());
            logJsonObj.put((Object)"logType", (Object)rplog.getLogType());
            logJsonObj.put((Object)"logStatus", (Object)rplog.getLogStatus());
            logJsonObj.put((Object)"operator", (Object)rplog.getOperator());
            logJsonObj.put((Object)"logName", (Object)rplog.getLogName());
            if (VerifyUtil.isEmpty((String)rplog.getStartTime())) {
                logJsonObj.put((Object)"startTime", (Object)"--");
            } else {
                logJsonObj.put((Object)"startTime", (Object)CommUtils.formatDate((Date)new Date(NumberUtil.convertToLong((Object)rplog.getStartTime()))));
            }
            if (VerifyUtil.isEmpty((String)rplog.getEndTime())) {
                logJsonObj.put((Object)"endTime", (Object)"--");
            } else {
                logJsonObj.put((Object)"endTime", (Object)CommUtils.formatDate((Date)new Date(NumberUtil.convertToLong((Object)rplog.getEndTime()))));
            }
            String executeTime = this.calcExecuteTime(rplog.getStartTime(), rplog.getEndTime());
            logJsonObj.put((Object)"executeTime", (Object)executeTime);
            logJsonObj.put((Object)"planId", (Object)rplog.getPlanId());
            logJsonObj.put((Object)"processId", (Object)rplog.getProcessId());
            logJsonObj.put((Object)"excuteDetail", (Object)"");
            result.add((Object)logJsonObj);
        }
        return result;
    }

    @Override
    @Permission(name={"ism.drm.drp.auth.scan"}, uuid={"$1"})
    public String queryProtectObjectInRp(String planId, String orderBy, String orderType, int pageSize, int startPage) {
        if (VerifyUtil.isEmpty((String)planId) || !Validator.checkPageQueryParams((String)orderType, (int)pageSize, (int)startPage)) {
            throw new LegoCheckedException(1073947393L);
        }
        JSONObject returnObject = new JSONObject();
        Page page = this.getRecoveryPlanService().pageQueryProtectObjectInRP(planId, startPage, pageSize, orderBy, !"desc".equalsIgnoreCase(orderType));
        if (VerifyUtil.isEmpty((Object)page)) {
            return returnObject.toString();
        }
        int total = (int)page.getTotalCount();
        returnObject.put((Object)"totalCount", (Object)total);
        List protectObjectBos = page.getResult();
        if (VerifyUtil.isEmpty((Collection)protectObjectBos)) {
            return returnObject.toString();
        }
        JSONArray jsonArray = new JSONArray();
        for (ProtectObjectBo protectObjectBo : protectObjectBos) {
            this.poToJsonStr(jsonArray, protectObjectBo);
        }
        returnObject.put((Object)"records", (Object)jsonArray);
        return returnObject.toString();
    }

    @Override
    @Permission(name={"ism.drm.drp.auth.scan"}, uuid={"$1"})
    public String queryRecoverySites(String planId) {
        if (VerifyUtil.isEmpty((String)planId)) {
            throw new LegoCheckedException(1073947393L);
        }
        RecoveryPlan rp = this.getRecoveryPlanService().getRecoveryPlan(planId);
        CommUtils.checkObjectExists((Object[])new Object[]{rp});
        CommUtils.checkObjectExists((Object[])new Object[]{rp.getProtectGroups()});
        JSONArray returnArray = new JSONArray();
        ProtectGroup pg = (ProtectGroup)CommonUtil.getFirstElement((Collection)rp.getProtectGroups());
        if (null == pg) {
            throw new LegoCheckedException(2117645L);
        }
        List<Site> siteList = this.getRecoverySiteList(pg);
        siteList.sort((Comparator<Site>)new CommonComparator("name", true));
        for (Site site : siteList) {
            returnArray.add((Object)this.toJsonStrSite(site));
        }
        return returnArray.toString();
    }

    private RelicaStorageInfo getRelicaStorageInfo(ProtectGroup pg) {
        ProtectGroupReplica pgRep = pg.getAnyoneReplicationReplica();
        if (null == pgRep) {
            LOGGER.error((Object)("The pgRep is null: " + pg.getName()));
            return null;
        }
        ProtectObjectReplica poRep = (ProtectObjectReplica)CommonUtil.getFirstElement((Collection)pgRep.getReplicas());
        if (null == poRep) {
            LOGGER.error((Object)("The poRep is null: " + pg.getName()));
            return null;
        }
        return (RelicaStorageInfo)CommonUtil.getFirstElement((Collection)poRep.getStorageInfos());
    }

    protected List<Site> getRecoverySiteList(ProtectGroup pg) {
        List<Site> siteIds;
        ArrayList<Site> siteList = new ArrayList<Site>();
        ISiteService siteService = (ISiteService)this.getBundleService(ISiteService.class);
        IStorageService storageService = (IStorageService)this.getBundleService(IStorageService.class);
        boolean is4DCTpl = PolicyTemplateType.REP_4DC_POLICYTEMPLATE.contains(pg.getTemplate().getType());
        if (is4DCTpl && !CollectionUtils.isEmpty(siteIds = this.getSitesInfoList(pg, siteService))) {
            return siteIds;
        }
        if (TYPES.contains(pg.getTemplate().getType())) {
            return this.getRecoverySiteListForHyperMetroScene(pg, siteList, siteService, storageService);
        }
        for (ProtectGroupReplica pgr : pg.getReplicaList()) {
            if (ReplicaUtil.isLocalStorageReplica((ProtectGroupReplica)pgr)) continue;
            String recoverySiteId = pgr.getRecoverySite();
            Site recoverySite = siteService.getSiteById(recoverySiteId);
            CommUtils.checkObjectExists((Object[])new Object[]{recoverySite});
            siteList.add(recoverySite);
        }
        return siteList;
    }

    private List<Site> getRecoverySiteListForHyperMetroScene(ProtectGroup pg, List<Site> siteList, ISiteService siteService, IStorageService storageService) {
        RelicaStorageInfo storageInfo = this.getRelicaStorageInfo(pg);
        ProtectGroupReplica pgRep = (ProtectGroupReplica)CommonUtil.getFirstElement((Collection)pg.getReplicaList());
        if (pgRep == null) {
            LOGGER.error((Object)("the pgRep is null,sn:" + pg.getName()));
            return siteList;
        }
        Site recoverySite = siteService.getSiteById(pgRep.getRecoverySite());
        if (storageInfo == null) {
            LOGGER.error((Object)("The storageInfo is null: " + pg.getName()));
            return siteList;
        }
        if (RecoveryPlanQueryRestServiceImpl.isProtectGroupUseNasFileSystem(pg)) {
            siteList = this.getNasSiteList(recoverySite, pg, storageInfo);
            if (VerifyUtil.isEmpty(siteList)) {
                throw new LegoCheckedException(2117645L);
            }
            return siteList;
        }
        Lun lun = storageService.getLunBySnAndLunId(storageInfo.getStorageProviderSN(), storageInfo.getStorageId());
        if (lun == null) {
            LOGGER.error((Object)("the lun is null,sn:" + storageInfo.getStorageProviderSN() + "lunId:" + storageInfo.getStorageId()));
            return siteList;
        }
        HashSet<String> wwnSet = new HashSet<String>();
        wwnSet.add(lun.getWwn());
        List lunList = storageService.getStorageResourceByWwn(wwnSet.toArray(new String[0]));
        this.getSiteInfo(siteList, siteService, lunList);
        return siteList;
    }

    private List<Site> getSitesInfoList(ProtectGroup pg, ISiteService siteService) {
        String siteInfoListStr = (String)pg.getProps().get("PROP_KEY_SITE_INFO");
        if (siteInfoListStr == null) {
            return Collections.emptyList();
        }
        List siteInfoList = JSONArray.toCollection((JSONArray)JSONArray.fromObject((Object)siteInfoListStr), SiteInfo.class);
        if ((siteInfoList = (List)Optional.ofNullable(siteInfoList).orElse(new ArrayList())).size() >= 3) {
            HashSet siteIds = new HashSet();
            List finalSiteInfoList = siteInfoList;
            siteInfoList.stream().filter(siteInfo -> finalSiteInfoList.indexOf(siteInfo) > 0).forEach(siteInfo -> siteIds.addAll(siteInfo.getSiteIdSet()));
            return siteIds.stream().map(arg_0 -> ((ISiteService)siteService).getSiteById(arg_0)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private List<Site> getNasSiteList(Site recoverySite, ProtectGroup pg, RelicaStorageInfo storageInfo) {
        VstoreHyperMetroPair pair;
        HvsUnit hvsUnit;
        IStorageResourceService storageResourceService = (IStorageResourceService)this.getBundleService(IStorageResourceService.class);
        String vStorePairId = (String)pg.getProps().get("PROP_KEY_VSTORE_PAIR_ID");
        VstoreHyperMetroPair vstoreHyperMetroPair = storageResourceService.getVstoreHyperMetroPairById(storageInfo.getStorageProviderSN(), vStorePairId, Boolean.valueOf(false));
        if (null == vstoreHyperMetroPair) {
            return Collections.emptyList();
        }
        String srcSn = storageInfo.getStorageProviderSN();
        List remotePairs = storageResourceService.getVstoreHyperPair(recoverySite.getServerUuid(), vstoreHyperMetroPair.getVstorePairId(), vstoreHyperMetroPair.getLocalVstoreId(), vstoreHyperMetroPair.getRemoteVstoreId());
        String remoteSn = null;
        Iterator iterator = remotePairs.iterator();
        while (iterator.hasNext() && srcSn.equals(remoteSn = (hvsUnit = (HvsUnit)(pair = (VstoreHyperMetroPair)iterator.next()).getParentMo()).getDevSn())) {
        }
        ArrayList<Site> siteList = new ArrayList<Site>();
        siteList.add(this.getSiteBySn(srcSn));
        siteList.add(this.getSiteBySn(remoteSn));
        return siteList;
    }

    private Site getSiteBySn(String devSn) {
        IResourceService resouceService = (IResourceService)this.getBundleService(IResourceService.class);
        ISiteService siteService = (ISiteService)this.getBundleService(ISiteService.class);
        DrResource drResource = resouceService.getDrResourceBySn(devSn);
        if (null != drResource) {
            Site site = siteService.getSiteById(drResource.getSiteId());
            CommUtils.checkObjectExists((Object[])new Object[]{site});
            return site;
        }
        return null;
    }

    private void getSiteInfo(List<Site> siteList, ISiteService siteService, List<StorageResource> lunList) {
        IResourceService resouceService = (IResourceService)this.getBundleService(IResourceService.class);
        for (StorageResource resource : lunList) {
            if (!(resource instanceof Lun)) continue;
            String devSn = resource.getDevSn();
            DrResource drResource = resouceService.getDrResourceBySn(devSn);
            if (null == drResource) {
                LOGGER.error((Object)("the drResouce is null: " + devSn));
                continue;
            }
            Site site = siteService.getSiteById(drResource.getSiteId());
            CommUtils.checkObjectExists((Object[])new Object[]{site});
            siteList.add(site);
        }
    }

    @Override
    @Permission(name={"ism.drm.drp.auth.scan"}, uuid={"$1"})
    public String queryAllStepByType(String planId, int procType) {
        DrmEnumDefine.RecoveryPlanExecuteTypeE type = DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)procType);
        CommUtils.checkParamEmpty((Object[])new Object[]{planId, type});
        JSONArray result = new JSONArray();
        IRecoveryPlanBaseService rpService = this.getRecoveryPlanService();
        List recoverSteps = rpService.getRecoveryProcessors(planId, type);
        if (VerifyUtil.isEmpty((Collection)recoverSteps)) {
            return result.toString();
        }
        RecoveryPlan recoveryPlan = rpService.getRecoveryPlan(planId);
        ProtectGroup protectGroup = recoveryPlan.getProtectGroup();
        IPolicyTemplateManager policyTemplateManager = (IPolicyTemplateManager)this.getBundleService(IPolicyTemplateManager.class);
        String ptId = protectGroup.getTemplate().getPtId();
        PolicyTemplate policyTemplate = policyTemplateManager.getPtByUuid(ptId);
        for (RecoveryProcessor step : recoverSteps) {
            JSONObject jsonObject = this.buildRecoveryStepsJson(planId, type, policyTemplate, step);
            if (VerifyUtil.isEmpty((Map)jsonObject)) continue;
            result.add((Object)jsonObject);
        }
        return result.toString();
    }

    protected JSONObject buildRecoveryStepsJson(String planId, DrmEnumDefine.RecoveryPlanExecuteTypeE type, PolicyTemplate policyTemplate, RecoveryProcessor step) {
        JSONObject jsonObject = new JSONObject();
        boolean isEnable = step.getIsEnabled();
        boolean isEditable = step.getIsEditable();
        if (!isEnable && !isEditable) {
            LOGGER.debug((Object)("stepId=" + step.getProcId() + " ; stepName=" + step.getProcName() + " is not view."));
            return null;
        }
        jsonObject.put((Object)"stepId", (Object)step.getProcId());
        jsonObject.put((Object)"stepName", (Object)step.getProcName());
        jsonObject.put((Object)"stepDescription", (Object)step.getDescription());
        jsonObject.put((Object)"name", (Object)step.getName());
        jsonObject.put((Object)"scriptName", (Object)"");
        String scriptSchemeId = (String)policyTemplate.getProps().get("scriptSchemeId");
        if (!VerifyUtil.isEmpty((String)scriptSchemeId)) {
            LOGGER.info((Object)("step use custom script scheme: " + scriptSchemeId));
            jsonObject.put((Object)"scriptSchemeId", (Object)scriptSchemeId);
        }
        for (Schedule schedule : policyTemplate.getSchedules()) {
            LOGGER.info((Object)("check schedule, type: " + schedule.getProtectedType() + ", name: " + schedule.getName()));
            if (ScheduleProtectedType.SNAPSHOT.getValue() != schedule.getProtectedType()) {
                LOGGER.debug((Object)"schedule is not snapshot.");
                continue;
            }
            LOGGER.info((Object)("resolve public params for schedule: " + schedule.getName()));
            String publicParams = (String)schedule.getExtParameters().get("publicParam");
            jsonObject.put((Object)"publicParam", (Object)publicParams);
        }
        if (!step.getIsPreset().booleanValue()) {
            boolean isUserDefined;
            boolean bl = isUserDefined = !"false".equals(step.getProps().get("isUserDefined"));
            if (!isUserDefined) {
                jsonObject.put((Object)"recoveryScriptSchemeId", step.getProps().get("recoveryScriptSchemeId"));
            }
            Map stepSetting = this.getCustomStepService().getCustomRecoveryProcessorInfos(planId, type, step.getProcId());
            jsonObject.put((Object)"isContinueIfFailed", stepSetting.get("EXECUTE_POLICY"));
            jsonObject.put((Object)"stepName", stepSetting.get("CUSTOM_PROCESSOR_NAME"));
            jsonObject.put((Object)"scriptName", stepSetting.get("EXECUTE_SCRIPT_NAME"));
            jsonObject.put((Object)"executeParams", step.getProps().get("STEP_PARAMS"));
            jsonObject.put((Object)"isUserDefined", (Object)isUserDefined);
            jsonObject.put((Object)"position", step.getProps().get("position"));
        }
        jsonObject.put((Object)"isEnabled", (Object)step.getIsEnabled());
        jsonObject.put((Object)"isEditable", (Object)step.getIsEditable());
        jsonObject.put((Object)"isPresetled", (Object)step.getIsPreset());
        return jsonObject;
    }

    @Override
    @Permission(name={"ism.drm.drp.auth.scan"}, uuid={"$1"})
    public RecoveryPlanEntity queryDRPAbstractInfo(String planId) {
        RecoveryLog recoveryLog;
        RecoveryPlanEntity selectedRP;
        block6: {
            IRecoveryPlanBaseService rpService = this.getRecoveryPlanService();
            RecoveryPlan plan = rpService.getRecoveryPlan(planId, false, false);
            if (null == plan) {
                throw new LegoCheckedException(201L);
            }
            selectedRP = this.constructRecoveryPlanEntity(plan);
            recoveryLog = null;
            try {
                recoveryLog = rpService.getLatestHistoryRecoveryLog(planId);
            }
            catch (LegoCheckedException e) {
                LOGGER.error((Object)"LegoCheckedException:", (Throwable)e, 90160758784001L);
                if (1073947394L == e.getErrorCode()) break block6;
                throw e;
            }
        }
        if (!VerifyUtil.isEmpty((Object)recoveryLog)) {
            Date startDate = null;
            String startTimeString = recoveryLog.getStartTime();
            String endTimeString = recoveryLog.getEndTime();
            String date = "";
            if (!VerifyUtil.isEmpty((String)startTimeString)) {
                startDate = new Date(NumberUtil.convertToLong((Object)startTimeString));
                date = CommUtil.formatDate((Date)startDate);
            }
            String excuteTime = null;
            if (!VerifyUtil.isEmpty((String)endTimeString)) {
                Date endDate = new Date(NumberUtil.convertToLong((Object)endTimeString));
                excuteTime = String.valueOf(endDate.getTime() - (null == startDate ? 0L : startDate.getTime()));
            }
            selectedRP.setLastExecuteDate(date);
            selectedRP.setLastExecuteTime(excuteTime);
            selectedRP.setLastExecuteResult(Integer.valueOf(recoveryLog.getLogStatus()));
            selectedRP.setLastExecuteUser(recoveryLog.getOperator());
            selectedRP.setLastExecuteType(Integer.valueOf(recoveryLog.getLogType()));
            this.initTestInfo(planId, selectedRP);
        }
        return selectedRP;
    }

    @Override
    @Permission(name={"ism.drm.drp.auth.scan"}, uuid={"$1"})
    public String viewRecoveryPlanExecuteSteps(String planId, int procType) {
        if (VerifyUtil.isEmpty((String)planId) || null == DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)procType)) {
            throw new LegoCheckedException(-1L);
        }
        IRecoveryPlanBaseService rpService = this.getRecoveryPlanService();
        List recoverDetails = rpService.getRecoveryProcessorDetailsByPlanId(planId, DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)procType));
        return this.toRecoveryProcessorDetailJsonStr(recoverDetails);
    }

    @Override
    @Permission(name={"ism.drm.drp.auth.scan"}, uuid={"$1"})
    public String queryRecoveryGlobalSettings(String planId, String key) {
        if (VerifyUtil.isEmpty((String)planId)) {
            throw new LegoCheckedException(1073947393L);
        }
        IRecoveryPlanService recoveryPlanService = (IRecoveryPlanService)this.getRecoveryPlanService();
        RecoveryPlan recoveryPlan = recoveryPlanService.getRecoveryPlan(planId);
        CommUtils.checkObjectExists((Object[])new Object[]{recoveryPlan});
        JSONObject jsonObject = new JSONObject();
        if (VerifyUtil.isEmpty((String)key)) {
            Map globalSettings = recoveryPlan.getGlobalSettings();
            for (Map.Entry eachEntry : globalSettings.entrySet()) {
                jsonObject.put(eachEntry.getKey(), eachEntry.getValue());
            }
        } else {
            String value = (String)recoveryPlan.getGlobalSettings().get(key);
            if (VerifyUtil.isEmpty((String)value)) {
                Iterator iterator;
                value = "";
                Set settings = RecoveryUtil.getRecoverySettingsByItemKey((String)planId, (String)key, (Set)recoveryPlan.getRecoverySettings());
                if (!VerifyUtil.isEmpty((Collection)settings) && (iterator = settings.iterator()).hasNext()) {
                    RecoverySetting setting = (RecoverySetting)iterator.next();
                    value = setting.getValue();
                }
            }
            jsonObject.put((Object)key, (Object)value);
        }
        return jsonObject.toString();
    }

    @Override
    @Permission(name={"ism.drm.drp.auth.scan"}, uuid={"$1"})
    public String viewRecoveryPlanExecuteLogDetail(String planId, String logId) {
        if (VerifyUtil.isEmpty((String)planId) || VerifyUtil.isEmpty((String)logId)) {
            throw new LegoCheckedException(1073947393L);
        }
        IRecoveryPlanService rpService = (IRecoveryPlanService)this.getBundleService("DRM_Base", IRecoveryPlanService.class.getSimpleName(), IRecoveryPlanService.class);
        List recoverDetails = rpService.getRecoveryProcessorDetailsByLogId(planId, logId);
        return this.toRecoveryProcessorDetailJsonStr(recoverDetails);
    }

    protected void checkUserQueryAuth() {
        this.checkUserOperationAuthority("recoveryPlan_query_operateName", 2, "ism.drm.drp.auth.scan");
    }

    protected void checkUserBizObjQueryAuth(String planId) {
        this.checkUserBizObjAuthority("recoveryPlan_query_operateName", 2, planId);
    }

    private RecoveryPlanEntity constructRecoveryPlanEntity(RecoveryPlan plan) {
        String mountConfigs;
        MountConfiguration mountConfiguration;
        RecoveryPlanEntity planEntity = new RecoveryPlanEntity();
        if (VerifyUtil.isEmpty((Object)plan)) {
            return planEntity;
        }
        planEntity.setPlanId(plan.getPlanId());
        planEntity.setPlanName(plan.getName());
        planEntity.setPlanDesc(plan.getDescription());
        planEntity.setPlanType(plan.getPlanType());
        if (VerifyUtil.isEmpty((Collection)plan.getProtectGroups())) {
            return planEntity;
        }
        Iterator iterator = plan.getProtectGroups().iterator();
        if (!iterator.hasNext()) {
            return planEntity;
        }
        ProtectGroup pg = (ProtectGroup)iterator.next();
        if (VerifyUtil.isEmpty((Object)pg)) {
            return planEntity;
        }
        planEntity.setAppType(pg.getPoType());
        planEntity.setMasterSiteId(pg.getProductSiteId());
        planEntity.setMasterSiteDisplay(this.constructSiteDisplayById(pg.getProductSiteId()));
        planEntity.setProtectGroupName(pg.getName());
        int planStatus = plan.getPlanStatus();
        planEntity.setPlanStatus(Integer.valueOf(planStatus));
        planEntity.setPlanProgress(Integer.valueOf(plan.getPlanProgress()));
        if (DrmEnumDefine.RecoveryPlanStatusE.READY == DrmEnumDefine.RecoveryPlanStatusE.getType((int)planStatus)) {
            planEntity.setPlanProgress(Integer.valueOf(0));
        }
        planEntity.setLastTestStatus(plan.getLastTestStatus());
        String replicaId = (String)plan.getGlobalSettings().get("REPLICA_ID");
        if (VerifyUtil.isEmpty((String)replicaId)) {
            return planEntity;
        }
        Set replicaList = pg.getReplicaList();
        Optional<ProtectGroupReplica> replicaOptional = replicaList.stream().filter(e -> replicaId.equals(e.getId())).findFirst();
        if (replicaOptional.isPresent() && (mountConfiguration = (MountConfiguration)JSONObject.toBean((String)(mountConfigs = replicaOptional.get().getProperty("mountConfigs")), MountConfiguration.class)) != null) {
            planEntity.setSharePrefix(mountConfiguration.getSharePrefix());
            planEntity.setShareType(mountConfiguration.getShareType());
        }
        return planEntity;
    }

    private List<QueryCondition> rpFilterCondition(String filterName, String filterValue) {
        ArrayList<QueryCondition> qcs = new ArrayList<QueryCondition>();
        if (VerifyUtil.isEmpty((String)filterName) || VerifyUtil.isEmpty((String)filterValue)) {
            return qcs;
        }
        if (filterName.equalsIgnoreCase("planStatus")) {
            QueryCondition qc = new QueryCondition(filterName, (Object)NumberUtil.convertToInteger((Object)filterValue));
            qcs.add(qc);
        } else {
            QueryCondition qc = new QueryCondition(filterName, (Object)filterValue);
            qcs.add(qc);
        }
        return qcs;
    }

    private String toRecoveryPlanJson(List<RecoveryPlan> recoveryPlans, Map<String, String> planIdToLogId) {
        if (VerifyUtil.isEmpty(recoveryPlans)) {
            return "[]";
        }
        JSONArray result = new JSONArray();
        for (RecoveryPlan recoveryPlan : recoveryPlans) {
            result.add((Object)this.toRecoveryPlanJson(recoveryPlan, planIdToLogId.get(recoveryPlan.getPlanId())));
        }
        return result.toString();
    }

    protected String toRecoveryPlanJson(RecoveryPlan recoveryPlan, String logId) {
        if (VerifyUtil.isEmpty((Object)recoveryPlan)) {
            return "";
        }
        JSONObject rpJsonObj = new JSONObject();
        rpJsonObj.put((Object)"uuid", (Object)recoveryPlan.getUuid());
        rpJsonObj.put((Object)"name", (Object)recoveryPlan.getName());
        rpJsonObj.put((Object)"description", (Object)recoveryPlan.getDescription());
        rpJsonObj.put((Object)"planStatus", (Object)recoveryPlan.getPlanStatus());
        rpJsonObj.put((Object)"lastExecuteType", (Object)recoveryPlan.getLastExecuteType());
        rpJsonObj.put((Object)"lastTestStatus", (Object)recoveryPlan.getLastTestStatus());
        rpJsonObj.put((Object)"planProgress", (Object)recoveryPlan.getPlanProgress());
        rpJsonObj.put((Object)"planType", (Object)recoveryPlan.getPlanType());
        rpJsonObj.put((Object)"processStatus", (Object)recoveryPlan.getProcessStatus());
        if (null == logId) {
            rpJsonObj.put((Object)"logId", (Object)"");
        } else {
            rpJsonObj.put((Object)"logId", (Object)logId);
        }
        String protectGroupsJson = this.toProtectGroupJson(new ArrayList<ProtectGroup>(recoveryPlan.getProtectGroups()));
        rpJsonObj.put((Object)"protectGroups", (Object)protectGroupsJson);
        rpJsonObj.put((Object)"isAllowExecute", (Object)this.isAllowExecuteRecoveryPlan(recoveryPlan));
        Map globalSettings = recoveryPlan.getGlobalSettings();
        Set protectGroups = recoveryPlan.getProtectGroups();
        Iterator iterator = protectGroups.iterator();
        ProtectGroup firstGroup = (ProtectGroup)iterator.next();
        int poType = firstGroup.getPoType();
        if (RecoveryPlan.MOUNT_PLAN.equals(recoveryPlan.getUse()) || REQUIRE_HANDLE_GLOBAL_SETTINGS_PO_TYPES.contains(poType)) {
            rpJsonObj.put((Object)"globalSettings", (Object)globalSettings);
        }
        if (globalSettings.containsKey("keepMac")) {
            rpJsonObj.put((Object)"keepMac", globalSettings.get("keepMac"));
        }
        rpJsonObj.put((Object)"isConfirmDelProdVm", (Object)LegoConfig.getInstance().getBoolean("is_confirm_del_prod_vm", Boolean.valueOf(true)));
        return rpJsonObj.toString();
    }

    protected String toProtectGroupJson(List<ProtectGroup> protectGrsours) {
        JSONArray result = new JSONArray();
        if (VerifyUtil.isEmpty(protectGrsours)) {
            return result.toString();
        }
        for (ProtectGroup protectGroup : protectGrsours) {
            result.add((Object)this.toProtectGroupJson(protectGroup));
        }
        return result.toString();
    }

    private String toProtectGroupJson(ProtectGroup protectGroup) {
        if (VerifyUtil.isEmpty((Object)protectGroup)) {
            return "";
        }
        JSONObject pgJsonObj = new JSONObject();
        pgJsonObj.put((Object)"uuid", (Object)protectGroup.getUuid());
        pgJsonObj.put((Object)"name", (Object)protectGroup.getName());
        pgJsonObj.put((Object)"description", (Object)protectGroup.getDescription());
        pgJsonObj.put((Object)"poType", (Object)protectGroup.getPoType());
        pgJsonObj.put((Object)"status", (Object)protectGroup.getStatus());
        pgJsonObj.put((Object)"productSiteId", (Object)protectGroup.getProductSiteId());
        pgJsonObj.put((Object)"productSiteName", (Object)this.constructSiteDisplayById(protectGroup.getProductSiteId()));
        pgJsonObj.put((Object)"poProviderSN", (Object)protectGroup.getPoProviderSN());
        pgJsonObj.put((Object)"lastExecTime", (Object)protectGroup.getLastExecTime());
        pgJsonObj.put((Object)"lastExecResult", (Object)protectGroup.getLastExecResult());
        PolicyTemplate template = protectGroup.getTemplate();
        JSONObject templateJsonObj = new JSONObject();
        templateJsonObj.put((Object)"uuid", (Object)template.getUuid());
        templateJsonObj.put((Object)"name", (Object)template.getName());
        templateJsonObj.put((Object)"description", (Object)template.getDescription());
        templateJsonObj.put((Object)"ptId", (Object)template.getPtId());
        templateJsonObj.put((Object)"type", (Object)template.getType());
        templateJsonObj.put((Object)"subType", (Object)template.getSubType());
        pgJsonObj.put((Object)"template", (Object)templateJsonObj);
        Map props = protectGroup.getProps();
        if (null != props) {
            pgJsonObj.put((Object)"props", (Object)props);
        }
        return pgJsonObj.toString();
    }

    protected int isAllowExecuteRecoveryPlan(RecoveryPlan recoveryPlan) {
        int isAllowExecute = 1;
        if (DrmEnumDefine.RecoveryPlanTypeE.LOCAL.getValue() == recoveryPlan.getPlanType()) {
            return isAllowExecute;
        }
        if (VerifyUtil.isEmpty((Collection)recoveryPlan.getProtectGroups())) {
            throw new LegoCheckedException(1073947393L);
        }
        Iterator iterator = recoveryPlan.getProtectGroups().iterator();
        if (!iterator.hasNext()) {
            throw new LegoCheckedException(2117645L);
        }
        if (this.isLocalSite(((ProtectGroup)iterator.next()).getProductSiteId())) {
            boolean isLocalRecoverySite;
            Set<String> disasterSiteIds = this.getDisasterSiteIds(recoveryPlan);
            isAllowExecute = !VerifyUtil.isEmpty(disasterSiteIds) && 1 == disasterSiteIds.size() ? (!(isLocalRecoverySite = this.isLocalSite(disasterSiteIds.iterator().next())) ? 0 : 1) : this.checkIfAllowExecute(recoveryPlan);
        } else {
            Set<String> disasterSiteIds = this.getDisasterSiteIds(recoveryPlan);
            if (!VerifyUtil.isEmpty(disasterSiteIds) && 1 != disasterSiteIds.size()) {
                isAllowExecute = this.checkIfAllowExecute(recoveryPlan);
            }
        }
        return isAllowExecute;
    }

    private int checkIfAllowExecute(RecoveryPlan recoveryPlan) {
        int isAllowExecute = 1;
        try {
            this.checkRecoveryOperationPrivilegeBySite(recoveryPlan);
        }
        catch (LegoCheckedException e) {
            if (1073948711L == e.getErrorCode() || 1073948730L == e.getErrorCode()) {
                isAllowExecute = 0;
            }
            LOGGER.error((Object)("LegoCheckedException:" + e.getErrorCode()), 90160758784001L);
        }
        return isAllowExecute;
    }

    private void checkRecoveryOperationPrivilegeBySite(RecoveryPlan rp) {
        this.checkOperationPrivilegeBySite(rp);
        String curDisasterSiteId = (String)rp.getGlobalSettings().get("DISASTER_SITE_ID");
        if (VerifyUtil.isEmpty((String)curDisasterSiteId)) {
            return;
        }
        ISiteService siteService = (ISiteService)this.getBundleService(ISiteService.class.getName(), ISiteService.class);
        Site curDisasterSite = siteService.getSiteById(curDisasterSiteId);
        if (null == curDisasterSite) {
            return;
        }
        if (DrmEnumDefine.RecoveryPlanStatusE.READY.getValue() == rp.getPlanStatus() || DrmEnumDefine.RecoveryPlanStatusE.CLEAN_COMPLETED.getValue() == rp.getPlanStatus() || DrmEnumDefine.RecoveryPlanStatusE.REPROTECT_COMPLETED.getValue() == rp.getPlanStatus()) {
            return;
        }
        if (0 != curDisasterSite.getSiteType()) {
            throw new LegoCheckedException(1073948730L);
        }
    }

    private String toJsonStrSite(Site site) {
        JSONObject object = new JSONObject();
        if (VerifyUtil.isEmpty((Object)site)) {
            return object.toString();
        }
        object.put((Object)"siteId", (Object)site.getSiteId());
        object.put((Object)"name", (Object)site.getName());
        object.put((Object)"description", (Object)site.getDescription());
        object.put((Object)"siteType", (Object)site.getSiteType());
        object.put((Object)"siteAlias", (Object)site.getSiteAlias());
        return object.toString();
    }

    private String toRecoveryProcessorDetailJsonStr(Collection<RecoveryProcessorDetail> recoverDetails) {
        JSONArray jsonArray = new JSONArray();
        if (VerifyUtil.isEmpty(recoverDetails)) {
            return jsonArray.toString();
        }
        int i = 0;
        for (RecoveryProcessorDetail rpd : recoverDetails) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"detailId", (Object)rpd.getDetailId());
            if (!VerifyUtil.isEmpty((String)rpd.getStartTime())) {
                jsonObject.put((Object)"startTime", (Object)CommUtil.formatDate((Date)new Date(NumberUtil.convertToLong((Object)rpd.getStartTime()))));
            } else {
                jsonObject.put((Object)"startTime", (Object)"--");
            }
            jsonObject.put((Object)"status", (Object)rpd.getProcessStatus());
            if (!VerifyUtil.isEmpty((String)rpd.getEndTime())) {
                jsonObject.put((Object)"endTime", (Object)CommUtil.formatDate((Date)new Date(NumberUtil.convertToLong((Object)rpd.getEndTime()))));
            } else {
                jsonObject.put((Object)"endTime", (Object)"--");
            }
            String executeTime = this.calcExecuteTime(rpd.getStartTime(), rpd.getEndTime());
            jsonObject.put((Object)"executeTime", (Object)executeTime);
            jsonObject.put((Object)"processName", (Object)rpd.getProcessName());
            jsonObject.put((Object)"processNameParams", (Object)this.stringToJSONString(rpd.getProcessNameParams()));
            jsonObject.put((Object)"processDetail", (Object)rpd.getProcessDetail());
            jsonObject.put((Object)"processDetailParams", (Object)this.stringToJSONString(rpd.getProcessDetailParams()));
            jsonObject.put((Object)"processStatus", (Object)rpd.getProcessStatus());
            jsonObject.put((Object)"logId", (Object)rpd.getLogId());
            jsonObject.put((Object)"procId", (Object)rpd.getProcId());
            jsonObject.put((Object)"procIndex", (Object)i++);
            jsonObject.put((Object)"parentDetailId", (Object)rpd.getParentDetailId());
            jsonObject.put((Object)"children", (Object)this.toRecoveryProcessorDetailJsonStr(rpd.getChildDetails()));
            jsonArray.add((Object)jsonObject);
        }
        return jsonArray.toString();
    }

    private void poToJsonStr(JSONArray jsonArray, ProtectObjectBo protectObjectBo) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"uuid", (Object)protectObjectBo.getPoId());
        jsonObject.put((Object)"moUuid", (Object)protectObjectBo.getMoUuid());
        jsonObject.put((Object)"name", (Object)protectObjectBo.getName());
        jsonObject.put((Object)"pgName", (Object)protectObjectBo.getPgName());
        jsonObject.put((Object)"poRecoveryStatus", (Object)protectObjectBo.getPoRecoveryStatus());
        jsonObject.put((Object)"poType", (Object)protectObjectBo.getPoType());
        jsonObject.put((Object)"props", (Object)protectObjectBo.getProps());
        jsonObject.put((Object)"providerSN", (Object)protectObjectBo.getProviderSN());
        jsonObject.put((Object)"providerName", (Object)protectObjectBo.getProviderName());
        jsonArray.add((Object)jsonObject);
    }

    private boolean checkPage(Page page) {
        return VerifyUtil.isEmpty((Object)page) || VerifyUtil.isEmpty((Collection)page.getResult());
    }

    @Override
    @Permission(name={"ism.drm.drp.auth.scan"}, uuid={"$1"})
    public String needSyncPtPropsToRp(String planId) {
        IRecoveryPlanBaseService rpService = this.getRecoveryPlanService();
        RecoveryPlan plan = rpService.getRecoveryPlan(planId, false, false);
        if (null == plan) {
            throw new LegoCheckedException(201L);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"demand", (Object)this.getCustomStepService().needSyncPtPropsToRp(planId));
        return jsonObject.toString();
    }

    static {
        REQUIRE_HANDLE_GLOBAL_SETTINGS_PO_TYPES.add(21);
        REQUIRE_HANDLE_GLOBAL_SETTINGS_PO_TYPES.add(20);
    }
}

