/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.util;

import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class MaskUtil {
    private static final String MASK = "*";
    private static final int PHONE_LENGTH_LIMIT = 7;
    private static final int HEAD_MASK_LIMIT = 3;
    private static final int TAIL_MASK_LIMIT = 4;

    public static String maskEmail(String email) {
        if (email == null) {
            return email;
        }
        int index = email.indexOf("@");
        if (index <= 0) {
            return MaskUtil.maskString(email.length());
        }
        int tail = Math.min(Math.max(index - 3, 3), index);
        int head = Math.min(index - tail, 3);
        return email.substring(0, head) + MaskUtil.maskString(index - head) + email.substring(index);
    }

    public static String maskPhone(String phone) {
        if (phone == null) {
            return phone;
        }
        int length = phone.length();
        if (length <= 2) {
            return MaskUtil.maskString(length);
        }
        StringBuilder builder = new StringBuilder(phone);
        if (phone.length() <= 7) {
            builder.replace(1, length - 1, MaskUtil.maskString(length - 2));
        } else {
            builder.replace(3, length - 4, MaskUtil.maskString(length - 7));
        }
        return builder.toString();
    }

    private static String maskString(int count) {
        return IntStream.range(0, count).mapToObj($ -> MASK).collect(Collectors.joining(""));
    }
}

