/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.anti.blackmail.service;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.model.AntiBlackmailPlatform;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AntiBlackmailPlatformCache {
    private static final AntiBlackmailPlatformCache INSTANCE = new AntiBlackmailPlatformCache();
    private final Map<String, AntiBlackmailPlatform> platformMap = new ConcurrentHashMap<String, AntiBlackmailPlatform>();

    public static AntiBlackmailPlatformCache getInstance() {
        return INSTANCE;
    }

    public AntiBlackmailPlatform getPlatform(String devSn) {
        return this.platformMap.get(devSn);
    }

    public Map<String, AntiBlackmailPlatform> getPlatformMap() {
        return this.platformMap;
    }

    public void addPlatform(String devSn, AntiBlackmailPlatform snapshotService) {
        this.platformMap.put(devSn, snapshotService);
    }

    public boolean removePlatform(String devSn) {
        AntiBlackmailPlatform platform = this.platformMap.remove(devSn);
        return !VerifyUtil.isEmpty((Object)platform);
    }

    public boolean isPlatformExist(String devSn) {
        return this.platformMap.containsKey(devSn);
    }
}

