/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.anti.blackmail.util;

import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.HashSet;
import java.util.Set;

public class AntiBlackmailResourceLockUtil {
    public static final String REPLICA_RESOURCE_TYPE = "AntiBlackmailSnapshotReplica";
    private static final Log LOGGER = LogFactory.getInstance(AntiBlackmailResourceLockUtil.class);
    private static final HashSet<String> RESOURCE_LOCK_SET = new HashSet();
    private static final long MAX_WAIT_TIME_ONE_HOUR = 3600000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean tryLock(String lockId) {
        if (RESOURCE_LOCK_SET.contains(lockId)) {
            LOGGER.error((Object)"Try lock for resource failed, lock key is: %s", new Object[]{lockId});
            return false;
        }
        HashSet<String> hashSet = RESOURCE_LOCK_SET;
        synchronized (hashSet) {
            if (RESOURCE_LOCK_SET.contains(lockId)) {
                LOGGER.error((Object)"Try lock for resource failed, lock key is: %s", new Object[]{lockId});
                return false;
            }
            LOGGER.debug((Object)"Locking resource succeed: %s", new Object[]{lockId});
            RESOURCE_LOCK_SET.add(lockId);
            return true;
        }
    }

    public static String lockRes(String resId, String resType) {
        String lockId = resId + resType;
        LOGGER.debug((Object)"Lock resource id: %s", new Object[]{lockId});
        AntiBlackmailResourceLockUtil.waitAndLockRes(lockId, 3600000L);
        LOGGER.debug((Object)"Lock resource completed.");
        return lockId;
    }

    public static String lockRes(String resId, String resType, long timeout) {
        String lockId = resId + resType;
        AntiBlackmailResourceLockUtil.waitAndLockRes(lockId, timeout);
        return lockId;
    }

    private static void waitAndLockRes(String lockId, long timeout) {
        long startTime = System.currentTimeMillis();
        try {
            while (!AntiBlackmailResourceLockUtil.waitAndLock(lockId, timeout)) {
                long balance = System.currentTimeMillis() - startTime;
                if (System.currentTimeMillis() - startTime <= timeout) continue;
                LOGGER.error((Object)"Locking resource time out: lockId=%s, startTime=%s, balance=%s", new Object[]{lockId, startTime, balance});
                throw new LegoCheckedException(1073947433L);
            }
        }
        catch (LegoCheckedException e) {
            throw e;
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"Locking resource interrupted out: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException("Locking resource interrupted", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Unexpected error occurred: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException("Unexpected error");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean waitAndLock(String lockId, long timeout) throws InterruptedException {
        HashSet<String> hashSet = RESOURCE_LOCK_SET;
        synchronized (hashSet) {
            if (!RESOURCE_LOCK_SET.contains(lockId)) {
                RESOURCE_LOCK_SET.add(lockId);
                LOGGER.debug((Object)"Locking resource succeed: %s", new Object[]{lockId});
                return true;
            }
            RESOURCE_LOCK_SET.wait(timeout);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unlockRes(String lockId) {
        LOGGER.debug((Object)"Unlock resource id: %s, existed: %s", new Object[]{lockId, RESOURCE_LOCK_SET.contains(lockId)});
        HashSet<String> hashSet = RESOURCE_LOCK_SET;
        synchronized (hashSet) {
            if (RESOURCE_LOCK_SET.contains(lockId)) {
                RESOURCE_LOCK_SET.remove(lockId);
                RESOURCE_LOCK_SET.notifyAll();
                LOGGER.debug((Object)"Unlocking resource succeed: %s", new Object[]{lockId});
            }
        }
        LOGGER.debug((Object)"Unlocking resource completed");
    }

    public static Set<String> lockReplicasInPg(ProtectGroup protectGroup) {
        HashSet<String> lockedReplicaIdSet = new HashSet<String>();
        protectGroup.getReplicaList().stream().filter(ProtectGroupReplica::isStorageSnapshotReplica).map(ProtectGroupReplica::getId).forEach(replicaId -> {
            boolean isLocked = AntiBlackmailResourceLockUtil.tryLock(replicaId + REPLICA_RESOURCE_TYPE);
            if (isLocked) {
                lockedReplicaIdSet.add((String)replicaId);
            }
        });
        LOGGER.debug((Object)"Locking resources(id: %s) successfully, pg name: %s", new Object[]{lockedReplicaIdSet, protectGroup.getName()});
        return lockedReplicaIdSet;
    }

    public static void unlockReplicas(Set<String> replicaIdSet) {
        if (VerifyUtil.isEmpty(replicaIdSet)) {
            return;
        }
        for (String replicaId : replicaIdSet) {
            AntiBlackmailResourceLockUtil.unlockRes(replicaId + REPLICA_RESOURCE_TYPE);
        }
    }
}

