/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.drp.service.impl;

import com.huawei.ism.drm.recovery.IShareTemplateService;
import com.huawei.ism.drm.storage.manager.proxy.StorageFileSystemManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageFileSystemManager;
import com.huawei.ism.drm.storage.sdk.constant.ShareType;
import com.huawei.ism.drm.storage.sdk.model.CIFSShare;
import com.huawei.ism.drm.storage.sdk.model.NFSShare;
import com.huawei.ism.drm.storage.sdk.model.ShareTemplateInfo;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.List;
import java.util.stream.Collectors;

@Service(name="com.huawei.ism.drm.recovery.IShareTemplateService", desc="", interfaceClass=IShareTemplateService.class)
public class ShareTemplateServiceImpl
extends BaseService
implements IShareTemplateService {
    private static final Log LOGGER = LogFactory.getInstance(ShareTemplateServiceImpl.class);

    public List<ShareTemplateInfo> queryShareTemplates(String shareType, String devSn, String vstoreId) {
        List<ShareTemplateInfo> res;
        if (VerifyUtil.isEmpty((Object)ShareType.getShareType((String)shareType)) || VerifyUtil.isEmpty((String)devSn) || VerifyUtil.isEmpty((String)vstoreId)) {
            LOGGER.error((Object)"Param is invalid, shareType=%s, devSn=%s, vstoreId=%s", new Object[]{shareType, devSn, vstoreId});
            throw new LegoCheckedException(1073947393L);
        }
        IStorageFileSystemManager mgr = StorageFileSystemManagerProxy.getInstance().getStorageFileSystemManager(devSn);
        if (ShareType.NFS.getValue().equals(shareType)) {
            List nfsShareTemplates = mgr.getNFSShareTemplates(devSn, vstoreId);
            res = this.getNFSShareTemplateInfos(nfsShareTemplates, vstoreId);
        } else {
            List cifsShareTemplates = mgr.getCIFSShareTemplates(devSn, vstoreId);
            res = this.getCIFSShareTemplateInfos(cifsShareTemplates, vstoreId);
        }
        return res;
    }

    private List<ShareTemplateInfo> getCIFSShareTemplateInfos(List<CIFSShare> cifsShareTemplates, String vstoreId) {
        List<ShareTemplateInfo> res = cifsShareTemplates.stream().map(e -> {
            ShareTemplateInfo shareTemplateInfo = new ShareTemplateInfo();
            shareTemplateInfo.setId(e.getId());
            shareTemplateInfo.setName(e.getName());
            shareTemplateInfo.setSharePath(e.getSharePath());
            shareTemplateInfo.setVstoreId(vstoreId);
            shareTemplateInfo.setShareType(ShareType.CIFS.getValue());
            return shareTemplateInfo;
        }).collect(Collectors.toList());
        return res;
    }

    private List<ShareTemplateInfo> getNFSShareTemplateInfos(List<NFSShare> nfsShareTemplates, String vstoreId) {
        List<ShareTemplateInfo> res = nfsShareTemplates.stream().map(e -> {
            ShareTemplateInfo shareTemplateInfo = new ShareTemplateInfo();
            shareTemplateInfo.setId(e.getId());
            shareTemplateInfo.setName(e.getName());
            shareTemplateInfo.setSharePath(e.getSharePath());
            shareTemplateInfo.setVstoreId(vstoreId);
            shareTemplateInfo.setShareType(ShareType.NFS.getValue());
            return shareTemplateInfo;
        }).collect(Collectors.toList());
        return res;
    }

    public String queryAuthClientCountByShareTemplate(String shareType, String templateId, String devSn, String vstoreId) {
        if (VerifyUtil.isEmpty((Object)ShareType.getShareType((String)shareType)) || VerifyUtil.isEmpty((String)templateId) || VerifyUtil.isEmpty((String)devSn) || VerifyUtil.isEmpty((String)vstoreId)) {
            LOGGER.error((Object)"Param is invalid, shareType=%s, templateId=%s, devSn=%s, vstoreId=%s", new Object[]{templateId, shareType, devSn, vstoreId});
            throw new LegoCheckedException(1073947393L);
        }
        IStorageFileSystemManager mgr = StorageFileSystemManagerProxy.getInstance().getStorageFileSystemManager(devSn);
        return String.valueOf(mgr.getShareAuthClientCount(shareType, devSn, templateId, vstoreId));
    }
}

