/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.engine.action;

import com.huawei.ism.drm.anti.blackmail.manager.sdk.model.AntiBlackmailPlatform;
import com.huawei.ism.drm.anti.blackmail.util.AntiBlackmailUtil;
import com.huawei.ism.drm.protection.action.model.ActionContext;
import com.huawei.ism.drm.protection.framework.engine.action.CreateNasSnapshotAction;
import com.huawei.ism.drm.protection.framework.service.replica.realtime.service.ExecuteReplicaManager;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.schedule.sdk.model.ScheduleProtectedType;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.NumberUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collections;
import java.util.Optional;

public class CreateAntiBlackmailSnapshotAction
extends CreateNasSnapshotAction {
    private static final Log LOGGER = LogFactory.getInstance(CreateAntiBlackmailSnapshotAction.class);

    @Override
    public boolean doExecute(ActionContext context) {
        ProtectGroup protectGroup = (ProtectGroup)context.getObject("PG_ENTITY", ProtectGroup.class);
        ProtectGroupReplica pgReplica = ExecuteReplicaManager.getInstance().getExecuteReplica(protectGroup, NumberUtil.convertToInteger((Object)context.getObject("PG_EXECUTE_LOCATION")).intValue());
        if (VerifyUtil.isEmpty((Object)pgReplica)) {
            LOGGER.error((Object)"Create protect group replica error, pgId: %s, pgName: %s.", new Object[]{protectGroup.getUuid(), protectGroup.getName()});
            this.setDetail("lego.err.2117645");
            return false;
        }
        context.addObject("PG_REPLICA_ENTITY", (Object)pgReplica);
        context.addObject("PO_REPLICA_ENTITY", (Object)pgReplica.getReplicas());
        try {
            AntiBlackmailPlatform platform = AntiBlackmailUtil.addAntiBlackMailPlatform(protectGroup.getPoProviderSN());
            AntiBlackmailUtil.createAntiBlackMailSnapshot(platform, pgReplica, context);
        }
        catch (LegoCheckedException e) {
            this.setDetail("lego.err." + e.getErrorCode());
            return false;
        }
        if (this.isUsingSecureReplicaStrategy(protectGroup)) {
            context.addObject("isSecureReplicaStrategy", (Object)true);
            this.setTimeStamp(context);
        }
        return true;
    }

    private boolean isUsingSecureReplicaStrategy(ProtectGroup protectGroup) {
        return Optional.ofNullable(protectGroup).map(ProtectGroup::getTemplate).map(PolicyTemplate::getSchedules).orElse(Collections.emptySet()).stream().findFirst().map(schedule -> schedule.getProtectedType() == ScheduleProtectedType.NAS_AIRGAP_ANTI_BLACKMAIL_SECURE_SNAPSHOT.getValue()).orElse(false);
    }
}

