/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.group;

import com.huawei.ism.array.sdk.model.Controller;
import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.array.sdk.model.XveLun;
import com.huawei.ism.base.sdk.model.StoragePool;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskService;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.cbb.proxy.xve.XveUUID;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupBaseServiceImpl;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupQueryServiceImpl;
import com.huawei.ism.drm.protection.framework.service.group.ProtectionTaskExecutor;
import com.huawei.ism.drm.protection.group.sdk.model.DiskInfo;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectProvider;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectProviderDelegate;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.schedule.sdk.model.ScheduleProtectedType;
import com.huawei.ism.drm.protection.task.sdk.model.ProtectionTask;
import com.huawei.ism.drm.storage.sdk.service.IStorageResourceService;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import org.springframework.dao.DataAccessException;

public abstract class ProtectGroupQueryExtendServiceImpl
extends ProtectGroupBaseServiceImpl
implements IProtectGroupService {
    private static final Log LOG = LogFactory.getInstance(ProtectGroupQueryServiceImpl.class);

    public static void logDiskInfo(String pgName, List<DiskInfo> diskInfos) {
        if (null == diskInfos) {
            return;
        }
        JSONArray diskJSONArray = new JSONArray();
        diskInfos.stream().map(diskInfo -> {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"devSn", (Object)diskInfo.getDevSn());
            jsonObject.put((Object)"resourceId", (Object)diskInfo.getResourceId());
            jsonObject.put((Object)"deviceName", (Object)diskInfo.getDeviceName());
            jsonObject.put((Object)"poolId", (Object)diskInfo.getPoolId());
            jsonObject.put((Object)"poolName", (Object)diskInfo.getPoolName());
            jsonObject.put((Object)"status", (Object)diskInfo.getStatus());
            JSONArray poArray = new JSONArray();
            diskInfo.getProtectObjects().stream().map(po -> {
                JSONObject poJsonObj = new JSONObject();
                poJsonObj.put((Object)"moUuid", (Object)po.getMoUuid());
                poJsonObj.put((Object)"name", (Object)po.getName());
                return poJsonObj;
            }).forEach(o -> poArray.add(o));
            jsonObject.put((Object)"protectObjects", (Object)poArray);
            jsonObject.put((Object)"recoveryPools", (Object)JSONArray.fromObject((Object)diskInfo.getRecoveryPools()));
            return jsonObject;
        }).forEach(o -> diskJSONArray.add(o));
        String str = diskJSONArray.toString();
        LOG.info((Object)("protectGroup:" + pgName + " diskInfos:" + str));
    }

    public boolean isHostGroupUsedByProtectGroup(String hostGroupId) {
        String hql = "from ProtectGroup as pg where pg.poProviderSN = ? order by pg.pgId";
        List result = null;
        try {
            result = this.getBaseDao().getHibernateTemplate().find(hql, new Object[]{hostGroupId});
        }
        catch (DataAccessException e) {
            LOG.error((Object)"failed to query potectgroup.", (Throwable)e, 90160758786894L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        return !VerifyUtil.isEmpty((Collection)result);
    }

    public boolean stopProtectGroup(String protectgroupId, boolean isStopAirGap) {
        ProtectGroup protectGroup = this.getProtectGroupByID(protectgroupId, false);
        if (protectGroup.getStatus() != DrmEnumDefine.ProtectGroupStatus.RUNNING.getStatus()) {
            String pgName = protectGroup.getName();
            LOG.error((Object)"The protect group(name:%s) is not running.", new Object[]{pgName});
            throw new LegoCheckedException(1073948486L, new String[]{pgName});
        }
        boolean stopResult = false;
        Future<?> futureTask = this.findProtectBackTaskByPgId(protectgroupId, isStopAirGap);
        if (!VerifyUtil.isEmpty(futureTask)) {
            stopResult = futureTask.cancel(true);
        }
        LOG.info((Object)"StopProtectGroup id:%s, stopResult:%s", new Object[]{protectgroupId, stopResult});
        return stopResult;
    }

    private Future<?> findProtectBackTaskByPgId(String pgId, boolean isStopAirGap) {
        BackTaskService backTaskService = BackTaskService.getBackTaskService((String)"Protection_Task");
        ConcurrentLinkedQueue taskUnitQueue = backTaskService.getTaskUnitQueue();
        for (BackTaskService.TaskUnit taskUnit : taskUnitQueue) {
            ProtectGroup runningPg;
            ProtectionTaskExecutor protectionTaskExecutor;
            ProtectionTask protectionTask;
            AbstractBackTask task = taskUnit.getTask();
            if (!(task instanceof ProtectionTaskExecutor) || VerifyUtil.isEmpty((Object)(protectionTask = (protectionTaskExecutor = (ProtectionTaskExecutor)task).getTask())) || VerifyUtil.isEmpty((Object)protectionTask.getProtectGroup()) || !(runningPg = protectionTask.getProtectGroup()).getUuid().equals(pgId)) continue;
            if (isStopAirGap) {
                LOG.info((Object)"Set the thread communication variable to stop the air gap protection group{%s}", new Object[]{runningPg.getName()});
                protectionTaskExecutor.getActionContext().setShouldTerminate(true);
            }
            LOG.info((Object)"Success find ProtectBack Task for PgId:%s", new Object[]{pgId});
            return taskUnit.getTaskFuture();
        }
        LOG.info((Object)"Not find ProtectBack Task for PgId:%s", new Object[]{pgId});
        return null;
    }

    public List<Lun> getUsedStorageLunsByProtectObject(List<ProtectObject> protectObjects, int poType, int templateType) {
        IProtectObjectProviderDelegate poProvider = (IProtectObjectProviderDelegate)ServiceLocator.getInstance().getService(IProtectObjectProviderDelegate.class);
        IProtectObjectProvider provider = (IProtectObjectProvider)poProvider.getProviderByAppType(poType);
        provider.loadProtectObjectStorageInfo(protectObjects);
        String deviceSn = null;
        ArrayList<String> resourceIds = new ArrayList<String>();
        for (ProtectObject protectObject : protectObjects) {
            Set storageInfos = protectObject.getUsedStorageResourceSet();
            for (ProtectObjectStorageInfo storageInfo : storageInfos) {
                deviceSn = storageInfo.getResourceProviderSN();
                resourceIds.add(storageInfo.getResourceId());
            }
        }
        IStorageResourceService storageResourceService = (IStorageResourceService)ServiceLocator.getInstance().getService(IStorageResourceService.class);
        List storageResources = storageResourceService.getStorageResources(deviceSn, resourceIds, Lun.class);
        Map<String, String> poolIdAndNameMap = this.getPoolIdAndNameMap();
        Map<String, String> controllerLocations = this.getControllerLocations();
        for (Lun lun : storageResources) {
            this.fillControllerNameOfLun((StorageResource)lun, controllerLocations);
            if (!(lun instanceof XveLun)) continue;
            XveLun xveLun = (XveLun)lun;
            xveLun.setStoragePoolName(poolIdAndNameMap.get(CommUtil.combineString((String[])new String[]{xveLun.getDevSn(), xveLun.getStoragePoolId()})));
        }
        return storageResources;
    }

    private void fillControllerNameOfLun(StorageResource storageResource, Map<String, String> controllerLocations) {
        if (!(storageResource instanceof Lun) || VerifyUtil.isEmpty(controllerLocations)) {
            return;
        }
        Lun lun = (Lun)storageResource;
        String controllerUUID = lun.getDevSn() + "14:0:" + lun.getControllerId();
        if (lun instanceof XveLun) {
            controllerUUID = new XveUUID(lun.getDevSn(), XveMOType.CONTROLLER, lun.getControllerId()).toString();
        }
        if (VerifyUtil.isEmpty((String)controllerLocations.get(controllerUUID))) {
            LOG.error((Object)("controller name is empty! lun id:" + lun.getLunId() + "lun name:" + lun.getName() + ",devSn:" + lun.getDevSn() + "controllerId:" + lun.getControllerId() + "controllerUUID:" + controllerUUID + ",Lun is XveLun?" + (lun instanceof XveLun)));
        }
        lun.setControllerName(controllerLocations.get(controllerUUID));
    }

    private Map<String, String> getPoolIdAndNameMap() {
        HashMap<String, String> poolIdAndNameMap = new HashMap<String, String>();
        List storagePools = this.getMoDao().find("from StoragePool", new Object[0]);
        if (!VerifyUtil.isEmpty((Collection)storagePools)) {
            for (Object object : storagePools) {
                StoragePool pool = (StoragePool)object;
                poolIdAndNameMap.put(pool.getPoolId(), pool.getName());
                poolIdAndNameMap.put(CommUtil.combineString((String[])new String[]{pool.getNeSN(), pool.getPoolId()}), pool.getName());
            }
        }
        return poolIdAndNameMap;
    }

    private Map<String, String> getControllerLocations() {
        HashMap<String, String> controllerLocations = new HashMap<String, String>();
        List controllers = this.getMoDao().find("from Controller", new Object[0]);
        if (!VerifyUtil.isEmpty((Collection)controllers)) {
            for (Object object : controllers) {
                Controller controller = (Controller)object;
                String location = controller.getLocation();
                if (VerifyUtil.isEmpty((String)location) && !VerifyUtil.isEmpty((String)controller.getControllerType())) {
                    location = controller.getControllerType();
                }
                controllerLocations.put(controller.getUuid(), location);
                LOG.info((Object)("controller uuid:" + controller.getUuid() + ", location:" + location));
            }
        }
        return controllerLocations;
    }

    public void offlineTransfer(String protectGroupId, String scheduleId, int status) {
        Schedule scheduleInDb = this.getSchedule(protectGroupId, scheduleId);
        if (ScheduleProtectedType.CLOUD_BACKUP.getValue() != scheduleInDb.getProtectedType()) {
            String errorMsg = String.format("The protection type[%s] is not cloud backup and is not allowed.", scheduleInDb.getProtectedType());
            LOG.error((Object)errorMsg);
            throw new LegoCheckedException(1073947393L, errorMsg);
        }
    }

    private Schedule getSchedule(String protectGroupId, String scheduleId) {
        List scheduleList = this.getAllSchedule(protectGroupId);
        Schedule schedule = scheduleList.stream().filter(schedule1 -> schedule1.getScheduleId().equals(scheduleId)).findFirst().orElse(null);
        if (null == schedule) {
            String errorMsg = String.format(Locale.ROOT, "Schedule[%s] does not exists", scheduleId);
            LOG.error((Object)errorMsg);
            throw new LegoCheckedException(1073947393L, errorMsg);
        }
        return schedule;
    }
}

