/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.group;

import com.huawei.ism.cbb.proxy.xve.XveEuumDefineParent;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.protection.action.model.ActionContext;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectionJobExtendUtil;
import com.huawei.ism.drm.protection.framework.service.group.IProtectionRemoteService;
import com.huawei.ism.drm.protection.framework.template.util.ProtectionRelationJsonConverter;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.protection.template.sdk.model.ProtectionRelation;
import com.huawei.ism.drm.storage.sdk.service.IStorageResourceService;
import com.huawei.ism.unistor.sdk.model.VstoreHyperMetroPair;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.NumberUtil;
import java.util.List;
import java.util.Map;

@Service(name="IProtectionRemoteService", desc="", interfaceClass=IProtectionRemoteService.class)
public class ProtectionRemoteServiceImpl
implements IProtectionRemoteService {
    private static final Log logger = LogFactory.getInstance(ProtectionRemoteServiceImpl.class);

    public void syncProtectGroup(ProtectGroup protectGroup) {
        logger.info((Object)"No need do this operation.");
    }

    public void checkHyperMetro(ProtectGroup protectGroup, ActionContext actionContext, ProtectGroupReplica protectGroupReplica) {
        ProtectionJobExtendUtil.getInstance().checkHyperMetro(protectGroup, actionContext, protectGroupReplica);
    }

    public boolean checkHyperVault(ProtectGroup protectGroup, ActionContext context) {
        PolicyTemplate template = protectGroup.getTemplate();
        if (VerifyUtil.isEmpty((Object)template)) {
            logger.info((Object)("checkHyperVault empty:" + protectGroup.getUuid()));
            return true;
        }
        if (template.getType() == 28) {
            Integer activeOrPassive;
            String prStr = (String)template.getProps().get("protectionRelation");
            if (VerifyUtil.isEmpty((String)prStr)) {
                logger.error((Object)("checkHyperVault protectionRelation is null:" + protectGroup.getUuid()));
                return false;
            }
            List<ProtectionRelation> protectionRelations = ProtectionRelationJsonConverter.toProtectionRelationList(prStr);
            if (VerifyUtil.isEmpty(protectionRelations)) {
                logger.error((Object)("checkHyperVault protectionRelations is empty:" + prStr));
                return false;
            }
            context.addObject("VAULT_PATH", protectionRelations);
            ProtectionRelation protectionRelation = (ProtectionRelation)CommonUtil.getFirstElement(protectionRelations);
            String devSn = protectionRelation.getSrcResourceProviderSn();
            String vStorePairId = (String)protectGroup.getProps().get("PROP_KEY_VSTORE_PAIR_ID");
            if (VerifyUtil.isEmpty((String)vStorePairId) || VerifyUtil.isEmpty((String)devSn)) {
                logger.error((Object)("checkHyperVault vStorePairId or devSn is null:" + protectGroup.getUuid()));
                return false;
            }
            IStorageResourceService srSvc = (IStorageResourceService)ServiceLocator.getInstance().getService(IStorageResourceService.class);
            VstoreHyperMetroPair vstoreHyperMetroPair = srSvc.getVstoreHyperMetroPairById(devSn, vStorePairId, Boolean.valueOf(false));
            if (!VerifyUtil.isEmpty((Object)vstoreHyperMetroPair) && String.valueOf(XveEuumDefineParent.HEALTH_STATUS_E.NORMAL.getValue()).equals(vstoreHyperMetroPair.getHealthStatus())) {
                return true;
            }
            String active = vstoreHyperMetroPair.getActiveOrPassive();
            if (VerifyUtil.isEmpty((String)active)) {
                active = srSvc.getHyperMetroDomainById(vstoreHyperMetroPair.getDomainId(), false).getServiceStatus();
            }
            if ((activeOrPassive = NumberUtil.convertToInteger((Object)active)).equals(XveEuumDefineParent.VSTOREPAIR_ACTIVATION_STATUS_E.PASSIVE.getValue())) {
                logger.info((Object)("This devSn VstorePair is not activeOrPassive:" + devSn + " ,pairId:" + vStorePairId));
                return false;
            }
        }
        return true;
    }

    public void updateProtectGroupProps(ProtectGroup protectGroup, Map<String, String> map) {
        logger.info((Object)"No need do this operation.");
    }

    public void checkSiteExist(ProtectGroup protectGroup) {
        logger.info((Object)"No need do this operation.");
    }

    public void syncProtectGroupToRemoteSite(ProtectGroup protectGroup, String s) {
        logger.info((Object)"No need do this operation.");
    }

    public void synDeletePgToRemote(ProtectGroup protectGroup) {
        logger.info((Object)"No need do this operation.");
    }

    public void checkRemoteGroupStatus(ProtectGroup protectGroup) {
        logger.info((Object)"No need do this operation.");
    }

    public void syncInfoPgToRemote(ProtectGroup protectGroup) {
        logger.info((Object)"No need do this operation.");
    }
}

