/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.replica.retention.impl;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.constant.RecoveryPlanUse;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.protection.framework.engine.executor.FixedProtectionThreadPool;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupHelper;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.framework.service.replica.retention.bean.ReplicaRetentionStrategy;
import com.huawei.ism.drm.protection.framework.service.replica.retention.service.IReplicaRetentionStrategyHandler;
import com.huawei.ism.drm.protection.framework.service.replica.retention.util.CheckReplicaExtendTools;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupTempReplica;
import com.huawei.ism.drm.protection.schedule.sdk.model.RetentionPolicy;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.schedule.sdk.model.ScheduleProtectedType;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.NumberUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.query.Query;

public abstract class AbstractReplicaRetentionHandler
implements IReplicaRetentionStrategyHandler {
    private static final Log LOGGER = LogFactory.getInstance(AbstractReplicaRetentionHandler.class);
    private static final Set<Integer> SAN_SNAPSHOT_TEMPLATE_TYPE_SET = Collections.unmodifiableSet(new HashSet<Integer>(){
        {
            this.add(PolicyTemplateType.PolicyTemplateE.ARRAY_SNAPSHOT.getValue());
            this.add(PolicyTemplateType.PolicyTemplateE.ARRAY_HYPER_METRO_SNAPSHOT.getValue());
            this.addAll(PolicyTemplateType.SAN_HYPER_VAULT_POLICYTEMPLATE);
        }
    });

    private static Date getMonthBefore(int day) {
        Calendar now = AbstractReplicaRetentionHandler.getNowCalendar();
        now.set(5, 1);
        now.setTime(now.getTime());
        now.add(2, -day);
        return now.getTime();
    }

    private static Date getWeekBefore(int day) {
        Calendar now = AbstractReplicaRetentionHandler.getNowCalendar();
        if (now.get(7) == 1) {
            now.add(3, -1 - day);
        } else {
            now.add(3, -day);
        }
        now.set(7, 2);
        return now.getTime();
    }

    private static Date getDateBefore(int day) {
        Calendar now = AbstractReplicaRetentionHandler.getNowCalendar();
        now.setTime(now.getTime());
        now.add(5, -day);
        return now.getTime();
    }

    private static Calendar getNowCalendar() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }

    public boolean executeStrategy(ProtectGroup pg) {
        ArrayList<ProtectGroupReplica> toDelete = new ArrayList<ProtectGroupReplica>();
        Set<String> usedReplicaIds = this.getUsedReplicaIds(pg);
        for (Schedule schedule : pg.getTemplate().getSchedules()) {
            schedule.setPolicyTemplate(pg.getTemplate());
            RetentionPolicy strategy = schedule.getRetentionPolicy();
            if (VerifyUtil.isEmpty((Object)strategy)) continue;
            List<ProtectGroupReplica> tmpDelete = this.getToDeleteReplicas(strategy, schedule, pg.getReplicaList(), usedReplicaIds, null);
            if (this.isSanSnapshotPg(pg)) {
                this.handleSanSnapshotReplicas(tmpDelete, pg, schedule);
            }
            if (CollectionUtils.isEmpty(tmpDelete)) continue;
            toDelete.addAll(tmpDelete);
        }
        if (!this.isSanSnapshotPg(pg)) {
            this.deleteReplicas(toDelete, pg);
        }
        return true;
    }

    public Set<ReplicaRetentionStrategy> convertReplicaStrategy(ProtectGroup pg) {
        HashSet<ReplicaRetentionStrategy> result = new HashSet<ReplicaRetentionStrategy>();
        String strategyValue = (String)pg.getTemplate().getProps().get("ReplicaRetentionPolicy");
        JSONObject replicaRetentionPolicyJsonValue = JSONObject.fromObject((Object)strategyValue);
        Set jsonEntry = replicaRetentionPolicyJsonValue.keySet();
        if (VerifyUtil.isEmpty((Collection)jsonEntry)) {
            LOGGER.info((Object)"JsonEntry is empty!");
            this.dealUpgrade(pg, result);
            return result;
        }
        for (String key : jsonEntry) {
            ReplicaRetentionStrategy tmp = new ReplicaRetentionStrategy();
            tmp.setPgId(pg.getUuid());
            tmp.setType(this.getType());
            int protectLocation = NumberUtil.convertToInteger((Object)key.substring(key.length() - 1));
            tmp.setProtectLocation(protectLocation);
            String protectLocationJsonString = replicaRetentionPolicyJsonValue.getString(key);
            JSONObject protectLocationJsonValue = JSONObject.fromObject((Object)protectLocationJsonString).getJSONObject("props");
            Map<String, String> props = tmp.getProps();
            props.put("dailyRetention", this.getRetentionCount(protectLocationJsonValue, "dailyRetention"));
            props.put("weeklyRetention", this.getRetentionCount(protectLocationJsonValue, "weeklyRetention"));
            props.put("monthlyRetention", this.getRetentionCount(protectLocationJsonValue, "monthlyRetention"));
            props.put("retentionNumber", this.getRetentionNumber(pg.getTemplate().getProps(), protectLocation));
            tmp.setProps(props);
            result.add(tmp);
        }
        return result;
    }

    public String getType() {
        return "0";
    }

    public List<ProtectGroupReplica> getToReactivateReplicas(ProtectGroup pg, int protectLocation, Integer differ, Integer type, Set<ProtectGroupReplica> mappedReplicas) {
        Set<String> usedReplicaIds;
        Schedule schedule = pg.getTemplate().getSchedules().stream().filter(sc -> protectLocation == sc.getProtectLocation() && sc.getProtectedType() == type.intValue()).findAny().orElse(null);
        if (VerifyUtil.isEmpty((Object)schedule)) {
            return new ArrayList<ProtectGroupReplica>();
        }
        RetentionPolicy currentStrategy = schedule.getRetentionPolicy();
        if (VerifyUtil.isEmpty((Object)currentStrategy)) {
            return new ArrayList<ProtectGroupReplica>();
        }
        List<ProtectGroupReplica> replicaList = this.filterReplicasByLocation(pg.getReplicaList(), schedule);
        HashSet<ProtectGroupReplica> replicaSet = new HashSet<ProtectGroupReplica>(replicaList);
        List<ProtectGroupReplica> tmpDelete = this.getToDeleteReplicas(currentStrategy, schedule, replicaSet, usedReplicaIds = this.getUsedReplicaIds(pg), differ);
        if (VerifyUtil.isEmpty(tmpDelete)) {
            tmpDelete = new ArrayList<ProtectGroupReplica>();
        }
        ProtectGroupHelper.getInstance().orderReplicaList(tmpDelete);
        tmpDelete.removeIf(protectGroupReplica -> protectGroupReplica.getStatus() == 3);
        if (!PolicyTemplateType.AIR_GAP_NETWORKING.contains(pg.getTemplate().getType())) {
            tmpDelete = this.checkMappedReplica(tmpDelete, replicaSet, usedReplicaIds, mappedReplicas);
        }
        return tmpDelete;
    }

    private List<ProtectGroupReplica> checkMappedReplica(List<ProtectGroupReplica> tmpToBeReactive, Set<ProtectGroupReplica> replicaSet, Set<String> usedReplicaIds, Set<ProtectGroupReplica> mappedReplicas) {
        if (VerifyUtil.isEmpty(tmpToBeReactive)) {
            return tmpToBeReactive;
        }
        for (ProtectGroupReplica pgReplica : tmpToBeReactive) {
            if (CheckReplicaExtendTools.checkSnapshotMapped(pgReplica)) {
                mappedReplicas.add(pgReplica);
                continue;
            }
            return Collections.singletonList(pgReplica);
        }
        Set mappedReplicaIds = mappedReplicas.stream().map(ProtectGroupReplica::getId).collect(Collectors.toSet());
        LOGGER.info((Object)"Mapped replicas: %s.", new Object[]{mappedReplicaIds});
        usedReplicaIds.addAll(mappedReplicaIds);
        List sortedReplicas = replicaSet.stream().filter(replica -> replica.getStatus() != 3).collect(Collectors.toList());
        ProtectGroupHelper.getInstance().orderReplicaList(sortedReplicas);
        ProtectGroupHelper.getInstance().orderReplicaList(sortedReplicas);
        for (ProtectGroupReplica sortedReplica : sortedReplicas) {
            if (usedReplicaIds.contains(sortedReplica.getId())) continue;
            if (CheckReplicaExtendTools.checkSnapshotMapped(sortedReplica)) {
                LOGGER.debug((Object)"Snapshot in replica is mapped: %s.", new Object[]{sortedReplica.getId()});
                mappedReplicas.add(sortedReplica);
                continue;
            }
            return Collections.singletonList(sortedReplica);
        }
        return Collections.emptyList();
    }

    public void deleteReplicas(List<ProtectGroupReplica> toDelete, ProtectGroup pg) {
        if (VerifyUtil.isEmpty(toDelete)) {
            return;
        }
        List<String> failedIds = this.deletePgReplicaFromDB(toDelete);
        if (!VerifyUtil.isEmpty(failedIds)) {
            LOGGER.error((Object)"Delete replicas failed, cause by visit db exception, replicaIds is %s", new Object[]{failedIds});
            return;
        }
        FixedProtectionThreadPool.submit((FixedProtectionThreadPool.FixedProtectionThreadPoolEnum)FixedProtectionThreadPool.FixedProtectionThreadPoolEnum.PROTECT_DELETE_REPLICA_EXECUTOR, (Callable)new DeleteReplicaTask(pg, toDelete));
    }

    public Set<String> getUsedReplicaIds(ProtectGroup pg) {
        HashSet<String> usedReplicaIds = new HashSet<String>();
        IRecoveryPlanService rpService = (IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class);
        List planIdList = rpService.getAssociatedRecoveryPlanListWithProtectGroup(pg.getUuid(), null);
        if (VerifyUtil.isEmpty((Collection)planIdList)) {
            return usedReplicaIds;
        }
        for (String planId : planIdList) {
            RecoveryPlan plan = rpService.getRecoveryPlan(planId, false, false);
            if (VerifyUtil.isEmpty((Object)plan)) continue;
            HashSet<Integer> availablePlanStatus = new HashSet<Integer>();
            availablePlanStatus.add(DrmEnumDefine.RecoveryPlanStatusE.TEST_RUNNING.getValue());
            availablePlanStatus.add(DrmEnumDefine.RecoveryPlanStatusE.TEST_FAILED.getValue());
            availablePlanStatus.add(DrmEnumDefine.RecoveryPlanStatusE.TEST_COMPLETED.getValue());
            availablePlanStatus.add(DrmEnumDefine.RecoveryPlanStatusE.CLEAN_RUNNING.getValue());
            availablePlanStatus.add(DrmEnumDefine.RecoveryPlanStatusE.CLEAN_FAILED.getValue());
            if (!availablePlanStatus.contains(plan.getPlanStatus()) && RecoveryPlanUse.INTERNAL_USE.getValue() != plan.getUse().intValue() || VerifyUtil.isEmpty((Map)plan.getGlobalSettings()) || !plan.getGlobalSettings().containsKey("REPLICA_ID") || VerifyUtil.isEmpty((String)((String)plan.getGlobalSettings().get("REPLICA_ID")))) continue;
            usedReplicaIds.add((String)plan.getGlobalSettings().get("REPLICA_ID"));
        }
        return usedReplicaIds;
    }

    public boolean checkProtectLocationValue(ProtectGroup protectGroup, String value, int location) {
        Schedule schedule2;
        JSONObject protectLocationJsonValue = JSONObject.fromObject((Object)value);
        if (!protectLocationJsonValue.containsKey((Object)"type") || !protectLocationJsonValue.getString("type").equals(this.getType())) {
            return false;
        }
        if (!protectLocationJsonValue.containsKey((Object)"props")) {
            return false;
        }
        String propsJsonString = protectLocationJsonValue.getString("props");
        JSONObject propsJson = JSONObject.fromObject((Object)propsJsonString);
        String daily = "dailyRetention";
        String weekly = "weeklyRetention";
        String monthly = "monthlyRetention";
        List schedules = protectGroup.getTemplate().getSchedules().stream().filter(schedule -> schedule.getProtectLocation() == location && schedule.getScheduleMode() == 0).collect(Collectors.toList());
        long retentionNumber = 0L;
        String retentionNumberStr = this.getRetentionNumber(protectGroup.getTemplate().getProps(), location);
        if (!VerifyUtil.isEmpty((String)retentionNumberStr)) {
            retentionNumber = NumberUtil.convertToLong((Object)retentionNumberStr);
        }
        if (!VerifyUtil.isEmpty(schedules) && (schedule2 = (Schedule)schedules.get(0)).getProtectedType() == ScheduleProtectedType.HYPERCDP.getValue() && schedule2.getPeriodType() == 5) {
            if (retentionNumber > 60000L) {
                return false;
            }
            return this.compareTheJsonValue(propsJson, daily, 256) && this.compareTheJsonValue(propsJson, weekly, 256) && this.compareTheJsonValue(propsJson, monthly, 256);
        }
        if (retentionNumber > 2048L) {
            return false;
        }
        return this.compareTheJsonValue(propsJson, daily, 365) && this.compareTheJsonValue(propsJson, weekly, 52) && this.compareTheJsonValue(propsJson, monthly, 60);
    }

    protected abstract List<ProtectGroupReplica> getToDeleteReplicas(RetentionPolicy var1, Schedule var2, Set<ProtectGroupReplica> var3, Set<String> var4, Integer var5);

    protected List<ProtectGroupReplica> getToDeleteNormalReplicas(RetentionPolicy strategy, Schedule schedule, Set<ProtectGroupReplica> replicas, Set<String> usedReplicaIds, Integer differ) {
        int retentionNumber = strategy.getLatestCopies();
        if (!VerifyUtil.isEmpty((Object)differ)) {
            retentionNumber = Math.max(retentionNumber + differ, 0);
        }
        ArrayList<ProtectGroupReplica> toDelete = new ArrayList<ProtectGroupReplica>();
        List<ProtectGroupReplica> replicaList = this.filterReplicasByLocation(replicas, schedule);
        if (replicaList.size() <= retentionNumber) {
            LOGGER.info((Object)"No replicas need to delete, number of existing replicas: %s, retentionNumber: %s", new Object[]{replicaList.size(), retentionNumber});
            return toDelete;
        }
        for (ProtectGroupReplica replica : replicaList) {
            if (replica.getStatus() == 1) continue;
            toDelete.add(replica);
        }
        replicaList.removeAll(toDelete);
        if (replicaList.size() <= retentionNumber) {
            return toDelete;
        }
        ProtectGroupHelper.getInstance().orderReplicaList(replicaList);
        List<ProtectGroupReplica> exceedLimitReplicas = replicaList.subList(0, replicaList.size() - retentionNumber);
        toDelete.addAll(this.handleExceedLimitReplicas(strategy, exceedLimitReplicas, replicaList));
        this.handleUsedReplicas(usedReplicaIds, toDelete);
        return toDelete;
    }

    protected abstract List<ProtectGroupReplica> getToDeleteSecureReplicas(Set<ProtectGroupReplica> var1, Set<String> var2, Schedule var3);

    protected void handleUsedReplicas(Set<String> usedReplicaIds, List<ProtectGroupReplica> toDelete) {
        if (VerifyUtil.isEmpty(toDelete) || VerifyUtil.isEmpty(usedReplicaIds)) {
            return;
        }
        LOGGER.info((Object)"There are some Replica used by recoveryPlan: %s", new Object[]{usedReplicaIds});
        toDelete.removeIf(replica -> usedReplicaIds.contains(replica.getId()));
    }

    protected List<ProtectGroupReplica> handleExceedLimitReplicas(RetentionPolicy strategy, List<ProtectGroupReplica> exceedLimitReplicas, List<ProtectGroupReplica> allReplicas) {
        ArrayList<ProtectGroupReplica> retentionReplicas = new ArrayList<ProtectGroupReplica>();
        if (exceedLimitReplicas.isEmpty()) {
            return retentionReplicas;
        }
        retentionReplicas.addAll(this.getRetentionReplicas(strategy, allReplicas, "dailyRetention"));
        retentionReplicas.addAll(this.getRetentionReplicas(strategy, allReplicas, "weeklyRetention"));
        retentionReplicas.addAll(this.getRetentionReplicas(strategy, allReplicas, "monthlyRetention"));
        ArrayList<ProtectGroupReplica> toDelete = new ArrayList<ProtectGroupReplica>();
        for (ProtectGroupReplica replica : exceedLimitReplicas) {
            if (retentionReplicas.contains(replica)) continue;
            toDelete.add(replica);
        }
        return toDelete;
    }

    private List<String> deletePgReplicaFromDB(List<ProtectGroupReplica> toDelete) {
        List<String> allReplicaIds = ((List)Optional.ofNullable(toDelete).orElse(new ArrayList())).stream().map(ProtectGroupReplica::getId).collect(Collectors.toList());
        return this.deleteProtectGroupReplicaFromDBById(allReplicaIds);
    }

    private void dealUpgrade(ProtectGroup pg, Set<ReplicaRetentionStrategy> result) {
        Set schedules = pg.getTemplate().getSchedules();
        HashSet<Integer> protectLocationSet = new HashSet<Integer>();
        for (Schedule schedule : schedules) {
            protectLocationSet.add(schedule.getProtectLocation());
        }
        for (Integer protectLocation : protectLocationSet) {
            ReplicaRetentionStrategy tmp = new ReplicaRetentionStrategy();
            tmp.setPgId(pg.getUuid());
            tmp.setType(this.getType());
            tmp.setProtectLocation(protectLocation);
            HashMap<String, String> props = new HashMap<String, String>();
            String notSetValue = "-1";
            props.put("dailyRetention", notSetValue);
            props.put("weeklyRetention", notSetValue);
            props.put("monthlyRetention", notSetValue);
            props.put("retentionNumber", this.getRetentionNumber(pg.getTemplate().getProps(), protectLocation));
            tmp.setProps(props);
            result.add(tmp);
        }
    }

    private String getRetentionCount(JSONObject protectLocationJsonValue, String key) {
        if (protectLocationJsonValue == null || !protectLocationJsonValue.containsKey((Object)key)) {
            return "-1";
        }
        return protectLocationJsonValue.getString(key);
    }

    private String getRetentionNumber(Map<String, String> props, int protectLocation) {
        LOGGER.debug((Object)"Do getRetentionNumber. protectLocation: %s", new Object[]{String.valueOf(protectLocation)});
        if (props.containsKey("PP_SNAPSHOT_COUNT" + protectLocation)) {
            return props.get("PP_SNAPSHOT_COUNT" + protectLocation);
        }
        return props.get("PP_SNAPSHOT_COUNT");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> deleteProtectGroupReplicaFromDBById(List<String> replicaIds) {
        Session session;
        ArrayList<String> failedReplicaIds;
        block5: {
            failedReplicaIds = new ArrayList<String>();
            if (VerifyUtil.isEmpty(replicaIds)) {
                LOGGER.error((Object)"ReplicaIds is empty");
                return failedReplicaIds;
            }
            session = null;
            try {
                session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
                if (VerifyUtil.isEmpty((Object)session)) break block5;
                Transaction transaction = session.beginTransaction();
                Query hql = session.createQuery("DELETE ProtectGroupReplica a WHERE a.id IN (:id) ");
                hql.setParameterList("id", replicaIds);
                hql.executeUpdate();
                transaction.commit();
            }
            catch (Exception e) {
                try {
                    DBOperationUtil.rollbackSession((Session)session);
                    failedReplicaIds.addAll(replicaIds);
                    LOGGER.error((Object)"Delete new replica error, error msg: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
                }
                catch (Throwable throwable) {
                    DBOperationUtil.closeSession(session);
                    throw throwable;
                }
                DBOperationUtil.closeSession((Session)session);
            }
        }
        DBOperationUtil.closeSession((Session)session);
        return failedReplicaIds;
    }

    private boolean isSanSnapshotPg(ProtectGroup pg) {
        if (!SAN_SNAPSHOT_TEMPLATE_TYPE_SET.contains(pg.getTemplate().getType())) {
            return false;
        }
        ProtectObject po = (ProtectObject)CommonUtil.getFirstElement((Collection)pg.getPolist());
        ProtectObjectStorageInfo poStorageInfo = (ProtectObjectStorageInfo)CommonUtil.getFirstElement((Collection)po.getUsedStorageResourceSet());
        return DrmEnumDefine.ResourceTypeE.LUN.getValue() == poStorageInfo.getResourceType().intValue();
    }

    private void handleSanSnapshotReplicas(List<ProtectGroupReplica> list, ProtectGroup pg, Schedule schedule) {
        if (CollectionUtils.isEmpty(list)) {
            LOGGER.info((Object)"No replicas need to delete, pg name: %s, schedule location: %s", new Object[]{pg.getName(), schedule.getProtectLocation()});
            return;
        }
        if (schedule.getProtectedType() == 102) {
            this.deleteSecureSnapshot(list);
        } else {
            this.deleteReplicas(list, pg);
        }
    }

    private void deleteSecureSnapshot(List<ProtectGroupReplica> list) {
        LOGGER.info((Object)"Delete secure snapshots: %s ", new Object[]{list});
        if (VerifyUtil.isEmpty(list)) {
            return;
        }
        List<String> failedIds = this.deletePgReplicaFromDB(list);
        if (!VerifyUtil.isEmpty(failedIds)) {
            LOGGER.error((Object)"Delete secure replicas failed, cause by visit db exception, replicaIds is %s", new Object[]{failedIds});
        }
    }

    private int getStrategyReplicaSize(ProtectGroup pg, Schedule schedule) {
        List<ProtectGroupReplica> replicaList = this.filterReplicasByLocation(pg.getReplicaList(), schedule);
        return replicaList.size();
    }

    private List<ProtectGroupReplica> filterReplicasByLocation(Set<ProtectGroupReplica> replicas, Schedule schedule) {
        if (VerifyUtil.isEmpty((Object)schedule)) {
            LOGGER.debug((Object)"Schedule is null.");
            return new ArrayList<ProtectGroupReplica>(replicas);
        }
        ArrayList<ProtectGroupReplica> result = new ArrayList<ProtectGroupReplica>();
        for (ProtectGroupReplica replica : replicas) {
            if (!ProtectGroupUtil.isLocalStorageReplica((ProtectGroupReplica)replica) || replica.getProtectLocation() != schedule.getProtectLocation() || !ScheduleProtectedType.isSameType((int)replica.getType(), (int)schedule.getProtectedType()) || replica.getGeneration() != null && replica.getGeneration() != 1) continue;
            result.add(replica);
        }
        return result;
    }

    private int getMaxReserveSize(RetentionPolicy strategy) {
        return strategy.getTotalCopyies();
    }

    private List<ProtectGroupReplica> getRetentionReplicas(RetentionPolicy strategy, List<ProtectGroupReplica> allReplicas, String retentionType) {
        int retentionNumber = "dailyRetention".equals(retentionType) ? strategy.getDailyCopies() : ("weeklyRetention".equals(retentionType) ? strategy.getWeeklyCopies() : ("monthlyRetention".equals(retentionType) ? strategy.getMonthlyCopyies() : -1));
        ArrayList<ProtectGroupReplica> allAvailableReplicas = new ArrayList<ProtectGroupReplica>();
        if (retentionNumber <= 0) {
            LOGGER.debug((Object)"RetentionNumber <= 0");
            return allAvailableReplicas;
        }
        for (int i = 0; i < retentionNumber; ++i) {
            String beginDateStr = this.getTimeBefore(i + 1, retentionType);
            String endDateStr = this.getTimeBefore(i, retentionType);
            if (VerifyUtil.isEmpty((String)endDateStr) || VerifyUtil.isEmpty((String)beginDateStr)) {
                LOGGER.error((Object)"BeginDateStr or endDateStr is null");
                throw new LegoCheckedException(1073947394L);
            }
            ProtectGroupReplica lastestReplica = this.latestReplicaInPeriod(allReplicas, beginDateStr, endDateStr);
            if (VerifyUtil.isEmpty((Object)lastestReplica)) continue;
            allAvailableReplicas.add(lastestReplica);
        }
        return allAvailableReplicas;
    }

    private String getTimeBefore(int count, String retentionType) {
        LOGGER.debug((Object)"RetentionType: %s, , count: %s", new Object[]{retentionType, count});
        String result = null;
        switch (retentionType) {
            case "dailyRetention": {
                result = String.valueOf(AbstractReplicaRetentionHandler.getDateBefore(count).getTime());
                break;
            }
            case "weeklyRetention": {
                result = String.valueOf(AbstractReplicaRetentionHandler.getWeekBefore(count).getTime());
                break;
            }
            case "monthlyRetention": {
                result = String.valueOf(AbstractReplicaRetentionHandler.getMonthBefore(count).getTime());
                break;
            }
        }
        return result;
    }

    private ProtectGroupReplica latestReplicaInPeriod(List<ProtectGroupReplica> allReplicas, String beginDateStr, String endDateStr) {
        ProtectGroupReplica latestReplica = null;
        for (ProtectGroupReplica replica : allReplicas) {
            if (replica.getTimeStamp().compareTo(beginDateStr) < 0 || replica.getTimeStamp().compareTo(endDateStr) >= 0) continue;
            if (VerifyUtil.isEmpty(latestReplica)) {
                latestReplica = replica;
                continue;
            }
            if (replica.getTimeStamp().compareTo(latestReplica.getTimeStamp()) <= 0) continue;
            latestReplica = replica;
        }
        return latestReplica;
    }

    private boolean compareTheJsonValue(JSONObject protectLocationJsonValue, String key, int upperLimit) {
        return protectLocationJsonValue.containsKey((Object)key) && NumberUtil.convertToInteger((Object)protectLocationJsonValue.getString(key)) >= 0 && NumberUtil.convertToInteger((Object)protectLocationJsonValue.getString(key)) <= upperLimit;
    }

    private void deleteReplicasStorage(ProtectGroup pg, List<ProtectGroupReplica> toDelete) {
        ProtectGroup protectGroup;
        List<ProtectGroupTempReplica> tempReplicaList;
        HashSet<ProtectGroupReplica> replicaSet = new HashSet<ProtectGroupReplica>(toDelete);
        try {
            tempReplicaList = this.queryFailedDeleteReplicaInDB(pg);
            this.addFailedDeleteReplica(replicaSet, tempReplicaList);
            if (VerifyUtil.isEmpty(replicaSet)) {
                return;
            }
            Object clone = pg.clone();
            if (!(clone instanceof ProtectGroup)) {
                LOGGER.error((Object)"Clone error, pg name: %s", new Object[]{pg.getName()});
                this.saveFailedReplica(pg, toDelete);
                return;
            }
            protectGroup = (ProtectGroup)clone;
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)("DeleteReplicasStorage error!pg name:" + pg.getName()), (Throwable)e);
            this.saveFailedReplica(pg, toDelete);
            return;
        }
        catch (Exception e) {
            LOGGER.error((Object)("DeleteReplicasStorage error!pg name:" + pg.getName()));
            this.saveFailedReplica(pg, toDelete);
            return;
        }
        protectGroup.setReplicaList(replicaSet);
        Set failedReplicaSet = ProtectGroupHelper.getInstance().deleteReplica(protectGroup);
        if (!VerifyUtil.isEmpty(tempReplicaList)) {
            CommonDAOLocator.getBaseDao().getHibernateTemplate().deleteAll(tempReplicaList);
        }
        this.printfToDeleteReplicas(pg, replicaSet, failedReplicaSet);
        if (VerifyUtil.isEmpty((Collection)failedReplicaSet)) {
            return;
        }
        this.saveFailedReplica(pg, failedReplicaSet);
    }

    private List<ProtectGroupTempReplica> queryFailedDeleteReplicaInDB(ProtectGroup pg) {
        String queryTempReplicaSql = "FROM ProtectGroupTempReplica WHERE pgId=?";
        List tempReplicaList = CommonDAOLocator.getBaseDao().getHibernateTemplate().find(queryTempReplicaSql, new Object[]{pg.getUuid()});
        LOGGER.debug((Object)"Pg uuid:%s", new Object[]{pg.getUuid()});
        return tempReplicaList;
    }

    private void addFailedDeleteReplica(Set<ProtectGroupReplica> replicaSet, List<ProtectGroupTempReplica> tempReplicaList) {
        if (VerifyUtil.isEmpty(tempReplicaList)) {
            LOGGER.warn((Object)"TempReplicaList is empty!");
            return;
        }
        for (ProtectGroupTempReplica tempReplica : tempReplicaList) {
            replicaSet.add(tempReplica.toProtectGroupReplica());
        }
    }

    private void saveFailedReplica(ProtectGroup pg, Collection<ProtectGroupReplica> failedReplicaSet) {
        LOGGER.warn((Object)"Failed to delete replicas: %s, to delete size:", new Object[]{pg.getName(), failedReplicaSet.size()});
        HashSet<ProtectGroupTempReplica> deleteFailedReplicaSet = new HashSet<ProtectGroupTempReplica>();
        for (ProtectGroupReplica pgReplica : failedReplicaSet) {
            deleteFailedReplicaSet.add(ProtectGroupTempReplica.toProtectGroupTempReplica((ProtectGroup)pg, (ProtectGroupReplica)pgReplica));
        }
        CommonDAOLocator.getBaseDao().saveOrUpdateAll(deleteFailedReplicaSet);
        LOGGER.info((Object)"Success to save deleteFailedReplicas");
    }

    private void printfToDeleteReplicas(ProtectGroup pg, Set<ProtectGroupReplica> toDelete, Set<ProtectGroupReplica> failedReplicaSet) {
        LOGGER.info((Object)"Delete replicas: %s, to delete size:", new Object[]{pg.getName(), toDelete.size()});
        for (ProtectGroupReplica replica : toDelete) {
            String formatTime = "";
            try {
                if (!VerifyUtil.isEmpty((String)replica.getTimeStamp())) {
                    Date date = new Date(NumberUtil.convertToLong((Object)replica.getTimeStamp(), (long)0L));
                    formatTime = date.toString();
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"Get formatTime error! error: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            }
            if (!VerifyUtil.isEmpty(failedReplicaSet) && failedReplicaSet.contains(replica)) {
                LOGGER.warn((Object)"Failed to delete replica! replica id: %s, time: %s", new Object[]{replica.getId(), formatTime});
                continue;
            }
            LOGGER.info((Object)"Delete replica successfully, replica id: %s, time:%s", new Object[]{replica.getId(), formatTime});
        }
    }

    class DeleteReplicaTask
    implements Callable<Boolean> {
        private final ProtectGroup pg;
        private final List<ProtectGroupReplica> replicaList;

        public DeleteReplicaTask(ProtectGroup pg, List<ProtectGroupReplica> replicaList) {
            this.pg = pg;
            this.replicaList = replicaList;
        }

        @Override
        public Boolean call() {
            boolean result = true;
            try {
                AbstractReplicaRetentionHandler.this.deleteReplicasStorage(this.pg, this.replicaList);
            }
            catch (Exception e) {
                LOGGER.error((Object)"Delete replicas storage failed! pgName: %s, exception:", new Object[]{this.pg.getName(), ExceptionUtil.getErrorMessage((Throwable)e)});
                result = false;
            }
            return result;
        }
    }
}

