/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.task;

import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskUtil;
import com.huawei.ism.drm.license.sdk.ILicenseControl;
import com.huawei.ism.drm.protection.framework.service.replica.factory.IReplicaFactory;
import com.huawei.ism.drm.protection.framework.service.replica.factory.ReplicaFactoryManager;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.service.IReplicaService;
import com.huawei.ism.drm.recovery.framework.task.CreateMountNasSnapshotPlanTask;
import com.huawei.ism.drm.recovery.framework.task.MountBackTaskHandler;
import com.huawei.ism.drm.recovery.sdk.model.MountConfiguration;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Date;

public class CloneNasSnapshotTask
extends AbstractBackTask {
    private static final Log LOGGER = LogFactory.getInstance(CloneNasSnapshotTask.class);
    private final User user;
    private final ProtectGroupReplica srcReplica;
    private final boolean isNeedMount;
    private final MountConfiguration mountConfigs;

    public CloneNasSnapshotTask(User user, ProtectGroupReplica srcReplica, boolean isNeedMount, int timeout, MountConfiguration mountConfigs) {
        super(UUIDGenerator.getUUID(), BackTaskUtil.buildBackTask((String)srcReplica.getName(), (String)"ism.drm.clone.replica", (String)user.getUserName(), (String)"", null), timeout, true);
        this.user = user;
        this.srcReplica = srcReplica;
        this.isNeedMount = isNeedMount;
        this.mountConfigs = mountConfigs;
    }

    protected void doWork() {
        LOGGER.info((Object)"CloneNasSnapshotTask: Begin to clone replica from replica: id(%s),name(%s).", new Object[]{this.srcReplica.getId(), this.srcReplica.getName()});
        ReplicaFactoryManager manager = ReplicaFactoryManager.getInstance();
        IReplicaFactory sourceReplicaFactory = manager.getReplicaFactory(this.srcReplica.getType());
        if (!sourceReplicaFactory.validReplica(this.srcReplica, true)) {
            LOGGER.error((Object)"srcReplica is invalid, id: %s, isNeedMount: %s.", new Object[]{this.srcReplica.getId(), this.isNeedMount});
            throw new LegoCheckedException(1073948459L);
        }
        ILicenseControl licenseController = (ILicenseControl)ServiceLocator.getInstance().getService(ILicenseControl.class);
        ProtectGroup pg = this.srcReplica.getPg();
        licenseController.checkEnablePgCount(pg);
        int targetReplicaType = this.getTargetReplicaType();
        IReplicaFactory targetReplicaFactory = manager.getReplicaFactory(targetReplicaType);
        if (VerifyUtil.isEmpty((Object)targetReplicaFactory)) {
            LOGGER.error((Object)"Can not get replica Factory, replicaType=%s.", new Object[]{String.valueOf(targetReplicaType)});
            throw new LegoCheckedException(2117645L);
        }
        ProtectGroupReplica newReplica = targetReplicaFactory.createReplica(this.srcReplica);
        if (VerifyUtil.isEmpty((Object)newReplica)) {
            LOGGER.error((Object)"Create new replica failed, source replicaId=%s, replicaName=%s, targetReplicaType=%s.", new Object[]{this.srcReplica.getId(), this.srcReplica.getName(), targetReplicaType});
            throw new LegoCheckedException(0x300001L);
        }
        IReplicaService service = (IReplicaService)ServiceLocator.getInstance().getService(IReplicaService.class);
        newReplica.setGeneration(Integer.valueOf(2));
        newReplica.addProperty("mountConfigs", JSONObject.fromObject((Object)this.mountConfigs).toString());
        newReplica.setTimeStamp(String.valueOf(new Date().getTime()));
        service.saveOrUpdateReplica(newReplica);
        if (this.isNeedMount) {
            String mountHost = this.mountConfigs.getHostOrGroupSn();
            CreateMountNasSnapshotPlanTask task = new CreateMountNasSnapshotPlanTask(newReplica, mountHost, this.user, this.mountConfigs);
            MountBackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
        }
        LOGGER.info((Object)"CloneNasSnapshotTask: Finish cloning new replica: id(%s),name(%s).", new Object[]{newReplica.getId(), newReplica.getName()});
    }

    private int getTargetReplicaType() {
        int configTargetReplicaType;
        int targetReplicaType = this.srcReplica.getType();
        int defaultType = 0;
        int n = configTargetReplicaType = this.mountConfigs != null ? this.mountConfigs.getTargetReplicaType() : defaultType;
        if (configTargetReplicaType != defaultType && targetReplicaType != 14) {
            targetReplicaType = configTargetReplicaType;
        }
        return targetReplicaType;
    }
}

