/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.schedule.sdk.model.ScheduleProtectedType;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelationBo;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ProtectGroupExecuteStatusChecker {
    private static final Log logger = LogFactory.getInstance(ProtectGroupExecuteStatusChecker.class);
    private static final int CHECK_INTERVAL = 3000;
    private final boolean checkLoopFlag = true;
    private final ProtectGroup protectGroup;
    private final BaseRecoveryProcessor relatedProcessor;
    private String disasterSiteId;

    public ProtectGroupExecuteStatusChecker(ProtectGroup protectGroup, BaseRecoveryProcessor relatedProcessor) {
        this.protectGroup = protectGroup;
        this.relatedProcessor = relatedProcessor;
    }

    public ProtectGroupExecuteStatusChecker(ProtectGroup protectGroup, BaseRecoveryProcessor relatedProcessor, String disasterSiteId) {
        this.protectGroup = protectGroup;
        this.relatedProcessor = relatedProcessor;
        this.disasterSiteId = disasterSiteId;
    }

    public boolean startProcess() {
        return this.syncReplicationByProtectGroup();
    }

    private boolean syncReplicationByProtectGroup() {
        try {
            this.executeProtectGroup();
            this.checkProtectGroupExecuteResult();
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"Executing protect group failed.", (Throwable)e, 90160758784001L);
            this.relatedProcessor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            String productionSiteId = this.protectGroup.getProductSiteId();
            ISiteService siteService = (ISiteService)ServiceLocator.getInstance().getService(ISiteService.class);
            Site productionSite = siteService.getSiteById(productionSiteId);
            ProtectGroup curProtectGroup = this.getProtectGroup(this.protectGroup.getUuid(), productionSite);
            if (null == curProtectGroup) {
                throw new LegoCheckedException(1073947418L);
            }
            String lastExecParams = curProtectGroup.getLastExecParam();
            if (VerifyUtil.isEmpty((String)lastExecParams)) {
                this.relatedProcessor.updateProcessDetail(e);
                return false;
            }
            String[] execParams = new String[]{};
            if (!VerifyUtil.isEmpty((String)lastExecParams)) {
                execParams = lastExecParams.split(";");
            }
            this.relatedProcessor.updateProcessDetail(curProtectGroup.getLastExecErrorDetail(), execParams);
            return false;
        }
        catch (Exception e) {
            logger.error((Object)("Executing protect group failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            this.relatedProcessor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.relatedProcessor.updateProcessDetail("lego.err.1073947418", new String[0]);
            return false;
        }
        this.relatedProcessor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        return true;
    }

    private void checkProtectGroupExecuteResult() {
        block4: {
            String productionSiteId = this.protectGroup.getProductSiteId();
            ISiteService siteService = (ISiteService)ServiceLocator.getInstance().getService(ISiteService.class);
            Site productionSite = siteService.getSiteById(productionSiteId);
            int normalCount = 0;
            int runningCount = 0;
            while (true) {
                ProtectGroup curProtectGroup;
                if (null == (curProtectGroup = this.getProtectGroup(this.protectGroup.getUuid(), productionSite))) {
                    throw new LegoCheckedException(1073947418L);
                }
                if (curProtectGroup.isRunning()) {
                    normalCount = 0;
                    ++runningCount;
                    CommUtil.pauseThread((long)3000L);
                    continue;
                }
                if (!curProtectGroup.isNormal()) break;
                if (this.checkRunningCount(runningCount, curProtectGroup) && this.checkNormalCount(normalCount, curProtectGroup)) {
                    ++normalCount;
                    CommUtil.pauseThread((long)3000L);
                    continue;
                }
                break block4;
                break;
            }
            throw new LegoCheckedException(1073947418L);
        }
    }

    private boolean checkNormalCount(int normalCount, ProtectGroup curProtectGroup) {
        boolean isNeedContinue = false;
        if (5 > normalCount) {
            isNeedContinue = true;
        } else {
            if (curProtectGroup.getLastExecResult() == null) {
                return 100 > normalCount;
            }
            if (1 != curProtectGroup.getLastExecResult()) {
                throw new LegoCheckedException(1073947418L);
            }
        }
        return isNeedContinue;
    }

    private boolean checkRunningCount(int runningCount, ProtectGroup curProtectGroup) {
        boolean isNeedContinue = true;
        if (0 < runningCount) {
            if (curProtectGroup.getLastExecResult() == null) {
                return isNeedContinue;
            }
            if (1 == curProtectGroup.getLastExecResult()) {
                isNeedContinue = false;
            } else {
                throw new LegoCheckedException(1073947418L);
            }
        }
        return isNeedContinue;
    }

    private void executeProtectGroup() {
        String sourceSiteId = this.getSourceSiteId();
        if (null == sourceSiteId || null == this.disasterSiteId) {
            logger.error((Object)"sourceSiteId Site Id or disaster Site Id is null");
            throw new LegoCheckedException(1073947393L);
        }
        List<Integer> types = Arrays.stream(ScheduleProtectedType.values()).map(ScheduleProtectedType::getValue).collect(Collectors.toList());
        Schedule schedule = this.getSchedule(sourceSiteId, types);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("backupTypeAfterSync", -1);
        parameters.put("SYNC_EXECUTE_IN_RECOVERY_PROCESS", this.relatedProcessor.getProcType());
        Schedule targetSchedule = this.protectGroup.findFirstSchedule(schedule);
        if (!schedule.getScheduleId().equals(targetSchedule.getScheduleId())) {
            parameters.put("MergeProtectAction", "true");
            if (this.isSyncTypeAfterSync()) {
                parameters.put("MergeProtectAction", "false");
                parameters.put("syncTypeAfterSync", 1);
            }
        }
        if (schedule.getScheduleId().equals(targetSchedule.getScheduleId()) && this.isNeedUpdatePutBackup(targetSchedule)) {
            logger.info((Object)"Need to backupTypeAfterSync by scheduleId: %s", new Object[]{schedule.getScheduleId()});
            parameters.put("backupTypeAfterSync", 2);
        }
        IProtectGroupService protectGroupService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
        protectGroupService.runSchedule(this.protectGroup.getUuid(), targetSchedule.getScheduleId(), parameters);
    }

    private boolean isNeedUpdatePutBackup(Schedule schedule) {
        int templateType = this.protectGroup.getTemplate().getType();
        if (!this.is4DCSyncAsyncType(templateType)) {
            return false;
        }
        Map extMap = schedule.getExtParameters();
        return extMap.containsKey("replicationMode") && ((String)extMap.get("replicationMode")).equals(String.valueOf(1));
    }

    private Schedule getSchedule(String sourceSiteId, List<Integer> types) {
        Schedule schedule = this.protectGroup.getTemplate().getSchedules().stream().filter(item -> this.split(item.getSourceSiteId()).contains(sourceSiteId) && this.split(item.getTargetSiteId()).contains(this.disasterSiteId) && !types.contains(item.getProtectedType())).findFirst().orElse(null);
        if (null == schedule) {
            logger.error((Object)"Cannot find schedule by production site id[%s] and disaster site id[%s]", new Object[]{sourceSiteId, this.disasterSiteId});
            throw new LegoCheckedException(1073947394L);
        }
        return schedule;
    }

    private boolean isSyncTypeAfterSync() {
        int templateType = this.protectGroup.getTemplate().getType();
        return templateType == 58 || templateType == 40;
    }

    private boolean is4DCSyncAsyncType(int templateType) {
        return templateType == 58 || templateType == 59 || templateType == 40 || templateType == 41;
    }

    private String getSourceSiteId() {
        List repList = this.protectGroup.getReplicationRelationByRecoverySiteId(this.disasterSiteId);
        if (null == repList || repList.isEmpty()) {
            return this.protectGroup.getProductSiteId();
        }
        ReplicationRelationBo replicationRelationBo = (ReplicationRelationBo)repList.stream().findFirst().get();
        String srcDeviceSn = replicationRelationBo.getSrcDeviceSn();
        ISiteService siteService = (ISiteService)ServiceLocator.getInstance().getService(ISiteService.class);
        Site site = siteService.getSiteByDeviceSn(srcDeviceSn);
        if (null == site) {
            return null;
        }
        return site.getSiteId();
    }

    private Collection<String> split(String siteIds) {
        if (siteIds == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(siteIds.split(":"));
    }

    private ProtectGroup getProtectGroup(String protectGroupId, Site productionSite) {
        IProtectGroupService protectGroupService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
        return protectGroupService.getProtectGroupByID(protectGroupId, false);
    }
}

