/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.process;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectionJobUtil;
import com.huawei.ism.drm.recovery.framework.process.AbstractPgLockingCustomPreProcessor;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.HashMap;
import java.util.Map;

public class RollbackPgLockingCustomPreProcessor
extends AbstractPgLockingCustomPreProcessor {
    private final Log logger = LogFactory.getInstance(((Object)((Object)this)).getClass());

    public Map<String, Object> process(RecoveryPlan plan) {
        boolean lockFlag;
        HashMap<String, Object> result = new HashMap();
        String pgId = plan.getProtectGroup().getUuid();
        if (!VerifyUtil.isEmpty((String)pgId) && !(lockFlag = ProtectionJobUtil.getInstance().getLockPg(pgId))) {
            this.logger.error((Object)("The pg is locked: " + pgId), 90160758786893L);
            throw new LegoCheckedException(102401L);
        }
        try {
            result = super.process(plan);
        }
        catch (LegoCheckedException e1) {
            this.logger.error((Object)("Lock the pg error:" + pgId), (Throwable)e1);
            ProtectionJobUtil.getInstance().releaseLockPg(pgId);
            throw e1;
        }
        catch (Exception e2) {
            this.logger.error((Object)("Lock the pg error:" + pgId), new Object[]{ExceptionUtil.getErrorMessage((Throwable)e2)});
            ProtectionJobUtil.getInstance().releaseLockPg(pgId);
            ExceptionUtil.rethrowException((Throwable)e2, (String)("Lock the pg error:" + pgId), (long)-1L, (String[])new String[0], (Log)this.logger);
        }
        return result;
    }

    public String getType() {
        return DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK.name();
    }
}

