/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.process.airgap;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.base.job.airgapjob.AirGapLinkProcessor;
import com.huawei.ism.drm.base.util.AirGapLinkPortUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.sdk.model.EnablePortTask;
import com.huawei.ism.drm.storage.sdk.model.StorageLinkPort;
import com.huawei.lego.core.sdk.exception.LegoUnsupportedOperationException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class DisableStorageReplicationPortProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 5797596509118422854L;
    private static final Log logger = LogFactory.getInstance(DisableStorageReplicationPortProcessor.class);

    protected boolean execute(RecoveryProcessorContext context) {
        ProtectGroup pg = (ProtectGroup)context.getAttribute("Recovery_ProtectGroup");
        if (!PolicyTemplateType.AIR_GAP_NETWORKING.contains(pg.getTemplate().getType())) {
            return true;
        }
        if (!this.disablePgPorts(context, pg)) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail("ism.drm.recovery.airgap.disable.port.error", new String[0]);
            return false;
        }
        List linkPorts = AirGapLinkPortUtil.getAirGapPortList((ProtectGroup)pg);
        Set portNames = linkPorts.stream().map(StorageLinkPort::getPortName).collect(Collectors.toSet());
        String name = AirGapLinkPortUtil.getPortNames(portNames);
        String[] nameArray = new String[]{name};
        this.updateProcessDetail("ism.drm.recovery.airgap.disable.port.description", nameArray);
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        return true;
    }

    private boolean disablePgPorts(RecoveryProcessorContext context, ProtectGroup pg) {
        Map map = pg.getProps();
        if (!map.containsKey("isAirGapType")) {
            logger.error((Object)"Not find need data of pgName: %s", new Object[]{pg.getName()});
            return false;
        }
        Optional opt = context.getProtectPortTask();
        if (!opt.isPresent()) {
            logger.error((Object)"Not find task info.");
            return false;
        }
        List linkPorts = AirGapLinkPortUtil.getAirGapPortList((ProtectGroup)pg);
        if (CollectionUtils.isEmpty((Collection)linkPorts)) {
            logger.info((Object)"Get link ports from storage failed, disable ports in task.");
            linkPorts = ((EnablePortTask)opt.get()).getPortList();
        }
        List portIds = linkPorts.stream().map(StorageLinkPort::getPortId).collect(Collectors.toList());
        AirGapLinkProcessor linkProcessor = AirGapLinkProcessor.getInstance();
        for (StorageLinkPort linkPort : linkPorts) {
            logger.info((Object)"update PortName: %s disable time", new Object[]{linkPort.getPortName()});
            StorageLinkPort portInDb = this.getPortInDb(linkPort);
            portInDb.setExecTypeEnum(DrmEnumDefine.ExecTypeEnum.MANUAL);
            portInDb.setScheduleModeType(DrmEnumDefine.ExecTypeEnum.MANUAL);
            portInDb.setTaskId(((EnablePortTask)opt.get()).getTaskId());
            portInDb.setOperator(pg.getName());
            portInDb.setPgWorkPorts(portIds);
            portInDb.setOperateType(2);
            linkProcessor.updateDisableTimeMap(portInDb);
        }
        AirGapLinkPortUtil.updateTimeWindowWithPg((ProtectGroup)pg, (boolean)false);
        return true;
    }

    private StorageLinkPort getPortInDb(StorageLinkPort linkPort) {
        return (StorageLinkPort)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(StorageLinkPort.class, (Serializable)((Object)linkPort.getPortId()));
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected String generateResultKey() {
        throw new LegoUnsupportedOperationException("The operation is not supported.");
    }

    public void updateDescription() {
        this.setDescription("com.huawei.ism.drm.recovery.framework.process.airgap.DisableStorageReplicationPortProcessor.des");
    }

    public String getStepPosition() {
        return "Disable the replication network port of the storage device.";
    }
}

