/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.process.reprotect;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupExtendUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.RemoteStorageReplica;
import com.huawei.ism.drm.recovery.framework.process.reprotect.RefreshStorageProcessor;
import com.huawei.ism.drm.recovery.framework.process.reprotect.ReprotectBaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.manager.proxy.StorageReprotectManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageReprotectManager;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;

public class CheckStorageRelationSubProcessor
extends ReprotectBaseRecoveryProcessor {
    private static final long serialVersionUID = -7759898517444187750L;
    private static final Log logger = LogFactory.getInstance(CheckStorageRelationSubProcessor.class);
    private String recoveryArray;
    private List<String> lunIds;

    public CheckStorageRelationSubProcessor() {
        this.setIsNeedSave(false);
    }

    public CheckStorageRelationSubProcessor(RecoveryProcessor parentProcess, String recoveryArray, List<String> lunIds) {
        super(parentProcess);
        this.recoveryArray = recoveryArray;
        this.lunIds = lunIds;
        this.setIsNeedSave(false);
    }

    public String getRecoveryArray() {
        return this.recoveryArray;
    }

    public void setRecoveryArray(String recoveryArray) {
        this.recoveryArray = recoveryArray;
    }

    public List<String> getLunIds() {
        return this.lunIds;
    }

    public void setLunIds(List<String> lunIds) {
        this.lunIds = lunIds;
    }

    public boolean execute(RecoveryProcessorContext context) {
        RefreshStorageProcessor refreshStorageProcessor = new RefreshStorageProcessor((RecoveryProcessor)this);
        refreshStorageProcessor.setIsNeedCreateDetail(false);
        boolean result = refreshStorageProcessor.execute(context);
        if (!result) {
            this.updateProcessDetail("lego.err.1073948761", new String[0]);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        try {
            logger.debug((Object)("Need to check lunIds:" + this.lunIds.toString()), 90160758786816L);
            IStorageReprotectManager manager = (IStorageReprotectManager)StorageReprotectManagerProxy.getInstance().getStorageReprotectMgrByDevId(this.recoveryArray);
            manager.checkStorageReplication(this.recoveryArray, this.lunIds);
            this.checkStorageRunning(manager, context);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"Checking storage replication failed.", (Throwable)e, 90160758787071L);
            this.updateProcessDetail(e);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        catch (Exception e) {
            logger.error((Object)("Checking storage replication failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            this.updateProcessDetail("lego.err.-1", new String[0]);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        return true;
    }

    private void checkStorageRunning(IStorageReprotectManager manager, RecoveryProcessorContext context) {
        ProtectGroup pg = context.getProtectGroup();
        List<Integer> hmRingTemplateTypes = Arrays.asList(PolicyTemplateType.PolicyTemplateE.ARRAY_HYPER_METRO_ASYNC_RING.getValue(), PolicyTemplateType.PolicyTemplateE.ARRAY_ASYNC_HYPER_METRO_RING.getValue());
        List<Integer> repRingTemplateTypes = Arrays.asList(PolicyTemplateType.PolicyTemplateE.ARRAY_CASCADE_SYNC_ASYNC.getValue(), PolicyTemplateType.PolicyTemplateE.ARRAY_CONCURRENT_SYNC_ASYNC.getValue());
        int templateType = pg.getTemplate().getType();
        if (!hmRingTemplateTypes.contains(templateType) && !repRingTemplateTypes.contains(templateType)) {
            return;
        }
        logger.info((Object)"Begin to check 3DC storage running status. pgName: %s", new Object[]{pg.getName()});
        Set<String> usedDrRingIdSet = this.getUsedDrRingIdSet(pg);
        if (CollectionUtils.isEmpty(usedDrRingIdSet)) {
            logger.error((Object)"find dr ring id error!");
            throw new LegoCheckedException(201L);
        }
        ArrayList<String> usedDrRingIds = new ArrayList<String>(usedDrRingIdSet);
        String storageProviderSn = this.getAnyStorageReplica(pg).get().getSrcStorageProviderSN();
        logger.info((Object)"Get provider SN: %s for get dr storage running status.", new Object[]{storageProviderSn});
        String drStrategy = hmRingTemplateTypes.contains(templateType) ? "1" : "2";
        manager.checkStorageRunningStatus(storageProviderSn, usedDrRingIds, drStrategy);
    }

    private Optional<RemoteStorageReplica> getAnyStorageReplica(ProtectGroup pg) {
        ProtectGroupReplica replica = pg.getAnyoneReplicationReplica();
        if (replica == null) {
            return Optional.empty();
        }
        Optional opt = replica.getReplicas().stream().findAny();
        if (!opt.isPresent()) {
            logger.error((Object)"Not find poReplica, return!");
            return Optional.empty();
        }
        Optional optStorageInfo = ((ProtectObjectReplica)opt.get()).getStorageInfos().stream().findAny();
        if (!optStorageInfo.isPresent()) {
            logger.error((Object)"Not find optStorageInfo, return!");
            return Optional.empty();
        }
        RelicaStorageInfo replicaStorageInfo = (RelicaStorageInfo)optStorageInfo.get();
        RemoteStorageReplica remoteStorageReplica = (RemoteStorageReplica)replicaStorageInfo;
        return Optional.of(remoteStorageReplica);
    }

    private Set<String> getUsedDrRingIdSet(ProtectGroup pg) {
        HashSet<String> usedDrRingIdSet = new HashSet<String>();
        if (pg.hasMultiCg()) {
            Set<RemoteStorageReplica> allRemoteStorageReplica = ProtectGroupExtendUtil.getAllRemoteStorageReplica(pg);
            allRemoteStorageReplica.forEach(remoteReplica -> usedDrRingIdSet.add(remoteReplica.getDrRingId()));
        } else {
            Optional<RemoteStorageReplica> remoteReplicaOpt = this.getAnyStorageReplica(pg);
            if (remoteReplicaOpt.isPresent()) {
                String id = remoteReplicaOpt.get().getDrRingId();
                usedDrRingIdSet.add(id);
            }
        }
        logger.info((Object)"Get used drRingId set: %s", new Object[]{usedDrRingIdSet});
        return usedDrRingIdSet;
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

