/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.task;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.common.sdk.model.MessageEvent;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.drp.sdk.model.RecoveryLog;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessDefinition;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanObserverManager;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.drp.synchronize.RecoveryLogSynchronizer;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.framework.process.RecoveryProcessorMgr;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessSerialExecutor;
import com.huawei.ism.drm.recovery.framework.util.MotionPausedUtils;
import com.huawei.ism.drm.recovery.framework.util.SyncLockManager;
import com.huawei.ism.drm.recovery.process.IInitialChildProcessor;
import com.huawei.ism.drm.recovery.process.IProcessor;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessHandler;
import com.huawei.ism.drm.recovery.process.RecoveryProcessResult;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.recovery.task.ICallBackExcuteRecoveryTask;
import com.huawei.ism.drm.recovery.task.IRecoveryBackTask;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoUncaughtExceptionHandler;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.NumberUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;

public class RecoveryBackTask
implements IRecoveryBackTask {
    private static Log logger = LogFactory.getInstance(RecoveryBackTask.class);
    private RecoveryPlan recoveryPlan;
    private DrmEnumDefine.RecoveryPlanExecuteTypeE recoveryPlanExecuteType;
    private User operator;
    private RecoveryProcessSerialExecutor recoveryProcessTemplate;
    private Map<String, Object> preProcessResults = new HashMap<String, Object>();
    private Map<String, Object> initialContextData = new HashMap<String, Object>();
    private ICallBackExcuteRecoveryTask callBaskTask;

    public ICallBackExcuteRecoveryTask getCallBaskTask() {
        return this.callBaskTask;
    }

    public void setCallBaskTask(ICallBackExcuteRecoveryTask callBaskTask) {
        this.callBaskTask = callBaskTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        try {
            String recoveryLogId;
            if (!SyncLockManager.tryLock(this.recoveryPlan.getPlanId() + 0)) {
                logger.error((Object)("The recovery plan is executing. PlanId:" + this.recoveryPlan.getPlanId() + ",Type:" + this.recoveryPlanExecuteType.getValue()), 90160758784001L);
                return;
            }
            String planIdPrefix = this.recoveryPlan.getPlanId().substring(0, 8);
            Thread.currentThread().setName("RecoveryTask_" + planIdPrefix + "_" + this.recoveryPlanExecuteType.getValue());
            Thread.currentThread().setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)LegoUncaughtExceptionHandler.getInstance());
            RecoveryProcessorContext context = new RecoveryProcessorContext();
            this.initializeRecoveryContext(context, this.preProcessResults);
            this.initializeRecoveryContext(context, this.initialContextData);
            context.setRecoveryPlan(this.recoveryPlan);
            if (this.recoveryPlan.getGlobalSettings().containsKey("isReserved")) {
                context.setAttribute("isReserved", this.recoveryPlan.getGlobalSettings().get("isReserved"));
            }
            RecoveryProcessResult processResult = new RecoveryProcessResult();
            context.setProcessResult(processResult);
            String productionSiteId = RecoveryServiceUtil.getProductSiteId((RecoveryPlan)this.recoveryPlan);
            context.setAttribute("PRODUCT_SITE_ID", (Object)productionSiteId);
            String disasterSiteId = (String)this.recoveryPlan.getGlobalSettings().get("DISASTER_SITE_ID");
            context.setDisasterSiteId(disasterSiteId);
            String selDisasterSiteId = (String)this.recoveryPlan.getGlobalSettings().get("SELECT_DISASTER_SITE_KEY");
            if (null != selDisasterSiteId) {
                context.setAttribute("SELECT_DISASTER_SITE_KEY", (Object)selDisasterSiteId);
            }
            String string = recoveryLogId = this.isPaused() ? this.queryRecoveryLog(productionSiteId, disasterSiteId).getLogId() : this.addRecoveryLog(null, productionSiteId, disasterSiteId, (RecoveryProcessDefinition)context.getAttribute("RecoveryProcessDefinition"));
            if (null == recoveryLogId) {
                logger.error((Object)"Adding recovery log failed.", 90160758784001L);
                return;
            }
            context.setRecoveryLogId(recoveryLogId);
            context.setProcessStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            context.setAttribute("PLAN_EXEXUTE_TYPE", (Object)this.recoveryPlanExecuteType);
            this.execute(context);
        }
        finally {
            SyncLockManager.unLock(this.recoveryPlan.getPlanId() + 0);
        }
    }

    private boolean isPaused() {
        return DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.equals((Object)this.recoveryPlanExecuteType) && DrmEnumDefine.RecoveryPlanStatusE.PLANED_MOTION_PAUSED.getValue() == this.recoveryPlan.getPlanStatus();
    }

    private RecoveryLog queryRecoveryLog(String productionSiteId, String recoverySiteId) {
        RecoveryLog log = new RecoveryLog();
        log.setLogType(this.recoveryPlanExecuteType.getValue());
        log.setPlanId(this.recoveryPlan.getPlanId());
        log.setLogStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.PAUSED.getValue());
        log.setRecoverySiteId(recoverySiteId);
        log.setProductionSiteId(productionSiteId);
        IRecoveryProcessService rpService = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class);
        return rpService.queryRecoveryLog(log);
    }

    public RecoveryPlan getRecoveryPlan() {
        return this.recoveryPlan;
    }

    public void setRecoveryPlan(RecoveryPlan recoveryPlan) {
        this.recoveryPlan = recoveryPlan;
    }

    public DrmEnumDefine.RecoveryPlanExecuteTypeE getRecoveryPlanExecuteType() {
        return this.recoveryPlanExecuteType;
    }

    public void setRecoveryPlanExecuteType(DrmEnumDefine.RecoveryPlanExecuteTypeE recoveryPlanExecuteType) {
        this.recoveryPlanExecuteType = recoveryPlanExecuteType;
    }

    public User getOperator() {
        return this.operator;
    }

    public void setOperator(User operator) {
        this.operator = operator;
    }

    public RecoveryProcessSerialExecutor getRecoveryProcessTemplate() {
        return this.recoveryProcessTemplate;
    }

    public void setRecoveryProcessTemplate(IProcessor recoveryProcessTemplate) {
        this.recoveryProcessTemplate = (RecoveryProcessSerialExecutor)recoveryProcessTemplate;
    }

    protected void afterExecuteRecoveryPlan(boolean result, RecoveryProcessorContext context) {
        logger.debug((Object)"Method afterExecuteRecoveryPlan result:%s", new Object[]{result});
        int planStatus = this.calcRecoveryPlanStatus(result, context);
        Map<String, DrmEnumDefine.ProtectObjectRecoveryStatusE> poRecoveryStatusMap = this.calcPoRecoveryStatus(context, DrmEnumDefine.RecoveryPlanStatusE.getType((int)planStatus));
        Integer planProgress = 100;
        if (!result) {
            planProgress = null;
        }
        if (result && DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() == this.recoveryPlanExecuteType.getValue() && planStatus == DrmEnumDefine.RecoveryPlanStatusE.PLANED_MOTION_PAUSED.getValue()) {
            planProgress = null;
        }
        IRecoveryProcessService rpService = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class);
        rpService.updateRecoveryPlan(this.recoveryPlan.getPlanId(), planStatus, this.recoveryPlanExecuteType, poRecoveryStatusMap, planProgress, context.getProcessStatus());
        if (this.callBaskTask != null) {
            this.callBaskTask.afterExecuteRecoveryPlan(context, this.recoveryPlan);
        }
    }

    protected int calcRecoveryPlanStatus(boolean result, RecoveryProcessorContext context) {
        boolean isPausedProcess;
        DrmEnumDefine.RecoveryPlanExecuteTypeE executeType = this.recoveryPlanExecuteType;
        int planStatus = result ? executeType.getPlanSuccessStatus() : executeType.getPlanFailedStatus();
        ProtectGroup pg = (ProtectGroup)CommonUtil.getFirstElement((Collection)this.recoveryPlan.getProtectGroups());
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() == this.recoveryPlanExecuteType.getValue() && pg != null && PolicyTemplateType.OPENSTACK_POLICYTEMPLATE.contains(pg.getTemplate().getType())) {
            planStatus = result ? DrmEnumDefine.RecoveryPlanStatusE.REPROTECT_COMPLETED.getValue() : DrmEnumDefine.RecoveryPlanStatusE.PLANED_MOTION_FAILED.getValue();
        }
        boolean bl = isPausedProcess = context != null && Boolean.parseBoolean(String.valueOf(context.getAttribute("IS_PAUSED_PROCESS")));
        if (result && isPausedProcess && MotionPausedUtils.isOpenMotionPaused((RecoveryProcessorContext)context)) {
            planStatus = executeType.getPlanPausedStatus();
        }
        logger.debug((Object)"planStatus:%s.", (long)planStatus);
        return planStatus;
    }

    protected void beforeExecuteRecoveryPlan(RecoveryProcessorContext context) {
        boolean isPaused;
        this.cleanRecoveryProcesses();
        int planStatus = this.getRecoveryPlanExecuteType().getPlanRunningStatus();
        Map<String, DrmEnumDefine.ProtectObjectRecoveryStatusE> poRecoveryStatusMap = this.calcPoRecoveryStatus(context, DrmEnumDefine.RecoveryPlanStatusE.getType((int)planStatus));
        int planProgress = 0;
        boolean bl = isPaused = DrmEnumDefine.RecoveryPlanStatusE.PLANED_MOTION_PAUSED.getValue() == this.recoveryPlan.getPlanStatus();
        if (isPaused && DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.equals((Object)this.recoveryPlanExecuteType)) {
            planProgress = this.recoveryPlan.getPlanProgress();
        }
        IRecoveryProcessService rpService = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class);
        rpService.updateRecoveryPlan(this.recoveryPlan.getPlanId(), planStatus, this.recoveryPlanExecuteType, poRecoveryStatusMap, Integer.valueOf(planProgress), context.getProcessStatus());
        if (this.callBaskTask != null) {
            logger.debug((Object)"callBaskTask is not null!");
            this.callBaskTask.beforeExecuteRecoveryPlan(context, this.recoveryPlan);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(RecoveryProcessorContext context) {
        Boolean result = null;
        try {
            SyncLockManager.putSyncLock(this.recoveryPlan.getPlanId(), new ReentrantLock());
            MessageEvent event = new MessageEvent();
            HashMap<String, DrmEnumDefine.RecoveryPlanExecuteTypeE> messageMap = new HashMap<String, DrmEnumDefine.RecoveryPlanExecuteTypeE>();
            messageMap.put("message_event_excute_type", this.recoveryPlanExecuteType);
            event.setMessageMap(messageMap);
            event.setMessageType(6);
            ArrayList<RecoveryPlan> objectList = new ArrayList<RecoveryPlan>();
            objectList.add(context.getRecoveryPlan());
            event.setObjectList(objectList);
            IRecoveryPlanObserverManager observerManager = (IRecoveryPlanObserverManager)ServiceLocator.getInstance().getService(IRecoveryPlanObserverManager.class);
            observerManager.notifyObserverList(event, "before");
            this.beforeExecuteRecoveryPlan(context);
            result = this.recoveryProcessTemplate.checkMotionCancel(context, this.recoveryPlan) ? Boolean.valueOf(this.recoveryProcessTemplate.changeProcessorDetailStatus(context)) : Boolean.valueOf(this.recoveryProcessTemplate.process(context));
            this.afterExecuteRecoveryPlan(result, context);
            event.getMessageMap().put("IS_RE_PROTECT_SUCCESS", result);
            event.getMessageMap().put("IS_CONTINUE_PROCESS", context.getAttribute("IS_CONTINUE_PROCESS"));
            observerManager.notifyObserverList(event, "after");
            DrmEnumDefine.RecoveryPlanExecuteResultE procResult = this.calcExecutionResult(result, context);
            if (null == procResult) {
                procResult = DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER;
            }
            this.updateRecoveryLog(context.getRecoveryLogId(), procResult);
            this.cleanRecoveryProcessesAfterOperation(procResult);
        }
        catch (Exception e) {
            logger.error((Object)("Executing recovery plan failed. PlanId:" + this.recoveryPlan.getPlanId() + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            this.updateRecoveryLog(context.getRecoveryLogId(), DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED);
            if (null != result) {
                DrmEnumDefine.RecoveryPlanExecuteResultE procResult = this.calcExecutionResult(result);
                if (null == procResult) {
                    procResult = DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER;
                }
                this.updateRecoveryLog(context.getRecoveryLogId(), procResult);
                this.cleanRecoveryProcessesAfterOperation(procResult);
            }
        }
        finally {
            SyncLockManager.removeSyncLock(this.recoveryPlan.getPlanId());
            Object lockResult = context.getAttribute("LockProtectGroup");
            logger.info((Object)("LockProtectGroup=" + lockResult));
            if (null != lockResult && ((Boolean)lockResult).booleanValue()) {
                this.unlockProtectGroups(context, this.recoveryPlanExecuteType);
            }
        }
        if (DrmEnumDefine.RecoveryPlanTypeE.REMOTE.getValue() == this.recoveryPlan.getPlanType()) {
            RecoveryLogSynchronizer logSynchronizer = RecoveryLogSynchronizer.getInstance();
            logSynchronizer.syncRecoveryLog(this.recoveryPlan.getPlanId(), context.getRecoveryLogId());
        }
    }

    private String addRecoveryLog(String recoveryLogName, String productionSiteId, String recoverySiteId, RecoveryProcessDefinition processes) {
        logger.debug((Object)"recoveryPlan:%s, executeType:%s, productionSiteId:%s", new Object[]{this.recoveryPlan.getName(), this.recoveryPlanExecuteType.getValue(), productionSiteId});
        RecoveryLog recoveryLog = new RecoveryLog();
        Date curDate = new Date();
        recoveryLog.setStartTime(String.valueOf(curDate.getTime()));
        recoveryLog.setLogName(recoveryLogName);
        recoveryLog.setLogStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.RUNNING.getValue());
        recoveryLog.setLogType(this.recoveryPlanExecuteType.getValue());
        recoveryLog.setOperator(this.operator.getUserName());
        recoveryLog.setPlanId(this.recoveryPlan.getPlanId());
        recoveryLog.setProductionSiteId(productionSiteId);
        recoveryLog.setRecoverySiteId(recoverySiteId);
        IRecoveryProcessService rpService = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class);
        return rpService.createRecoveryLog(recoveryLog, processes);
    }

    protected Map<String, DrmEnumDefine.ProtectObjectRecoveryStatusE> calcPoRecoveryStatus(RecoveryProcessorContext context, DrmEnumDefine.RecoveryPlanStatusE planStatus) {
        logger.debug((Object)("planStatus:" + planStatus));
        int procType = this.recoveryPlanExecuteType.getValue();
        RecoveryProcessResult processResult = context.getProcessResult();
        HashMap<String, DrmEnumDefine.ProtectObjectRecoveryStatusE> poRecoveryStatusMap = new HashMap<String, DrmEnumDefine.ProtectObjectRecoveryStatusE>();
        Set protectObjects = context.getRecoveryProtectObjects();
        if (VerifyUtil.isEmpty((Collection)protectObjects)) {
            return poRecoveryStatusMap;
        }
        if (VerifyUtil.isEmpty((Object)processResult)) {
            logger.error((Object)"process result is null: procType=%s, planStatus=%s", new Object[]{procType, planStatus});
            return poRecoveryStatusMap;
        }
        DrmEnumDefine.ProtectObjectRecoveryStatusE poRecoveryStatusForAllPo = this.calcPoRecoveryStatusForAll(planStatus);
        this.resetRecoveryProtectObjects(processResult, protectObjects);
        for (ProtectObject po : protectObjects) {
            DrmEnumDefine.ProtectObjectRecoveryStatusE newPoRecoveryStatus = this.calcPoRecoveryStatus(procType, processResult, poRecoveryStatusForAllPo, po.getUuid(), po.getPoType());
            poRecoveryStatusMap.put(po.getUuid(), newPoRecoveryStatus);
        }
        return poRecoveryStatusMap;
    }

    private void resetRecoveryProtectObjects(RecoveryProcessResult processResult, Set<ProtectObject> protectObjects) {
        Set<ProtectObject> recoveryPoSet = this.getRecoveryProtectObjects(processResult);
        if (VerifyUtil.isEmpty(recoveryPoSet)) {
            logger.debug((Object)"recoveryPoSet is empty!");
            return;
        }
        for (ProtectObject protectObject : protectObjects) {
            Iterator<ProtectObject> iter = recoveryPoSet.iterator();
            while (iter.hasNext()) {
                if (!protectObject.getUuid().equals(iter.next().getUuid())) continue;
                iter.remove();
                iter = recoveryPoSet.iterator();
            }
        }
        for (ProtectObject recoveryPo : recoveryPoSet) {
            protectObjects.add(recoveryPo);
        }
    }

    private Set<ProtectObject> getRecoveryProtectObjects(RecoveryProcessResult processResult) {
        HashSet<ProtectObject> protectObjects = new HashSet<ProtectObject>();
        Map procResults = processResult.getProcessResults("PoRecoveryStatus");
        if (VerifyUtil.isEmpty((Map)procResults)) {
            logger.debug((Object)"procResults is empty!");
            return protectObjects;
        }
        Set entrySet = procResults.entrySet();
        for (Map.Entry entry : entrySet) {
            String key = (String)entry.getKey();
            String[] strArray = key.split(":");
            if (4 != strArray.length) continue;
            ProtectObject po = new ProtectObject();
            po.setUuid(strArray[2]);
            po.setPoType(NumberUtil.convertToInteger((Object)strArray[3]).intValue());
            protectObjects.add(po);
        }
        return protectObjects;
    }

    private DrmEnumDefine.ProtectObjectRecoveryStatusE calcPoRecoveryStatus(int procType, RecoveryProcessResult processResult, DrmEnumDefine.ProtectObjectRecoveryStatusE allPoRecoveryStatus, String poUuid, int poType) {
        String key;
        boolean result;
        DrmEnumDefine.ProtectObjectRecoveryStatusE newPoRecoveryStatus = allPoRecoveryStatus;
        if (DrmEnumDefine.ProtectObjectRecoveryStatusE.FAILED.getValue() == allPoRecoveryStatus.getValue() && (result = processResult.getProcessResult(key = RecoveryProcessResult.getPoRecoveryStatusKey((int)procType, (String)poUuid, (int)poType)))) {
            newPoRecoveryStatus = DrmEnumDefine.ProtectObjectRecoveryStatusE.COMPLETED;
        }
        logger.debug((Object)("newPoRecoveryStatus:" + newPoRecoveryStatus));
        return newPoRecoveryStatus;
    }

    private boolean updateRecoveryLog(String recoveryLogId, DrmEnumDefine.RecoveryPlanExecuteResultE result) {
        IRecoveryProcessService recoveryPlanInterCalledService = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class);
        logger.debug((Object)("recoveryLogId:" + recoveryLogId));
        return recoveryPlanInterCalledService.updateRecoveryLog(recoveryLogId, result.getValue(), String.valueOf(new Date().getTime()));
    }

    private void cleanRecoveryProcesses() {
        DrmEnumDefine.RecoveryPlanStatusE status = DrmEnumDefine.RecoveryPlanStatusE.getType((int)this.recoveryPlan.getPlanStatus());
        if (null == status) {
            return;
        }
        boolean cleanFlag = status.containsExecuteType(this.recoveryPlanExecuteType.getValue());
        logger.debug((Object)("cleanFlag:" + cleanFlag));
        if (cleanFlag) {
            this.cleanRecoverySubProcessor(this.recoveryPlan, this.recoveryPlanExecuteType);
        }
    }

    protected void cleanRecoverySubProcessor(RecoveryPlan recoveryPlanParam, DrmEnumDefine.RecoveryPlanExecuteTypeE type) {
        if (null == recoveryPlanParam || null == type) {
            logger.warn((Object)"The parameter is invalid.", 90160758784001L);
            return;
        }
        IRecoveryProcessService recoveryProcessService = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class);
        RecoveryProcessDefinition rpDefinition = recoveryPlanParam.getRecoveryProcess(type);
        if (null == rpDefinition) {
            logger.warn((Object)("There is no matched recovery process definition. ExecType:" + type.getValue()), 90160758784001L);
            return;
        }
        Set recoveryProcesses = rpDefinition.getRecoveryProcessors();
        for (RecoveryProcessor process : recoveryProcesses) {
            process.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
            if (process.getProcType() != type.getValue() || null != process.getParentProc()) continue;
            if (process instanceof IInitialChildProcessor) {
                this.dealInitianlProcessor(type, recoveryProcessService, process);
                continue;
            }
            this.clearChildProc(recoveryProcessService, process);
        }
        recoveryProcessService.updateRecoveryPlan(recoveryPlanParam);
    }

    private void dealInitianlProcessor(DrmEnumDefine.RecoveryPlanExecuteTypeE type, IRecoveryProcessService recoveryProcessService, RecoveryProcessor process) {
        process.getChildProc().forEach(proc -> {
            proc.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
            if (proc.getProcType() == type.getValue()) {
                this.clearChildProc(recoveryProcessService, (RecoveryProcessor)proc);
            }
        });
    }

    private void clearChildProc(IRecoveryProcessService recoveryProcessService, RecoveryProcessor process) {
        if (null != process.getChildProc() && !process.getChildProc().isEmpty()) {
            recoveryProcessService.deleteSubRecoveryProcessor(process.getProcId());
            process.getChildProc().clear();
        }
    }

    private DrmEnumDefine.RecoveryPlanExecuteResultE calcExecutionResult(boolean result) {
        DrmEnumDefine.RecoveryPlanExecuteResultE procResult = null;
        boolean isAllProcessorCompleted = this.recoveryProcessTemplate.isAllProcessorCompleted();
        procResult = !isAllProcessorCompleted ? (result ? DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS : DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED) : this.recoveryProcessTemplate.getLastProcessorResult();
        logger.debug((Object)("procResult:" + procResult));
        return procResult;
    }

    private DrmEnumDefine.RecoveryPlanExecuteResultE calcExecutionResult(boolean result, RecoveryProcessorContext context) {
        DrmEnumDefine.RecoveryPlanExecuteResultE procResult;
        boolean isAllProcessorCompleted = this.recoveryProcessTemplate.isAllProcessorCompleted();
        if (!isAllProcessorCompleted) {
            DrmEnumDefine.RecoveryPlanExecuteResultE recoveryPlanExecuteResultE = procResult = result ? DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS : DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED;
            if (result && context != null && Boolean.parseBoolean(String.valueOf(context.getAttribute("IS_PAUSED_PROCESS")))) {
                procResult = DrmEnumDefine.RecoveryPlanExecuteResultE.PAUSED;
            }
        } else {
            procResult = this.recoveryProcessTemplate.getLastProcessorResult();
        }
        logger.debug((Object)"procResult:%s.", new Object[]{procResult});
        return procResult;
    }

    protected int calcRecoveryPlanStatus(boolean result) {
        DrmEnumDefine.RecoveryPlanExecuteTypeE executeType = this.recoveryPlanExecuteType;
        int planStatus = result ? executeType.getPlanSuccessStatus() : executeType.getPlanFailedStatus();
        ProtectGroup pg = (ProtectGroup)CommonUtil.getFirstElement((Collection)this.recoveryPlan.getProtectGroups());
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() == this.recoveryPlanExecuteType.getValue() && null != pg && PolicyTemplateType.OPENSTACK_POLICYTEMPLATE.contains(pg.getTemplate().getType())) {
            planStatus = result ? DrmEnumDefine.RecoveryPlanStatusE.REPROTECT_COMPLETED.getValue() : DrmEnumDefine.RecoveryPlanStatusE.PLANED_MOTION_FAILED.getValue();
        }
        logger.debug((Object)("planStatus:" + planStatus));
        return planStatus;
    }

    protected DrmEnumDefine.ProtectObjectRecoveryStatusE calcPoRecoveryStatusForAll(DrmEnumDefine.RecoveryPlanStatusE planStatus) {
        DrmEnumDefine.ProtectObjectRecoveryStatusE poRecoveryStatusForAllPo = DrmEnumDefine.ProtectObjectRecoveryStatusE.NOT_STARTED;
        switch (planStatus) {
            case PLANED_MOTION_COMPLETED: 
            case DISASTER_RECOVERY_COMPLETED: {
                poRecoveryStatusForAllPo = DrmEnumDefine.ProtectObjectRecoveryStatusE.COMPLETED;
                break;
            }
            case PLANED_MOTION_RUNNING: 
            case DISASTER_RECOVERY_RUNNING: {
                poRecoveryStatusForAllPo = DrmEnumDefine.ProtectObjectRecoveryStatusE.RUNNING;
                break;
            }
            case PLANED_MOTION_FAILED: 
            case DISASTER_RECOVERY_FAILED: {
                poRecoveryStatusForAllPo = DrmEnumDefine.ProtectObjectRecoveryStatusE.FAILED;
                break;
            }
            default: {
                poRecoveryStatusForAllPo = DrmEnumDefine.ProtectObjectRecoveryStatusE.NOT_STARTED;
            }
        }
        logger.debug((Object)("poRecoveryStatusForAllPo:" + poRecoveryStatusForAllPo));
        return poRecoveryStatusForAllPo;
    }

    private void cleanRecoveryProcessesAfterOperation(DrmEnumDefine.RecoveryPlanExecuteResultE result) {
        int excuteType = this.recoveryPlanExecuteType.getValue();
        logger.debug((Object)("excuteType:" + excuteType));
        DrmEnumDefine.RecoveryPlanExecuteTypeE executeTypeEnum = DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)excuteType);
        if (null != result && DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == result.getValue()) {
            IRecoveryPlanService planService = (IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class);
            RecoveryPlan plan = planService.getRecoveryPlan(this.recoveryPlan.getPlanId(), true, false);
            switch (executeTypeEnum) {
                case CLEAN_DRILLING: {
                    this.cleanRecoverySubProcessor(plan, this.recoveryPlanExecuteType);
                    this.cleanRecoverySubProcessor(plan, DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING);
                    break;
                }
                case UMOUNT_REPLICA: {
                    this.cleanRecoverySubProcessor(plan, this.recoveryPlanExecuteType);
                    this.cleanRecoverySubProcessor(plan, DrmEnumDefine.RecoveryPlanExecuteTypeE.MOUNT_REPLICA);
                    break;
                }
                case REPROTECT: {
                    this.cleanRecoverySubProcessor(plan, this.recoveryPlanExecuteType);
                    this.cleanRecoverySubProcessor(plan, DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION);
                    this.cleanRecoverySubProcessor(plan, DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY);
                    break;
                }
                case PLANED_MOTION: {
                    ProtectGroup pg = (ProtectGroup)CommonUtil.getFirstElement((Collection)this.recoveryPlan.getProtectGroups());
                    if (null == pg || !PolicyTemplateType.OPENSTACK_POLICYTEMPLATE.contains(pg.getTemplate().getType())) break;
                    this.cleanRecoverySubProcessor(plan, DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION);
                    break;
                }
                case HOT_MIGRATION: {
                    this.cleanRecoverySubProcessor(plan, DrmEnumDefine.RecoveryPlanExecuteTypeE.HOT_MIGRATION);
                    break;
                }
            }
        }
    }

    private void unlockProtectGroups(RecoveryProcessorContext context, DrmEnumDefine.RecoveryPlanExecuteTypeE type) {
        HashSet<DrmEnumDefine.RecoveryPlanExecuteTypeE> needUnlockType = new HashSet<DrmEnumDefine.RecoveryPlanExecuteTypeE>(Arrays.asList(DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY, DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION, DrmEnumDefine.RecoveryPlanExecuteTypeE.HOT_MIGRATION, DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK, DrmEnumDefine.RecoveryPlanExecuteTypeE.VM_ROLLBACK));
        logger.debug((Object)("type:" + type));
        if (needUnlockType.contains(type) || DrmEnumDefine.RecoveryPlanTypeE.LOCAL.getValue() == this.recoveryPlan.getPlanType()) {
            IRecoveryProcessHandler recoveryProcessHandler = (IRecoveryProcessHandler)RecoveryProcessorMgr.getInstance().getRecoveryProcessHandler();
            recoveryProcessHandler.unlockProtectGroups(context.getRecoveryPlan().getProtectGroups());
        }
    }

    public void setPreProcessResults(Map<String, Object> results) {
        if (null != results) {
            this.preProcessResults.putAll(results);
        }
    }

    public Object getPreProcessResult(String key) {
        return this.preProcessResults.get(key);
    }

    public void setInitialContextData(Map<String, Object> initialContextData) {
        if (null != initialContextData) {
            this.initialContextData.putAll(initialContextData);
        }
    }

    private void initializeRecoveryContext(RecoveryProcessorContext context, Map<String, Object> initialData) {
        if (VerifyUtil.isEmpty(initialData)) {
            logger.debug((Object)"initialData is null,not initialize RecoveryContext.");
            return;
        }
        logger.info((Object)("result=" + initialData));
        for (Map.Entry<String, Object> next : initialData.entrySet()) {
            context.setAttribute(next.getKey(), next.getValue());
        }
    }
}

