/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.util;

import com.huawei.ism.array.sdk.model.HyperMetroConsistentGroup;
import com.huawei.ism.array.sdk.model.HyperMetroPair;
import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.protection.template.sdk.model.SiteInfo;
import com.huawei.ism.drm.recovery.framework.checker.manager.RecoveryProcessCheckerManager;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessSerialExecutor;
import com.huawei.ism.drm.recovery.framework.util.RecoveryProcessBaseUtil;
import com.huawei.ism.drm.recovery.process.IProcessor;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessChecker;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.recovery.task.RecoveryTask;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.manager.proxy.StoragePortLinksManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStoragePortLinksManager;
import com.huawei.ism.drm.storage.sdk.model.RemoteLinkDevice;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelationBo;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.ism.drm.storage.sdk.service.IStorageResourceService;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.ism.drm.storage.service.router.StorageResourceServiceRouter;
import com.huawei.ism.drm.storage.util.SnapshotScheduleUtil;
import com.huawei.ism.unistor.sdk.model.NasFileSystem;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;

public final class RecoveryProcessUtil
extends RecoveryProcessBaseUtil {
    private static Log logger = LogFactory.getInstance(RecoveryProcessUtil.class);
    private static final String ALL_RELATED_REPLICATION_PAIRS = "all-related-replication-pairs";
    private static final String STANDBY = "standby";

    private RecoveryProcessUtil() {
    }

    public static String getProtectGroupIdFromWrapper(String wrappedProtectGroupId) {
        if (VerifyUtil.isEmpty((String)wrappedProtectGroupId)) {
            logger.error((Object)"wrapped pg id is null");
            return wrappedProtectGroupId;
        }
        if (!wrappedProtectGroupId.contains(":")) {
            return wrappedProtectGroupId;
        }
        return wrappedProtectGroupId.split(":")[0];
    }

    public static RecoveryProcessSerialExecutor createSerialExecutorWithConcurrentSubExecutor(Map<Integer, List<IProcessor>> processorsWithPriority, DrmEnumDefine.RecoveryPlanExecuteTypeE type, boolean isAsc) {
        int i;
        if (null == processorsWithPriority || null == type) {
            throw new LegoCheckedException(1073947393L);
        }
        ArrayList<IProcessor> iProcessors = new ArrayList<IProcessor>();
        ArrayList<RecoveryProcessConcurrentExecutor> subProcessors = new ArrayList<RecoveryProcessConcurrentExecutor>();
        ArrayList<Integer> priorityLevel = new ArrayList<Integer>();
        priorityLevel.addAll(processorsWithPriority.keySet());
        Collections.sort(priorityLevel, new Comparator<Integer>(){

            @Override
            public int compare(Integer arg0, Integer arg1) {
                return arg0.compareTo(arg1);
            }
        });
        if (isAsc) {
            for (i = 0; i < priorityLevel.size(); ++i) {
                List<IProcessor> processors = processorsWithPriority.get(priorityLevel.get(i));
                RecoveryProcessConcurrentExecutor executor = null;
                executor = RecoveryProcessConcurrentExecutor.createExecutor(processors, (boolean)false);
                subProcessors.add(executor);
                iProcessors.addAll(processors);
            }
        } else {
            for (i = priorityLevel.size() - 1; i >= 0; --i) {
                List<IProcessor> processors = processorsWithPriority.get(priorityLevel.get(i));
                RecoveryProcessConcurrentExecutor executor = null;
                executor = RecoveryProcessConcurrentExecutor.createExecutor(processors, (boolean)false);
                subProcessors.add(executor);
                iProcessors.addAll(processors);
            }
        }
        RecoveryProcessUtil.updateProgressRatio(iProcessors);
        RecoveryProcessSerialExecutor mainExecutor = RecoveryProcessSerialExecutor.createRecoveryProcessExecutor(subProcessors, (DrmEnumDefine.RecoveryPlanExecuteTypeE)type);
        if (null == mainExecutor) {
            logger.error((Object)"mainExecutor is null.");
            throw new LegoCheckedException(0x300001L);
        }
        return mainExecutor;
    }

    public static RecoveryProcessSerialExecutor createSerialExecutorWithSerialSubExecutor(Map<Integer, List<IProcessor>> processorsWithPriority, DrmEnumDefine.RecoveryPlanExecuteTypeE type, boolean isAsc) {
        int i;
        if (null == processorsWithPriority || null == type) {
            throw new LegoCheckedException(1073947393L);
        }
        ArrayList<IProcessor> iProcessors = new ArrayList<IProcessor>();
        ArrayList<RecoveryProcessSerialExecutor> subProcessors = new ArrayList<RecoveryProcessSerialExecutor>();
        ArrayList<Integer> priorityLevel = new ArrayList<Integer>();
        priorityLevel.addAll(processorsWithPriority.keySet());
        Collections.sort(priorityLevel, new Comparator<Integer>(){

            @Override
            public int compare(Integer arg0, Integer arg1) {
                return arg0.compareTo(arg1);
            }
        });
        if (isAsc) {
            for (i = 0; i < priorityLevel.size(); ++i) {
                List<IProcessor> processors = processorsWithPriority.get(priorityLevel.get(i));
                RecoveryProcessSerialExecutor executor = RecoveryProcessSerialExecutor.createRecoveryProcessExecutor(processors, (DrmEnumDefine.RecoveryPlanExecuteTypeE)type);
                subProcessors.add(executor);
                iProcessors.addAll(processors);
            }
        } else {
            for (i = priorityLevel.size() - 1; i >= 0; --i) {
                List<IProcessor> processors = processorsWithPriority.get(priorityLevel.get(i));
                RecoveryProcessSerialExecutor executor = RecoveryProcessSerialExecutor.createRecoveryProcessExecutor(processors, (DrmEnumDefine.RecoveryPlanExecuteTypeE)type);
                subProcessors.add(executor);
                iProcessors.addAll(processors);
            }
        }
        RecoveryProcessUtil.updateProgressRatio(iProcessors);
        RecoveryProcessSerialExecutor mainExecutor = RecoveryProcessSerialExecutor.createRecoveryProcessExecutor(subProcessors, (DrmEnumDefine.RecoveryPlanExecuteTypeE)type);
        return mainExecutor;
    }

    private static void updateProgressRatio(List<IProcessor> iProcessors) {
        ArrayList<RecoveryProcessor> recoveryProcessors = new ArrayList<RecoveryProcessor>();
        for (IProcessor processor : iProcessors) {
            if (!(processor instanceof RecoveryProcessor)) continue;
            recoveryProcessors.add((RecoveryProcessor)processor);
        }
        RecoveryServiceUtil.updateProgressRatio(recoveryProcessors);
    }

    public static boolean isAllSrcLunUnMapping(RecoveryProcessorContext context, Site remoteSite, Collection<RecoveryTask> recoveryTasks) {
        RecoveryPlan plan = context.getRecoveryPlan();
        Iterator iterator = plan.getProtectGroups().iterator();
        if (!iterator.hasNext()) {
            throw new LegoCheckedException(1073947393L);
        }
        HashSet<Integer> hyperMetreTypeSet = new HashSet<Integer>(Arrays.asList(18, 23, 31, 36, 35, 58, 59));
        PolicyTemplate template = ((ProtectGroup)iterator.next()).getTemplate();
        if (null != template && hyperMetreTypeSet.contains(template.getType())) {
            if (null == context.getProtectGroup()) {
                logger.error((Object)"The protectgroup in context is empty!");
                throw new LegoCheckedException(1073947394L);
            }
            return RecoveryProcessUtil.checkHyperMetroSrcLunUnMapping(remoteSite, context.getProtectGroup().getPolist());
        }
        HashMap<String, Set<String>> devAndLunMap = new HashMap<String, Set<String>>();
        for (RecoveryTask rt : recoveryTasks) {
            Map lunAndHostMap = rt.getLunAndHostMap();
            Map resourceAndTypeMap = rt.getResourceAndTypeMap();
            String srcDevId = rt.getSrcDeviceId();
            HashSet<String> srcLunIds = (HashSet<String>)devAndLunMap.get(srcDevId);
            if (null == srcLunIds) {
                srcLunIds = new HashSet<String>();
                devAndLunMap.put(srcDevId, srcLunIds);
            }
            for (String key : lunAndHostMap.keySet()) {
                if (DrmEnumDefine.AppType.NAS_FILESYSTEM.getValue() == ((Integer)resourceAndTypeMap.get(key)).intValue()) continue;
                String srcLunId = RecoveryProcessUtil.getSrcLunIdFromLunAndHostMapKey((String)key);
                srcLunIds.add(srcLunId);
            }
        }
        return RecoveryProcessUtil.isSrcLunsUnMapping(remoteSite, devAndLunMap);
    }

    private static boolean isSrcLunsUnMapping(Site remoteSite, Map<String, Set<String>> devAndLunMap) {
        boolean isSrcLunUnMap = false;
        for (Map.Entry<String, Set<String>> entry : devAndLunMap.entrySet()) {
            ArrayList<String> srcLunIds;
            String devId = entry.getKey();
            isSrcLunUnMap = RecoveryProcessUtil.isSrcLunUnMapping(remoteSite, devId, srcLunIds = new ArrayList<String>((Collection)entry.getValue()));
            if (isSrcLunUnMap) continue;
            return false;
        }
        return isSrcLunUnMap;
    }

    private static boolean checkHyperMetroSrcLunUnMapping(Site productionSite, Set<ProtectObject> protectObjects) {
        Set lunWwnSet = RecoveryProcessUtil.getAllWwn(protectObjects);
        ArrayList wwnList = new ArrayList(lunWwnSet);
        List lunList = StorageResourceServiceRouter.getInstance().getStorageResourcesByWwns(productionSite.getServerUuid(), wwnList, Lun.class);
        HashMap<String, Set<String>> devAndLunMap = new HashMap<String, Set<String>>();
        for (Lun lun : lunList) {
            HashSet<String> srcLunIds = (HashSet<String>)devAndLunMap.get(lun.getDevSn());
            if (null == srcLunIds) {
                srcLunIds = new HashSet<String>();
                devAndLunMap.put(lun.getDevSn(), srcLunIds);
            }
            srcLunIds.add(lun.getLunId());
        }
        return RecoveryProcessUtil.isSrcLunsUnMapping(productionSite, devAndLunMap);
    }

    public static boolean isAllSrcLunUnMapping(RecoveryProcessorContext context, Collection<RecoveryTask> recoveryTasks) {
        if (null == recoveryTasks) {
            throw new LegoCheckedException(-1L);
        }
        ProtectGroup protectGroup = context.getProtectGroup();
        if (protectGroup.getTemplate().getType() == 44) {
            return RecoveryProcessUtil.checkAirGapSrcLunUnMapping(protectGroup);
        }
        Map<String, Set<String>> devLunMap = RecoveryProcessUtil.getReplicaSourceMap(context);
        if (!VerifyUtil.isEmpty(devLunMap)) {
            return RecoveryProcessUtil.isReplicaSourceUnMapping(devLunMap);
        }
        HashSet<String> devSns = new HashSet<String>();
        HashSet<String> srcLunIds = new HashSet<String>();
        for (RecoveryTask recoveryTask : recoveryTasks) {
            Iterator iterator;
            devSns.add(recoveryTask.getSrcDeviceId());
            Set srcStorageIds = recoveryTask.getSrcStorageIds();
            if (VerifyUtil.isEmpty((Collection)srcStorageIds) || !(iterator = srcStorageIds.iterator()).hasNext()) continue;
            String srcLunId = (String)iterator.next();
            srcLunIds.add(srcLunId);
        }
        if (devSns.isEmpty() || devSns.size() > 1) {
            logger.error((Object)("Error: the source device amount:" + devSns.size()));
            throw new LegoCheckedException(-1L);
        }
        String srcDevSn = (String)CommonUtil.getFirstElement(devSns);
        ArrayList<String> lunIds = new ArrayList<String>(srcLunIds);
        return RecoveryProcessUtil.isSrcLunUnMapping(srcDevSn, lunIds);
    }

    private static Map<String, Set<String>> getReplicaSourceMap(RecoveryProcessorContext context) {
        HashMap<String, Set<String>> devLunMap = new HashMap<String, Set<String>>();
        if (VerifyUtil.isEmpty((Object)context)) {
            return devLunMap;
        }
        ProtectGroupReplica protectGroupReplica = context.getProtectGroupReplica();
        if (VerifyUtil.isEmpty((Object)protectGroupReplica)) {
            return devLunMap;
        }
        Set replicas = protectGroupReplica.getReplicas();
        if (VerifyUtil.isEmpty((Collection)replicas)) {
            return devLunMap;
        }
        HashSet<String> lunWwnSet = new HashSet<String>();
        for (ProtectObjectReplica protectObjectReplica : replicas) {
            Set storageInfos = protectObjectReplica.getStorageInfos();
            if (VerifyUtil.isEmpty((Collection)storageInfos)) continue;
            for (RelicaStorageInfo storageInfo : storageInfos) {
                String lunWwn = storageInfo.getProtectObjectStorageWwn();
                if (VerifyUtil.isEmpty((String)lunWwn)) {
                    logger.warn((Object)"Empty lunWwn, SrcStorageId=%s", new Object[]{storageInfo.getSrcStorageId()});
                    continue;
                }
                lunWwnSet.add(lunWwn);
                List resources = ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).getStorageResourceByWwn(new String[]{lunWwn});
                if (VerifyUtil.isEmpty((Collection)resources)) {
                    logger.error((Object)"Resources null, lunWwn=%s", new Object[]{lunWwn});
                    continue;
                }
                for (StorageResource resource : resources) {
                    String devSn = resource.getDevSn();
                    String lunId = resource.getResourceId();
                    HashSet<String> lunIdSet = (HashSet<String>)devLunMap.get(devSn);
                    if (VerifyUtil.isEmpty((Collection)lunIdSet)) {
                        lunIdSet = new HashSet<String>();
                        devLunMap.put(devSn, lunIdSet);
                    }
                    lunIdSet.add(lunId);
                }
            }
        }
        for (Map.Entry entry : devLunMap.entrySet()) {
            if (((Set)entry.getValue()).size() == lunWwnSet.size()) continue;
            logger.error((Object)"StorageInfos.size=%s, not equal lunIdSet.size=%s", new Object[]{lunWwnSet.size(), entry.getValue()});
            return new HashMap<String, Set<String>>();
        }
        return devLunMap;
    }

    private static boolean checkAirGapSrcLunUnMapping(ProtectGroup protectGroup) {
        ProtectGroupReplica tmpReplica = protectGroup.getAnyoneReplicationReplica();
        String metaData = tmpReplica.getPoReplicaMateData();
        Set<String> srcProviderSns = RecoveryProcessUtil.getValueByKey(metaData, "srcStorageProviderSN");
        Set<String> srcStorageIds = RecoveryProcessUtil.getValueByKey(metaData, "srcStorageId");
        Optional<String> opt = srcProviderSns.stream().filter(srcProviderSn -> !VerifyUtil.isEmpty((String)srcProviderSn)).findAny();
        if (!opt.isPresent()) {
            logger.error((Object)"Not find remote devSn for pgName: %s", new Object[]{protectGroup.getName()});
            return false;
        }
        String localDevSn = protectGroup.getPoProviderSN();
        String remoteDevSn = opt.get();
        IStoragePortLinksManager mgr = StoragePortLinksManagerProxy.getInstance().getStoragePortLinksMgrByDevId(localDevSn);
        List remoteDevices = mgr.getStorageRemoteDeviceByRemoteSn(localDevSn, remoteDevSn);
        for (RemoteLinkDevice remoteLinkDevice : remoteDevices) {
            boolean res = mgr.checkRemoteLunMappedByIds(localDevSn, remoteLinkDevice.getDeviceId(), new ArrayList<String>(srcStorageIds));
            if (!res) continue;
            return false;
        }
        return true;
    }

    private static Set<String> getValueByKey(String metaData, String key) {
        HashSet<String> res = new HashSet<String>();
        JSONArray jsonArray = JSONArray.fromObject((Object)metaData);
        for (Object obj : jsonArray) {
            JSONArray array = JSONObject.fromObject(obj).getJSONArray("storageInfos");
            Set<String> tmpSet = RecoveryProcessUtil.getString(key, array);
            if (CollectionUtils.isEmpty(tmpSet)) continue;
            res.addAll(tmpSet);
        }
        return res;
    }

    private static Set<String> getString(String key, JSONArray array) {
        HashSet<String> ret = new HashSet<String>();
        for (Object objReplica : array) {
            String value;
            JSONObject remoteJson = JSONObject.fromObject(objReplica).getJSONObject("RemoteStorageReplica");
            if (remoteJson == null || !remoteJson.containsKey((Object)key) || VerifyUtil.isEmpty((String)(value = remoteJson.getString(key)))) continue;
            ret.add(value);
        }
        return ret;
    }

    private static boolean isReplicaSourceUnMapping(Map<String, Set<String>> devLunMap) {
        for (Map.Entry<String, Set<String>> entry : devLunMap.entrySet()) {
            ArrayList<String> lunIds;
            String srcDevSn = entry.getKey();
            if (RecoveryProcessUtil.isSrcLunUnMapping(srcDevSn, lunIds = new ArrayList<String>((Collection)entry.getValue()))) continue;
            return false;
        }
        return true;
    }

    public static Set<String> getAllSecondaryLunWwn(ProtectGroup protectGroup) {
        return RecoveryProcessUtil.getSecondaryLunWwn(protectGroup, null);
    }

    public static Set<String> getSecondaryLunWwn(ProtectGroup protectGroup, Set<String> secondarySites) {
        HashSet<String> allWwn = new HashSet<String>();
        ArrayList resourceIds = new ArrayList();
        String deviceSn = null;
        ArrayList replicationRelations = new ArrayList();
        Map replicationRelationBoMap = protectGroup.getAllReplicationRelation();
        Set entrySet = replicationRelationBoMap.entrySet();
        for (Map.Entry entry : entrySet) {
            if (!VerifyUtil.isEmpty(secondarySites) && !secondarySites.contains(entry.getKey())) continue;
            replicationRelations.addAll((Collection)entry.getValue());
        }
        for (ReplicationRelationBo rep : replicationRelations) {
            deviceSn = rep.getTgtDeviceSn();
            resourceIds.addAll(rep.getTgtLuns().values());
        }
        if (null == deviceSn || VerifyUtil.isEmpty(resourceIds)) {
            logger.error((Object)("ProtectGroup's ReplicationRelation info is empty, pgId:" + protectGroup.getUuid()), 90160758786897L);
            throw new LegoCheckedException(1073948453L);
        }
        if (RecoveryProcessUtil.isProtectGroupUseNasFileSystem((ProtectGroup)protectGroup)) {
            allWwn.addAll(resourceIds);
            return allWwn;
        }
        List targetLuns = ((IStorageResourceService)ServiceLocator.getInstance().getService(IStorageResourceService.class)).getStorageResources(deviceSn, resourceIds, Lun.class);
        if (!VerifyUtil.isEmpty((Collection)targetLuns)) {
            for (Lun lun : targetLuns) {
                allWwn.add(lun.getWwn());
            }
        }
        return allWwn;
    }

    public static String getPairStr(HyperMetroPair pair) {
        StringBuilder sb = new StringBuilder();
        String uuid = pair.getUuid();
        String resourceWwn = pair.getResourceWwn();
        String localObjId = pair.getLocalObjId();
        String remoteObjId = pair.getRemoteObjId();
        String remoteDevSn = pair.getRemoteDevSn();
        sb.append("[");
        sb.append("pairUuid:").append(uuid).append(",").append("runningStatus:").append(pair.getRunningState()).append(",").append("healthStatus:").append(pair.getHealthState()).append(",").append("syncDirection:").append(VerifyUtil.isEmpty((Object)pair.getSyncDirection()) ? "empty" : pair.getSyncDirection().toString()).append(",").append("resourceWwn:").append(resourceWwn).append(",").append("localObjId:").append(localObjId).append(",").append("remoteObjId:").append(remoteObjId).append(",").append("remoteDevSn:").append(remoteDevSn).append("]");
        return sb.toString();
    }

    public static String getConsistentGroupStr(HyperMetroConsistentGroup group) {
        StringBuilder sb = new StringBuilder();
        String uuid = group.getUuid();
        String devSn = group.getDevSn();
        sb.append("[");
        sb.append("pairUuid:").append(uuid).append(",").append("runningStatus:").append(group.getRunningState()).append(",").append("healthStatus:").append(group.getHealthState()).append(",").append("syncDirection:").append(VerifyUtil.isEmpty((Object)group.getSyncDirection()) ? "empty" : group.getSyncDirection().toString()).append(",").append("DevSn:").append(devSn).append("]");
        return sb.toString();
    }

    public static void presetCheck(RecoveryProcessorContext context, DrmEnumDefine.RecoveryPlanExecuteTypeE procType) {
        RecoveryProcessCheckerManager rpCheckerMgr = RecoveryProcessCheckerManager.getInstance();
        List recoveryProcessCheckers = rpCheckerMgr.getRecoveryProcessCheckers();
        if (VerifyUtil.isEmpty((Collection)recoveryProcessCheckers)) {
            logger.error((Object)"There is no recovery process checkers.", 90160758784001L);
            throw new LegoCheckedException(1073947394L);
        }
        for (IRecoveryProcessChecker checker : recoveryProcessCheckers) {
            checker.check(context, procType);
        }
    }

    public static DrmEnumDefine.RecoveryPlanExecuteTypeE getProcType(String procType) {
        if (procType.equalsIgnoreCase(DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY.name())) {
            return DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY;
        }
        if (procType.equalsIgnoreCase(DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.name())) {
            return DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION;
        }
        if (procType.equalsIgnoreCase(DrmEnumDefine.RecoveryPlanExecuteTypeE.HOT_MIGRATION.name())) {
            return DrmEnumDefine.RecoveryPlanExecuteTypeE.HOT_MIGRATION;
        }
        if (procType.equalsIgnoreCase(DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.name())) {
            return DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING;
        }
        if (procType.equalsIgnoreCase(DrmEnumDefine.RecoveryPlanExecuteTypeE.CLEAN_DRILLING.name())) {
            return DrmEnumDefine.RecoveryPlanExecuteTypeE.CLEAN_DRILLING;
        }
        if (procType.equalsIgnoreCase(DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.name())) {
            return DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT;
        }
        if (procType.equalsIgnoreCase(DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK.name())) {
            return DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK;
        }
        if (procType.equalsIgnoreCase(DrmEnumDefine.RecoveryPlanExecuteTypeE.SWAP.name())) {
            return DrmEnumDefine.RecoveryPlanExecuteTypeE.SWAP;
        }
        if (procType.equalsIgnoreCase(DrmEnumDefine.RecoveryPlanExecuteTypeE.MOUNT_REPLICA.name())) {
            return DrmEnumDefine.RecoveryPlanExecuteTypeE.MOUNT_REPLICA;
        }
        return DrmEnumDefine.RecoveryPlanExecuteTypeE.UMOUNT_REPLICA;
    }

    public static boolean isSrcLunUnMapping(Site remoteSite, String srcDeviceId, List<String> srcLunIds) {
        if (null == remoteSite || null == srcDeviceId || VerifyUtil.isEmpty(srcLunIds)) {
            logger.error((Object)"Invalid parameters. srcDeviceId=%s, srcLunIds=%s", new Object[]{srcDeviceId, srcLunIds});
            throw new LegoCheckedException(1073947393L);
        }
        return RecoveryProcessUtil.isSrcLunUnMapping(srcDeviceId, srcLunIds);
    }

    public static ProtectGroupReplica getProtectGroupReplicaBySiteId(ProtectGroup protectGroup, String disasterSiteId) {
        if (null == protectGroup || VerifyUtil.isEmpty((Collection)protectGroup.getReplicaList()) || VerifyUtil.isEmpty((String)disasterSiteId)) {
            logger.error((Object)"Invalid parameters.");
            return null;
        }
        Set pgReplicas = protectGroup.getReplicaList();
        for (ProtectGroupReplica pgReplica : pgReplicas) {
            List siteInfoList;
            Set siteIdSet;
            String siteInfoListStr;
            if (ProtectGroupUtil.isLocalStorageReplica((ProtectGroupReplica)pgReplica)) continue;
            if (pgReplica.getRecoverySite().equals(disasterSiteId)) {
                return pgReplica;
            }
            if (20 == protectGroup.getTemplate().getType() || 24 == protectGroup.getTemplate().getType() || 27 == protectGroup.getTemplate().getType() || 32 == protectGroup.getTemplate().getType()) {
                return pgReplica;
            }
            if (!PolicyTemplateType.REP_4DC_POLICYTEMPLATE.contains(protectGroup.getTemplate().getType()) || null == (siteInfoListStr = (String)protectGroup.getProps().get("PROP_KEY_SITE_INFO")) || null == (siteIdSet = (siteInfoList = JSONArray.toCollection((JSONArray)JSONArray.fromObject((Object)siteInfoListStr), SiteInfo.class)).stream().filter(siteInfo -> siteInfo.getSiteIdSet().contains(disasterSiteId)).findFirst().get().getSiteIdSet()) || !siteIdSet.contains(pgReplica.getRecoverySite())) continue;
            return pgReplica;
        }
        return null;
    }

    public static String getDisterSiteId(String defaultSiteId, ProtectGroup pg) {
        ProtectGroupReplica rep = RecoveryProcessUtil.getProtectGroupReplicaBySiteId(pg, defaultSiteId);
        if (null != rep) {
            return rep.getRecoverySite();
        }
        return defaultSiteId;
    }

    public static ProtectGroupReplica getProtectGroupReplicaByReplicaId(ProtectGroup protectGroup, String replicaId) {
        if (null == protectGroup || VerifyUtil.isEmpty((String)replicaId)) {
            return null;
        }
        ProtectGroupReplica replica = SnapshotScheduleUtil.getProtectGroupReplica(replicaId);
        if (null != replica) {
            return replica;
        }
        Set pgReplicas = protectGroup.getReplicaList();
        if (null == pgReplicas) {
            return null;
        }
        for (ProtectGroupReplica pgReplica : pgReplicas) {
            if (!pgReplica.getId().equals(replicaId)) continue;
            return pgReplica;
        }
        return null;
    }

    private static boolean isSrcLunUnMapping(String srcDeviceId, List<String> lunIds) {
        try {
            List luns = ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).queryLunByDevSnAndLunIds(srcDeviceId, lunIds);
            return RecoveryProcessUtil.isLunUnMapping(lunIds, luns);
        }
        catch (Exception e) {
            logger.error((Object)("query SrcLunUnMapping Local error:" + srcDeviceId + "-" + lunIds + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            return false;
        }
    }

    private static boolean isLunUnMapping(List<String> lunIds, List<Lun> luns) {
        if (VerifyUtil.isEmpty(luns)) {
            logger.error((Object)"LUNs quered is empty, return isLunUnMapping is false", 90160758784001L);
            return false;
        }
        if (luns.size() != lunIds.size()) {
            logger.error((Object)"LUNs quered is not equals to the lunID amount, return isLunUnMapping is false", 90160758784001L);
            return false;
        }
        for (Lun lun : luns) {
            boolean isMapped = lun.getMapped();
            if (!isMapped) continue;
            logger.error((Object)("The lun is mapped, and ID: " + lun.getLunId() + ",name: " + lun.getName()), 90160758784001L);
            return false;
        }
        return true;
    }

    public static String getVstoreId(ProtectGroup pg) {
        String vStoreId = null;
        if (null != pg && null != pg.getPolist() && pg.getPolist().size() > 0) {
            ProtectObject protectObject = (ProtectObject)pg.getPolist().iterator().next();
            vStoreId = RecoveryProcessUtil.getVstoreId(protectObject);
        }
        return vStoreId;
    }

    private static String getVstoreId(ProtectObject protectObject) {
        String vStoreId = null;
        if (null != protectObject && null != protectObject.getUsedStorageResourceSet() && protectObject.getUsedStorageResourceSet().size() > 0) {
            ProtectObjectStorageInfo protectObjectStorageInfo = (ProtectObjectStorageInfo)protectObject.getUsedStorageResourceSet().iterator().next();
            vStoreId = null != protectObjectStorageInfo ? protectObjectStorageInfo.getVstoreId() : null;
        }
        return vStoreId;
    }

    public static String getVstoreIdByResourceId(String devSn, String resourceId) {
        IMoDao moDao = CommonDAOLocator.getMoDao();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("devSn", devSn);
        props.put("resourceId", resourceId);
        List result = moDao.findMoBy(NasFileSystem.class, props);
        if (!VerifyUtil.isEmpty((Collection)result)) {
            return ((NasFileSystem)result.iterator().next()).getVstoreId();
        }
        return null;
    }

    public static Collection<RecoveryTask> filterRecoveryTask(RecoveryProcessorContext context, String recoveryTasksKey) {
        RecoveryProcessUtil.checkContext(context);
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        RecoveryProcessUtil.checkRecoveryPlan(recoveryPlan);
        Iterator<ProtectGroup> iterator = recoveryPlan.getProtectGroups().iterator();
        RecoveryProcessUtil.checkProtectGroup(iterator);
        Collection candidates = (Collection)context.getAttribute(recoveryTasksKey);
        boolean ring = candidates.stream().anyMatch(task -> Objects.nonNull(task.getParams()) && task.getParams().containsKey(STANDBY));
        if (ring) {
            return RecoveryProcessUtil.getNormalReplicationTask(candidates);
        }
        return candidates;
    }

    private static Collection<RecoveryTask> getNormalReplicationTask(Collection<RecoveryTask> candidates) {
        ArrayList<RecoveryTask> recoverTasks = new ArrayList<RecoveryTask>();
        if (VerifyUtil.isEmpty(candidates)) {
            return recoverTasks;
        }
        for (RecoveryTask recoveryTask : candidates) {
            Map params = recoveryTask.getParams();
            if (params == null) {
                recoverTasks.add(recoveryTask);
                continue;
            }
            Object allRelatedReplicationPairs = params.get(ALL_RELATED_REPLICATION_PAIRS);
            if (!(allRelatedReplicationPairs instanceof Collection)) {
                return recoverTasks;
            }
            Collection collection = (Collection)allRelatedReplicationPairs;
            RecoveryProcessUtil.checkPairStatusConsistentByRingID(collection);
            if (((Boolean)params.get(STANDBY)).booleanValue()) continue;
            recoverTasks.add(recoveryTask);
        }
        return recoverTasks;
    }

    private static void checkPairStatusConsistentByRingID(Collection<?> collection) {
        HashMap<String, ArrayList<ReplicationPair>> ringPairs = new HashMap<String, ArrayList<ReplicationPair>>();
        for (Object item : collection) {
            if (!ReplicationPair.class.isInstance(item)) {
                logger.error((Object)"Object item is not ReplicationPair", 1073947393L);
                throw new LegoCheckedException(1073947393L);
            }
            ReplicationPair replicaPair = (ReplicationPair)ReplicationPair.class.cast(item);
            if (replicaPair.getRepTgtLuns() == null || replicaPair.getRepTgtLuns().isEmpty()) {
                logger.error((Object)"replicaPair have no target lun.", 1073947393L);
                throw new LegoCheckedException(1073947393L);
            }
            String pairKey = replicaPair.getDrRingId() + ":" + replicaPair.getSrcDevSN() + ":" + ((ReplicationTargetLun)replicaPair.getRepTgtLuns().get(0)).getTgtDevSN();
            ArrayList<ReplicationPair> pairs = (ArrayList<ReplicationPair>)ringPairs.get(pairKey);
            if (pairs == null || pairs.isEmpty()) {
                pairs = new ArrayList<ReplicationPair>();
                ringPairs.put(pairKey, pairs);
            }
            pairs.add(replicaPair);
        }
        for (Map.Entry entry : ringPairs.entrySet()) {
            String originState = "";
            for (ReplicationPair pair : (List)entry.getValue()) {
                String runningState = RecoveryProcessUtil.getReplicationPairRunningStatus(pair);
                if (originState.isEmpty()) {
                    originState = runningState;
                    continue;
                }
                if (originState.equals(runningState) || !originState.equals(STANDBY) && !runningState.equals(STANDBY)) continue;
                logger.error((Object)("Ring(" + (String)entry.getKey() + ")'s replcationpair(" + pair.getId() + ") running status is not as same as others."), 1073947393L);
                throw new LegoCheckedException(1073947393L);
            }
        }
    }

    private static String getReplicationPairRunningStatus(ReplicationPair pair) {
        String pairStatus = null;
        if (pair == null) {
            return pairStatus;
        }
        String runningState = pair.getRunningState();
        if (runningState != null) {
            pairStatus = runningState;
            return pairStatus;
        }
        List targets = pair.getRepTgtLuns();
        if (targets == null || targets.size() != 1) {
            return pairStatus;
        }
        Integer status = ((ReplicationTargetLun)targets.get(0)).getPairStatus();
        return status != null ? status.toString() : pairStatus;
    }

    private static void checkProtectGroup(Iterator<ProtectGroup> iterator) {
        if (!iterator.hasNext()) {
            logger.error((Object)"iterator is empty");
            throw new LegoCheckedException(1073947393L);
        }
    }

    private static void checkRecoveryPlan(RecoveryPlan recoveryPlan) {
        if (null == recoveryPlan || VerifyUtil.isEmpty((Collection)recoveryPlan.getProtectGroups())) {
            logger.error((Object)"recoveryPlan is null", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    private static void checkContext(RecoveryProcessorContext context) {
        if (null == context) {
            logger.error((Object)"context is null", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
    }
}

