/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.site.service.impl;

import com.huawei.ism.array.sdk.model.HvsStorage;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.AirGapLinkPortUtil;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.ManagementServer;
import com.huawei.ism.drm.site.sdk.service.IManagementServerBaseService;
import com.huawei.ism.drm.site.service.impl.AbstractManagementServerService;
import com.huawei.ism.drm.storage.manager.proxy.StoragePortLinksManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStoragePortLinksManager;
import com.huawei.ism.drm.storage.sdk.model.RemoteLinkDevice;
import com.huawei.ism.drm.storage.sdk.model.ResourceTimeWindow;
import com.huawei.ism.drm.storage.sdk.model.StorageLinkPort;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.cbb.resource.sdk.service.ILocalResourceService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.common.ServiceProvider;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.dao.DataAccessException;

@Service(name="com.huawei.ism.drm.site.sdk.service.IManagementServerBaseService", desc="", interfaceClass=IManagementServerBaseService.class)
public class ManagementServerBaseServiceImpl
extends AbstractManagementServerService
implements IManagementServerBaseService {
    private static final Log LOG = LogFactory.getInstance(ManagementServerBaseServiceImpl.class);

    public void updateServer(ManagementServer server) {
        if (server == null) {
            LOG.error((Object)"Parameter is null.");
            throw new LegoCheckedException(1073947393L);
        }
        ManagementServer replica = this.getServer(server.getUuid());
        if (replica == null) {
            LOG.error((Object)"Server does not exist: %s", new Object[]{server.getUuid()});
            throw new LegoCheckedException(2117645L);
        }
        this.updateBasicInfo(replica, server.getName());
        try {
            CommonDAOLocator.getMoDao().getHibernateTemplate().update((Object)replica);
        }
        catch (DataAccessException e) {
            throw new LegoCheckedException("Update server info failed.", (Throwable)e);
        }
    }

    private void updateBasicInfo(ManagementServer replica, String newName) {
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)newName) || newName.equals(replica.getName())) {
            LOG.info((Object)"BaseInfo not changed.");
            return;
        }
        this.validateName(newName);
        replica.setName(newName);
    }

    public List<ManagementServer> getServers() {
        ArrayList<ManagementServer> servers = new ArrayList<ManagementServer>();
        servers.add(this.getServerInfo());
        return servers;
    }

    public void handleAirGapResourceDiscovery(String ipAddress) {
        ILocalResourceService resourceService = ServiceProvider.getLocalResourceService();
        if (resourceService == null) {
            LOG.info((Object)"Get IResourceService null.");
            return;
        }
        ManagedObject managedObject = resourceService.getMoByIp(ipAddress);
        if (!(managedObject instanceof HvsStorage)) {
            LOG.info((Object)"Not discover storage, return.");
            return;
        }
        HvsStorage storage = (HvsStorage)managedObject;
        String devSn = storage.getSn();
        if (VerifyUtil.isEmpty((String)devSn)) {
            LOG.error((Object)"Not find devSn.");
            throw new LegoCheckedException(1073947394L);
        }
        IStoragePortLinksManager mgr = StoragePortLinksManagerProxy.getInstance().getStoragePortLinksMgrByDevId(devSn);
        List remoteDevices = mgr.getStorageRemoteDevice(devSn);
        if (CollectionUtils.isEmpty((Collection)remoteDevices)) {
            LOG.error((Object)"Not remote device info, no need to disable. devSn: %s", new Object[]{devSn});
            return;
        }
        this.addTimeWindowByDeviceId(devSn, mgr, remoteDevices);
        this.disableAndSaveLinkPorts(devSn, mgr, remoteDevices);
    }

    private void addTimeWindowByDeviceId(String devSn, IStoragePortLinksManager mgr, List<RemoteLinkDevice> remoteDevices) {
        IResourceService resourceService = (IResourceService)ServiceLocator.getInstance().getService(IResourceService.class);
        for (RemoteLinkDevice remoteDevice : remoteDevices) {
            LOG.info((Object)"Begin to add time window. devSn: %s, deviceId: %s", new Object[]{devSn, remoteDevice.getDeviceId()});
            ResourceTimeWindow timeWindow = ResourceTimeWindow.instance((String)devSn, (RemoteLinkDevice)remoteDevice);
            resourceService.addResourceTimeWindow(timeWindow);
            LOG.info((Object)"Add timeWindow: %s success.", new Object[]{timeWindow.toString()});
        }
        for (RemoteLinkDevice remoteDevice : remoteDevices) {
            this.doIsolateAlarm(devSn, mgr, remoteDevice);
        }
    }

    private void disableAndSaveLinkPorts(String devSn, IStoragePortLinksManager mgr, List<RemoteLinkDevice> remoteDevices) {
        ArrayList linkPorts = new ArrayList();
        for (RemoteLinkDevice remoteDevice : remoteDevices) {
            List tmpPorts = remoteDevice.getLinkPorts();
            linkPorts.addAll(tmpPorts);
        }
        HashSet<String> portIds = new HashSet<String>();
        for (StorageLinkPort port : linkPorts) {
            String portId = port.getPortId();
            if (portIds.contains(portId)) continue;
            portIds.add(portId);
            LOG.info((Object)"Begin to disable portName: %s", new Object[]{port.getPortName()});
            if (port.getEnable().booleanValue() || port.getOperationalStatus().booleanValue()) {
                mgr.disableStoragePort(devSn, port);
                port.setEnable(Boolean.valueOf(false));
                port.setOperationalStatus(Boolean.valueOf(false));
            }
            port.setTime(System.currentTimeMillis());
            try {
                CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)port);
            }
            catch (DataAccessException e) {
                LOG.error((Object)"Error to save portInfo, portName: %s, msg: %s", new Object[]{port.getPortName(), e.getMessage()});
                throw new LegoCheckedException(-1L);
            }
            LOG.info((Object)"Save port: %s success!", new Object[]{port.getPortName()});
        }
    }

    private void doIsolateAlarm(String devSn, IStoragePortLinksManager mgr, RemoteLinkDevice remoteDevice) {
        AirGapLinkPortUtil util = AirGapLinkPortUtil.getInstance();
        try {
            remoteDevice.setNetIsolation(1);
            LOG.info((Object)"Begin to isolate alarm. remoteWWn: %s", new Object[]{remoteDevice.getRemoteWwn()});
            mgr.isolateAlarm(devSn, remoteDevice);
            util.updateIsolateAlarmFlag(devSn, remoteDevice.getRemoteWwn(), false);
        }
        catch (Exception e) {
            LOG.error((Object)"remoteEsn: %s remote device abnormal, Need to isolate again. msg: %s", new Object[]{remoteDevice.getEsn(), e.getMessage()});
            util.updateIsolateAlarmFlag(devSn, remoteDevice.getRemoteWwn(), true);
        }
        String[] params = new String[]{remoteDevice.getEsn() + remoteDevice.getRemoteName()};
        AlarmReporter.restoreAlarm((String)"0x3230068", (String[])params);
    }
}

