/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.site.service.impl;

import com.huawei.ism.cbb.base.dao.IBaseDao;
import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskHandler;
import com.huawei.ism.cbb.base.task.BackTaskUtil;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.security.sdk.service.IBizScopeManager;
import com.huawei.ism.drm.site.sdk.model.ManagementServer;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.IManagementServerService;
import com.huawei.ism.drm.site.sdk.service.ISiteBaseService;
import com.huawei.ism.drm.site.sdk.service.ISiteCheckService;
import com.huawei.ism.drm.site.sdk.service.ISiteResourceService;
import com.huawei.ism.drm.site.service.impl.AbstractSiteService;
import com.huawei.ism.drm.site.service.impl.DeleteSiteTransCallbackImpl;
import com.huawei.ism.drm.site.service.impl.RefreshSiteBackTask;
import com.huawei.ism.drm.site.util.SiteResourceServiceProxy;
import com.huawei.lego.cbb.backtask.sdk.model.BackTask;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.query.Query;
import org.springframework.transaction.support.TransactionCallback;

@Service(name="com.huawei.ism.drm.site.sdk.service.ISiteBaseService", desc="", interfaceClass=ISiteBaseService.class)
public class SiteBaseServiceImpl
extends AbstractSiteService
implements ISiteBaseService {
    private static Log logger = LogFactory.getInstance(SiteBaseServiceImpl.class);
    private static final List<String> SUPPORTED_KEY = Arrays.asList("ism.deviceType.cloudVault.mainType", "ism.deviceType.cloudServer.mainType");
    private List<ISiteCheckService> siteCheckServices = new ArrayList<ISiteCheckService>();

    protected void deleteSiteFromDB(Site site) {
        IBaseDao baseDao = CommonDAOLocator.getBaseDao();
        if (0 == site.getSiteType() && !site.getIsCloudSite().booleanValue()) {
            baseDao.getHibernateTemplate().delete((Object)site);
            return;
        }
        DeleteSiteTransCallbackImpl callBack = new DeleteSiteTransCallbackImpl(baseDao, site);
        baseDao.getTransactionTemplate().execute((TransactionCallback)callBack);
        ((IBizScopeManager)ServiceLocator.getInstance().getService(IBizScopeManager.class)).deleteScopeObject(site.getSiteId());
    }

    public String createSite(Site site, Long userId) {
        String serverUuid = site.getServerUuid();
        ManagementServer server = ((IManagementServerService)ServiceLocator.getInstance().getService(IManagementServerService.class)).getServer(serverUuid);
        if (null == server) {
            throw new LegoCheckedException(2117645L);
        }
        if (0 == server.getServerType()) {
            if (this.isSiteExist(site.getName())) {
                throw new LegoCheckedException(1073947392L);
            }
            this.isExceedMaxSiteNum(0);
            site.setSiteId(UUIDGenerator.getUUID());
            site.setSiteType(0);
            CommonDAOLocator.getBaseDao().getHibernateTemplate().save((Object)site);
            this.grandSiteScope(userId, site.getSiteId());
            if (site.getIsCloudSite().booleanValue()) {
                this.refreshSiteByBackTask(site, "System");
            }
            return site.getSiteId();
        }
        return "";
    }

    public void refreshSiteByBackTask(Site site, String userName) {
        BackTask bt = BackTaskUtil.buildBackTask((String)site.getName(), (String)"ism.srm.site.refresh.operationName", (String)userName, (String)"", null);
        RefreshSiteBackTask task = new RefreshSiteBackTask(site, bt, true);
        BackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
    }

    public void updateSite(Site site, String siteName, Long userId) {
        if (null == site) {
            throw new LegoCheckedException(1073947393L);
        }
        Site replica = this.getSite(site.getSiteId());
        if (null == replica) {
            throw new LegoCheckedException(1073947394L);
        }
        String oldName = replica.getName();
        String oldDesc = replica.getDescription();
        String newName = site.getName();
        String newDesc = site.getDescription();
        Boolean regionIdUpdateFlag = false;
        if (!VerifyUtil.isEmpty((String)site.getRegionId())) {
            regionIdUpdateFlag = this.isDistinctParam(site.getRegionId(), replica.getRegionId());
        }
        if (0 == site.getSiteType() && null != newName && !newName.equals(oldName)) {
            this.validateSiteName(newName);
            replica.setName(newName);
        }
        if (null != newDesc && !newDesc.equals(oldDesc)) {
            this.validateSiteDesc(newDesc);
            replica.setDescription(site.getDescription());
        }
        this.updateSiteDataBase(site, replica, oldName, newName, regionIdUpdateFlag);
    }

    private void updateSiteDataBase(Site site, Site replica, String oldName, String newName, Boolean regionIdUpdateFlag) {
        Session session = null;
        Transaction transaction = null;
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            if (!VerifyUtil.isEmpty((Object)session)) {
                transaction = session.beginTransaction();
                CommonDAOLocator.getBaseDao().getHibernateTemplate().update((Object)replica);
                Query query = session.createQuery("update ProtectGroup pg set pg.productSiteName = ?0 where pg.productSiteName=?1");
                query.setParameter(0, (Object)newName);
                query.setParameter(1, (Object)oldName);
                query.executeUpdate();
                if (site.getIsCloudSite().booleanValue() && regionIdUpdateFlag.booleanValue()) {
                    this.refreshSiteByBackTask(replica, "System");
                }
                transaction.commit();
            }
        }
        catch (Exception e) {
            try {
                DBOperationUtil.rollbackSession((Session)session);
                logger.error((Object)("update site failed!" + ExceptionUtil.getErrorMessage((Throwable)e)), -1L);
                throw e;
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
        }
        DBOperationUtil.closeSession((Session)session);
    }

    public Map<String, Integer> sum(String siteId, Long userId) {
        logger.debug((Object)("siteId=" + siteId));
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        Site site = null;
        try {
            site = (Site)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(Site.class, (Serializable)((Object)siteId));
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("Unable to get site:" + siteId), (long)-1L, (String[])new String[0], (Log)logger);
        }
        if (VerifyUtil.isEmpty((Object)site)) {
            return result;
        }
        for (String key : SiteResourceServiceProxy.getInstance().getAllSiteResourceServiceKey()) {
            if (SUPPORTED_KEY.contains(key)) continue;
            ISiteResourceService service = SiteResourceServiceProxy.getInstance().getSiteResourceService(key);
            result.put(key, service.sum(siteId, userId));
        }
        return result;
    }

    public void checkSiteCanDelete(Site site) {
        List resources;
        String siteId = site.getSiteId();
        if (0 == site.getSiteType() && !site.getIsCloudSite().booleanValue() && !VerifyUtil.isEmpty((Collection)(resources = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from DrResource where siteId = ?", new Object[]{site.getSiteId()})))) {
            logger.error((Object)"resources is empty.");
            throw new LegoCheckedException(1073947650L);
        }
        List pgReplicas = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from ProtectGroupReplica where recoverySite = ?", (Object[])new String[]{siteId});
        if (!VerifyUtil.isEmpty((Collection)pgReplicas)) {
            throw new LegoCheckedException(1073947656L);
        }
        List pgs = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from ProtectGroup where productSiteId = ?", (Object[])new String[]{siteId});
        if (!VerifyUtil.isEmpty((Collection)pgs)) {
            logger.error((Object)"pgs is empty.");
            throw new LegoCheckedException(1073947656L);
        }
        for (ISiteCheckService checkService : this.siteCheckServices) {
            checkService.checkCanDeleteSite(siteId);
        }
    }
}

