/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.site.service.impl;

import com.huawei.ism.cbb.base.dao.IBaseDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.commons.DeviceOperationLock;
import com.huawei.ism.cbb.discover.commons.OperationLock;
import com.huawei.ism.drm.security.sdk.service.IBizScopeManager;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.site.service.impl.BatchResultUtil;
import com.huawei.ism.drm.site.service.impl.RefreshOurSiteCallbackImpl;
import com.huawei.ism.drm.site.service.impl.SiteBaseServiceImpl;
import com.huawei.ism.drm.site.util.SiteResourceServiceProxy;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.comm.BatchOperationResult;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.springframework.dao.DataAccessException;
import org.springframework.transaction.support.TransactionCallback;

@Service(name="com.huawei.ism.drm.site.sdk.service.ISiteService", desc="", interfaceClass=ISiteService.class)
public class SiteServiceImpl
extends SiteBaseServiceImpl
implements ISiteService {
    private static Log logger = LogFactory.getInstance(SiteServiceImpl.class);

    public void deleteSite(String siteId) {
        Site site = (Site)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(Site.class, (Serializable)((Object)siteId));
        if (null == site) {
            throw new LegoCheckedException(201L);
        }
        OperationLock opLock = DeviceOperationLock.getLock((String)siteId);
        if (!opLock.tryLock()) {
            logger.warn((Object)("Someone[" + opLock.getOwnerName() + "] has locked site, siteId=" + siteId), 90160758784000L);
            throw new LegoCheckedException(102401L);
        }
        logger.info((Object)("Get site operation lock ... siteId=" + siteId), 90160758784000L);
        try {
            this.checkSiteCanDelete(site);
            this.deleteSiteFromDB(site);
        }
        catch (DataAccessException e) {
            logger.error((Object)"delete site set error", (Throwable)e, 90160758786872L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        finally {
            opLock.unTryLock();
            logger.info((Object)("Release site operation lock ... siteId=" + siteId), 90160758784000L);
        }
    }

    private Site getSite(String siteId, String spiltLabel) {
        if (VerifyUtil.isEmpty((String)siteId)) {
            logger.error((Object)("siteId=" + siteId), 90160758786876L);
            throw new LegoCheckedException(1073947393L);
        }
        Site site = null;
        ArrayList<String> siteIdSet = new ArrayList<String>();
        if (!VerifyUtil.isEmpty((String)spiltLabel)) {
            String[] sites = siteId.split(spiltLabel);
            if (sites.length >= 2) {
                for (String siteid : sites) {
                    siteIdSet.add(siteid);
                }
                site = this.getCombainSite(siteIdSet, spiltLabel);
            } else {
                site = this.getSite(siteId);
            }
            return site;
        }
        try {
            site = (Site)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(Site.class, (Serializable)((Object)siteId));
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("unable to get site:" + siteId), (long)-1L, (String[])new String[0], (Log)logger);
        }
        return site;
    }

    private Site getCombainSite(List<String> siteIdSet, String spiltLabel) {
        Site site = null;
        StringBuffer name = new StringBuffer();
        for (String siteId : siteIdSet) {
            if (name.length() > 0) {
                name.append(spiltLabel);
            }
            if (null == (site = this.getSite(siteId))) continue;
            name.append(site.getName());
        }
        if (null != site) {
            site.setName(name.toString());
        }
        return site;
    }

    public Site getSiteById(String siteId, Long userId) {
        logger.debug((Object)("siteId=" + siteId));
        Site site = this.getSite(siteId);
        if (null == site) {
            return null;
        }
        List filterSites = new ArrayList<Site>(1);
        filterSites.add(site);
        filterSites = ((IBizScopeManager)ServiceLocator.getInstance().getService(IBizScopeManager.class)).filterObject(userId, filterSites);
        if (VerifyUtil.isEmpty(filterSites)) {
            return null;
        }
        return (Site)filterSites.get(0);
    }

    public Site getSiteById(String siteId) {
        logger.debug((Object)("siteId=" + siteId));
        Site site = this.getSite(siteId);
        return site;
    }

    public Site getCombinaSiteById(String siteId, String spiltLabel) {
        return this.getSite(siteId, spiltLabel);
    }

    public synchronized void refreshSite(Site site) {
        this.checkSiteParam(site);
        logger.debug((Object)("begin to refresh site:" + site.getUuid()), 90160758786877L);
        Site siteInDB = this.getSite(site.getSiteId());
        if (null == siteInDB) {
            logger.error((Object)("Site not exist, siteId=" + site.getSiteId()), 90160758784001L);
            throw new LegoCheckedException(1073947394L);
        }
        try {
            if (site.getIsCloudSite().booleanValue()) {
                this.refreshOurSite(site);
            }
        }
        catch (LegoCheckedException ex) {
            logger.error((Object)("failed to poll site:" + site.getSiteId()), (Throwable)ex, 90160758786878L);
            throw ex;
        }
        catch (Exception ex) {
            ExceptionUtil.rethrowException((Throwable)ex, (String)("Exception happend,failed to poll site:" + site.getSiteId()), (long)1053L, (String[])new String[0], (Log)logger);
        }
        logger.debug((Object)("end to poll site:" + site.getSiteId()), 90160758786877L);
    }

    private void refreshOurSite(Site site) {
        if (!site.getIsCloudSite().booleanValue()) {
            logger.info((Object)("site is not a remote site, siteId=" + site.getSiteId()));
            return;
        }
        IBaseDao baseDao = CommonDAOLocator.getBaseDao();
        RefreshOurSiteCallbackImpl callBack = new RefreshOurSiteCallbackImpl(site);
        baseDao.getTransactionTemplate().execute((TransactionCallback)callBack);
    }

    public BatchOperationResult checkResourceUsed(Long userId, List<Long> moIds) {
        logger.debug((Object)("moids=" + moIds));
        BatchOperationResult batchOperationResult = new BatchOperationResult();
        if (null == moIds || moIds.isEmpty()) {
            return batchOperationResult;
        }
        batchOperationResult.setTotalCount(moIds.size());
        BatchResultUtil.setBatchResult((BatchOperationResult)batchOperationResult, moIds, (Long)userId);
        return batchOperationResult;
    }

    private void checkSiteParam(Site site) {
        if (null == site) {
            logger.error((Object)"site is null");
            throw new LegoCheckedException(1073947393L);
        }
        VerifyUtil.checkStrs((String[])new String[]{site.getServerUuid(), site.getSiteId()});
    }

    public List<Site> getAllLocalSites() {
        String hql = "from Site as st where st.siteType = 0 order by st.name asc";
        return this.executeQuery(hql);
    }

    private List<Site> getAllSites() {
        String hql = "from Site as st order by st.name asc";
        return this.executeQuery(hql);
    }

    public List<Site> getAllSites(Long userId) {
        List<Site> siteList = this.getAllSites();
        if (VerifyUtil.isEmpty(siteList)) {
            return new ArrayList<Site>(0);
        }
        return ((IBizScopeManager)ServiceLocator.getInstance().getService(IBizScopeManager.class)).filterObject(userId, siteList);
    }

    private List<Site> executeQuery(String hql) {
        try {
            return CommonDAOLocator.getBaseDao().getHibernateTemplate().find(hql, new Object[0]);
        }
        catch (DataAccessException ex) {
            logger.error((Object)"unable to get sites", (Throwable)ex, 90160758786873L);
            return new ArrayList<Site>();
        }
    }

    public List<? extends DrResource> getAllResourceBySite(String siteId, String resType) {
        logger.debug((Object)("siteId=" + siteId + ", resType=" + resType));
        if (null == siteId) {
            return new ArrayList();
        }
        return SiteResourceServiceProxy.getInstance().getSiteResourceService(resType).getDrResourceBySite(siteId);
    }

    public List<Site> getSites(String serverUuid) {
        if (VerifyUtil.isEmpty((String)serverUuid)) {
            logger.error((Object)("serverUuid=" + serverUuid), 90160758786873L);
            throw new LegoCheckedException(1073947393L);
        }
        List<Site> sites = null;
        try {
            List find = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from Site where serverUuid = ? order by name asc", (Object[])new String[]{serverUuid});
            sites = Arrays.asList(find.toArray(new Site[find.size()]));
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("Query site fail, serverUuid=" + serverUuid), (long)-1L, (String[])new String[0], (Log)logger);
        }
        return sites;
    }

    public Site getSiteByDeviceSn(String devSn) {
        String hql = "from DrResource where deviceSn=?";
        IBaseDao baseDao = CommonDAOLocator.getBaseDao();
        List resourceList = baseDao.getHibernateTemplate().find(hql, new Object[]{devSn});
        if (null == resourceList || resourceList.isEmpty()) {
            logger.error((Object)("DrResource is null, sn=" + devSn));
            throw new LegoCheckedException(2117645L);
        }
        DrResource drResource = (DrResource)resourceList.get(0);
        Site site = this.getSiteById(drResource.getSiteId());
        if (null == site) {
            logger.error((Object)("Site is null, siteId=" + drResource.getSiteId()));
            throw new LegoCheckedException(2117645L);
        }
        return site;
    }

    private Site getSitebyProjectId(String projectId) {
        try {
            List sites = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from Site as st where st.projectId = ? ", new Object[]{projectId});
            if (VerifyUtil.isEmpty((Collection)sites)) {
                return null;
            }
            return (Site)sites.get(0);
        }
        catch (DataAccessException e) {
            logger.error((Object)("failed to get site:" + projectId), (Throwable)e, 0L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
    }

    public Site getSiteByBackupBucketOrPath(String bucketOrPath) {
        if (bucketOrPath.length() < 32) {
            logger.error((Object)"The path size less than32");
            return null;
        }
        String projectId = bucketOrPath.substring(bucketOrPath.length() - 32);
        return this.getSitebyProjectId(projectId);
    }

    public List<String> getCloudbrands() {
        ArrayList<String> cloudTypeList = new ArrayList<String>();
        String cloudType = LegoConfig.getInstance().getKeyValue("support.cloud.brand", "");
        String[] cloudTypeArray = cloudType.split(",");
        cloudTypeList.addAll(Arrays.asList(cloudTypeArray));
        return cloudTypeList;
    }
}

