/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.site.util;

import com.huawei.ism.cbb.base.sdk.constant.CommonConstant;
import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.SiteUtil;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.site.util.IRemoteTaskCallback;
import com.huawei.lego.cbb.backtask.sdk.model.BackTask;
import com.huawei.lego.cbb.backtask.sdk.service.BackTaskState;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class RemoteSiteMonitorTask
extends AbstractBackTask {
    private final Log logger = LogFactory.getInstance((Object)((Object)this));
    private String remoteSiteId = "";
    private long remoteTaskId = -1L;
    private long monitorInterval = 10L;
    private IRemoteTaskCallback callback;

    public RemoteSiteMonitorTask(String siteId, long remoteTaskId) {
        super(UUIDGenerator.getUUID(), null, true);
        if (VerifyUtil.isEmpty((String)siteId) || remoteTaskId <= 0L) {
            throw new LegoCheckedException(1073947393L);
        }
        this.remoteSiteId = siteId;
        this.remoteTaskId = remoteTaskId;
        this.initTask();
    }

    public RemoteSiteMonitorTask(String siteId, long remoteTaskId, BackTask bt) {
        super(UUIDGenerator.getUUID(), bt, true);
        if (VerifyUtil.isEmpty((String)siteId) || remoteTaskId <= 0L) {
            throw new LegoCheckedException(1073947393L);
        }
        this.remoteSiteId = siteId;
        this.remoteTaskId = remoteTaskId;
    }

    private void initTask() {
        if (this.getBackTask() != null) {
            return;
        }
        this.initBackTaskByRemoteTask(this.remoteSiteId, this.remoteTaskId);
        if (this.getBackTask() == null) {
            this.logger.error((Object)"initTask failed.", 90160758784000L);
            throw new LegoCheckedException(1563L);
        }
        String threadName = "remoteSiteId:" + this.remoteSiteId + "; localTaskId:" + this.getBackTask().getTaskId() + "; remoteTaskId:" + this.remoteTaskId;
        Thread.currentThread().setName(threadName);
        this.logger.info((Object)("initTask threadName=" + threadName), 90160758784000L);
    }

    public void setMonitorInterval(long interval) {
        if (interval > 0L) {
            this.monitorInterval = interval;
            this.logger.info((Object)("setMonitorInterval =" + interval), 90160758784000L);
        }
    }

    private BackTask queryRemoteSiteTask(String siteId, long taskId) {
        BackTask backTask = null;
        try {
            RestClient client = SiteUtil.initClient((String)siteId);
            String uri = "/ws/backtasks/" + taskId;
            String response = client.get(uri, null);
            backTask = this.jsonStrToBackTask(response);
        }
        catch (Exception e) {
            this.logger.error((Object)("getRemoteSiteTasks failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784000L);
        }
        return backTask;
    }

    private boolean synRemoteTaskInfo(BackTask remoteTask) {
        BackTask localTask = this.getBackTask();
        boolean isEnd = false;
        localTask.setTaskProgress(remoteTask.getTaskProgress());
        localTask.setTaskResult(remoteTask.getTaskResult());
        localTask.setTaskDetail(remoteTask.getTaskDetail());
        localTask.setTaskDetailPara(remoteTask.getTaskDetailPara());
        if (CommonConstant.BACKTASK_RESULT_FAIL == remoteTask.getTaskResult() || CommonConstant.BACKTASK_RESULT_SUCCESS == remoteTask.getTaskResult()) {
            localTask.setEndTime(new Date());
            isEnd = true;
        }
        this.getBackTaskService().updateTask(localTask);
        return isEnd;
    }

    private void initBackTaskByRemoteTask(String siteId, long taskId) {
        BackTask remoteTask = this.queryRemoteSiteTask(siteId, taskId);
        if (remoteTask != null) {
            this.setBackTask(remoteTask);
        }
    }

    protected void doWork() {
        try {
            block3: {
                this.logger.info((Object)"start monitorRemoteSite ......", 90160758784000L);
                while (true) {
                    TimeUnit.SECONDS.sleep(this.monitorInterval);
                    BackTask remoteTask = this.queryRemoteSiteTask(this.remoteSiteId, this.remoteTaskId);
                    if (null == remoteTask) continue;
                    boolean isEnd = this.synRemoteTaskInfo(remoteTask);
                    if (isEnd) break block3;
                    if (Thread.currentThread().isInterrupted()) break;
                }
                this.logger.info((Object)("Current thread has been interrupted, remoteSiteId=" + this.remoteSiteId + ", remoteTaskId=" + this.remoteTaskId + ", localAbstractBackTaskInfo=" + (Object)((Object)this)), 90160758784000L);
                throw new LegoCheckedException(1073947433L);
            }
            this.doCallback();
            this.logger.info((Object)"end monitorRemoteSite end.", 90160758784000L);
        }
        catch (InterruptedException e) {
            this.logger.error((Object)"exception occured when monitorRemoteSite.", (Throwable)e, 90160758784000L);
            throw new LegoCheckedException(0x200909L, (Throwable)e);
        }
    }

    protected void succeed() {
    }

    private void doCallback() {
        if (null == this.getCallback()) {
            return;
        }
        try {
            this.logger.info((Object)("Begin callback, taskResult=" + this.getBackTask().getTaskResult()), 90160758784000L);
            if (this.getBackTask().getTaskResult().intValue() == BackTaskState.SUCCEED.getValue()) {
                this.getCallback().succeed();
            } else {
                this.getCallback().fail();
            }
            this.logger.info((Object)"End callback", 90160758784000L);
        }
        catch (Exception e) {
            this.logger.error((Object)("callback execute fail" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784000L);
        }
    }

    private BackTask jsonStrToBackTask(String str) {
        if (VerifyUtil.isEmpty((String)str)) {
            throw new LegoCheckedException(1073947393L);
        }
        BackTask task = new BackTask();
        JSONObject json = JSONObject.fromObject((Object)str);
        task.setTaskName(json.getString("taskName"));
        task.setTargetName(json.getString("targetName"));
        task.setCreateUser(json.getString("createUser"));
        task.setStartTime(new Date());
        task.setTaskProgress(Integer.valueOf(json.getInt("taskProgress")));
        task.setTaskResult(Integer.valueOf(json.getInt("taskResult")));
        task.setTaskDetail(json.getString("taskDetail"));
        task.setTaskDetailPara(json.getString("taskDetailPara"));
        Object taskDetailParas = json.get("taskDetailParas");
        task.setTaskDetailParas(VerifyUtil.isEmpty((Object)taskDetailParas) ? null : (String[])json.get("taskDetailParas"));
        return task;
    }

    public IRemoteTaskCallback getCallback() {
        return this.callback;
    }

    public void setCallback(IRemoteTaskCallback callback) {
        this.callback = callback;
    }
}

