/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.util;

import com.huawei.ism.cbb.base.util.AlarmUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.AntiBlackMailEnumDefine;
import com.huawei.ism.drm.constant.ReplicaMountStatus;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupHelper;
import com.huawei.ism.drm.protection.replica.sdk.model.LocalStorageReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.recovery.sdk.model.MountConfiguration;
import com.huawei.ism.drm.storage.manager.proxy.StorageFileSystemCloneManagerProxy;
import com.huawei.ism.drm.storage.manager.proxy.StorageFileSystemManagerProxy;
import com.huawei.ism.drm.storage.manager.proxy.StorageFileSystemSnapshotManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.model.CIFSShareAuthClient;
import com.huawei.ism.drm.storage.manager.sdk.model.NFSShareAuthClient;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageFileSystemCloneManager;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageFileSystemManager;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageFileSystemSnapshotManager;
import com.huawei.ism.drm.storage.sdk.constant.ShareType;
import com.huawei.ism.drm.storage.sdk.model.CIFSShare;
import com.huawei.ism.drm.storage.sdk.model.NFSShare;
import com.huawei.ism.drm.storage.sdk.model.NasCloneParam;
import com.huawei.ism.drm.storage.sdk.model.NasSnapshotClone;
import com.huawei.ism.drm.storage.sdk.model.Snapshot;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.ism.unistor.sdk.model.NasFileSystem;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.LegoBaseConfig;
import com.huawei.lego.core.sdk.util.SecurityUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class NasCloneUtil {
    private static final Log LOGGER = LogFactory.getInstance(NasCloneUtil.class);
    private static final int CLONE_NAME_MAX_LENGTH = 80;

    public static ProtectGroupReplica cloneFileSystemSnapshot(ProtectGroupReplica sourceReplica, NasCloneParam nasCloneParam, String newSnapshotName) {
        ProtectGroupReplica resClone = null;
        try {
            Object clone = sourceReplica.clone();
            if (!(clone instanceof ProtectGroupReplica)) {
                return resClone;
            }
            ProtectGroupReplica cloneReplica = (ProtectGroupReplica)clone;
            cloneReplica.setId(UUIDGenerator.getUUID());
            cloneReplica.setName("SnapshotCopy_" + newSnapshotName);
            cloneReplica.setSourceReplicaId(sourceReplica.getId());
            cloneReplica.setMountStatus(Integer.valueOf(ReplicaMountStatus.UMOUNTED.getStatus()));
            cloneReplica.setMountedHost("");
            cloneReplica.addProperty("planId", null);
            cloneReplica.setGeneration(Integer.valueOf(2));
            String parentType = sourceReplica.getProperty("ParentType");
            if (!VerifyUtil.isEmpty((String)parentType)) {
                cloneReplica.addProperty("ParentType", parentType);
            } else {
                cloneReplica.addProperty("ParentType", String.valueOf(sourceReplica.getType()));
            }
            String devSn = sourceReplica.getStorageDeviceId();
            String vstoreId = ProtectGroupHelper.getInstance().getVstoreId(sourceReplica.getPg());
            if (VerifyUtil.isEmpty((String)vstoreId)) {
                LOGGER.error((Object)"Vstore id is invalid.");
                throw new LegoCheckedException(1073947393L);
            }
            nasCloneParam.setVstoreId(vstoreId);
            if (!NasCloneUtil.doCloneFileSystemSnapshot(cloneReplica, devSn, nasCloneParam)) {
                LOGGER.error((Object)"Failed to create nas snapshot clone.");
                return resClone;
            }
            sourceReplica.addProperty("nasCloneInfos", cloneReplica.getProperty("nasCloneInfos"));
            cloneReplica.setType(14);
            resClone = cloneReplica;
        }
        catch (CloneNotSupportedException e) {
            LOGGER.error((Object)"An error occurred while cloning a copy");
        }
        return resClone;
    }

    public static boolean doCloneFileSystemSnapshot(ProtectGroupReplica cloneReplica, String devSn, NasCloneParam nasCloneParam) {
        Set replicaList = cloneReplica.getReplicas();
        HashMap<String, NasSnapshotClone> context = new HashMap<String, NasSnapshotClone>();
        try {
            for (ProtectObjectReplica replica : replicaList) {
                if (replica.getDetectionStatus() == AntiBlackMailEnumDefine.DetectionStatus.INFECTED.getValue()) continue;
                replica.setId(UUIDGenerator.getUUID());
                Set protectObjectStorageList = replica.getStorageInfos();
                NasCloneUtil.buildCloneReplica(devSn, protectObjectStorageList, nasCloneParam, context);
            }
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Create nas snapshot clone failed, rollback clone, clone num=%d, e=%s.", new Object[]{context.size(), ExceptionUtil.getErrorMessage((Throwable)e)});
            NasCloneUtil.rollbackCreateClone(devSn, context);
            if (e.getErrorCode() == 1077948993L) {
                throw new LegoCheckedException(1073937963L, new String[]{nasCloneParam.getSharePrefix()});
            }
            throw e;
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error occurred when create nas snapshot clone, rollback clone, clone num=%d, e=%s.", new Object[]{context.size(), ExceptionUtil.getErrorMessage((Throwable)e)});
            NasCloneUtil.rollbackCreateClone(devSn, context);
            return false;
        }
        NasCloneUtil.cleanCloneSnapshotInfo(cloneReplica);
        if (context.isEmpty()) {
            LOGGER.error((Object)"Failed to create nas snapshot clone, snapshot is not exist.");
            throw new LegoCheckedException(1073754118L);
        }
        if (!NasCloneUtil.checkCloneSplit(devSn, nasCloneParam, context)) {
            LOGGER.error((Object)"Split nas clone failed, rollback clone.");
            NasCloneUtil.rollbackCreateClone(devSn, context);
            return false;
        }
        JSONArray cloneArray = JSONArray.fromObject(new ArrayList(context.values()));
        cloneReplica.addProperty("nasCloneInfos", cloneArray.toString());
        return true;
    }

    private static void cleanCloneSnapshotInfo(ProtectGroupReplica cloneReplica) {
        cloneReplica.setDetectionStatus(AntiBlackMailEnumDefine.ReplicaDetectionStatusEnum.NOT_SUPPORT.getValue());
        cloneReplica.getProps().remove("isNeedSecureSnapshot");
        Set replicas = cloneReplica.getReplicas();
        Set newReplicas = replicas.stream().filter(replica -> {
            Set storageInfos = replica.getStorageInfos();
            return storageInfos.stream().noneMatch(storageInfo -> storageInfo.getStorageId().contains("@"));
        }).collect(Collectors.toSet());
        cloneReplica.setReplicas(newReplicas);
    }

    private static void buildCloneReplica(String devSn, Set<RelicaStorageInfo> protectObjectStorageList, NasCloneParam nasCloneParam, Map<String, NasSnapshotClone> context) {
        StorageFileSystemCloneManagerProxy proxy = StorageFileSystemCloneManagerProxy.getInstance();
        IStorageFileSystemCloneManager cloneManager = proxy.getStorageHyperCloneManager(devSn);
        for (RelicaStorageInfo storageInfo : protectObjectStorageList) {
            String srcSnapshotId;
            String copyName;
            if (!(storageInfo instanceof LocalStorageReplica)) break;
            storageInfo.setId(UUIDGenerator.getUUID());
            String nasId = storageInfo.getSrcStorageId();
            int type = Optional.of(storageInfo.getPoReplica().getPgReplica().getType()).orElse(0);
            boolean isHyperCDP = false;
            if (type == 102) {
                copyName = "DRdata_Secure" + nasId + "_" + System.currentTimeMillis();
                isHyperCDP = true;
            } else {
                copyName = "DRdata_" + nasId + "_" + System.currentTimeMillis();
            }
            if (!NasCloneUtil.checkSnapshotExist(devSn, nasId, srcSnapshotId = storageInfo.getStorageId())) continue;
            NasSnapshotClone clone = context.get(storageInfo.getSrcStorageId());
            if (clone == null) {
                String snapshotName = ((LocalStorageReplica)storageInfo).getSnapshotName();
                String cloneName = nasCloneParam.getSharePrefix() + "_" + snapshotName;
                NasCloneUtil.checkCloneName(cloneName);
                nasCloneParam.setName(cloneName);
                nasCloneParam.setParentFilesystemId(nasId);
                nasCloneParam.setParentSnapshotId(srcSnapshotId);
                nasCloneParam.setVstoreId(nasCloneParam.getVstoreId());
                clone = cloneManager.createFilesSystemClone(devSn, nasCloneParam);
                context.put(storageInfo.getSrcStorageId(), clone);
                nasCloneParam.setId(clone.getId());
                nasCloneParam.setName(clone.getName());
                cloneManager.splitFilesSystemClone(devSn, nasCloneParam);
            }
            storageInfo.setStorageId(clone.getId());
            ((LocalStorageReplica)storageInfo).setSnapshotName(copyName);
        }
    }

    private static boolean checkSnapshotExist(String devSn, String fsId, String snapshotId) {
        StorageFileSystemSnapshotManagerProxy storageManagerProxy = StorageFileSystemSnapshotManagerProxy.getInstance();
        IStorageFileSystemSnapshotManager proxy = storageManagerProxy.getStorageFileSystemSnapshotManager(devSn);
        Snapshot snapshot = proxy.querySpecificSnapshot(devSn, fsId, snapshotId);
        if (snapshot == null) {
            LOGGER.error((Object)"Clone nas snapshot failed, src snapshot does not exist, devSn: %s, fsId: %s, snapshotId: %s.", new Object[]{SecurityUtil.desensitizeId((String)devSn), fsId, snapshotId});
            return false;
        }
        return true;
    }

    public static void rollbackCreateClone(String devSn, Map<String, NasSnapshotClone> context) {
        IStorageFileSystemManager fileSystemManager = StorageFileSystemManagerProxy.getInstance().getStorageFileSystemManager(devSn);
        for (NasSnapshotClone clone : context.values()) {
            NasCloneUtil.deleteFileSystem(devSn, clone, fileSystemManager);
        }
    }

    private static boolean deleteFileSystem(String devSn, NasSnapshotClone clone, IStorageFileSystemManager fileSystemManager) {
        OperationResult operationResult = fileSystemManager.deleteFileSystem(devSn, clone.getId(), clone.getVstoreId());
        if (!operationResult.isSuccess()) {
            LOGGER.error((Object)"Delete nas clone failed, nas id=%s.", new Object[]{clone.getId()});
            String[] alarmParams = new String[]{clone.getName(), clone.getId(), devSn};
            AlarmUtil.sendCommonAlarm((String)"0x3230088", (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.MAJOR, (String[])alarmParams);
            return false;
        }
        return true;
    }

    public static boolean checkCloneSplit(String devSn, NasCloneParam nasCloneParam, Map<String, NasSnapshotClone> context) {
        List splitFsIds;
        block3: {
            ArrayList notFinishSplitFsIds;
            long curTime;
            StorageFileSystemManagerProxy proxy = StorageFileSystemManagerProxy.getInstance();
            IStorageFileSystemManager snapshotManager = proxy.getStorageFileSystemManager(devSn);
            splitFsIds = context.values().stream().map(NasSnapshotClone::getId).collect(Collectors.toList());
            long timeout = LegoBaseConfig.getInstance().getNumber("nas.clone.task.timeout", 120L) * 60L * 1000L;
            long startTime = System.currentTimeMillis();
            do {
                if (!NasCloneUtil.pauseThread(10000L)) {
                    LOGGER.warn((Object)"Another thread interrupts the current task while waiting to split clone.");
                    return false;
                }
                notFinishSplitFsIds = new ArrayList();
                List nasFileSystems = snapshotManager.queryFileSystems(devSn, splitFsIds, nasCloneParam.getVstoreId());
                for (NasFileSystem fileSystem : nasFileSystems) {
                    if (!"true".equalsIgnoreCase(fileSystem.getIsCloneFs())) continue;
                    notFinishSplitFsIds.add(fileSystem.getResourceId());
                    LOGGER.info((Object)"Nas clone is splitting, fsId: %s.", new Object[]{fileSystem.getResourceId()});
                }
                splitFsIds = notFinishSplitFsIds;
                if (splitFsIds.isEmpty()) break block3;
            } while ((curTime = System.currentTimeMillis()) - startTime < timeout);
            LOGGER.error((Object)"Timeout: nas clone split failed by max wait time, not finish fsId: %s.", new Object[]{((Object)notFinishSplitFsIds).toString()});
            throw new LegoCheckedException(1073947433L);
        }
        LOGGER.debug((Object)"All nas clone has been split.");
        return splitFsIds.isEmpty();
    }

    public static boolean pauseThread(long millis) {
        try {
            CommUtil.interruptiblePauseThread((long)millis);
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"Pause thread error.");
            return false;
        }
        return true;
    }

    public static boolean createShare(RecoveryProcessorContext context, NasSnapshotClone nasSnapshotClone) {
        MountConfiguration mountConfiguration = NasCloneUtil.getMountConfiguration(context);
        boolean createResult = false;
        if (ShareType.NFS.getValue().equals(mountConfiguration.getShareType())) {
            createResult = NasCloneUtil.createNFSShare(context, nasSnapshotClone, mountConfiguration);
        }
        if (ShareType.CIFS.getValue().equals(mountConfiguration.getShareType())) {
            createResult = NasCloneUtil.createCIFSShare(context, nasSnapshotClone, mountConfiguration);
        }
        return createResult;
    }

    public static MountConfiguration getMountConfiguration(RecoveryProcessorContext context) {
        ProtectGroupReplica replica = context.getProtectGroupReplica();
        String mountConfigs = replica.getProperty("mountConfigs");
        MountConfiguration mountConfiguration = (MountConfiguration)JSONObject.toBean((String)mountConfigs, MountConfiguration.class);
        if (mountConfiguration == null || VerifyUtil.isEmpty((Object)ShareType.getShareType((String)mountConfiguration.getShareType()))) {
            LOGGER.error((Object)"MountConfigs or shareType is invalid.");
            throw new LegoCheckedException(1073947393L);
        }
        return mountConfiguration;
    }

    private static boolean createNFSShare(RecoveryProcessorContext context, NasSnapshotClone nasSnapshotClone, MountConfiguration mountConfiguration) {
        String cloneName = nasSnapshotClone.getName();
        NasCloneUtil.checkCloneName(cloneName);
        String devSn = nasSnapshotClone.getDevSn();
        String vstoreId = nasSnapshotClone.getVstoreId();
        String templateId = mountConfiguration.getTemplateId();
        IStorageFileSystemManager fileSystemManager = NasCloneUtil.getStorageFileSystemManager(devSn);
        List nfsShareAuthClients = fileSystemManager.queryNFSShareAuthClients(devSn, vstoreId, templateId);
        if (nfsShareAuthClients.isEmpty()) {
            LOGGER.error((Object)"auth client is empty.");
            return false;
        }
        NFSShare nfsShareTemp = fileSystemManager.getNFSShareByShareId(devSn, templateId, vstoreId);
        if (VerifyUtil.isEmpty((Object)nfsShareTemp)) {
            LOGGER.error((Object)"NFSShare is empty.");
            return false;
        }
        String fsId = nasSnapshotClone.getId();
        String sharePath = "/" + cloneName;
        NFSShare nfsShare = null;
        try {
            nfsShare = fileSystemManager.createNFSShareByTemplate(devSn, nfsShareTemp, fsId, sharePath, vstoreId);
            if (VerifyUtil.isEmpty((String)nfsShare.getId())) {
                LOGGER.error((Object)"NFSShare is empty.");
                return false;
            }
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"create nfs share error, e:%s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            return false;
        }
        for (NFSShareAuthClient nfsShareAuthClient : nfsShareAuthClients) {
            Optional newAuthClientOp = fileSystemManager.createNFSShareAuthClientV2(devSn, nfsShare.getId(), nfsShareAuthClient, vstoreId);
            if (newAuthClientOp.isPresent() && !VerifyUtil.isEmpty((String)((NFSShareAuthClient)newAuthClientOp.get()).getId())) continue;
            return false;
        }
        return true;
    }

    public static boolean createCIFSShare(RecoveryProcessorContext context, NasSnapshotClone nasSnapshotClone, MountConfiguration mountConfiguration) {
        String shareName = nasSnapshotClone.getName();
        NasCloneUtil.checkCloneName(shareName);
        String devSn = nasSnapshotClone.getDevSn();
        String vstoreId = nasSnapshotClone.getVstoreId();
        String templateId = mountConfiguration.getTemplateId();
        IStorageFileSystemManager fileSystemManager = NasCloneUtil.getStorageFileSystemManager(devSn);
        List cifsShareAuthClients = fileSystemManager.queryCIFSShareAuthClients(devSn, vstoreId, templateId);
        if (cifsShareAuthClients.isEmpty()) {
            LOGGER.error((Object)"CIFS auth client is empty.");
            return false;
        }
        CIFSShare cifsShareTemp = fileSystemManager.getCIFSShareByShareId(devSn, templateId, vstoreId);
        if (VerifyUtil.isEmpty((Object)cifsShareTemp)) {
            LOGGER.error((Object)"CIFSShare is empty.");
            return false;
        }
        String fsId = nasSnapshotClone.getId();
        CIFSShare cifsShare = null;
        try {
            cifsShare = fileSystemManager.createCIFSShareByTemplate(devSn, cifsShareTemp, fsId, shareName, vstoreId);
            if (VerifyUtil.isEmpty((String)cifsShare.getId())) {
                LOGGER.error((Object)"NFSShare is empty.");
                return false;
            }
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"create cifs share error, e:%s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            return false;
        }
        for (CIFSShareAuthClient cifsShareAuthClient : cifsShareAuthClients) {
            Optional newAuthClientOp = fileSystemManager.createCIFSShareAuthClient(devSn, cifsShare.getId(), cifsShareAuthClient, vstoreId);
            if (newAuthClientOp.isPresent() && !VerifyUtil.isEmpty((String)((CIFSShareAuthClient)newAuthClientOp.get()).getId())) continue;
            return false;
        }
        return true;
    }

    private static void checkCloneName(String cloneName) {
        if (VerifyUtil.isEmpty((String)cloneName) || cloneName.length() > 80 || !CommUtil.checkParam((String)cloneName, (String)"^[a-zA-Z0-9_.-]*$")) {
            LOGGER.error((Object)"Clone name does not match.");
            throw new LegoCheckedException(1073947393L);
        }
    }

    public static void rollbackCreateShare(RecoveryProcessorContext context) {
        ProtectGroupReplica replica = context.getProtectGroupReplica();
        List<NasSnapshotClone> nasSnapshotClones = NasCloneUtil.getNasSnapshotClones(replica);
        for (NasSnapshotClone nasSnapshotClone : nasSnapshotClones) {
            NasCloneUtil.deleteShare(context, nasSnapshotClone);
        }
    }

    public static List<NasSnapshotClone> getNasSnapshotClones(ProtectGroupReplica replica) {
        String cloneInfo = replica.getProperty("nasCloneInfos");
        if (VerifyUtil.isEmpty((String)cloneInfo)) {
            return new ArrayList<NasSnapshotClone>();
        }
        return JSONArray.toCollection((JSONArray)JSONArray.fromObject((Object)cloneInfo), NasSnapshotClone.class);
    }

    public static boolean deleteShare(RecoveryProcessorContext context, NasSnapshotClone nasSnapshotClone) {
        MountConfiguration mountConfiguration = NasCloneUtil.getMountConfiguration(context);
        boolean deleteResult = false;
        if (ShareType.NFS.getValue().equals(mountConfiguration.getShareType())) {
            return NasCloneUtil.deleteNFSShare(nasSnapshotClone);
        }
        if (ShareType.CIFS.getValue().equals(mountConfiguration.getShareType())) {
            return NasCloneUtil.deleteCIFSShare(nasSnapshotClone);
        }
        return deleteResult;
    }

    public static boolean deleteNFSShare(NasSnapshotClone nasSnapshotClone) {
        String devSn = nasSnapshotClone.getDevSn();
        IStorageFileSystemManager fileSystemManager = NasCloneUtil.getStorageFileSystemManager(devSn);
        String vstoreId = nasSnapshotClone.getVstoreId();
        List nfsShares = fileSystemManager.queryNFSSharesByFsId(devSn, nasSnapshotClone.getId(), vstoreId);
        if (nfsShares.isEmpty()) {
            return true;
        }
        for (NFSShare nfsShare : nfsShares) {
            String nfsShareId = nfsShare.getId();
            String nfsShareName = nfsShare.getName();
            List nfsShareAuthClients = fileSystemManager.queryNFSShareAuthClients(devSn, vstoreId, nfsShareId);
            for (NFSShareAuthClient nfsShareAuthClient : nfsShareAuthClients) {
                String authId = nfsShareAuthClient.getId();
                OperationResult operationResult = fileSystemManager.deleteShareAuthClient(devSn, ShareType.NFS.getValue(), vstoreId, authId);
                if (operationResult.isSuccess()) continue;
                LOGGER.error((Object)"Delete nfsShareAuthClient failed, devSn=%s, vstoreId=%s, nfsShareId=%s, nfsShareName=%s, authId=%s.", new Object[]{SecurityUtil.desensitizeId((String)devSn), vstoreId, nfsShareId, nfsShareName, authId});
                NasCloneUtil.sendDeleteShareFailedAlarm(ShareType.NFS.getValue(), nfsShareName, nfsShareId, devSn);
                return false;
            }
            OperationResult operationResult = fileSystemManager.deleteNFSShare(devSn, nfsShareId, vstoreId);
            if (operationResult.isSuccess()) continue;
            LOGGER.error((Object)"Delete nfsShare failed, devSn=%s, vstoreId=%s, nfsShareId=%s, nfsShareName=%s.", new Object[]{SecurityUtil.desensitizeId((String)devSn), vstoreId, nfsShareId, nfsShareName});
            NasCloneUtil.sendDeleteShareFailedAlarm(ShareType.NFS.getValue(), nfsShareName, nfsShareId, devSn);
            return false;
        }
        return true;
    }

    public static boolean deleteCIFSShare(NasSnapshotClone nasSnapshotClone) {
        String devSn = nasSnapshotClone.getDevSn();
        IStorageFileSystemManager fileSystemManager = NasCloneUtil.getStorageFileSystemManager(devSn);
        String vstoreId = nasSnapshotClone.getVstoreId();
        List cifsShares = fileSystemManager.queryCIFSSharesByFsId(devSn, nasSnapshotClone.getId(), vstoreId);
        if (cifsShares.isEmpty()) {
            return true;
        }
        for (CIFSShare cifsShare : cifsShares) {
            String cifsShareId = cifsShare.getId();
            String cifsShareName = cifsShare.getName();
            List cifsShareAuthClients = fileSystemManager.queryCIFSShareAuthClients(devSn, vstoreId, cifsShareId);
            for (CIFSShareAuthClient cifsShareAuthClient : cifsShareAuthClients) {
                String authId = cifsShareAuthClient.getId();
                OperationResult operationResult = fileSystemManager.deleteShareAuthClient(devSn, ShareType.CIFS.getValue(), vstoreId, authId);
                if (operationResult.isSuccess()) continue;
                LOGGER.error((Object)"Delete cifsShareAuthClient failed, devSn=%s, vstoreId=%s, cifsShareId=%s, cifsShareName=%s, authId=%s.", new Object[]{SecurityUtil.desensitizeId((String)devSn), vstoreId, cifsShareId, cifsShareName, authId});
                NasCloneUtil.sendDeleteShareFailedAlarm(ShareType.CIFS.getValue(), cifsShareName, cifsShareId, devSn);
                return false;
            }
            OperationResult operationResult = fileSystemManager.deleteCIFSShare(devSn, cifsShareId, vstoreId);
            if (operationResult.isSuccess()) continue;
            LOGGER.error((Object)"Delete cifsShare failed, devSn=%s, vstoreId=%s, cifsShareId=%s, cifsShareName=%s.", new Object[]{SecurityUtil.desensitizeId((String)devSn), vstoreId, cifsShareId, cifsShareName});
            NasCloneUtil.sendDeleteShareFailedAlarm(ShareType.CIFS.getValue(), cifsShareName, cifsShareId, devSn);
            return false;
        }
        return true;
    }

    private static void sendDeleteShareFailedAlarm(String shareType, String shareName, String shareId, String devSn) {
        String[] alarmParams = new String[]{shareType, shareName, shareId, devSn};
        AlarmUtil.sendCommonAlarm((String)"0x3230092", (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.MAJOR, (String[])alarmParams);
    }

    private static IStorageFileSystemManager getStorageFileSystemManager(String devSn) {
        return StorageFileSystemManagerProxy.getInstance().getStorageFileSystemManager(devSn);
    }

    public static boolean deleteCloneFileSystem(ProtectGroupReplica replica, boolean isNeedSendAlarm) {
        List<NasSnapshotClone> nasSnapshotClones = NasCloneUtil.getNasSnapshotClones(replica);
        if (nasSnapshotClones.isEmpty()) {
            LOGGER.info((Object)"No clone need to be delete.");
            return true;
        }
        String devSn = ((NasSnapshotClone)nasSnapshotClones.stream().findAny().get()).getDevSn();
        IStorageFileSystemManager storageFileSystemManager = NasCloneUtil.getStorageFileSystemManager(devSn);
        for (NasSnapshotClone nasSnapshotClone : nasSnapshotClones) {
            if (NasCloneUtil.deleteFileSystem(devSn, nasSnapshotClone, storageFileSystemManager)) continue;
            LOGGER.error((Object)"Delete nas clone failed, nas id=%s.", new Object[]{nasSnapshotClone.getId()});
        }
        return true;
    }

    public static boolean isAirGapSnapshotCloneReplica(ProtectGroupReplica replica) {
        if (replica.getGeneration() != 2) {
            return false;
        }
        int templateType = replica.getPg().getTemplate().getType();
        return templateType == 45 || templateType == 46;
    }
}

