/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cbb.license.util;

import com.huawei.lego.cbb.license.sdk.model.FeatureBo;
import com.huawei.lego.cbb.license.sdk.model.FunctionItemBo;
import com.huawei.lego.cbb.license.sdk.model.LicItemCompId;
import com.huawei.lego.cbb.license.sdk.model.LicenseInfoBo;
import com.huawei.lego.cbb.license.sdk.model.ResourceItemBo;
import com.huawei.lego.cbb.license.sdk.model.po.LicenseInfo;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class TranslateLicenseModel {
    private static final Log LOGGER = LogFactory.getInstance(TranslateLicenseModel.class);

    private TranslateLicenseModel() {
    }

    public static List<LicenseInfoBo> translateLicenseInfoLstToInfoBoLst(List<LicenseInfo> lstLicInfo) {
        ArrayList<LicenseInfoBo> tmpLstLicBo = new ArrayList<LicenseInfoBo>();
        for (LicenseInfo tmpLicInfo : lstLicInfo) {
            LicenseInfoBo tmpLicBo = new LicenseInfoBo();
            tmpLicBo.setFeatureAtt(tmpLicInfo.getFeatureAtt());
            tmpLicBo.setFile(TranslateLicenseModel.getByteByBlob(tmpLicInfo.getFile()));
            tmpLicBo.setId(tmpLicInfo.getId());
            tmpLicBo.setInUse(Boolean.valueOf(tmpLicInfo.isInUse()));
            tmpLicBo.setProductESN(tmpLicInfo.getProductESN());
            tmpLicBo.setProductName(tmpLicInfo.getProductName());
            tmpLicBo.setProductVers(tmpLicInfo.getProductVers());
            tmpLicBo.setUploadTime(Long.valueOf(tmpLicInfo.getUploadTime()));
            tmpLstLicBo.add(tmpLicBo);
        }
        return tmpLstLicBo;
    }

    public static LicenseInfoBo translateLicenseInfoToInfoBo(LicenseInfo licInfo) {
        LicenseInfoBo tmpLicBo = new LicenseInfoBo();
        tmpLicBo.setFeatureAtt(licInfo.getFeatureAtt());
        if (licInfo.getFile() != null) {
            tmpLicBo.setFile(TranslateLicenseModel.getByteByBlob(licInfo.getFile()));
        }
        tmpLicBo.setId(licInfo.getId());
        tmpLicBo.setInUse(Boolean.valueOf(licInfo.isInUse()));
        tmpLicBo.setProductESN(licInfo.getProductESN());
        tmpLicBo.setProductName(licInfo.getProductName());
        tmpLicBo.setProductVers(licInfo.getProductVers());
        tmpLicBo.setUploadTime(Long.valueOf(licInfo.getUploadTime()));
        return tmpLicBo;
    }

    public static byte[] getByteByBlob(Blob blob) {
        try {
            int iLength = (int)blob.length();
            return blob.getBytes(1L, iLength);
        }
        catch (SQLException e) {
            LOGGER.error((Object)"GetByteByBlob error.");
            ExceptionUtil.rethrowException((Exception)e, (String)"getByteByBlob error", (long)515L, (String[])new String[0]);
            return new byte[0];
        }
    }

    public static List<FunctionItemBo> getFuncLst(LicenseInfoBo lib) {
        ArrayList<FunctionItemBo> retFuncLst = new ArrayList<FunctionItemBo>();
        for (FeatureBo fb : lib.getFeaBolst()) {
            retFuncLst.addAll(fb.getFunclst());
        }
        return retFuncLst;
    }

    public static Map<LicItemCompId, ResourceItemBo> getResMap(LicenseInfoBo lib) {
        HashMap<LicItemCompId, ResourceItemBo> ribMap = new HashMap<LicItemCompId, ResourceItemBo>();
        for (FeatureBo fb : lib.getFeaBolst()) {
            for (ResourceItemBo rib : fb.getReslst()) {
                LicItemCompId lici = new LicItemCompId();
                lici.setFeaname(rib.getFeatureName());
                lici.setItemName(rib.getItemName());
                ribMap.put(lici, rib);
            }
        }
        return ribMap;
    }

    public static Map<LicItemCompId, FunctionItemBo> getFuncMap(LicenseInfoBo lib) {
        HashMap<LicItemCompId, FunctionItemBo> fibMap = new HashMap<LicItemCompId, FunctionItemBo>();
        for (FeatureBo fb : lib.getFeaBolst()) {
            for (FunctionItemBo fib : fb.getFunclst()) {
                LicItemCompId lici = new LicItemCompId();
                lici.setFeaname(fib.getFeatureName());
                lici.setItemName(fib.getFunctionItemName());
                fibMap.put(lici, fib);
            }
        }
        return fibMap;
    }
}

