/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cbb.resource.messagesubscriber;

import com.huawei.lego.cbb.resource.dao.IResourceDao;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.cbb.resource.util.DaoFactory;
import com.huawei.lego.comm.internal.jms.IMessageCenter;
import com.huawei.lego.comm.internal.jms.MessageRegister;
import com.huawei.lego.comm.internal.jms.MessageTaskManager;
import com.huawei.lego.comm.internal.jms.MessageTopic;
import com.huawei.lego.comm.internal.jms.MessageUnit;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Locale;
import java.util.Map;
import org.springframework.beans.factory.InitializingBean;

public class MoOffLineMessageSubscriber
extends MessageTaskManager
implements InitializingBean {
    private static final Log LOGGER = LogFactory.getInstance(MoOffLineMessageSubscriber.class);
    private IMessageCenter mc = null;

    public void afterPropertiesSet() {
        this.mc.addSubscriberTo(this);
    }

    @Override
    public MessageRegister[] getTypes() {
        MessageRegister[] mrs = MessageRegister.getMessageRegisters(1);
        mrs[0].setMessageTopic(MessageTopic.COMMAND);
        mrs[0].addMessageCode(109L);
        return mrs;
    }

    @Override
    public void onMessage(MessageUnit mu) {
        if (109L == mu.getCmdcode()) {
            Object obj = mu.getObj();
            LOGGER.debug((Object)"MoOffLineMessage body is : ");
            if (!(obj instanceof Map)) {
                LOGGER.error((Object)"error message body in MoOffLineMessageSubscriber!!!");
                return;
            }
            Map map = (Map)obj;
            if (map.isEmpty()) {
                LOGGER.error((Object)"error message body in MoOffLineMessageSubscriber!!!");
                return;
            }
            Long moId = (Long)map.keySet().iterator().next();
            Integer status = (Integer)map.values().iterator().next();
            LOGGER.info((Object)String.format(Locale.ENGLISH, "Mo offline is arrived, moId is : %s.", moId), 1L);
            IResourceDao dao = DaoFactory.getInstance().getResourceDao();
            ManagedObject mo = dao.getMoByIdAndType(ManagedObject.class, moId, null);
            if (mo == null) {
                LOGGER.warn((Object)("in mo offline, mo is nullllllllllll, moid is : " + moId));
                return;
            }
            if (mo.getStatus() != null && mo.getStatus() == -1) {
                return;
            }
            mo.setStatus(status);
            dao.updateMo(mo);
        }
    }

    public IMessageCenter getMc() {
        return this.mc;
    }

    public void setMc(IMessageCenter mc) {
        this.mc = mc;
    }
}

