/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cbb.resource.service;

import com.huawei.lego.cbb.resource.dao.DeviceTypeInfoDao;
import com.huawei.lego.cbb.resource.sdk.model.MainDeviceTypeState;
import com.huawei.lego.cbb.resource.sdk.model.TopoObject;
import com.huawei.lego.cbb.resource.sdk.service.IDeviceTypeMgr;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.util.tree.RootDataElement;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.SessionFactory;

@Service(name="deviceTypeMgr", desc="", interfaceClass=IDeviceTypeMgr.class)
public class DeviceTypeMgr
extends BaseService
implements IDeviceTypeMgr {
    private DeviceTypeInfoDao dao;

    public DeviceTypeMgr(SessionFactory factory) {
        this.dao = new DeviceTypeInfoDao(factory);
    }

    public List<TopoObject> getDeviceListByMainTypeName(String mainTypeName) {
        return this.dao.getDevLisetByMainType(mainTypeName);
    }

    public List<MainDeviceTypeState> getMainDeviceTypeList() {
        return this.dao.getDeviceStateInfo();
    }

    public List<TopoObject> getAllDevice() {
        return this.dao.getAllDevice();
    }

    public List<String> getDevSubTypesByMainType(String devMainType) {
        return this.dao.getDevSubTypesByMainType(devMainType);
    }

    public void registerDeviceType(String sysOid, String mainDevType, String subDevType) {
        Long regId = this.registerDeviceType(mainDevType, subDevType);
        this.dao.registerDeviceType(sysOid, regId);
    }

    public Long registerDeviceType(String mainDevType, String subDevType) {
        Long regId = this.dao.getDeviceRelationId(mainDevType, subDevType);
        if (regId == null) {
            regId = this.dao.registerDeviceType(mainDevType, subDevType);
        }
        this.dao.addDevMainType(mainDevType);
        this.dao.addDevSubType(subDevType);
        return regId;
    }

    public RootDataElement getDeviceTypeTree(Long userId, Boolean hiddenTypeWithoutChild) {
        return this.dao.getDeviceTypeTree(userId, hiddenTypeWithoutChild);
    }

    public RootDataElement getDeviceTypeTreeWithoutDev(Long userId, Boolean hiddenTypeWithoutChild) {
        return this.dao.getDeviceTypeTreeWithoutDev(userId, hiddenTypeWithoutChild);
    }

    public RootDataElement getDeviceTypeTreeWithoutDev(Long userId, Boolean hiddenTypeWithoutChild, Boolean isShieldMainType) {
        return this.dao.getDeviceTypeTreeBaseShield(userId, hiddenTypeWithoutChild, false, isShieldMainType);
    }

    public RootDataElement getDeviceTypeTreeWithoutDev(Boolean hiddenTypeWithoutChild) {
        return this.dao.getDeviceTypeTreeWithoutDev(hiddenTypeWithoutChild);
    }

    public Map<String, Set<String>> getDeviceTypes() {
        return this.dao.getDeviceTypeList();
    }

    public Map<String, Map<String, Long>> getDeviceStateInfo(Long userId) {
        return this.dao.getDeviceTypeState(userId);
    }

    public Map<String, Long> getDeviceStateInfo(String mainDevType, Long userId) {
        return this.dao.getDeviceTypeState(mainDevType, userId);
    }
}

