/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cbb.user.hibernate;

import com.huawei.lego.cbb.user.dao.IUserDao;
import com.huawei.lego.cbb.user.sdk.hibernate.model.UserInfo;
import com.huawei.lego.core.base.persistance.initializer.HibernateDaoSupportWrapper;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoExceptionTranslator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.LegoBaseConfig;
import java.io.Serializable;
import java.util.List;
import org.springframework.dao.DataAccessException;

public class UserDaoImpl
extends HibernateDaoSupportWrapper
implements IUserDao {
    private static final String SYSTEM_USER_LIMIT_TOTALS = "system.user.limit.totals";
    private static final long SYSTEM_USER_LIMIT_TOTALS_DEFAULT_VALUE = 64L;
    private static final Log LOGGER = LogFactory.getInstance(UserDaoImpl.class);
    private long userLimitSize;

    public void initialize() {
        this.userLimitSize = LegoBaseConfig.getInstance().getNumber(SYSTEM_USER_LIMIT_TOTALS, 64L);
    }

    @Override
    public Long addUser(UserInfo user) {
        try {
            return (Long)this.getHibernateTemplate().save((Object)user);
        }
        catch (DataAccessException ex) {
            LOGGER.error((Object)"Method addUser fail,msg is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
            throw LegoExceptionTranslator.convert((Throwable)ex);
        }
    }

    @Override
    public void deleteUser(long userId) {
        try {
            UserInfo user = (UserInfo)this.getHibernateTemplate().get(UserInfo.class, (Serializable)Long.valueOf(userId));
            if (user == null) {
                String[] pama = new String[]{"lego.lab.usr"};
                throw new LegoCheckedException(206L, pama);
            }
            this.getHibernateTemplate().delete((Object)user);
        }
        catch (DataAccessException ex) {
            LOGGER.error((Object)"Method deleteUser fail,msg is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
            throw LegoExceptionTranslator.convert((Throwable)ex);
        }
    }

    @Override
    public List<UserInfo> getAllUser(boolean isFetchRole) {
        List allUserList;
        try {
            String hql = "FROM UserInfo";
            allUserList = this.getHibernateTemplate().find(hql, new Object[0]);
        }
        catch (DataAccessException ex) {
            LOGGER.error((Object)"Method getAllUser fail,msg is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
            throw LegoExceptionTranslator.convert((Throwable)ex);
        }
        return allUserList;
    }

    @Override
    public UserInfo getUserInfoById(long userId, boolean isFetchRole) {
        UserInfo userInfo = null;
        try {
            if (isFetchRole) {
                String hql = "FROM UserInfo u left join fetch u.rolesSet where u.id = " + userId;
                List allUserList = this.getHibernateTemplate().find(hql, new Object[0]);
                if (null != allUserList && !allUserList.isEmpty()) {
                    userInfo = (UserInfo)allUserList.get(0);
                }
            } else {
                userInfo = (UserInfo)this.getHibernateTemplate().get(UserInfo.class, (Serializable)Long.valueOf(userId));
            }
        }
        catch (DataAccessException ex) {
            LOGGER.error((Object)"Method getUserInfoById fail,msg is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
            throw LegoExceptionTranslator.convert((Throwable)ex);
        }
        if (userInfo == null) {
            String[] pama = new String[]{"lego.lab.usr"};
            throw new LegoCheckedException(206L, pama);
        }
        return userInfo;
    }

    @Override
    public UserInfo getUserByName(String name, boolean isFetchRole) {
        UserInfo userInfo = null;
        try {
            String hql = isFetchRole ? "FROM UserInfo u left join fetch u.rolesSet where u.userName = ?" : "FROM UserInfo u where u.userName = ?";
            List allUserList = this.getHibernateTemplate().find(hql, (Object[])new String[]{name});
            if (allUserList != null && !allUserList.isEmpty()) {
                userInfo = (UserInfo)allUserList.get(0);
            }
        }
        catch (DataAccessException ex) {
            LOGGER.error((Object)"Method getUserByName fail,msg is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
            throw LegoExceptionTranslator.convert((Throwable)ex);
        }
        if (userInfo == null) {
            String[] pama = new String[]{"lego.lab.usr"};
            throw new LegoCheckedException(206L, pama);
        }
        return userInfo;
    }

    @Override
    public UserInfo checkUser(String userName, String pwd, boolean isFetchRole) {
        UserInfo userInfo = null;
        try {
            String hql = isFetchRole ? "FROM UserInfo u left join fetch u.rolesSet where u.userName = ? and u.userPwd = ?" : "FROM UserInfo u where u.userName =? and u.userPwd = ?";
            List allUserList = this.getHibernateTemplate().find(hql, (Object[])new String[]{userName, pwd});
            if (allUserList != null && !allUserList.isEmpty()) {
                userInfo = (UserInfo)allUserList.get(0);
            }
        }
        catch (DataAccessException ex) {
            LOGGER.error((Object)"Method checkUser fail,msg is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
            throw LegoExceptionTranslator.convert((Throwable)ex);
        }
        if (userInfo == null) {
            String[] pamas = new String[]{"lego.lab.usr"};
            throw new LegoCheckedException(206L, pamas);
        }
        return userInfo;
    }

    @Override
    public void updateUser(UserInfo user) {
        if (user != null) {
            try {
                UserInfo userInfo = this.getUserInfoById(user.getId(), false);
                if (userInfo == null) {
                    String[] pama = new String[]{"lego.lab.usr"};
                    throw new LegoCheckedException(206L, pama);
                }
                boolean isLock = userInfo.isLock();
                user.setLock(isLock);
                this.getHibernateTemplate().update((Object)user);
            }
            catch (DataAccessException ex) {
                LOGGER.error((Object)"Method updateUser fail,msg is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
                throw LegoExceptionTranslator.convert((Throwable)ex);
            }
        } else {
            LOGGER.error((Object)"The parameter is null");
        }
    }

    @Override
    public void checkUserLimit(boolean reserve) {
        boolean accord;
        List results;
        try {
            results = this.getHibernateTemplate().find("select count(*) from UserInfo", new Object[0]);
        }
        catch (DataAccessException ex) {
            ExceptionUtil.convertException((Throwable)ex, (String)"user count query failed, cause access exception.", (long)102L, null, (Log)LOGGER);
            throw new LegoCheckedException(102L, (Throwable)ex);
        }
        if (results == null || results.isEmpty()) {
            LOGGER.error((Object)"User count query failed.");
            throw new LegoCheckedException(102L);
        }
        Object result = results.get(0);
        if (!Number.class.isInstance(result)) {
            LOGGER.error((Object)"user count query result is not number");
            throw new LegoCheckedException(102L);
        }
        long used = ((Number)Number.class.cast(result)).longValue();
        if (reserve) {
            accord = used < this.userLimitSize;
        } else {
            boolean bl = accord = used <= this.userLimitSize;
        }
        if (!accord) {
            LOGGER.error((Object)("The number of users exceeds the upper limit (" + this.userLimitSize + ") of the system."));
            throw new LegoCheckedException(1073947465L, new String[]{String.valueOf(this.userLimitSize)});
        }
    }
}

