/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cbb.user.hibernate;

import com.huawei.lego.cbb.user.dao.IUserRelMoDao;
import com.huawei.lego.cbb.user.sdk.hibernate.model.UserRelMoInfo;
import com.huawei.lego.core.base.persistance.initializer.HibernateDaoSupportWrapper;
import com.huawei.lego.core.sdk.exception.LegoExceptionTranslator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.List;
import java.util.Set;
import org.springframework.dao.DataAccessException;

public class UserRelMoDaoImpl
extends HibernateDaoSupportWrapper
implements IUserRelMoDao {
    private static final int ZERO = 0;
    private static final int BATCH_OPER_MAX_NUMBER = 50;
    private static final Log LOGGER = LogFactory.getInstance(UserRelMoDaoImpl.class);

    @Override
    public void deleteUserRelMO(Set<UserRelMoInfo> set) {
        if (set != null) {
            try {
                this.getHibernateTemplate().deleteAll(set);
            }
            catch (DataAccessException ex) {
                LOGGER.error((Object)"Method deleteUserRelMO fail,msg is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
                throw LegoExceptionTranslator.convert((Throwable)ex);
            }
        }
    }

    @Override
    public void addMoByUser(Set<UserRelMoInfo> set) {
        if (set != null) {
            try {
                for (UserRelMoInfo info : set) {
                    this.getHibernateTemplate().saveOrUpdate((Object)info);
                }
            }
            catch (DataAccessException ex) {
                LOGGER.error((Object)"Method addMoByUser fail,msg is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
                throw LegoExceptionTranslator.convert((Throwable)ex);
            }
        }
    }

    @Override
    public void deleteMOByUserId(long userId) {
        try {
            String hql = "delete from UserRelMoInfo where id.userIdx = " + userId;
            this.updateByHql(hql);
        }
        catch (DataAccessException ex) {
            LOGGER.error((Object)"Method deleteMOByUserId fail,msg is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
            throw LegoExceptionTranslator.convert((Throwable)ex);
        }
    }

    @Override
    public void deleteMos(Set<Long> set) {
        if (set != null && !set.isEmpty()) {
            try {
                this.deleteByHql(set);
            }
            catch (DataAccessException ex) {
                LOGGER.error((Object)"Method deleteMos fail,msg is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
                throw LegoExceptionTranslator.convert((Throwable)ex);
            }
        }
    }

    private void deleteByHql(Set<Long> set) {
        int inum = 0;
        String hql = "delete from UserRelMoInfo where id.moId in (";
        for (long moId : set) {
            if (inum == 50) {
                hql = hql.substring(0, hql.length() - 1);
                hql = hql + ")";
                this.updateByHql(hql);
                hql = "delete from UserRelMoInfo where id.moId in (";
                inum = 0;
            }
            hql = hql + "" + moId + ",";
            ++inum;
        }
        hql = hql.substring(0, hql.length() - 1);
        hql = hql + ")";
        this.updateByHql(hql);
    }

    @Override
    public void deleteMo(Long moId) {
        try {
            String hql = "delete from UserRelMoInfo where id.moId = " + moId;
            this.updateByHql(hql);
        }
        catch (DataAccessException ex) {
            LOGGER.error((Object)"Method deleteMo fail,msg is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
            throw LegoExceptionTranslator.convert((Throwable)ex);
        }
    }

    @Override
    public void updataMOByUserId(long userId, Set<UserRelMoInfo> set) {
        this.deleteMOByUserId(userId);
        this.addMoByUser(set);
    }

    @Override
    public List<UserRelMoInfo> getAllMOByUserId(long userId) {
        List result;
        try {
            String hql = "FROM UserRelMoInfo where id.userIdx = " + userId;
            result = this.getHibernateTemplate().find(hql, new Object[0]);
        }
        catch (DataAccessException ex) {
            LOGGER.error((Object)"Method getAllMOByUserId fail,msg is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
            throw LegoExceptionTranslator.convert((Throwable)ex);
        }
        return result;
    }

    @Override
    public List<UserRelMoInfo> getMoByUserId(long userId, long moId) {
        List result = null;
        try {
            String hql = "FROM UserRelMoInfo where id.userIdx = " + userId + "and id.moId = " + moId;
            result = this.getHibernateTemplate().find(hql, new Object[0]);
        }
        catch (DataAccessException ex) {
            LOGGER.error((Object)"Method getMoByUserId fail,msg is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
            throw LegoExceptionTranslator.convert((Throwable)ex);
        }
        return result;
    }

    private int updateByHql(String hql) {
        return super.getHibernateTemplate().bulkUpdate(hql, new Object[0]);
    }
}

