/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.comm.security;

import com.huawei.ism.drm.wcc.rest.security.AbstractX509TrustManager;
import com.huawei.lego.comm.security.SecurityCertificateManager;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.LegoBaseConfig;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class KeyStoreX509TrustManager
extends AbstractX509TrustManager {
    private static final Log LOGGER = LogFactory.getInstance(KeyStoreX509TrustManager.class);

    public KeyStoreX509TrustManager(String keystoreFile, String ipAddress, boolean isForceCheckCert) {
        this(keystoreFile, ipAddress, SecurityCertificateManager.getDefaultKeyStoreFromCache(keystoreFile), isForceCheckCert);
    }

    public KeyStoreX509TrustManager(String keystoreFile, String ipAddress, KeyStore keyStore, boolean isForceCheckCert) {
        super(keystoreFile, ipAddress, KeyStoreX509TrustManager.getTrustManager(keyStore), isForceCheckCert);
    }

    public void reloadTrustManager() {
        KeyStore keyStore = SecurityCertificateManager.getDefaultKeyStore(this.getKeystoreFile(), KeyStoreX509TrustManager.getKeystoreFileModifyTime());
        this.trustManager = KeyStoreX509TrustManager.getTrustManager(keyStore);
    }

    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
    }

    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        boolean isCheckTrust = LegoBaseConfig.getInstance().getBoolean("cert.auth.switch", Boolean.FALSE);
        if (!this.isForceCheckCert() && !isCheckTrust) {
            LOGGER.warn((Object)"Cert auth switch is disable, end execute KeyStoreX509TrustManager checkServerTrusted.");
            return;
        }
        if (this.trustManager == null) {
            LOGGER.error((Object)"The trust manager is not initialized, ipAddress=%s.", new Object[]{this.ipAddress});
            throw new LegoCheckedException(207L);
        }
        try {
            this.checkRevoked(chain);
            this.checkExpired(chain);
            this.checkExpiring(chain);
            this.checkTrusted(chain, authType);
        }
        catch (SSLHandshakeException e) {
            LOGGER.error((Object)"KeyStoreX509TrustManager checkServerTrusted failed, msg:%S", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(207L);
        }
    }

    public X509Certificate[] getAcceptedIssuers() {
        return this.trustManager.getAcceptedIssuers();
    }

    protected static X509TrustManager getTrustManager(KeyStore keyStore) {
        X509TrustManager defaultTrustManager;
        if (keyStore == null) {
            LOGGER.warn((Object)"The keyStore is null.");
            throw new LegoCheckedException(207L);
        }
        try {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(keyStore);
            TrustManager manager = tmf.getTrustManagers()[0];
            if (!(manager instanceof X509TrustManager)) {
                throw new LegoCheckedException("trustManager is not of type X509TrustManager.");
            }
            defaultTrustManager = (X509TrustManager)manager;
        }
        catch (Exception e) {
            LOGGER.error((Object)"Initialized TrustManager failed by the certificate,errorMsg is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(207L, (Throwable)e);
        }
        return defaultTrustManager;
    }
}

