/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.base.cache;

import com.huawei.lego.core.sdk.base.ICacheService;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import org.springframework.beans.factory.DisposableBean;

public class CacheService
implements ICacheService<String, Object>,
DisposableBean {
    private static final Log LOGGER = LogFactory.getInstance(CacheService.class);
    private ICacheService<String, Object> cache;

    public boolean clear() {
        if (null != this.cache) {
            return this.cache.clear();
        }
        return false;
    }

    public synchronized boolean containsKey(String key) {
        if (null != this.cache) {
            return this.cache.containsKey((Object)key);
        }
        return false;
    }

    public synchronized Object get(String key) {
        if (null != this.cache) {
            return this.cache.get((Object)key);
        }
        return null;
    }

    public synchronized Set<String> keySet() {
        if (null != this.cache) {
            return this.cache.keySet();
        }
        return null;
    }

    public synchronized Object put(String key, Object value) {
        if (null != this.cache) {
            return this.cache.put((Object)key, value);
        }
        return null;
    }

    public Object put(String key, Object value, Date expiry) {
        if (null != this.cache) {
            return this.cache.put((Object)key, value, expiry);
        }
        return null;
    }

    public Object put(String key, Object value, int ttl) {
        if (null != this.cache) {
            return this.cache.put((Object)key, value, ttl);
        }
        return null;
    }

    public synchronized Object remove(String key) {
        if (null != this.cache) {
            return this.cache.remove((Object)key);
        }
        return null;
    }

    public int size() {
        if (null != this.cache) {
            return this.cache.size();
        }
        return -1;
    }

    public synchronized Collection<Object> values() {
        if (null != this.cache) {
            return this.cache.values();
        }
        return null;
    }

    public void setCache(ICacheService<String, Object> cache) {
        this.cache = cache;
    }

    public void destroy() {
    }

    public boolean containsKey(String key, boolean updateTime) {
        if (null != this.cache) {
            return this.cache.containsKey((Object)key, updateTime);
        }
        return false;
    }

    public Object get(String key, boolean updateTime) {
        if (null != this.cache) {
            return this.cache.get((Object)key, updateTime);
        }
        return false;
    }

    public Set<String> keySet(boolean updateTime) {
        if (null != this.cache) {
            return this.cache.keySet(updateTime);
        }
        return null;
    }

    public int size(boolean updateTime) {
        if (null != this.cache) {
            return this.cache.size(updateTime);
        }
        return 0;
    }

    public Collection<Object> values(boolean updateTime) {
        if (null != this.cache) {
            return this.cache.values(updateTime);
        }
        return null;
    }

    public synchronized void decreaseCachedDataCount(String key) {
        Long inCount = (Long)this.get(key);
        if (inCount == null) {
            LOGGER.warn((Object)("the key does not exist, key is : " + key), 0L);
        } else if (inCount > 0L) {
            inCount = inCount - 1L;
            this.put(key, (Object)inCount);
        }
        LOGGER.info((Object)String.format(Locale.ENGLISH, "DecreaseCachedDataCount, theeeee key is : %s, value is : %s.", key, inCount), 0L);
    }

    public synchronized void increaseCachedDataCount(String key) {
        Long inCount = (Long)this.get(key);
        if (inCount == null) {
            this.put(key, (Object)1L);
        } else {
            inCount = inCount + 1L;
            this.put(key, (Object)inCount);
        }
        LOGGER.info((Object)String.format(Locale.ENGLISH, "IncreaseCachedDataCounts, theeeee key is : %s, value is : %s.", key, inCount), 0L);
    }
}

