/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.base.framework.container.support;

import com.huawei.lego.core.base.framework.container.Launcher;
import com.huawei.lego.core.base.framework.container.PreLaunchProcessor;
import com.huawei.lego.core.base.framework.container.StructurePreProcessor;
import com.huawei.lego.core.base.framework.container.support.SpringFrameworkHook;
import com.huawei.lego.core.sdk.base.structure.AbsApplication;
import com.huawei.lego.core.sdk.base.structure.ICallback;
import com.huawei.lego.core.sdk.base.structure.ILifecycle;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import org.springframework.context.ApplicationContext;

public class ApplicationLauncher
extends Launcher {
    public ApplicationLauncher(SpringFrameworkHook hook) {
        super(hook);
    }

    @Override
    public void launch(ApplicationContext aContext) throws MalformedURLException, URISyntaxException {
        Collection apps = aContext.getBeansOfType(AbsApplication.class).values();
        for (PreLaunchProcessor processor : this.getPreProcessors()) {
            if (processor instanceof StructurePreProcessor) {
                ((StructurePreProcessor)processor).initStructureContext(aContext);
            }
            processor.doProcess();
        }
        ArrayList<Launcher.ListenerInitializeCallback> initCallbacks = new ArrayList<Launcher.ListenerInitializeCallback>();
        initCallbacks.add(new Launcher.ListenerInitializeCallback());
        ArrayList<StartCallback> startCallbacks = new ArrayList<StartCallback>();
        startCallbacks.add(new StartCallback());
        for (ILifecycle app : apps) {
            app.initialize(initCallbacks);
            app.start(startCallbacks);
        }
    }

    static class StopCallback
    implements ICallback {
        StopCallback() {
        }

        public void invoke(ILifecycle life) {
        }
    }

    static class StartCallback
    implements ICallback {
        StartCallback() {
        }

        public void invoke(ILifecycle life) {
        }
    }
}

