/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.base.framework.rpc.rmi;

import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.LegoBaseConfig;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.rmi.server.RemoteServer;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class SecurityInterceptor
implements MethodInterceptor {
    private static final Log LOGGER = LogFactory.getInstance(SecurityInterceptor.class);
    private static final Set<String> ALLOWED = new HashSet<String>();
    private static final String LOCAL_HOST_IP = "127.0.0.1";
    private static final String LOCALHOST_PREFIX = "127.";
    private static final long DEFAULT_OVERTIME = 5000L;
    private long overTime = LegoBaseConfig.getInstance().getNumber("rmi.monitor.overtime", 5000L);
    private Log log = LogFactory.getInstance(SecurityInterceptor.class);

    public SecurityInterceptor() {
        this.init();
    }

    private void init() {
        ALLOWED.add(LOCAL_HOST_IP);
        LOGGER.info((Object)String.format(Locale.ENGLISH, "RMI allowed ip: %s.", ALLOWED), 1L);
    }

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        String clientHost = RemoteServer.getClientHost();
        LOGGER.debug((Object)String.format(Locale.ENGLISH, "Client host: %s; methodInvocation:%s.", clientHost, methodInvocation.toString()), 1L);
        if (ALLOWED != null && (clientHost.startsWith(LOCALHOST_PREFIX) || ALLOWED.contains(clientHost))) {
            return this.monitorProceed(methodInvocation);
        }
        LOGGER.error((Object)("IT is no authority to invoke:" + clientHost), 1L);
        throw new LegoCheckedException("The host " + clientHost + " is no authority to invoke!");
    }

    private Object monitorProceed(MethodInvocation methodInvocation) throws Throwable {
        Date startTime = new Date();
        Object object = methodInvocation.proceed();
        Date endTime = new Date();
        long costTime = endTime.getTime() - startTime.getTime();
        if (null != methodInvocation.getMethod() && costTime > this.overTime) {
            LOGGER.warn((Object)"rmi method over time! starttime:%s, endtime:%s, cost:%s ms, method:%s", new Object[]{startTime, endTime, costTime, String.valueOf(methodInvocation.getMethod())});
        }
        return object;
    }

    public List<String> getLocalAllIps() {
        ArrayList<String> list = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            if (null == e) {
                return list;
            }
            while (e.hasMoreElements()) {
                NetworkInterface nif = e.nextElement();
                this.addIpAddress(nif, list);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("get Local IP Error" + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
        return list;
    }

    private void addIpAddress(NetworkInterface nif, List<String> list) {
        Enumeration<InetAddress> l = nif.getInetAddresses();
        while (l.hasMoreElements()) {
            String ipAddress;
            InetAddress address = l.nextElement();
            if (!(address instanceof Inet4Address) || LOCAL_HOST_IP.equals(ipAddress = address.getHostAddress())) continue;
            list.add(ipAddress);
        }
    }
}

