/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.base.registry;

import com.huawei.lego.core.base.registry.AppStorehouse;
import com.huawei.lego.core.sdk.base.AppStatus;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.IAppManager;
import com.huawei.lego.core.sdk.base.event.ApplicationStatusChangedListener;
import com.huawei.lego.core.sdk.base.event.StatusChangedEvent;
import com.huawei.lego.core.sdk.base.model.AppInfo;
import com.huawei.lego.core.sdk.base.model.ServiceInfo;
import com.huawei.lego.core.sdk.base.model.Status;
import com.huawei.lego.core.sdk.base.structure.AbsApplication;
import com.huawei.lego.core.sdk.base.structure.IApplication;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.List;
import java.util.Map;

public class AppManagerService
extends BaseService
implements IAppManager,
ApplicationStatusChangedListener {
    private static final Log LOGGER = LogFactory.getInstance(AppManagerService.class);
    private static final int VALUE_2 = 2;
    private AppStorehouse appstore;

    public void setAppstore(AppStorehouse appstore) {
        this.appstore = appstore;
    }

    public void add(AppInfo info) {
        this.appstore.add(info);
    }

    public void remove(String appName) {
        AppInfo info = this.appstore.query(appName);
        info.setStatus(AppStatus.STOPED);
    }

    public List<AppInfo> getAppList() {
        return this.appstore.list();
    }

    public AppInfo queryApp(String appName) {
        return this.appstore.query(appName);
    }

    public ServiceInfo queryService(String name) {
        String[] names = name.split("/");
        if (names.length != 2) {
            return null;
        }
        AppInfo info = this.appstore.query(names[0]);
        if (null == info) {
            return null;
        }
        List services = info.getServices();
        if (null != services && !services.isEmpty()) {
            for (ServiceInfo service : services) {
                if (!names[1].equals(service.getName())) continue;
                return service;
            }
        }
        return null;
    }

    public ServiceInfo queryService(String name, Map context) {
        String[] names = name.split("/");
        if (names.length != 2) {
            return null;
        }
        AppInfo info = this.appstore.query(names[0]);
        if (info == null) {
            return null;
        }
        List services = info.getServices();
        if (services != null && !services.isEmpty()) {
            for (ServiceInfo service : services) {
                if (!names[1].equals(service.getName()) || service.getService() == null) continue;
                ((BaseService)service.getService()).setContext(context);
                return service;
            }
        }
        return null;
    }

    public void start(String appName) {
        AppInfo info = this.queryApp(appName);
        info.setStatus(AppStatus.STARTED);
    }

    public void stop(String appName) {
        AppInfo info = this.queryApp(appName);
        info.setStatus(AppStatus.STOPED);
    }

    public IApplication getContainer() {
        return null;
    }

    public ServiceInfo getInfor() {
        return null;
    }

    public void setContainer(IApplication container) {
    }

    public void setServiceInfor(ServiceInfo srvInfor) {
    }

    private void updateAppStatus(Object obj, AppStatus state) {
        String appName = "";
        try {
            AppInfo info;
            AppInfo appinfo;
            if (obj instanceof AbsApplication && (appinfo = this.queryApp(appName = (info = ((AbsApplication)obj).getInfor()).getAppName())) != null) {
                appinfo.setStatus(state);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("appName: " + appName + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
    }

    public void onStatusChangedEvent(StatusChangedEvent event) {
        if (event.getStatus() == Status.STATUS_STARTED) {
            this.updateAppStatus(event.getEventTarget(), AppStatus.STARTED);
        }
        if (event.getStatus() == Status.STATUS_STOPED) {
            this.updateAppStatus(event.getEventTarget(), AppStatus.STOPED);
        }
    }
}

