/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.base.service;

import com.huawei.lego.core.sdk.base.event.StatusChangedEvent;
import com.huawei.lego.core.sdk.base.event.SystemStatusChangedListener;
import com.huawei.lego.core.sdk.base.model.Status;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Locale;
import java.util.Properties;

public class StartupChecker
implements SystemStatusChangedListener {
    private static final String START_FLAG_FILE = "startStatus.falg";
    private static final String START_STATUS = "start.status";
    private static final Log LOGGER = LogFactory.getInstance(StartupChecker.class);

    public void onStatusChangedEvent(StatusChangedEvent event) {
        LOGGER.info((Object)String.format(Locale.ENGLISH, "############ event.getStatus is %s.", event.getStatus()), 1L);
        if (event.getStatus() != Status.STATUS_STARTED) {
            return;
        }
        this.setStartStatus();
    }

    private void setStartStatus() {
        File tmpFile = new File(".");
        String path = "";
        try {
            path = tmpFile.getCanonicalPath();
        }
        catch (IOException e) {
            LOGGER.error((Object)"setStartStatus getCanonicalPath() error!", 102L);
        }
        String currentPath = path + File.separator;
        currentPath = currentPath + "conf" + File.separator + START_FLAG_FILE;
        this.setStartStatus(currentPath, Status.STATUS_STARTED.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStartStatus(String path, String status) {
        LOGGER.info((Object)"setStartStatus path", 1L);
        Properties pro = new Properties();
        FileOutputStream fileOutput = null;
        File flagFile = null;
        try {
            flagFile = new File(path);
            if (!flagFile.exists()) {
                boolean result = flagFile.createNewFile();
                pro.setProperty(START_STATUS, status);
                if (result) {
                    flagFile.setWritable(true);
                    fileOutput = new FileOutputStream(flagFile);
                    pro.store(fileOutput, "change status");
                }
            } else {
                LOGGER.info((Object)"setStartStatus flag is exist!", 1L);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("setStartStatus error" + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
        finally {
            if (null != fileOutput) {
                try {
                    fileOutput.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)"setStartStatus error", (Throwable)e, 1L);
                }
            }
        }
    }
}

